/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.utilities.db;

import com.dandymadeproductions.ajqvue.datasource.ConnectionInstance;
import com.dandymadeproductions.ajqvue.utilities.ProgressBar;
import com.dandymadeproductions.ajqvue.utilities.db.DB_To_DBThread;
import com.dandymadeproductions.ajqvue.utilities.db.SQLQuery;
import com.dandymadeproductions.ajqvue.utilities.db.TableRowElements;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLLoadThread
implements Runnable {
    private ConnectionInstance connectionInstance;
    private SQLQuery sqlQuery;
    private ArrayBlockingQueue<TableRowElements> tableRowDataQueue;
    private ProgressBar loadProgressBar;
    private int limitIncrement;
    private boolean useLimits;
    private boolean showProgressBar;
    private boolean debug;
    private Logger threadLogger;
    private static int LIMIT_INCREMENT = 10000;

    public SQLLoadThread(ConnectionInstance connectionInstance, SQLQuery sQLQuery, ArrayBlockingQueue<TableRowElements> arrayBlockingQueue, boolean bl) {
        this(connectionInstance, sQLQuery, arrayBlockingQueue, false, LIMIT_INCREMENT, false, bl);
    }

    public SQLLoadThread(ConnectionInstance connectionInstance, SQLQuery sQLQuery, ArrayBlockingQueue<TableRowElements> arrayBlockingQueue, boolean bl, int n, boolean bl2, boolean bl3) {
        this.connectionInstance = connectionInstance;
        this.sqlQuery = sQLQuery;
        this.tableRowDataQueue = arrayBlockingQueue;
        this.useLimits = bl;
        this.limitIncrement = n;
        this.showProgressBar = bl2;
        this.debug = bl3;
    }

    @Override
    public void run() {
        Connection connection = null;
        try {
            if (this.connectionInstance == null) {
                throw new SQLException("Null Instance");
            }
            connection = this.connectionInstance.getConnection("SQLLoadThread run()");
            if (connection == null) {
                return;
            }
            this.log(Level.INFO, "SQLLoadThread", "run()", "Entering loadData()");
            this.loadData(connection);
            this.log(Level.INFO, "SQLLoadThread", "run()", "Done loadData()\n");
        }
        catch (SQLException sQLException) {
            ConnectionInstance.displaySQLErrors(sQLException, "SQLLoadThread run()", this.debug);
        }
        finally {
            if (this.connectionInstance != null) {
                this.connectionInstance.closeConnection(connection, "SQLLoadThread run()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadData(Connection var1_1) throws SQLException {
        var10_2 = 0;
        var11_3 = 0;
        this.loadProgressBar = new ProgressBar("SQL Load Data");
        var9_4 = this.sqlQuery.getRowCount(this.connectionInstance);
        this.log(Level.FINE, "SQLLoadThread", "loadData()", "rowsCount: " + var9_4);
        if (this.showProgressBar) {
            this.loadProgressBar.setTaskLength(var9_4);
            this.loadProgressBar.pack();
            this.loadProgressBar.center();
        }
        this.loadProgressBar.setVisible(this.showProgressBar);
        var15_5 = null;
        var16_6 = null;
        try {
            var15_5 = var1_1.createStatement();
            block73: while (true) {
                if (this.useLimits) {
                    var2_7 = this.connectionInstance.getIdentifierQuoteString() + this.sqlQuery.getColumnNames().get(0) + this.connectionInstance.getIdentifierQuoteString();
                    var14_16 = this.connectionInstance.getDataSourceType().equals("oracle") ? "SELECT * FROM (SELECT ROW_NUMBER() OVER (ORDER BY " + var2_7 + " ASC) AS dmprownumber, " + this.sqlQuery.getSqlOrcaleColumnNamesString() + " FROM (" + this.sqlQuery.getSQLQuery() + ") AS t1) WHERE dmprownumber BETWEEN " + (var10_2 + 1) + " AND " + (var10_2 + this.limitIncrement) : (this.connectionInstance.getDataSourceType().equals("odbc") ? this.sqlQuery.getSQLQuery() : (this.connectionInstance.getDataSourceType().equals("sqlserver") ? "SELECT * FROM (SELECT *, ROW_NUMBER() OVER (ORDER BY " + var2_7 + " ASC) AS dmprownumber FROM (" + this.sqlQuery.getSQLQuery() + ") AS t) AS t1 WHERE t1.dmprownumber BETWEEN " + (var10_2 + 1) + " AND " + (var10_2 + this.limitIncrement) : (this.connectionInstance.getDataSourceType().equals("derby") ? "SELECT * FROM (" + this.sqlQuery.getSQLQuery() + ") AS t1 OFFSET " + var10_2 + " ROWS FETCH NEXT " + this.limitIncrement + " ROWS ONLY" : "SELECT * FROM (" + this.sqlQuery.getSQLQuery() + ") AS t1 LIMIT " + this.limitIncrement + " OFFSET " + var10_2)));
                } else {
                    var14_16 = this.sqlQuery.getSQLQuery();
                }
                this.log(Level.FINE, "SQLLoadThread", "loadData()", var14_16);
                var16_6 = var15_5.executeQuery(var14_16);
                while (true) {
                    if (var16_6.next() && !this.loadProgressBar.isCanceled()) {
                        this.loadProgressBar.setCurrentValue(var11_3++);
                        var13_15 = new TableRowElements(this.sqlQuery.getColumnNames().size());
                        var3_8 = this.sqlQuery.getColumnNames().iterator();
                    } else {
                        if (this.useLimits == false) return;
                        if ((var10_2 += this.limitIncrement) >= var9_4) return;
                        if (!this.loadProgressBar.isCanceled()) continue block73;
                        return;
                    }
                    while (var3_8.hasNext()) {
                        var4_9 = var3_8.next();
                        var5_10 = this.sqlQuery.getColumnClassHashMap().get(var4_9);
                        var6_11 = this.sqlQuery.getColumnSQLTypeHashMap().get(var4_9);
                        var7_12 = this.sqlQuery.getColumnTypeNameHashMap().get(var4_9);
                        var8_13 = this.sqlQuery.getColumnSizeHashMap().get(var4_9);
                        if (var7_12.equals("DATE")) {
                            var12_14 = this.connectionInstance.getDataSourceType().equals("sqlite") != false && var6_11 == 12 ? var16_6.getString(var4_9) : var16_6.getDate(var4_9);
                            if (var12_14 == null) {
                                var13_15.setRowElement(null);
                                continue;
                            }
                            var13_15.setRowElement(var12_14 + "");
                            continue;
                        }
                        if (var7_12.equals("TIME")) {
                            var12_14 = this.connectionInstance.getDataSourceType().equals("sqlite") != false && var6_11 == 12 ? var16_6.getString(var4_9) : var16_6.getTime(var4_9);
                            if (var12_14 == null) {
                                var13_15.setRowElement(null);
                                continue;
                            }
                            if (this.connectionInstance.getDataSourceType().equals("sqlite") && var6_11 == 12) {
                                var13_15.setRowElement(var12_14);
                                continue;
                            }
                            var13_15.setRowElement(new SimpleDateFormat("HH:mm:ss").format(var12_14));
                            continue;
                        }
                        if (var7_12.equals("TIMETZ") || var7_12.equals("TIME WITH TIME ZONE")) {
                            var12_14 = var16_6.getString(var4_9);
                            if (var12_14 == null) {
                                var13_15.setRowElement(null);
                                continue;
                            }
                            var17_17 = (String)var12_14;
                            if (var7_12.equals("TIMETZ")) {
                                var17_17 = var17_17.substring(0, 8) + ".0" + var17_17.substring(8, var17_17.length()) + ":00";
                                var13_15.setRowElement(var17_17);
                                continue;
                            }
                            if (var17_17.indexOf(":") == 1) {
                                var17_17 = "0" + (String)var17_17;
                            }
                            var13_15.setRowElement(var17_17);
                            continue;
                        }
                        if (var7_12.equals("TIMESTAMP") || var7_12.equalsIgnoreCase("DATETIME")) {
                            var12_14 = this.connectionInstance.getDataSourceType().equals("sqlite") != false && var6_11 == 12 ? var16_6.getString(var4_9) : var16_6.getTimestamp(var4_9);
                            if (var12_14 == null) {
                                var13_15.setRowElement(null);
                                continue;
                            }
                            if (this.connectionInstance.getDataSourceType().equals("sqlite") && var6_11 == 12) {
                                var13_15.setRowElement(var12_14);
                                continue;
                            }
                            var13_15.setRowElement(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(var12_14));
                            continue;
                        }
                        if (var7_12.equals("TIMESTAMPTZ") || var7_12.equals("TIMESTAMP WITH TIME ZONE") || var7_12.equals("TIMESTAMP WITH LOCAL TIME ZONE")) {
                            var12_14 = this.connectionInstance.getDataSourceType().equals("sqlite") != false && var6_11 == 12 ? var16_6.getString(var4_9) : var16_6.getTimestamp(var4_9);
                            if (var12_14 == null) {
                                var13_15.setRowElement(null);
                                continue;
                            }
                            if (this.connectionInstance.getDataSourceType().equals("sqlite") && var6_11 == 12) {
                                var13_15.setRowElement(var12_14);
                                continue;
                            }
                            var13_15.setRowElement(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(var12_14));
                            continue;
                        }
                        if (var7_12.equals("TIMESTAMPLTZ")) {
                            var12_14 = var16_6.getString(var4_9);
                            if (var12_14 == null) {
                                var13_15.setRowElement(null);
                                continue;
                            }
                            var13_15.setRowElement(var12_14);
                            continue;
                        }
                        if (var7_12.equals("YEAR")) {
                            var12_14 = var16_6.getString(var4_9);
                            if (var12_14 == null) {
                                var13_15.setRowElement(null);
                                continue;
                            }
                            var17_17 = (String)var12_14;
                            var17_17 = var17_17.trim();
                            if (var8_13 == 2) {
                                if (var17_17.length() >= 4) {
                                    var17_17 = var17_17.substring(2, 4);
                                }
                            } else {
                                var17_17 = var17_17.substring(0, 4);
                            }
                            var13_15.setRowElement(var17_17);
                            continue;
                        }
                        if (DB_To_DBThread.isBlob(var5_10, var7_12)) {
                            var12_14 = var16_6.getBytes(var4_9);
                            if (var12_14 == null) {
                                var13_15.setRowElement(null);
                                continue;
                            }
                            var13_15.setRowElement(var12_14);
                            continue;
                        }
                        if (var5_10.indexOf("Boolean") == -1 && var7_12.equals("BIT")) {
                            if (this.connectionInstance.getDataSourceType().equals("mysql") || this.connectionInstance.getDataSourceType().equals("mariadb")) {
                                var12_14 = var16_6.getByte(var4_9);
                                if (var12_14 == null) {
                                    var13_15.setRowElement(null);
                                    continue;
                                }
                                var17_17 = Byte.toString((Byte)var12_14);
                                var13_15.setRowElement(Integer.toBinaryString(Integer.parseInt((String)var17_17)));
                                continue;
                            }
                            var12_14 = var16_6.getString(var4_9);
                            if (var12_14 == null) {
                                var13_15.setRowElement(null);
                                continue;
                            }
                            var13_15.setRowElement(var12_14);
                            continue;
                        }
                        if (DB_To_DBThread.isText(var5_10, var7_12, var8_13, 65535)) {
                            var12_14 = var16_6.getString(var4_9);
                            if (var12_14 == null) {
                                var13_15.setRowElement(null);
                                continue;
                            }
                            var13_15.setRowElement(var12_14);
                            continue;
                        }
                        var12_14 = var16_6.getString(var4_9);
                        if (var12_14 == null) {
                            var13_15.setRowElement(null);
                            continue;
                        }
                        var13_15.setRowElement(var12_14);
                    }
                    this.tableRowDataQueue.put(var13_15);
                }
                break;
            }
        }
        catch (SQLException var17_21) {
            ConnectionInstance.displaySQLErrors(var17_21, "SQLLoadThread loadData()", this.debug);
            return;
        }
        catch (InterruptedException var17_26) {
            if (this.debug == false) return;
            this.log(Level.WARNING, "SQLLoadThread", "loadData()", var17_26.toString());
            return;
        }
        finally {
            this.loadProgressBar.setCanceled(true);
            this.loadProgressBar.dispose();
            try {
                var17_22 = new TableRowElements();
                this.log(Level.INFO, "SQLLoadThread", "loadData()", "Loading Final: Last Element\n");
                var17_22.setMessage("Last Element");
                this.tableRowDataQueue.put(var17_22);
                ** GOTO lbl173
            }
            catch (InterruptedException var17_24) {
                if (!this.debug) ** GOTO lbl173
                this.log(Level.WARNING, "SQLLoadThread", "loadData()", var17_24.toString());
                ** GOTO lbl173
            }
            finally {
                try {
                    if (var16_6 != null) {
                        var16_6.close();
                    }
                }
                catch (SQLException var17_25) {
                    ConnectionInstance.displaySQLErrors(var17_25, "SQLLoadThread loadData()", this.debug);
                }
                finally {
                    if (var15_5 != null) {
                        var15_5.close();
                    }
                }
lbl173:
                // 3 sources

            }
        }
    }

    protected void cancelLoad(String string) {
        if (this.loadProgressBar != null) {
            this.log(Level.WARNING, "SQLLoadThread", "cancelLoad()", string);
            this.loadProgressBar.setCanceled(true);
        }
    }

    private void log(Level level, String string, String string2, String string3) {
        if (this.threadLogger != null) {
            this.threadLogger.logp(level, string, string2, string3);
        }
    }

    public void setLogger(Logger logger) {
        this.threadLogger = logger;
    }
}

