/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.utilities;

import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class TableClearingThread
implements Runnable {
    int tabNumber;

    public TableClearingThread(int n) {
        this.tabNumber = n;
    }

    @Override
    public void run() {
        Connection connection = ConnectionManager.getConnection("TableClearingThread run()");
        String string = ConnectionManager.getDataSourceType();
        if (string.indexOf("hsql") != -1) {
            this.clearHSQLDBMemoryTables(connection);
        }
        if (string.equals("oracle")) {
            try {
                this.clearOracleDBTemporaryTables(connection);
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "TableClearingThread run()");
            }
        }
        ConnectionManager.closeConnection(connection, "TableClearingThread run()");
    }

    private void clearHSQLDBMemoryTables(Connection connection) {
        while (this.tabNumber >= 0) {
            try {
                Statement statement = connection.createStatement();
                statement.executeUpdate("DROP TABLE " + ConnectionManager.getIdentifierQuoteString() + "temptable" + this.tabNumber + ConnectionManager.getIdentifierQuoteString() + " IF EXISTS");
                statement.executeUpdate("DROP SEQUENCE id_" + this.tabNumber-- + " IF EXISTS");
                statement.close();
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "TableClearingThread clearHSQLDBMemoryTables()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void clearOracleDBTemporaryTables(Connection connection) throws SQLException {
        String string = ConnectionManager.getIdentifierQuoteString();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            while (this.tabNumber >= 0) {
                String string2 = "SELECT OBJECT_NAME FROM USER_OBJECTS WHERE OBJECT_NAME='temptable" + this.tabNumber + "' AND OBJECT_TYPE='TABLE'";
                resultSet = statement.executeQuery(string2);
                if (resultSet.next()) {
                    string2 = "DROP TABLE " + string + "temptable" + this.tabNumber + string + " PURGE";
                    statement.executeUpdate(string2);
                }
                --this.tabNumber;
            }
            return;
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "TableClearingThread clearOracleDBTemporaryTables()");
            return;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "TableClearingThread clearOracleDBTemporaryTables()");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }
}

