/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.utilities;

import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JButton;

public class SQLQueryBucketListObject
extends JButton {
    private static final long serialVersionUID = 2957461545143942698L;
    private static final float alphaValue = 0.76f;
    private transient BufferedImage buttonImage = null;
    private StringBuffer sqlStatementString;
    private boolean isLimited;

    public SQLQueryBucketListObject() {
        this.constructSQLQueryBucketListObject();
    }

    public SQLQueryBucketListObject(String string) {
        super(string);
        this.constructSQLQueryBucketListObject();
    }

    private void constructSQLQueryBucketListObject() {
        this.sqlStatementString = new StringBuffer();
        this.isLimited = false;
        this.setBorder(BorderFactory.createRaisedSoftBevelBorder());
        this.setFont(this.getFont().deriveFont(1));
        this.setContentAreaFilled(false);
        this.setOpaque(false);
    }

    public void paintCompnent(Graphics graphics) {
        super.paint(graphics);
        this.drawGraphics(graphics);
    }

    private void drawGraphics(Graphics graphics) {
        if (this.buttonImage == null || this.buttonImage.getWidth() != this.getWidth() || this.buttonImage.getHeight() != this.getHeight()) {
            this.buttonImage = this.getGraphicsConfiguration().createCompatibleImage(this.getWidth(), this.getHeight());
        }
        Graphics graphics2 = this.buttonImage.getGraphics();
        graphics2.setClip(graphics.getClip());
        super.paint(graphics2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.76f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.drawImage((Image)this.buttonImage, 0, 0, null);
    }

    public boolean isLimited() {
        return this.isLimited;
    }

    public StringBuffer getSQLStatementString() {
        if (!this.isLimited) {
            String string = Utils.getUnlimitedSQLStatementString(this.sqlStatementString.toString());
            this.sqlStatementString.delete(0, this.sqlStatementString.length());
            this.sqlStatementString.append(string);
            return this.sqlStatementString;
        }
        return this.sqlStatementString;
    }

    public void setSQLStatementString(String string) {
        this.sqlStatementString.delete(0, this.sqlStatementString.length());
        this.sqlStatementString.append(string);
    }

    public void setLimited(boolean bl) {
        this.isLimited = bl;
    }
}

