/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.utilities;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import javax.swing.JFrame;

public class ImageGraphicsFrame
extends JFrame {
    private static final long serialVersionUID = 5520696961286789397L;
    private transient Image itemImage;
    private transient Image offScreenGraphicsImage;
    private int imageWidth;
    private int imageHeight;

    public ImageGraphicsFrame(String string) {
        super(string);
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension;
        if (this.itemImage != null && this.getGraphics() != null && this.checkImage(dimension = this.getSize())) {
            this.draw(this.offScreenGraphicsImage.getGraphics());
            this.getGraphics().drawImage(this.offScreenGraphicsImage, 0, 0, null);
        }
    }

    private boolean checkImage(Dimension dimension) {
        if (dimension.width == 0 || dimension.height == 0) {
            return false;
        }
        if (this.offScreenGraphicsImage == null || this.offScreenGraphicsImage.getWidth(null) != dimension.width || this.offScreenGraphicsImage.getHeight(null) != dimension.height) {
            this.offScreenGraphicsImage = this.createImage(dimension.width, dimension.height);
        }
        return true;
    }

    private void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n != this.imageWidth || n2 != this.imageHeight) {
            Image image = this.createImage(n, n2);
            Graphics2D graphics2D2 = (Graphics2D)image.getGraphics();
            AffineTransform affineTransform = AffineTransform.getScaleInstance((double)n / (double)this.imageWidth, (double)n2 / (double)this.imageHeight);
            graphics2D2.setTransform(affineTransform);
            graphics2D2.drawImage(this.itemImage, 0, 0, null);
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D2.dispose();
        } else {
            graphics2D.drawImage(this.itemImage, 0, 0, null);
        }
    }

    protected void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setLocation(n, n2);
    }

    protected void setImage(Image image) {
        if (image != null) {
            this.itemImage = image;
            this.imageWidth = image.getWidth(null);
            this.imageHeight = image.getHeight(null);
        }
    }
}

