/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.utilities;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.datasource.ConnectionProperties;
import com.dandymadeproductions.ajqvue.gui.SiteParameters;
import com.dandymadeproductions.ajqvue.gui.XMLTranslator;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class DataSourcesDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -2547873067331646882L;
    private ConnectionProperties connectionProperties;
    private transient XMLTranslator xmlTranslator;
    private transient HashMap<String, SiteParameters> sites;
    private SiteParameters selectedSite;
    private JTextField hostTextField;
    private JTextField dbTextField;
    private JTextField userTextField;
    private JPasswordField passwordTextField;
    private JCheckBox validateCheckBox;
    private JOptionPane dialogOptionPane;
    private String confirmationString;
    private String nonConfirmationString;
    private String actionResult;
    private AResourceBundle resourceBundle;
    private boolean siteSelected;
    private String resourceSuccess;
    private ImageIcon successIcon;
    private transient WindowListener inputDialogFrameListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            DataSourcesDialog.this.actionResult = "close";
            DataSourcesDialog.this.closeDialog();
        }
    };

    public DataSourcesDialog(JFrame jFrame, ConnectionProperties connectionProperties, boolean bl) {
        super((Frame)jFrame, true);
        this.connectionProperties = connectionProperties;
        this.xmlTranslator = new XMLTranslator();
        this.resourceBundle = Ajqvue.getResourceBundle();
        this.actionResult = "";
        this.siteSelected = false;
        String string = this.resourceBundle.getResourceString("DataSourcesDialog.message.DataSourcesDialog", "Data Sources Dialog");
        this.setTitle("A DataSources Dialog");
        this.resourceSuccess = this.resourceBundle.getResourceString("DataSourcesDialog.message.Success", "Success");
        this.successIcon = this.resourceBundle.getResourceImage(Utils.getIconsDirectory() + Utils.getFileSeparator() + "successIcon.png");
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setBorder(BorderFactory.createEtchedBorder());
        jMenuBar.setMargin(new Insets(0, 0, 0, 0));
        if (this.xmlTranslator.getXMLTranslatorResult()) {
            this.sites = this.xmlTranslator.getSites();
        }
        string = this.resourceBundle.getResourceString("DataSourcesDialog.menu.Sites", "Sites");
        JMenu jMenu = new JMenu(string);
        string = this.resourceBundle.getResourceString("DataSourcesDialog.tooltip.SiteSelection", "Site Selection");
        jMenu.setToolTipText(string);
        if (this.sites != null) {
            this.fillSiteDataStructures(jMenu);
        }
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(8, 1, 0, 2));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(6, 8, 6, 8)));
        string = this.resourceBundle.getResourceString("DataSourcesDialog.label.Host", "Host");
        JLabel jLabel = new JLabel(string, 2);
        jPanel2.add(jLabel);
        this.hostTextField = new JTextField();
        this.hostTextField.setBorder(BorderFactory.createEtchedBorder());
        this.hostTextField.setEditable(false);
        jPanel2.add(this.hostTextField);
        string = this.resourceBundle.getResourceString("DataSourcesDialog.label.Database", "Database");
        JLabel jLabel2 = new JLabel(string);
        jPanel2.add(jLabel2);
        this.dbTextField = new JTextField();
        this.dbTextField.setBorder(BorderFactory.createEtchedBorder());
        this.dbTextField.setEditable(false);
        jPanel2.add(this.dbTextField);
        string = this.resourceBundle.getResourceString("DataSourcesDialog.label.User", "User");
        JLabel jLabel3 = new JLabel(string, 2);
        jPanel2.add(jLabel3);
        this.userTextField = new JTextField();
        this.userTextField.setBorder(BorderFactory.createEtchedBorder());
        this.userTextField.setEditable(false);
        jPanel2.add(this.userTextField);
        string = this.resourceBundle.getResourceString("DataSourcesDialog.label.Password", "Password");
        JLabel jLabel4 = new JLabel(string, 2);
        jPanel2.add(jLabel4);
        this.passwordTextField = new JPasswordField();
        this.passwordTextField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(0), BorderFactory.createLoweredBevelBorder()));
        jPanel2.add(this.passwordTextField);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        jPanel3.setBorder(BorderFactory.createRaisedSoftBevelBorder());
        string = this.resourceBundle.getResourceString("DataSourcesDialog.checkbox.Validate", "Validate");
        this.validateCheckBox = new JCheckBox(string, false);
        this.validateCheckBox.setEnabled(bl);
        jPanel3.add(this.validateCheckBox);
        jPanel.add((Component)jPanel3, "South");
        Object[] objectArray = new Object[]{jPanel};
        this.confirmationString = string = this.resourceBundle.getResourceString("DataSourcesDialog.dialogbutton.OK", "OK");
        this.nonConfirmationString = string = this.resourceBundle.getResourceString("DataSourcesDialog.dialogbutton.Cancel", "Cancel");
        Object[] objectArray2 = new Object[]{this.confirmationString, this.nonConfirmationString};
        this.dialogOptionPane = new JOptionPane(objectArray, -1, 2, null, objectArray2);
        this.dialogOptionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.setContentPane(this.dialogOptionPane);
        this.setOkDefaultButton(this.dialogOptionPane);
        this.dialogOptionPane.addPropertyChangeListener(this);
        this.addWindowListener(this.inputDialogFrameListener);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)object;
            String string = jMenuItem.getActionCommand();
            this.selectedSite = this.sites.get(string);
            this.setSelectedSite();
            this.siteSelected = true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (this.isVisible() && propertyChangeEvent.getSource() == this.dialogOptionPane && "value".equals(string)) {
            Object object = this.dialogOptionPane.getValue();
            if (object.equals(this.confirmationString)) {
                this.actionResult = "ok";
                this.closeDialog();
            }
            if (object.equals(this.nonConfirmationString)) {
                this.actionResult = "";
                this.closeDialog();
            }
        }
        this.dialogOptionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    private void fillSiteDataStructures(JMenu jMenu) {
        Object object;
        String string;
        String string2;
        jMenu.removeAll();
        Iterator<Map.Entry<String, SiteParameters>> iterator = this.sites.entrySet().iterator();
        TreeSet<String> treeSet = new TreeSet<String>();
        while (iterator.hasNext()) {
            string2 = iterator.next().getKey();
            if (!string2.equals("Last Site") && string2.indexOf(35) != -1) {
                string2 = string2.substring(0, string2.indexOf(35));
            } else {
                jMenu.add(this.createMenuItem(string2, string2));
            }
            if (treeSet.contains(string2) || string2.equals("Last Site")) continue;
            treeSet.add(string2);
        }
        Iterator iterator2 = treeSet.iterator();
        HashMap<String, JMenu> hashMap = new HashMap<String, JMenu>();
        while (iterator2.hasNext()) {
            string = (String)iterator2.next();
            object = new JMenu(string);
            hashMap.put(string, (JMenu)object);
            jMenu.add((JMenuItem)object);
        }
        for (Map.Entry<String, SiteParameters> entry : this.sites.entrySet()) {
            string2 = entry.getKey();
            if (string2.equals("Last Site") || string2.indexOf(35) == -1) continue;
            string = string2.substring(0, string2.indexOf(35));
            object = string2.substring(string2.indexOf(35) + 1);
            JMenu jMenu2 = (JMenu)hashMap.get(string);
            jMenu2.add(this.createMenuItem((String)object, string2));
        }
    }

    private JMenuItem createMenuItem(String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(string2);
        return jMenuItem;
    }

    private void setOkDefaultButton(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof JButton) {
                JButton jButton = (JButton)componentArray[i];
                if (!jButton.getText().equals(this.confirmationString)) continue;
                this.getRootPane().setDefaultButton(jButton);
                continue;
            }
            if (!(componentArray[i] instanceof JComponent)) continue;
            this.setOkDefaultButton((JComponent)componentArray[i]);
        }
    }

    private void setSelectedSite() {
        if (this.selectedSite == null) {
            return;
        }
        this.hostTextField.setText(this.selectedSite.getHost());
        this.dbTextField.setText(this.selectedSite.getDatabase());
        this.userTextField.setText(this.selectedSite.getUser());
    }

    public boolean isActionResult() {
        if (this.actionResult.equals("ok")) {
            if (!this.siteSelected) {
                return false;
            }
            return this.createConnectionProperties();
        }
        return false;
    }

    private boolean createConnectionProperties() {
        String string;
        Properties properties = new Properties();
        String string2 = this.selectedSite.getDriver();
        String string3 = this.selectedSite.getProtocol();
        String string4 = this.selectedSite.getSubProtocol();
        String string5 = this.selectedSite.getHost();
        String string6 = this.selectedSite.getPort();
        String string7 = this.selectedSite.getDatabase();
        String string8 = this.selectedSite.getUser();
        properties.setProperty("user", string8);
        String string9 = "";
        char[] cArray = this.passwordTextField.getPassword();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            stringBuffer.append(cArray[i]);
            cArray[i] = 48;
        }
        string9 = stringBuffer.toString();
        if (string4.indexOf("hsql") != -1 || string4.equals("derby") || string4.equals("postgresql") || string4.equals("mariadb") || string4.equals("mysql")) {
            string9 = string9.replaceAll("%", "%" + Integer.toHexString(37));
        }
        properties.setProperty("password", string9);
        if (this.selectedSite.getSsh().equals("1")) {
            string = "true";
            if (string4.indexOf("hsql") != -1 || string4.equals("mariadb") || string4.equals("mysql") || string4.equals("postgresql")) {
                properties.setProperty("useSSL", "1");
            }
        } else {
            string = "false";
        }
        if (string7.indexOf("?") != -1) {
            String[] stringArray = "?".equals("?") ? string7.split("\\?") : string7.split("?");
            string7 = stringArray[0];
            String[] stringArray2 = stringArray[1].split("&");
            for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray2[i].indexOf("=") == -1) continue;
                properties.setProperty(stringArray2[i].substring(0, stringArray2[i].indexOf("=")), stringArray2[i].substring(stringArray2[i].indexOf("=") + 1, stringArray2[i].length()));
            }
        }
        this.connectionProperties.setProperties(properties);
        this.connectionProperties.setProperty("Driver", string2);
        this.connectionProperties.setProperty("Protocol", string3);
        this.connectionProperties.setProperty("SubProtocol", string4);
        this.connectionProperties.setProperty("Host", string5);
        this.connectionProperties.setProperty("Port", string6);
        this.connectionProperties.setProperty("DB", string7);
        this.connectionProperties.setProperty("User", string8);
        this.connectionProperties.setProperty("Password", string9);
        this.connectionProperties.setProperty("SSH", string);
        String string10 = ConnectionManager.createConnectionURLString(this.connectionProperties);
        if (Ajqvue.getDebug()) {
            System.out.println("DataSourceDialog createConnectionProperties()\n" + this.connectionProperties.toString());
        }
        this.connectionProperties.setConnectionURLString(string10);
        if (this.validateCheckBox.isSelected()) {
            try {
                Connection connection = DriverManager.getConnection(string10, properties);
                if (connection != null) {
                    connection.close();
                }
                JOptionPane.showMessageDialog(null, this.resourceSuccess, "", -1, this.successIcon);
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "DataSourceDialog createConnectionProperties()");
                return false;
            }
        }
        return true;
    }

    public String getActionResult() {
        return this.actionResult;
    }

    public void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setLocation(n, n2);
    }
}

