/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.structures;

import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.util.prefs.Preferences;
import javax.swing.UIManager;

public class GeneralProperties {
    private int fontSize;
    private int framePosition_X;
    private int framePosition_Y;
    private int frameWidth;
    private int frameHeight;
    private int queryFramePosition_X;
    private int queryFramePosition_Y;
    private int queryFrameWidth;
    private int queryFrameHeight;
    private String sequenceList;
    private boolean enableProxy;
    private String proxyAddress;
    private int proxyPort;
    private Preferences generalPreferences;
    public static final String APPFONTSIZE = "AppFontSize";
    public static final String APPFRAMEPOSITIONX = "AppFramePositionX";
    public static final String APPFRAMEPOSITIONY = "AppFramePositionY";
    public static final String APPFRAMEWIDTH = "AppFrameWidth";
    public static final String APPFRAMEHEIGHT = "AppFrameHeight";
    public static final String APPQUERYFRAMEPOSITIONX = "AppQueryFramePositionX";
    public static final String APPQUERYFRAMEPOSITIONY = "AppQueryFramePositionY";
    public static final String APPQUERYFRAMEWIDTH = "AppQueryFrameWidth";
    public static final String APPQUERYFRAMEHEIGHT = "AppQueryFrameHeight";
    public static final String APPSEQUENCELIST = "AppSequenceList";
    public static final String APPENABLEPROXY = "AppEnableProxy";
    public static final String APPPROXYADDRESS = "AppProxyAddress";
    public static final String APPPROXYPORT = "AppProxyPort";

    public GeneralProperties() {
        Object object = null;
        object = UIManager.get("Label.font");
        if (object != null && object instanceof Font) {
            Font font = (Font)object;
            this.fontSize = font.getSize();
        } else {
            this.fontSize = 12;
        }
        this.framePosition_X = 0;
        this.framePosition_Y = 0;
        this.frameWidth = 800;
        this.frameHeight = 600;
        this.queryFramePosition_X = 0;
        this.queryFramePosition_Y = 0;
        this.queryFrameWidth = 800;
        this.queryFrameHeight = 600;
        this.sequenceList = null;
        this.enableProxy = false;
        this.proxyAddress = "";
        this.proxyPort = 0;
        try {
            this.generalPreferences = Preferences.userNodeForPackage(GeneralProperties.class);
        }
        catch (SecurityException securityException) {
            return;
        }
        try {
            this.fontSize = this.generalPreferences.getInt(APPFONTSIZE, this.fontSize);
            this.framePosition_X = this.generalPreferences.getInt(APPFRAMEPOSITIONX, this.framePosition_X);
            this.framePosition_Y = this.generalPreferences.getInt(APPFRAMEPOSITIONY, this.framePosition_Y);
            this.frameWidth = this.generalPreferences.getInt(APPFRAMEWIDTH, this.frameWidth);
            this.frameHeight = this.generalPreferences.getInt(APPFRAMEHEIGHT, this.frameHeight);
            this.queryFramePosition_X = this.generalPreferences.getInt(APPQUERYFRAMEPOSITIONX, this.queryFramePosition_X);
            this.queryFramePosition_Y = this.generalPreferences.getInt(APPQUERYFRAMEPOSITIONY, this.queryFramePosition_Y);
            this.queryFrameWidth = this.generalPreferences.getInt(APPQUERYFRAMEWIDTH, this.queryFrameWidth);
            this.queryFrameHeight = this.generalPreferences.getInt(APPQUERYFRAMEHEIGHT, this.queryFrameHeight);
            this.sequenceList = this.generalPreferences.get(APPSEQUENCELIST, this.sequenceList);
            this.enableProxy = this.generalPreferences.getBoolean(APPENABLEPROXY, this.enableProxy);
            this.proxyAddress = this.generalPreferences.get(APPPROXYADDRESS, this.proxyAddress);
            this.proxyPort = this.generalPreferences.getInt(APPPROXYPORT, this.proxyPort);
            if (this.framePosition_X < 0 || this.framePosition_Y < 0) {
                this.framePosition_X = 0;
                this.framePosition_Y = 0;
            }
            if (this.frameWidth <= 0 || this.frameHeight <= 0) {
                this.frameWidth = 800;
                this.frameHeight = 600;
            }
            if (this.queryFramePosition_X < 0 || this.queryFramePosition_Y < 0) {
                this.queryFramePosition_X = 0;
                this.queryFramePosition_Y = 0;
            }
            if (this.queryFrameWidth <= 0 || this.queryFrameHeight <= 0) {
                this.queryFrameWidth = 800;
                this.queryFrameHeight = 600;
            }
            if (this.sequenceList == null || this.sequenceList.isEmpty()) {
                this.setSequenceList(Utils.getChartList(15, 41));
                this.savePreference(APPSEQUENCELIST, this.sequenceList);
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public Point getPosition() {
        return new Point(this.framePosition_X, this.framePosition_Y);
    }

    public Dimension getDimension() {
        return new Dimension(this.frameWidth, this.frameHeight);
    }

    public Point getQueryFramePosition() {
        return new Point(this.queryFramePosition_X, this.queryFramePosition_Y);
    }

    public Dimension getQueryFrameDimension() {
        return new Dimension(this.queryFrameWidth, this.queryFrameHeight);
    }

    public int[] getSequenceList() {
        String[] stringArray = this.sequenceList.split(":");
        int[] nArray = new int[stringArray.length];
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = Integer.parseInt(stringArray[i]);
            }
            return nArray;
        }
        catch (NumberFormatException numberFormatException) {
            return new int[0];
        }
    }

    public boolean getEnableProxy() {
        return this.enableProxy;
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setFontSize(int n) {
        this.fontSize = n;
        this.savePreference(APPFONTSIZE, n);
    }

    public void setPosition(Point point) {
        if (point.x < 0 || point.y <= 0) {
            this.framePosition_X = 0;
            this.framePosition_Y = 0;
        } else {
            this.framePosition_X = point.x;
            this.framePosition_Y = point.y;
        }
        this.savePreference(APPFRAMEPOSITIONX, point.x);
        this.savePreference(APPFRAMEPOSITIONY, point.y);
    }

    public void setDimension(Dimension dimension) {
        if (dimension.width <= 0 || dimension.height <= 0) {
            this.frameWidth = 800;
            this.frameHeight = 600;
        } else {
            this.frameWidth = dimension.width;
            this.frameHeight = dimension.height;
        }
        this.savePreference(APPFRAMEWIDTH, dimension.width);
        this.savePreference(APPFRAMEHEIGHT, dimension.height);
    }

    public void setQueryFramePosition(Point point) {
        if (point.x < 0 || point.y <= 0) {
            this.queryFramePosition_X = 0;
            this.queryFramePosition_Y = 0;
        } else {
            this.queryFramePosition_X = point.x;
            this.queryFramePosition_Y = point.y;
        }
        this.savePreference(APPQUERYFRAMEPOSITIONX, point.x);
        this.savePreference(APPQUERYFRAMEPOSITIONY, point.y);
    }

    public void setQueryFrameDimension(Dimension dimension) {
        if (dimension.width <= 0 || dimension.height <= 0) {
            this.queryFrameWidth = 800;
            this.queryFrameHeight = 600;
        } else {
            this.queryFrameWidth = dimension.width;
            this.queryFrameHeight = dimension.height;
        }
        this.savePreference(APPQUERYFRAMEWIDTH, dimension.width);
        this.savePreference(APPQUERYFRAMEHEIGHT, dimension.height);
    }

    public void setSequenceList(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i] + ":");
        }
        this.sequenceList = stringBuffer.substring(0, stringBuffer.length() - 1);
        this.savePreference(APPSEQUENCELIST, this.sequenceList);
    }

    public void setEnableProxy(boolean bl) {
        this.enableProxy = bl;
        this.savePreference(APPENABLEPROXY, bl);
    }

    public void setProxyAddress(String string) {
        this.proxyAddress = string;
        this.savePreference(APPPROXYADDRESS, string);
    }

    public void setProxyPort(int n) {
        this.proxyPort = n;
        this.savePreference(APPPROXYPORT, n);
    }

    private void savePreference(String string, boolean bl) {
        try {
            if (this.generalPreferences != null) {
                this.generalPreferences.putBoolean(string, bl);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void savePreference(String string, String string2) {
        try {
            if (this.generalPreferences != null) {
                this.generalPreferences.put(string, string2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void savePreference(String string, int n) {
        try {
            if (this.generalPreferences != null) {
                this.generalPreferences.putInt(string, n);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[GeneralProperties: ");
        stringBuffer.append("[fontSize = " + this.fontSize + "]");
        stringBuffer.append("[framePosition_X = " + this.framePosition_X + "]");
        stringBuffer.append("[framePosition_Y = " + this.framePosition_Y + "]");
        stringBuffer.append("[framewidth = " + this.frameWidth + "]");
        stringBuffer.append("[frameheight = " + this.frameHeight + "]");
        stringBuffer.append("[queryFramePosition_X = " + this.queryFramePosition_X + "]");
        stringBuffer.append("[queryFramePosition_Y = " + this.queryFramePosition_Y + "]");
        stringBuffer.append("[queryFramewidth = " + this.queryFrameWidth + "]");
        stringBuffer.append("[queryFrameheight = " + this.queryFrameHeight + "]");
        stringBuffer.append("[enableProxy = " + this.enableProxy + "]");
        stringBuffer.append("[proxyAddress = " + this.proxyAddress + "]");
        stringBuffer.append("proxyPort = " + this.proxyPort + "]");
        return stringBuffer.toString();
    }
}

