/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.structures;

import java.util.prefs.Preferences;

public class GeneralDBProperties {
    private String viewDateFormat = "MM-dd-YYYY";
    private int limitIncrement = 50000;
    private boolean batchSizeEnabled = false;
    private int batchSize = 50000;
    private Preferences generalDBPreferences;
    public static final String VIEWDATEFORMAT = "ViewDateFormat";
    public static final String LIMITINCREMENT = "LimitIncrement";
    public static final String BATCHSIZEENABLED = "BatchSizeEnabled";
    public static final String BATCHSIZE = "BatchSize";

    public GeneralDBProperties() {
        try {
            this.generalDBPreferences = Preferences.userNodeForPackage(GeneralDBProperties.class);
        }
        catch (SecurityException securityException) {
            return;
        }
        try {
            this.viewDateFormat = this.generalDBPreferences.get(VIEWDATEFORMAT, "MM-DD-YYYY");
            this.limitIncrement = this.generalDBPreferences.getInt(LIMITINCREMENT, this.limitIncrement);
            this.batchSizeEnabled = this.generalDBPreferences.getBoolean(BATCHSIZEENABLED, this.batchSizeEnabled);
            this.batchSize = this.generalDBPreferences.getInt(BATCHSIZE, this.batchSize);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public String getViewDateFormat() {
        return this.viewDateFormat;
    }

    public int getLimitIncrement() {
        return this.limitIncrement;
    }

    public boolean getBatchSizeEnabled() {
        return this.batchSizeEnabled;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setViewDateFormat(String string) {
        this.viewDateFormat = string;
        this.savePreference(VIEWDATEFORMAT, string);
    }

    public void setLimitIncrement(int n) {
        this.limitIncrement = n;
        this.savePreference(LIMITINCREMENT, n);
    }

    public void setBatchSizeEnabled(boolean bl) {
        this.batchSizeEnabled = bl;
        this.savePreference(BATCHSIZEENABLED, bl);
    }

    public void setBatchSize(int n) {
        this.batchSize = n;
        this.savePreference(BATCHSIZE, n);
    }

    private void savePreference(String string, boolean bl) {
        try {
            if (this.generalDBPreferences != null) {
                this.generalDBPreferences.putBoolean(string, bl);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void savePreference(String string, String string2) {
        try {
            if (this.generalDBPreferences != null) {
                this.generalDBPreferences.put(string, string2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void savePreference(String string, int n) {
        try {
            if (this.generalDBPreferences != null) {
                this.generalDBPreferences.putInt(string, n);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[GeneralDBProperties: ");
        stringBuffer.append("[viewDataFormat = " + this.viewDateFormat + "]");
        stringBuffer.append("[limitIncrement = " + this.limitIncrement + "]");
        stringBuffer.append("[batchSize = " + this.batchSize + "]");
        return stringBuffer.toString();
    }
}

