/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.structures;

import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.gui.panels.PDFExportPreferencesPanel;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.pdf.BaseFont;
import java.awt.Color;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Locale;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.prefs.Preferences;

public class DataExportProperties {
    private boolean tableStructure = false;
    private boolean tableData = true;
    private String identifierQuoteString = ConnectionManager.getIdentifierQuoteString();
    private int insertPluralSize = 250;
    private int replacePluralSize = 250;
    private boolean insertLock = true;
    private boolean replaceLock = true;
    private boolean updateLock = true;
    private String insertExpression = "Singular";
    private String replaceExpression = "Singular";
    private boolean autoIncrement = false;
    private boolean timeStamp = false;
    private boolean insertType = false;
    private boolean replaceType = false;
    private boolean updateType = false;
    private String insertReplaceUpdate = "Insert";
    private String insertTypeSetting = "Low_Priority";
    private String replaceTypeSetting = "Low_Priority";
    private String updateTypeSetting = "Low_Priority";
    private boolean sqlSummaryTableUseLimit = true;
    private boolean textInclusion = false;
    private int textCharsNumber = 50;
    private String dataDelimiter = ",";
    private String csvDateFormat = "MM-dd-yyyy";
    private boolean csvSummaryTableUseLimit = true;
    private String title = "";
    private int titleFontSize = 14;
    private int titleColor = PDFExportPreferencesPanel.DEFAULT_COLOR.getRGB();
    private int headerFontSize = 12;
    private int headerColor = PDFExportPreferencesPanel.DEFAULT_COLOR.getRGB();
    private int headerBorderSize = 1;
    private int headerBorderColor = PDFExportPreferencesPanel.DEFAULT_COLOR.getRGB();
    private int numberAlignment = 2;
    private int dateAlignment = 1;
    private String pdfDateFormat = "MM-dd-yyyy";
    private String fontName = "Undefined";
    private int pageLayout = 0;
    private Preferences dataExportPreferences;
    private TreeMap<String, Font> fontTreeMap;
    private static final String TABLESTRUCTURE = "TableStructure";
    private static final String TABLEDATA = "TableData";
    private static final String INSERTPLURALSIZE = "InsertPluralSize";
    private static final String REPLACEPLURALSIZE = "ReplacePluralSize";
    private static final String INSERTLOCK = "InsertLock";
    private static final String REPLACELOCK = "replaceLock";
    private static final String UPDATELOCK = "UpdateLock";
    private static final String INSERTEXPRESSION = "InsertExpression";
    private static final String REPLACEEXPRESSION = "replaceExpression";
    private static final String AUTOINCREMENT = "AutoIncrement";
    private static final String TIMESTAMP = "TimeStamp";
    private static final String INSERTTYPE = "InsertType";
    private static final String REPLACETYPE = "ReplaceType";
    private static final String UPDATETYPE = "UpdateType";
    private static final String INSERTREPLACEUPDATE = "InsertReplaceUpdate";
    private static final String INSERTTYPESETTING = "InsertTypeSetting";
    private static final String REPLACETYPESETTING = "ReplaceTypeSetting";
    private static final String UPDATETYPESETTING = "UpdateTypeSetting";
    private static final String SQLSUMMARYTABLEUSELIMIT = "SQLSummaryTableUseLimit";
    private static final String TEXTINCLUSION = "TextInclusion";
    private static final String TEXTCHARSNUMBER = "TextCharsNumber";
    private static final String DATADELIMITER = "ExportDataDelimiter";
    private static final String CSVDATEFORMAT = "ExportCSVDateFormat";
    private static final String CSVSUMMARYTABLEUSELIMIT = "CSVSummaryTableUseLimit";
    private static final String TITLE = "Title";
    private static final String TITLEFONTSIZE = "TitleFontSize";
    private static final String TITLECOLOR = "TitleColor";
    private static final String HEADERFONTSIZE = "HeaderFontSize";
    private static final String HEADERCOLOR = "HeaderColor";
    private static final String HEADERBORDERSIZE = "HeaderBorderSize";
    private static final String HEADERBORDERCOLOR = "HeaderBorderColor";
    private static final String NUMBERALIGNMENT = "NumberAlignment";
    private static final String DATEALIGNMENT = "DateAlignment";
    private static final String PDFDATEFORMAT = "ExportPDFDateFormat";
    private static final String FONTNAME = "FontName";
    private static final String PAGELAYOUT = "PageLayout";

    public DataExportProperties() {
        try {
            this.dataExportPreferences = Preferences.userNodeForPackage(DataExportProperties.class);
        }
        catch (SecurityException securityException) {
            return;
        }
        try {
            this.tableStructure = this.dataExportPreferences.getBoolean(TABLESTRUCTURE, this.tableStructure);
            this.tableData = this.dataExportPreferences.getBoolean(TABLEDATA, this.tableData);
            this.insertPluralSize = this.dataExportPreferences.getInt(INSERTPLURALSIZE, this.insertPluralSize);
            this.replacePluralSize = this.dataExportPreferences.getInt(REPLACEPLURALSIZE, this.replacePluralSize);
            this.insertLock = this.dataExportPreferences.getBoolean(INSERTLOCK, this.insertLock);
            this.replaceLock = this.dataExportPreferences.getBoolean(REPLACELOCK, this.replaceLock);
            this.updateLock = this.dataExportPreferences.getBoolean(UPDATELOCK, this.updateLock);
            this.insertExpression = this.dataExportPreferences.get(INSERTEXPRESSION, this.insertExpression);
            this.replaceExpression = this.dataExportPreferences.get(REPLACEEXPRESSION, this.replaceExpression);
            this.autoIncrement = this.dataExportPreferences.getBoolean(AUTOINCREMENT, this.autoIncrement);
            this.timeStamp = this.dataExportPreferences.getBoolean(TIMESTAMP, this.timeStamp);
            this.insertType = this.dataExportPreferences.getBoolean(INSERTTYPE, this.insertType);
            this.replaceType = this.dataExportPreferences.getBoolean(REPLACETYPE, this.replaceType);
            this.updateType = this.dataExportPreferences.getBoolean(UPDATETYPE, this.updateType);
            this.insertReplaceUpdate = this.dataExportPreferences.get(INSERTREPLACEUPDATE, this.insertReplaceUpdate);
            this.insertTypeSetting = this.dataExportPreferences.get(INSERTTYPESETTING, this.insertTypeSetting);
            this.replaceTypeSetting = this.dataExportPreferences.get(REPLACETYPESETTING, this.replaceTypeSetting);
            this.updateTypeSetting = this.dataExportPreferences.get(UPDATETYPESETTING, this.updateTypeSetting);
            this.sqlSummaryTableUseLimit = this.dataExportPreferences.getBoolean(SQLSUMMARYTABLEUSELIMIT, this.sqlSummaryTableUseLimit);
            this.textInclusion = this.dataExportPreferences.getBoolean(TEXTINCLUSION, this.textInclusion);
            this.textCharsNumber = this.dataExportPreferences.getInt(TEXTCHARSNUMBER, this.textCharsNumber);
            this.dataDelimiter = this.dataExportPreferences.get(DATADELIMITER, this.dataDelimiter);
            this.csvDateFormat = this.dataExportPreferences.get(CSVDATEFORMAT, this.csvDateFormat);
            this.csvSummaryTableUseLimit = this.dataExportPreferences.getBoolean(CSVSUMMARYTABLEUSELIMIT, this.csvSummaryTableUseLimit);
            this.title = this.dataExportPreferences.get(TITLE, this.title);
            this.titleFontSize = this.dataExportPreferences.getInt(TITLEFONTSIZE, this.titleFontSize);
            this.titleColor = this.dataExportPreferences.getInt(TITLECOLOR, this.titleColor);
            this.headerFontSize = this.dataExportPreferences.getInt(HEADERFONTSIZE, this.headerFontSize);
            this.headerColor = this.dataExportPreferences.getInt(HEADERCOLOR, this.headerColor);
            this.headerBorderSize = this.dataExportPreferences.getInt(HEADERBORDERSIZE, this.headerBorderSize);
            this.headerBorderColor = this.dataExportPreferences.getInt(HEADERBORDERCOLOR, this.headerBorderColor);
            this.numberAlignment = this.dataExportPreferences.getInt(NUMBERALIGNMENT, this.numberAlignment);
            this.dateAlignment = this.dataExportPreferences.getInt(DATEALIGNMENT, this.dateAlignment);
            this.pdfDateFormat = this.dataExportPreferences.get(PDFDATEFORMAT, this.pdfDateFormat);
            this.fontName = this.dataExportPreferences.get(FONTNAME, this.fontName);
            this.pageLayout = this.dataExportPreferences.getInt(PAGELAYOUT, this.pageLayout);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.fontTreeMap = new TreeMap();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                DataExportProperties.this.loadPDFFonts();
            }
        }, "DataExportProperties.fontLoadingThread");
        thread.start();
    }

    private void loadPDFFonts() {
        String string = Utils.getFileSeparator();
        String string2 = "fonts" + string;
        TreeSet<String> treeSet = new TreeSet<String>();
        this.fontTreeMap.put("Undefined", new Font(Font.FontFamily.UNDEFINED));
        for (String string3 : FontFactory.getRegisteredFonts()) {
            this.fontTreeMap.put(string3, FontFactory.getFont((String)string3));
        }
        File file = new File(string2);
        if (file.exists()) {
            String[] stringArray;
            int n;
            File[] fileArray = file.listFiles(new DirectoriesFilter());
            if (fileArray != null) {
                for (n = 0; n < fileArray.length; ++n) {
                    stringArray = fileArray[n].list(new FontNameFilter());
                    if (stringArray == null) continue;
                    for (int i = 0; i < stringArray.length; ++i) {
                        treeSet.add(fileArray[n] + string + stringArray[i]);
                    }
                }
            }
            if ((stringArray = file.list(new FontNameFilter())) != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    treeSet.add(string2 + stringArray[n]);
                }
            }
            for (String string4 : treeSet) {
                String string3;
                string3 = string4.indexOf(string) != -1 ? string4.substring(string4.lastIndexOf(string) + 1, string4.indexOf(".")) : string4.substring(0, string4.indexOf("."));
                try {
                    BaseFont baseFont = BaseFont.createFont((String)string4, (String)"Identity-H", (boolean)true);
                    this.fontTreeMap.put(string3, new Font(baseFont, 12.0f));
                }
                catch (DocumentException documentException) {
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean getTableStructure() {
        return this.tableStructure;
    }

    public boolean getTableData() {
        return this.tableData;
    }

    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    public int getInsertPluralSize() {
        return this.insertPluralSize;
    }

    public int getReplacePluralSize() {
        return this.replacePluralSize;
    }

    public boolean getInsertLock() {
        return this.insertLock;
    }

    public boolean getReplaceLock() {
        return this.replaceLock;
    }

    public boolean getUpdateLock() {
        return this.updateLock;
    }

    public String getInsertExpression() {
        return this.insertExpression;
    }

    public String getReplaceExpression() {
        return this.replaceExpression;
    }

    public boolean getAutoIncrement() {
        if (this.insertReplaceUpdate.equals("Insert")) {
            return this.autoIncrement;
        }
        return false;
    }

    public boolean getTimeStamp() {
        if (this.insertReplaceUpdate.equals("Insert")) {
            return this.timeStamp;
        }
        return false;
    }

    public boolean getInsertType() {
        return this.insertType;
    }

    public boolean getReplaceType() {
        return this.replaceType;
    }

    public boolean getUpdateType() {
        return this.updateType;
    }

    public String getInsertReplaceUpdate() {
        return this.insertReplaceUpdate;
    }

    public String getInsertTypeSetting() {
        return this.insertTypeSetting;
    }

    public String getReplaceTypeSetting() {
        return this.replaceTypeSetting;
    }

    public String getUpdateTypeSetting() {
        return this.updateTypeSetting;
    }

    public boolean getLock() {
        if (this.insertReplaceUpdate.equals("Insert")) {
            return this.insertLock;
        }
        if (this.insertReplaceUpdate.equals("Replace")) {
            return this.replaceLock;
        }
        return this.updateLock;
    }

    public String getType() {
        if (this.tableStructure) {
            if (this.insertType) {
                return " " + this.insertTypeSetting + " ";
            }
            return " ";
        }
        if (this.insertReplaceUpdate.equals("Insert")) {
            if (this.insertType) {
                return " " + this.insertTypeSetting + " ";
            }
            return " ";
        }
        if (this.insertReplaceUpdate.equals("Replace")) {
            if (this.replaceType) {
                return " " + this.replaceTypeSetting + " ";
            }
            return " ";
        }
        if (this.insertReplaceUpdate.equals("Update")) {
            if (this.updateType) {
                return " " + this.updateTypeSetting + " ";
            }
            return " ";
        }
        return " ";
    }

    public boolean getSQLSummaryTableUseLimit() {
        return this.sqlSummaryTableUseLimit;
    }

    public boolean getTextInclusion() {
        return this.textInclusion;
    }

    public int getTextCharsNumber() {
        return this.textCharsNumber;
    }

    public String getDataDelimiter() {
        return this.dataDelimiter;
    }

    public String getCSVDateFormat() {
        return this.csvDateFormat;
    }

    public boolean getCSVSummaryTableUseLimit() {
        return this.csvSummaryTableUseLimit;
    }

    public String getTitle() {
        return this.title;
    }

    public int getTitleFontSize() {
        return this.titleFontSize;
    }

    public Color getTitleColor() {
        return new Color(this.titleColor);
    }

    public int getHeaderFontSize() {
        return this.headerFontSize;
    }

    public Color getHeaderColor() {
        return new Color(this.headerColor);
    }

    public int getHeaderBorderSize() {
        return this.headerBorderSize;
    }

    public Color getHeaderBorderColor() {
        return new Color(this.headerBorderColor);
    }

    public int getNumberAlignment() {
        return this.numberAlignment;
    }

    public String getPDFDateFormat() {
        return this.pdfDateFormat;
    }

    public int getDateAlignment() {
        return this.dateAlignment;
    }

    public Font getFont() {
        if (this.fontTreeMap.containsKey(this.fontName)) {
            return this.fontTreeMap.get(this.fontName);
        }
        return this.fontTreeMap.get("Undefined");
    }

    public Object[] getFonts() {
        return this.fontTreeMap.keySet().toArray();
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getPageLayout() {
        return this.pageLayout;
    }

    public void setTableStructure(boolean bl) {
        this.tableStructure = bl;
        this.savePreference(TABLESTRUCTURE, bl);
    }

    public void setTableData(boolean bl) {
        this.tableData = bl;
        this.savePreference(TABLEDATA, bl);
    }

    public void setIdentifierQuoteString(String string) {
        this.identifierQuoteString = string;
    }

    public void setInsertPluralSize(int n) {
        this.insertPluralSize = n;
        this.savePreference(INSERTPLURALSIZE, n);
    }

    public void setReplacePluralSize(int n) {
        this.replacePluralSize = n;
        this.savePreference(REPLACEPLURALSIZE, n);
    }

    public void setInsertLock(boolean bl) {
        this.insertLock = bl;
        this.savePreference(INSERTLOCK, bl);
    }

    public void setReplaceLock(boolean bl) {
        this.replaceLock = bl;
        this.savePreference(REPLACELOCK, bl);
    }

    public void setUpdateLock(boolean bl) {
        this.updateLock = bl;
        this.savePreference(UPDATELOCK, bl);
    }

    public void setInsertExpression(String string) {
        this.insertExpression = string;
        this.savePreference(INSERTEXPRESSION, string);
    }

    public void setReplaceExpression(String string) {
        this.replaceExpression = string;
        this.savePreference(REPLACEEXPRESSION, string);
    }

    public void setAutoIncrement(boolean bl) {
        this.autoIncrement = bl;
        this.savePreference(AUTOINCREMENT, bl);
    }

    public void setTimeStamp(boolean bl) {
        this.timeStamp = bl;
        this.savePreference(TIMESTAMP, bl);
    }

    public void setInsertType(boolean bl) {
        this.insertType = bl;
        this.savePreference(INSERTTYPE, bl);
    }

    public void setReplaceType(boolean bl) {
        this.replaceType = bl;
        this.savePreference(REPLACETYPE, bl);
    }

    public void setUpdateType(boolean bl) {
        this.updateType = bl;
        this.savePreference(UPDATETYPE, bl);
    }

    public void setInsertReplaceUpdate(String string) {
        this.insertReplaceUpdate = string;
        this.savePreference(INSERTREPLACEUPDATE, string);
    }

    public void setInsertTypeSetting(String string) {
        this.insertTypeSetting = string;
        this.savePreference(INSERTTYPESETTING, string);
    }

    public void setReplaceTypeSetting(String string) {
        this.replaceTypeSetting = string;
        this.savePreference(REPLACETYPESETTING, string);
    }

    public void setUpdateTypeSetting(String string) {
        this.updateTypeSetting = string;
        this.savePreference(UPDATETYPESETTING, string);
    }

    public void setSQLSummaryTableUseLimit(boolean bl) {
        this.sqlSummaryTableUseLimit = bl;
        this.savePreference(SQLSUMMARYTABLEUSELIMIT, bl);
    }

    public void setTextInclusion(boolean bl) {
        this.textInclusion = bl;
        this.savePreference(TEXTINCLUSION, bl);
    }

    public void setTextCharsNumber(int n) {
        this.textCharsNumber = n;
        this.savePreference(TEXTCHARSNUMBER, n);
    }

    public void setDataDelimiter(String string) {
        this.dataDelimiter = string;
        this.savePreference(DATADELIMITER, string);
    }

    public void setCSVDateFormat(String string) {
        this.csvDateFormat = string;
        this.savePreference(CSVDATEFORMAT, string);
    }

    public void setCSVSummaryTableUseLimit(boolean bl) {
        this.csvSummaryTableUseLimit = bl;
        this.savePreference(CSVSUMMARYTABLEUSELIMIT, bl);
    }

    public void setTitle(String string) {
        this.title = string;
        this.savePreference(TITLE, string);
    }

    public void setTitleFontSize(int n) {
        this.titleFontSize = n;
        this.savePreference(TITLEFONTSIZE, n);
    }

    public void setTitleColor(Color color) {
        this.titleColor = color.getRGB();
        this.savePreference(TITLECOLOR, color.getRGB());
    }

    public void setHeaderFontSize(int n) {
        this.headerFontSize = n;
        this.savePreference(HEADERFONTSIZE, n);
    }

    public void setHeaderColor(Color color) {
        this.headerColor = color.getRGB();
        this.savePreference(HEADERCOLOR, color.getRGB());
    }

    public void setHeaderBorderSize(int n) {
        this.headerBorderSize = n;
        this.savePreference(HEADERBORDERSIZE, n);
    }

    public void setHeaderBorderColor(Color color) {
        this.headerBorderColor = color.getRGB();
        this.savePreference(HEADERBORDERCOLOR, color.getRGB());
    }

    public void setNumberAlignment(int n) {
        this.numberAlignment = n;
        this.savePreference(NUMBERALIGNMENT, n);
    }

    public void setPDFDateFormat(String string) {
        this.pdfDateFormat = string;
        this.savePreference(PDFDATEFORMAT, string);
    }

    public void setDateAlignment(int n) {
        this.dateAlignment = n;
        this.savePreference(DATEALIGNMENT, n);
    }

    public void setFontName(String string) {
        this.fontName = string;
        this.savePreference(FONTNAME, string);
    }

    public void setPageLayout(int n) {
        this.pageLayout = n;
        this.savePreference(PAGELAYOUT, n);
    }

    private void savePreference(String string, boolean bl) {
        try {
            if (this.dataExportPreferences != null) {
                this.dataExportPreferences.putBoolean(string, bl);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void savePreference(String string, String string2) {
        try {
            if (this.dataExportPreferences != null) {
                this.dataExportPreferences.put(string, string2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void savePreference(String string, int n) {
        try {
            if (this.dataExportPreferences != null) {
                this.dataExportPreferences.putInt(string, n);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[DataExportProperties: ");
        stringBuffer.append("[tableStructure = " + this.tableStructure + "]");
        stringBuffer.append("[tableData = " + this.tableData + "]");
        stringBuffer.append("[identifierQuoteString = " + this.identifierQuoteString + "]");
        stringBuffer.append("[insertPluralSize " + this.insertPluralSize + "]");
        stringBuffer.append("[replacePluralSize " + this.replacePluralSize + "]");
        stringBuffer.append("[insertLock = " + this.insertLock + "]");
        stringBuffer.append("[replaceLock = " + this.replaceLock + "]");
        stringBuffer.append("[updateLock = " + this.updateLock + "]");
        stringBuffer.append("[insertExplicit = " + this.insertExpression + "]");
        stringBuffer.append("[replaceExplicit = " + this.replaceExpression + "]");
        stringBuffer.append("[autoIncrement = " + this.autoIncrement + "]");
        stringBuffer.append("[timeStamp = " + this.timeStamp + "]");
        stringBuffer.append("[insertType = " + this.insertType + "]");
        stringBuffer.append("[replaceType = " + this.replaceType + "]");
        stringBuffer.append("[updateType = " + this.updateType + "]");
        stringBuffer.append("[insertReplaceUpdate = " + this.insertReplaceUpdate + "]");
        stringBuffer.append("[insertTypeSetting = " + this.insertTypeSetting + "]");
        stringBuffer.append("[replaceTypeSetting = " + this.replaceTypeSetting + "]");
        stringBuffer.append("[updateTypeSetting = " + this.updateTypeSetting + "]");
        stringBuffer.append("[sqlSummaryTableUseLimit = " + this.sqlSummaryTableUseLimit + "]");
        stringBuffer.append("[textInclusion = " + this.textInclusion + "]");
        stringBuffer.append("[textCharsNumber = " + this.textCharsNumber + "]");
        stringBuffer.append("[dataDelimiter = " + this.dataDelimiter + "]");
        stringBuffer.append("[csvDataFormat = " + this.csvDateFormat + "]");
        stringBuffer.append("[csvSummaryTableUseLimit = " + this.csvSummaryTableUseLimit + "]");
        stringBuffer.append("[title = " + this.title + "]");
        stringBuffer.append("[titleFontSize = " + this.titleFontSize + "]");
        stringBuffer.append("[titleColor = " + this.titleColor + "]");
        stringBuffer.append("[headerFontSize = " + this.headerFontSize + "]");
        stringBuffer.append("[headerColor = " + this.headerColor + "]");
        stringBuffer.append("[headerBorderSize = " + this.headerBorderSize + "]");
        stringBuffer.append("[headerBorderColor = " + this.headerBorderColor + "]");
        stringBuffer.append("[numberAlignment = " + this.numberAlignment + "]");
        stringBuffer.append("[pdfDateFormat = " + this.pdfDateFormat + "]");
        stringBuffer.append("[dateAlignment = " + this.dateAlignment + "]");
        stringBuffer.append("[fontName = " + this.fontName + "]");
        stringBuffer.append("[pageLayout = " + this.pageLayout + "]");
        return stringBuffer.toString();
    }

    static class FontNameFilter
    implements FilenameFilter {
        FontNameFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.toLowerCase(Locale.ENGLISH).endsWith(".ttf") || string.toLowerCase(Locale.ENGLISH).endsWith("otf");
        }
    }

    static class DirectoriesFilter
    implements FileFilter {
        DirectoriesFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    }
}

