/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.plugin;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.io.WriteDataFile;
import com.dandymadeproductions.ajqvue.plugin.Plugin;
import com.dandymadeproductions.ajqvue.plugin.PluginListHandler;
import com.dandymadeproductions.ajqvue.plugin.PluginRepositoryInterface;
import com.dandymadeproductions.ajqvue.structures.GeneralProperties;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import javax.swing.JOptionPane;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class PluginRepository
implements PluginRepositoryInterface {
    private String repositoryName = "";
    private String repositoryPath = "";
    private String repositoryType = "unknown";
    private String[] repositoryOptions;
    private ArrayList<Plugin> pluginsList;
    protected GeneralProperties generalProperties;
    protected String remoteRepositoryURL;
    protected String cachedRepositoryURL;
    protected String cachedRepositoryDirectoryString;
    protected boolean downloadRepository;
    protected boolean isRepositoryCached;
    protected boolean debugMode;
    public static final String FILE = "file";
    public static final String FTP = "ftp";
    public static final String FTPS = "ftps";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String UNKNOWN = "unknown";
    public static final String REPOSITORY_PATH_FILE = ".path";
    protected static final int GZIP_MAGIC_1 = 31;
    protected static final int GZIP_MAGIC_2 = 139;
    protected static final String REPOSITORY_FILENAME = "ajqvue_plugin_list.xml.gz";
    protected static final String REPOSITORY_CACHED_FILE = "repository-cache.xml.gz";

    public PluginRepository(boolean bl) {
        this.downloadRepository = bl;
        this.isRepositoryCached = false;
        this.debugMode = Ajqvue.getDebug();
        this.generalProperties = Ajqvue.getGeneralProperties();
        this.pluginsList = new ArrayList();
    }

    @Override
    public void setName(String string) {
        this.repositoryName = string;
    }

    @Override
    public void setPath(String string) {
        this.repositoryPath = string;
        if (!string.isEmpty() && this.isRepositoryCached) {
            String string2 = this.cachedRepositoryDirectoryString + Utils.getFileSeparator() + REPOSITORY_PATH_FILE;
            WriteDataFile.mainWriteDataString(string2, string.getBytes(), false);
        }
    }

    @Override
    public void setType(String string) {
        this.repositoryType = string;
    }

    @Override
    public void setOptions(String[] stringArray) {
        this.repositoryOptions = stringArray;
    }

    @Override
    public boolean setRepository(String string) {
        this.remoteRepositoryURL = string.endsWith("/") ? string + REPOSITORY_FILENAME : string + "/" + REPOSITORY_FILENAME;
        this.cachedRepositoryDirectoryString = Utils.getCacheDirectory() + this.getName();
        String string2 = Utils.getFileSeparator();
        boolean bl = false;
        File file = new File(this.cachedRepositoryDirectoryString);
        if (file.exists() && file.isDirectory()) {
            this.isRepositoryCached = true;
            File file2 = new File(this.cachedRepositoryDirectoryString + string2 + REPOSITORY_CACHED_FILE);
            bl = file2.isFile();
        } else {
            this.isRepositoryCached = file.mkdir();
            bl = false;
        }
        this.cachedRepositoryURL = this.isRepositoryCached ? "file:" + this.cachedRepositoryDirectoryString + string2 + REPOSITORY_CACHED_FILE : this.remoteRepositoryURL;
        if (this.debugMode) {
            System.out.println("PluginRepository setRepository() Repository: " + this.getName() + "\nremoteRepositoryURL: " + this.remoteRepositoryURL + "\ncachedRepositoryURL: " + this.cachedRepositoryURL);
        }
        if (this.downloadRepository && this.isRepositoryCached && !bl) {
            bl = this.loadPluginList();
        }
        if (bl) {
            bl = this.readPluginList(true);
        }
        if (bl) {
            this.setPath(string);
            for (Plugin plugin : this.getPluginItems()) {
                plugin.setPath_FileName(this.remoteRepositoryURL.substring(0, this.remoteRepositoryURL.length() - REPOSITORY_FILENAME.length()) + plugin.getJAR());
            }
        }
        return bl;
    }

    @Override
    public void refresh() {
        if (this.isRepositoryCached && this.loadPluginList()) {
            this.readPluginList(true);
        }
        for (Plugin plugin : this.getPluginItems()) {
            plugin.setPath_FileName(this.remoteRepositoryURL.substring(0, this.remoteRepositoryURL.length() - REPOSITORY_FILENAME.length()) + plugin.getJAR());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean readPluginList(boolean bl) {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        InputStreamReader inputStreamReader = null;
        boolean bl2 = false;
        try {
            URL uRL = new URL(this.cachedRepositoryURL);
            URLConnection uRLConnection = uRL.openConnection(Proxy.NO_PROXY);
            inputStream = uRLConnection.getInputStream();
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            PluginListHandler pluginListHandler = new PluginListHandler(this);
            inputStream2 = new BufferedInputStream(inputStream);
            if (inputStream2.markSupported()) {
                inputStream2.mark(2);
                int n = inputStream2.read();
                int n2 = inputStream2.read();
                inputStream2.reset();
                if (n == 31 && n2 == 139) {
                    inputStream2 = new GZIPInputStream(inputStream2);
                }
            }
            inputStreamReader = new InputStreamReader(inputStream2, "UTF8");
            InputSource inputSource = new InputSource(inputStreamReader);
            inputSource.setSystemId("Ajqvue.jar");
            xMLReader.setContentHandler(pluginListHandler);
            xMLReader.setDTDHandler(pluginListHandler);
            xMLReader.setEntityResolver(pluginListHandler);
            xMLReader.setErrorHandler(pluginListHandler);
            xMLReader.parse(inputSource);
            bl2 = true;
            return bl2;
        }
        catch (MalformedURLException malformedURLException) {
            this.readPluginListException(malformedURLException, bl);
            return bl2;
        }
        catch (UnknownHostException unknownHostException) {
            this.readPluginListException(unknownHostException, bl);
            return bl2;
        }
        catch (IOException iOException) {
            this.readPluginListException(iOException, bl);
            return bl2;
        }
        catch (SAXException sAXException) {
            this.readPluginListException(sAXException, bl);
            return bl2;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                if (this.debugMode) {
                    System.out.println("PluginRepository readPluginList() Failed to close urlInputStream. " + iOException.toString());
                }
            }
            finally {
                try {
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                }
                catch (IOException iOException) {
                    if (this.debugMode) {
                        System.out.println("PluginRepository readPluginList() Failed to close inputStream. " + iOException.toString());
                    }
                }
                finally {
                    block226: {
                        try {
                            if (inputStreamReader != null) {
                                inputStreamReader.close();
                            }
                        }
                        catch (IOException iOException) {
                            if (!this.debugMode) break block226;
                            System.out.println("PluginRepository readPluginList() Failed to close inputStreamReader. " + iOException.toString());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void addPluginItem(Plugin plugin) {
        this.pluginsList.add(plugin);
    }

    @Override
    public void clearPluginItems() {
        this.pluginsList.clear();
    }

    @Override
    public String getName() {
        return this.repositoryName;
    }

    @Override
    public String getPath() {
        return this.repositoryPath;
    }

    @Override
    public String getRepositoryType() {
        return this.repositoryType;
    }

    @Override
    public String[] getRepositoryOptions() {
        return this.repositoryOptions;
    }

    @Override
    public ArrayList<Plugin> getPluginItems() {
        return this.pluginsList;
    }

    public void readPluginListException(Exception exception, boolean bl) {
        if (this.cachedRepositoryURL.startsWith("file:") && bl) {
            this.clearPluginItems();
            if (exception instanceof SAXException) {
                this.loadPluginList();
            }
            this.readPluginList(false);
        } else {
            this.displayErrors("PluginRepository readPluginList() Exception: " + exception.toString());
        }
    }

    protected void displayErrors(String string) {
        if (string.length() > 200) {
            string = string.substring(0, 200);
        }
        String string2 = "Error Loading Repository\n" + string;
        JOptionPane.showMessageDialog(null, string2, "Alert", 0);
    }
}

