/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.plugin;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.gui.Main_Frame;
import com.dandymadeproductions.ajqvue.gui.PluginFrame;
import com.dandymadeproductions.ajqvue.io.WriteDataFile;
import com.dandymadeproductions.ajqvue.plugin.PluginThread;
import com.dandymadeproductions.ajqvue.plugin.Plugin_Module;
import com.dandymadeproductions.ajqvue.structures.GeneralProperties;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class PluginLoader
implements Runnable {
    Thread pluginLoaderThread;
    private Main_Frame parentFrame;
    private URL pluginURL;
    private String repositoryName;
    private String repositoryType;
    private String[] repositoryOptions;
    private String fileSeparator;
    private String pluginDirectoryString;
    private String pluginFileName;
    private String pluginConfigFileString;
    private HashMap<String, String> pluginEntriesHashMap;
    private GeneralProperties generalProperties;
    private static final String CONFIGURATION_FILENAME = "ajqvue_plugin.conf";
    private static final String VALID_PLUGIN_MODULENAME = "PluginModule.class";
    public static final String pathClassSeparator = "<$$$>";

    public PluginLoader(Main_Frame main_Frame) {
        try {
            this.init(main_Frame, new URL("file:"), "", "file", null);
        }
        catch (MalformedURLException malformedURLException) {
            this.displayErrors("PluginLoader Constructor failed to create empty file:URL\n" + malformedURLException.toString());
        }
    }

    public PluginLoader(Main_Frame main_Frame, URL uRL, String string, String string2, String[] stringArray) {
        this.init(main_Frame, uRL, string, string2, stringArray);
    }

    private void init(Main_Frame main_Frame, URL uRL, String string, String string2, String[] stringArray) {
        this.parentFrame = main_Frame;
        this.pluginURL = uRL;
        this.repositoryName = string;
        this.repositoryType = string2;
        this.repositoryOptions = stringArray;
        if (uRL == null) {
            return;
        }
        this.fileSeparator = Utils.getFileSeparator();
        this.pluginConfigFileString = Utils.getAjqvueConfDirectory() + Utils.getFileSeparator() + CONFIGURATION_FILENAME;
        this.generalProperties = Ajqvue.getGeneralProperties();
        this.pluginFileName = uRL.getFile();
        if (this.pluginFileName.indexOf(this.fileSeparator) != -1) {
            this.pluginFileName = this.pluginFileName.substring(this.pluginFileName.lastIndexOf(this.fileSeparator) + 1, this.pluginFileName.length());
        }
        this.pluginDirectoryString = this.pluginFileName.equals("") ? Utils.getAjqvueDirectory() + this.fileSeparator + "lib" + this.fileSeparator + "plugins" + this.fileSeparator : "";
        this.pluginEntriesHashMap = new HashMap();
        this.pluginLoaderThread = new Thread((Runnable)this, "PluginLoader Thread");
        this.pluginLoaderThread.start();
    }

    @Override
    public void run() {
        if (!this.pluginFileName.equals("")) {
            try {
                this.loadPluginEntry();
            }
            catch (IOException iOException) {}
        } else {
            try {
                this.loadDefaultPluginEntries();
                this.loadConfigurationFilePluginEntries();
            }
            catch (IOException iOException) {
                this.displayErrors("PluginLoader run() \n" + iOException.toString());
            }
        }
        this.loadPluginModules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadPluginEntry() throws IOException {
        if (!this.pluginFileName.toLowerCase(Locale.ENGLISH).endsWith(".jar")) {
            return;
        }
        URL uRL = this.pluginURL;
        ZipFile zipFile = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            Object object;
            if (this.pluginURL.getProtocol().equals("file")) {
                zipFile = new ZipFile(new File(this.pluginURL.toExternalForm().substring(this.pluginURL.toExternalForm().indexOf("file:") + 5)));
            } else {
                if (!this.pluginURL.getProtocol().startsWith("http")) {
                    if (!this.pluginURL.getProtocol().startsWith("ftp")) return;
                }
                object = null;
                if (this.generalProperties.getEnableProxy() && this.repositoryType.startsWith("http")) {
                    object = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.generalProperties.getProxyAddress(), this.generalProperties.getProxyPort()));
                }
                String string = Utils.getCacheDirectory() + this.repositoryName + this.fileSeparator + this.pluginFileName;
                if (!this.cacheJAR(this.pluginURL.toExternalForm(), string, (Proxy)object, true)) {
                    JOptionPane.showMessageDialog(null, "PluginLoader loadPluginEntry() Failed Cache of Network JAR", "Alert", 0);
                    return;
                }
                uRL = new URL("file:" + string);
                if (Ajqvue.getDebug()) {
                    System.out.println("PluginLoader loadPluginEntry() JAR Cached: " + string);
                }
                URL uRL2 = new URL(uRL, "jar:" + uRL + "!/");
                JarURLConnection jarURLConnection = (JarURLConnection)uRL2.openConnection();
                zipFile = jarURLConnection.getJarFile();
            }
            String string = "";
            object = zipFile.entries();
            while (object.hasMoreElements()) {
                String string2 = object.nextElement().getName();
                if (!string2.endsWith(".class") || string2.indexOf("$") != -1 || string2.indexOf(VALID_PLUGIN_MODULENAME) == -1) continue;
                string2 = string2.replaceAll("/", ".");
                string = string2 = string2.substring(0, string2.indexOf(".class"));
                if (string.startsWith("java.") || string.startsWith("javax.")) continue;
                this.pluginEntriesHashMap.put(uRL.toExternalForm(), string);
            }
            if (this.pluginFileName.equals("")) return;
            if (string.equals("")) return;
            String string3 = uRL.toExternalForm() + pathClassSeparator + string + "\n";
            File file = new File(this.pluginConfigFileString);
            if (!file.exists()) {
                WriteDataFile.mainWriteDataString(this.pluginConfigFileString, string3.getBytes(), false);
                return;
            }
            outputStreamWriter = new FileWriter(this.pluginConfigFileString, true);
            object = new char[string3.length()];
            string3.getChars(0, string3.length(), (char[])object, 0);
            outputStreamWriter.write((char[])object);
            outputStreamWriter.flush();
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.displayErrors("PluginLoader loadPluginEntry() MalFormedException: " + this.pluginFileName + "\n" + malformedURLException.toString());
            return;
        }
        catch (IOException iOException) {
            this.displayErrors("PluginLoader loadPluginEntry() IOException: " + this.pluginFileName + "\n" + iOException.toString());
            return;
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {
                this.displayErrors("PluginLoader loadPluginEntry() Failed to close jarFile\n" + iOException.toString());
            }
            finally {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean cacheJAR(String var1_1, String var2_2, Proxy var3_3, boolean var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultPluginEntries() throws IOException {
        File file = new File(this.pluginDirectoryString);
        if (!file.exists()) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        ZipFile zipFile = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].toLowerCase(Locale.ENGLISH).endsWith(".jar")) continue;
            try {
                zipFile = new ZipFile(this.pluginDirectoryString + stringArray[i]);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement().getName();
                    if (!string.endsWith(".class") || string.indexOf("$") != -1 || string.indexOf(VALID_PLUGIN_MODULENAME) == -1) continue;
                    String string2 = new URL("file:" + this.pluginDirectoryString + stringArray[i]).toExternalForm();
                    string = string.replaceAll("/", ".");
                    if ((string = string.substring(0, string.indexOf(".class"))).startsWith("java.") || string.startsWith("javax.")) continue;
                    this.pluginEntriesHashMap.put(string2, string);
                }
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                this.displayErrors("PluginLoader loadDefaultPluginEntries() MalformedURLException: " + stringArray[i] + "\n" + malformedURLException.toString());
                continue;
            }
            catch (IOException iOException) {
                this.displayErrors("PluginLoader loadDefaultPluginEntries() IOException: " + stringArray[i] + "\n" + iOException.toString());
                continue;
            }
            finally {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadConfigurationFilePluginEntries() throws IOException {
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            File file = new File(this.pluginConfigFileString);
            try {
                if (!file.exists()) {
                    return;
                }
            }
            catch (SecurityException securityException) {
                this.displayErrors("PluginLoader loadConfigurationFilePluginEntries() Security Exception: " + securityException.toString());
                return;
            }
            inputStreamReader = new FileReader(this.pluginConfigFileString);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).indexOf(pathClassSeparator) == -1) continue;
                String string2 = string.substring(0, string.indexOf(pathClassSeparator));
                String string3 = string.substring(string.indexOf(pathClassSeparator) + pathClassSeparator.length());
                if (string3.startsWith("java.") || string3.startsWith("javax.")) continue;
                this.pluginEntriesHashMap.put(string2, string3);
            }
            return;
        }
        catch (IOException iOException) {
            this.displayErrors("PluginLoader loadConfigurationFilePluginEntries() File I/O problem, reading " + this.pluginConfigFileString + "\n" + iOException.toString());
            return;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                this.displayErrors("PluginLoader loadConfigurationFilePluginEntries() Failed to close bufferReader\n" + iOException.toString());
            }
            finally {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
        }
    }

    private void loadPluginModules() {
        String string = Utils.getIconsDirectory() + this.fileSeparator;
        ImageIcon imageIcon = Ajqvue.getResourceBundle().getResourceImage(string + "newsiteLeafIcon.png");
        Set<Map.Entry<String, String>> set = this.pluginEntriesHashMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            Object object;
            final String string2 = entry.getKey();
            ClassLoader classLoader = AccessController.doPrivileged(new PriviledgedControl(string2));
            if (classLoader == null) continue;
            try {
                if (Ajqvue.getDebug()) {
                    System.out.println("PluginLoader loadPluginModules() " + entry.getValue());
                }
                try {
                    Class<?> clazz = Class.forName(entry.getValue(), true, classLoader);
                    if (clazz.newInstance() instanceof Plugin_Module) {
                        object = (Plugin_Module)clazz.newInstance();
                        ((Plugin_Module)object).path_FileName = entry.getKey() + pathClassSeparator + entry.getValue();
                        new PluginThread(this.parentFrame, (Plugin_Module)object, imageIcon);
                        continue;
                    }
                    throw new Exception();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new Exception(classNotFoundException);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    throw new Exception(noClassDefFoundError);
                }
            }
            catch (Exception exception) {
                this.displayErrors("PluginLoader loadPluginModules() Exception: \n" + exception.toString());
                object = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        PluginFrame.removePluginConfigurationModule(string2);
                    }
                }, "PluginLoader.removePluginConfigurationModuleThread2");
                ((Thread)object).start();
            }
        }
    }

    public void displayErrors(String string) {
        if (Ajqvue.getDebug()) {
            System.out.println(string);
        }
    }

    class PriviledgedControl
    implements PrivilegedAction<ClassLoader> {
        String pluginURLString;

        PriviledgedControl(String string) {
            this.pluginURLString = string;
        }

        @Override
        public ClassLoader run() {
            try {
                return new URLClassLoader(new URL[]{new URL(this.pluginURLString)}, ClassLoader.getSystemClassLoader());
            }
            catch (MalformedURLException malformedURLException) {
                PluginLoader.this.displayErrors("PluginLoader classLoader Exception: \n" + malformedURLException.toString());
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        PluginFrame.removePluginConfigurationModule(PriviledgedControl.this.pluginURLString);
                    }
                }, "PluginLoader.removePluginConfigurationModuleThread1");
                thread.start();
                return null;
            }
        }
    }
}

