/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.plugin;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.plugin.Plugin;
import com.dandymadeproductions.ajqvue.plugin.PluginRepository;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class PluginListHandler
extends DefaultHandler {
    private final PluginRepository pluginRepository;
    private Plugin plugin;
    private String name;
    private String jar;
    private StringBuilder author;
    private StringBuilder version;
    private StringBuilder description;
    private StringBuilder category;
    private StringBuilder size;
    boolean debug;
    private final Stack<String> stateStack = new Stack();
    private static final String DTD_PARSER = "ajqvue_plugins.dtd";

    PluginListHandler(PluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
        this.author = new StringBuilder();
        this.version = new StringBuilder();
        this.description = new StringBuilder();
        this.category = new StringBuilder();
        this.size = new StringBuilder();
        this.debug = Ajqvue.getDebug();
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        block3: {
            AResourceBundle aResourceBundle;
            File file;
            if (string2 != null && string2.endsWith(DTD_PARSER) && (file = (aResourceBundle = Ajqvue.getResourceBundle()).getResourceFile(DTD_PARSER)) != null) {
                try {
                    return new InputSource(new BufferedInputStream(new FileInputStream(file)));
                }
                catch (Exception exception) {
                    if (!this.debug) break block3;
                    System.out.println("PluginListHandler resolveEntity() " + exception.toString());
                }
            }
        }
        return null;
    }

    public void attribute(String string, String string2, boolean bl) {
        if (string.equals("NAME")) {
            this.name = string2;
        } else if (string.equals("JAR")) {
            this.jar = string2;
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        String string = this.peekElement();
        if (string.equals("AUTHOR")) {
            this.author.append(cArray, n, n2);
        } else if (string.equals("VERSION")) {
            this.version.append(cArray, n, n2);
        } else if (string.equals("DESCRIPTION")) {
            this.description.append(cArray, n, n2);
        } else if (string.equals("CATEGORY")) {
            this.category.append(cArray, n, n2);
        } else if (string.equals("SIZE")) {
            this.size.append(cArray, n, n2);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string4 = attributes.getQName(i);
            String string5 = attributes.getValue(i);
            this.attribute(string4, string5, true);
        }
        if ((string3 = this.pushElement(string3)).equals("PLUGIN")) {
            this.author.setLength(0);
            this.version.setLength(0);
            this.description.setLength(0);
            this.category.setLength(0);
            this.size.setLength(0);
            this.plugin = new Plugin();
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.popElement();
        if (string3.equals("PLUGIN")) {
            int n;
            this.plugin.setName(this.name);
            this.plugin.setJAR(this.jar);
            this.plugin.setAuthor(this.author.toString());
            this.plugin.setVersion(this.version.toString());
            this.plugin.setDescription(this.description.toString());
            this.plugin.setCategory(this.category.toString());
            try {
                n = Integer.parseInt(this.size.toString());
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            this.plugin.setSize(n);
            this.pluginRepository.addPluginItem(this.plugin);
            this.name = null;
            this.jar = null;
            this.author.setLength(0);
            this.version.setLength(0);
            this.description.setLength(0);
            this.category.setLength(0);
            this.size.setLength(0);
        }
    }

    @Override
    public void startDocument() {
        block2: {
            try {
                this.pushElement(null);
            }
            catch (Exception exception) {
                if (!this.debug) break block2;
                System.out.println("PluginListHandler startDocument() " + exception.toString());
            }
        }
    }

    private String pushElement(String string) {
        this.stateStack.push(string);
        return string;
    }

    private String peekElement() {
        return this.stateStack.peek();
    }

    private String popElement() {
        return this.stateStack.pop();
    }
}

