/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.plugin;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.plugin.RepositoryAccess;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import javax.net.ssl.TrustManager;
import javax.swing.JOptionPane;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.net.util.TrustManagerUtils;

public class FTP_Client {
    private String repositoryType;
    private String remoteResourceURL;
    private String[] options;
    private String encoding;
    private long keepAliveTimeout;
    private String protocol;
    private String serverType;
    private String trustmgr;

    public FTP_Client(String string, String string2, String[] stringArray) {
        this.repositoryType = string;
        this.remoteResourceURL = string2;
        this.options = stringArray;
        this.keepAliveTimeout = -1L;
        if (stringArray != null) {
            this.configureOptions();
        }
    }

    private void configureOptions() {
        int n = 0;
        for (n = 0; n < this.options.length; ++n) {
            if (this.options[n].equals("-E")) {
                this.encoding = this.options[++n];
                continue;
            }
            if (this.options[n].equals("-k")) {
                try {
                    this.keepAliveTimeout = Long.parseLong(this.options[++n]);
                }
                catch (NumberFormatException numberFormatException) {
                    this.keepAliveTimeout = -1L;
                }
                continue;
            }
            if (this.options[n].equals("-p")) {
                this.protocol = this.options[++n];
                continue;
            }
            if (this.options[n].equals("-S")) {
                this.serverType = this.options[++n];
                continue;
            }
            if (this.options[n].equals("-T")) {
                this.trustmgr = this.options[++n];
                continue;
            }
            this.options = null;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FTPClient createFTPClient() {
        FTPSClient fTPSClient;
        FTPClient fTPClient = null;
        boolean bl = false;
        if (!this.repositoryType.equals("ftp") && !this.repositoryType.equals("ftps")) {
            return null;
        }
        RepositoryAccess repositoryAccess = new RepositoryAccess(true);
        if (!repositoryAccess.promptUserPassword()) {
            return null;
        }
        if (this.repositoryType.equals("ftp")) {
            fTPClient = new FTPClient();
        } else {
            String[] stringArray;
            fTPSClient = this.options != null && this.protocol != null ? (this.protocol.equals("true") ? new FTPSClient(true) : (this.protocol.equals("false") ? new FTPSClient(false) : ((stringArray = this.protocol.split(",")).length == 1 ? new FTPSClient(this.protocol) : new FTPSClient(stringArray[0], Boolean.parseBoolean(stringArray[1]))))) : new FTPSClient();
            if (this.options != null && this.trustmgr != null) {
                if (this.trustmgr.equals("all")) {
                    fTPSClient.setTrustManager((TrustManager)TrustManagerUtils.getAcceptAllTrustManager());
                } else if (this.trustmgr.equals("valid")) {
                    fTPSClient.setTrustManager((TrustManager)TrustManagerUtils.getValidateServerCertificateTrustManager());
                } else {
                    fTPSClient.setTrustManager(null);
                }
            }
            fTPClient = fTPSClient;
        }
        if (this.options != null) {
            if (this.keepAliveTimeout >= 0L) {
                fTPClient.setControlKeepAliveTimeout(this.keepAliveTimeout);
            }
            if (this.encoding != null) {
                fTPClient.setControlEncoding(this.encoding);
            }
            if (this.serverType != null) {
                FTPClientConfig fTPClientConfig = new FTPClientConfig(this.serverType);
                fTPClient.configure(fTPClientConfig);
            }
        }
        try {
            URL uRL = this.repositoryType.equals("ftps") ? new URL("ftp" + this.remoteResourceURL.substring(4)) : new URL(this.remoteResourceURL);
            if (uRL.getPort() != -1 && uRL.getPort() != fTPClient.getDefaultPort()) {
                fTPClient.connect(uRL.getHost(), uRL.getPort());
            } else {
                fTPClient.connect(uRL.getHost());
            }
            if (!FTPReply.isPositiveCompletion((int)fTPClient.getReplyCode())) {
                this.displayErrors("FTP_Client createFTPClient() Refused Connection:\n" + fTPClient.getReplyCode() + " : " + fTPClient.getReplyString());
                fTPSClient = null;
                return fTPSClient;
            }
            while (!fTPClient.login(repositoryAccess.getUser(), repositoryAccess.getPassword())) {
                this.displayErrors("FTP_Client createFTPClient() Login Error:\n" + fTPClient.getReplyCode() + " : " + fTPClient.getReplyString());
                if (!repositoryAccess.promptUserPassword()) {
                    fTPClient.logout();
                    fTPSClient = null;
                    return fTPSClient;
                }
                if (!repositoryAccess.loginAttemptsExceeded()) continue;
            }
            fTPClient.setFileType(2);
            fTPClient.enterLocalPassiveMode();
            bl = true;
        }
        catch (MalformedURLException malformedURLException) {
            this.displayErrors("FTP_Client createFTPClient() MalformedURLException:\n" + malformedURLException.toString());
        }
        catch (SocketException socketException) {
            this.displayErrors("FTP_Client createFTPClient() SocketException:\n" + socketException.toString());
        }
        catch (IOException iOException) {
            this.displayErrors("FTP_Client createFTPClient() IOException:\n" + iOException.toString());
        }
        finally {
            block45: {
                try {
                    if (fTPClient != null && fTPClient.isConnected() && !bl) {
                        fTPClient.disconnect();
                    }
                }
                catch (IOException iOException) {
                    if (!Ajqvue.getDebug()) break block45;
                    System.out.println("FTP_Client createFTPClient() Failed to disconnet ftpClient. " + iOException.toString());
                }
            }
        }
        return fTPClient;
    }

    private void displayErrors(String string) {
        if (string.length() > 300) {
            string = string.substring(0, 300);
        }
        String string2 = "Error Loading Plugin\n" + string;
        JOptionPane.showMessageDialog(null, string2, "Alert", 0);
    }
}

