/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.io;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.io.SQLDump;
import com.dandymadeproductions.ajqvue.structures.DataExportProperties;
import com.dandymadeproductions.ajqvue.utilities.ProgressBar;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import com.dandymadeproductions.ajqvue.utilities.db.TableDefinitionGenerator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.JOptionPane;

public class SQLDataDumpThread
extends SQLDump
implements Runnable {
    private Object dumpData;
    private String exportedTable;
    private ArrayList<String> columnNameFields;
    private HashMap<String, String> tableColumnNames;
    private HashMap<String, String> tableColumnClassHashMap;
    private HashMap<String, Integer> tableColumnSQLTypeHashMap;
    private HashMap<String, String> tableColumnTypeNameHashMap;
    private String dataSourceType;
    private String schemaName;
    private String tableName;
    private String dbSchemaTableName;
    private String schemaTableName;
    private String dbIdentifierQuoteString;
    private String identifierQuoteString;
    private boolean limits;
    private boolean insertReplaceDump;
    private boolean updateDump;
    private int limitIncrement;
    private int pluralValueLimit;
    private DataExportProperties sqlDataExportOptions;
    private ProgressBar dumpProgressBar;

    public SQLDataDumpThread(ArrayList<String> arrayList, HashMap<String, String> hashMap, boolean bl, HashMap<String, String> hashMap2, HashMap<String, Integer> hashMap3, HashMap<String, String> hashMap4, String string, String string2) {
        this.columnNameFields = arrayList;
        this.tableColumnNames = hashMap;
        this.limits = bl;
        this.tableColumnClassHashMap = hashMap2;
        this.tableColumnSQLTypeHashMap = hashMap3;
        this.tableColumnTypeNameHashMap = hashMap4;
        this.exportedTable = string;
        this.fileName = string2;
        this.updateDump = false;
        this.insertReplaceDump = false;
        this.dataSourceType = ConnectionManager.getDataSourceType();
        this.dbIdentifierQuoteString = ConnectionManager.getIdentifierQuoteString();
        this.sqlDataExportOptions = DBTablesPanel.getDataExportProperties();
        this.identifierQuoteString = this.sqlDataExportOptions.getIdentifierQuoteString();
        this.limitIncrement = DBTablesPanel.getGeneralDBProperties().getLimitIncrement();
        this.pluralValueLimit = this.sqlDataExportOptions.getInsertReplaceUpdate().equals("Insert") ? this.sqlDataExportOptions.getInsertPluralSize() : this.sqlDataExportOptions.getReplacePluralSize();
        this.dbSchemaTableName = Utils.getSchemaTableName(string);
        this.schemaTableName = Utils.getSchemaTableName(string, ConnectionManager.getCatalogSeparator(), this.identifierQuoteString);
    }

    @Override
    public void run() {
        try {
            this.dumpData();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dumpData() throws Exception {
        Connection connection = ConnectionManager.getConnection("SQLDataDumpThread run()");
        if (connection == null) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        this.filebuff = null;
        try {
            block110: {
                File file;
                block107: {
                    block106: {
                        file = new File(this.fileName);
                        if (file.exists()) {
                            try {
                                if (!file.delete()) {
                                    throw new SecurityException();
                                }
                            }
                            catch (SecurityException securityException) {
                                if (!Ajqvue.getDebug()) break block106;
                                System.out.println("Failed to Delete: '" + this.fileName + "'. " + securityException.toString());
                            }
                        }
                    }
                    fileOutputStream = new FileOutputStream(this.fileName, true);
                    this.filebuff = new BufferedOutputStream(fileOutputStream);
                    this.dumpProgressBar = new ProgressBar(this.exportedTable + " SQL Data Dump");
                    this.dumpData = this.generateHeaders();
                    if (!this.sqlDataExportOptions.getTableStructure() && !this.sqlDataExportOptions.getTableData()) {
                        this.dumpChunkOfData(this.dumpData);
                        this.dumpProgressBar.dispose();
                        ConnectionManager.closeConnection(connection, "SQLDataDumpThread run()");
                        return;
                    }
                    if (this.sqlDataExportOptions.getTableStructure()) {
                        this.dumpData = this.dumpData + this.genCommentSep("Table structure for table " + this.schemaTableName);
                        this.dumpData = this.dumpData + new TableDefinitionGenerator(connection, this.dbSchemaTableName).getTableDefinition();
                        if (!this.sqlDataExportOptions.getTableData()) {
                            this.dumpChunkOfData(this.dumpData);
                            this.dumpProgressBar.dispose();
                            ConnectionManager.closeConnection(connection, "SQLDataDumpThread run()");
                            return;
                        }
                    }
                    this.dumpData = this.dumpData + this.genCommentSep("Dumping data for table " + this.schemaTableName);
                    Statement statement = null;
                    ResultSet resultSet = null;
                    try {
                        statement = connection.createStatement();
                        String string = this.dataSourceType.equals("oracle") ? "SELECT * FROM " + this.dbSchemaTableName + " WHERE ROWNUM=1" : (this.dataSourceType.equals("odbc") ? "SELECT * FROM " + this.dbSchemaTableName + " AS t" : (this.dataSourceType.equals("sqlserver") ? "SELECT TOP 1 * FROM " + this.dbSchemaTableName + " AS t" : (this.dataSourceType.equals("derby") ? "SELECT * FROM " + this.dbSchemaTableName + " AS t FETCH FIRST ROW ONLY" : "SELECT * FROM " + this.dbSchemaTableName + " AS t LIMIT 1")));
                        resultSet = statement.executeQuery(string);
                        if (!resultSet.next()) break block107;
                        if (this.sqlDataExportOptions.getLock()) {
                            if (this.dataSourceType.equals("mysql") || this.dataSourceType.equals("mariadb")) {
                                this.dumpData = this.dumpData + "/*!40000 ALTER TABLE " + this.schemaTableName + " DISABLE KEYS */;\n";
                                this.dumpData = this.dumpData + "LOCK TABLES " + this.schemaTableName + " WRITE;\n";
                            } else if (this.dataSourceType.equals("postgresql")) {
                                this.dumpData = this.dumpData + "LOCK TABLE " + this.schemaTableName + ";\n";
                            }
                        }
                        if (this.sqlDataExportOptions.getInsertReplaceUpdate().equals("Insert")) {
                            if (this.sqlDataExportOptions.getInsertExpression().equals("Explicit")) {
                                this.explicitStatementData(connection);
                            } else {
                                this.insertReplaceStatementData(connection);
                            }
                        } else if (this.sqlDataExportOptions.getInsertReplaceUpdate().equals("Replace")) {
                            if (this.sqlDataExportOptions.getReplaceExpression().equals("Explicit")) {
                                this.explicitStatementData(connection);
                            } else {
                                this.insertReplaceStatementData(connection);
                            }
                        } else {
                            this.explicitStatementData(connection);
                        }
                        this.dumpData = this.dumpData + ";\n";
                        if (this.sqlDataExportOptions.getLock() && (this.dataSourceType.equals("mysql") || this.dataSourceType.equals("mariadb"))) {
                            this.dumpData = this.dumpData + "UNLOCK TABLES;\n";
                            this.dumpData = this.dumpData + "/*!40000 ALTER TABLE " + this.schemaTableName + " ENABLE KEYS */;\n";
                        }
                    }
                    catch (SQLException sQLException) {
                        ConnectionManager.displaySQLErrors(sQLException, "SQLDataDumpThread run()");
                    }
                    finally {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            ConnectionManager.displaySQLErrors(sQLException, "SQLDataDumpThread run()");
                        }
                        finally {
                            if (statement != null) {
                                statement.close();
                            }
                        }
                    }
                }
                this.dumpChunkOfData(this.dumpData);
                this.dumpData = "";
                ConnectionManager.closeConnection(connection, "SQLDataDumpThread run()");
                if (this.dumpProgressBar.isCanceled()) {
                    try {
                        if (!file.delete()) {
                            throw new SecurityException();
                        }
                    }
                    catch (SecurityException securityException) {
                        if (!Ajqvue.getDebug()) break block110;
                        System.out.println("Failed to Delete: '" + this.fileName + "'. " + securityException.toString());
                    }
                }
            }
            this.dumpProgressBar.dispose();
            return;
        }
        catch (IOException iOException) {
            String string = "Unable to Create filestream for: '" + this.fileName + "'.";
            JOptionPane.showMessageDialog(null, string, this.fileName, 0);
            return;
        }
        finally {
            try {
                if (this.filebuff != null) {
                    this.filebuff.close();
                }
            }
            catch (IOException iOException) {
                if (Ajqvue.getDebug()) {
                    System.out.println("SQLDataDumpThread dumpData() Failed to Close BufferedOutputStream. " + iOException);
                }
            }
            finally {
                block112: {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!Ajqvue.getDebug()) break block112;
                        System.out.println("SQLDataDumpThread dumpData() Failed to Close FileStream. " + iOException);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertReplaceStatementData(Connection connection) throws SQLException {
        this.insertReplaceDump = true;
        String string = this.sqlDataExportOptions.getInsertReplaceUpdate().toUpperCase(Locale.ENGLISH) + this.sqlDataExportOptions.getType().toUpperCase(Locale.ENGLISH) + "INTO " + this.schemaTableName + " (";
        String string2 = this.sqlDataExportOptions.getInsertReplaceUpdate().toUpperCase(Locale.ENGLISH).equals("INSERT") ? this.sqlDataExportOptions.getInsertExpression() : this.sqlDataExportOptions.getReplaceExpression();
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator<String> iterator = this.columnNameFields.iterator();
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList7 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList8 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList9 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList10 = new ArrayList<Integer>();
        while (iterator.hasNext()) {
            String string3 = iterator.next();
            String string4 = this.tableColumnClassHashMap.get(string3);
            int n2 = this.tableColumnSQLTypeHashMap.get(string3);
            String string5 = this.tableColumnTypeNameHashMap.get(string3);
            if (DBTablesPanel.getSelectedTableTabPanel().getAutoIncrementHashMap().containsKey(string3)) {
                if (this.dataSourceType.equals("oracle")) {
                    hashMap.put(n + 1, DBTablesPanel.getSelectedTableTabPanel().getAutoIncrementHashMap().get(string3));
                } else {
                    if (this.dataSourceType.equals("sqlserver") && this.sqlDataExportOptions.getAutoIncrement()) continue;
                    hashMap.put(n + 1, this.tableColumnNames.get(string3));
                }
            }
            if (Utils.isBlob(string4, string5) && string5.indexOf("BIT DATA") == -1) {
                arrayList.add(n + 1);
            }
            if (string5.indexOf("BIT") != -1 && !this.dataSourceType.equals("odbc") && !this.dataSourceType.equals("sqlserver")) {
                arrayList2.add(n + 1);
            }
            if (string5.indexOf("TIMESTAMP") != -1) {
                if (!this.dataSourceType.equals("sqlserver")) {
                    arrayList3.add(n + 1);
                }
                if (this.dataSourceType.equals("sqlite") && n2 == 12) {
                    arrayList4.add(n + 1);
                }
            }
            if (this.dataSourceType.equals("oracle") && (string5.equals("TIMESTAMP") || string5.equals("TIMESTAMPTZ") || string5.equals("TIMESTAMP WITH TIME ZONE") || string5.equals("TIMESTAMP WITH LOCAL TIME ZONE"))) {
                arrayList5.add(n + 1);
            }
            if (this.dataSourceType.equals("oracle") && string5.equals("TIMESTAMPLTZ")) {
                arrayList6.add(n + 1);
            }
            if (string5.equals("DATE")) {
                arrayList7.add(n + 1);
            }
            if (string5.indexOf("YEAR") != -1) {
                arrayList8.add(n + 1);
            }
            if (string5.indexOf("_") != -1) {
                arrayList9.add(n + 1);
            }
            if (Utils.isNotQuoted(string4, n2, string5)) {
                arrayList10.add(n + 1);
            }
            if (this.dataSourceType.equals("oracle") && string5.equals("TIMESTAMPLTZ")) {
                stringBuffer2.append("TO_CHAR(" + this.dbIdentifierQuoteString + this.tableColumnNames.get(string3) + this.dbIdentifierQuoteString + ", 'YYYY-MM-DD HH24:MM:SS TZR') AS " + this.dbIdentifierQuoteString + this.tableColumnNames.get(string3) + this.dbIdentifierQuoteString + ", ");
            } else {
                stringBuffer2.append(this.dbIdentifierQuoteString + this.tableColumnNames.get(string3) + this.dbIdentifierQuoteString + ", ");
            }
            stringBuffer.append(this.dbIdentifierQuoteString + this.tableColumnNames.get(string3) + this.dbIdentifierQuoteString + ", ");
            string = string + this.identifierQuoteString + this.tableColumnNames.get(string3) + this.identifierQuoteString + ", ";
            ++n;
        }
        stringBuffer2.delete(stringBuffer2.length() - 2, stringBuffer2.length());
        stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        String string6 = stringBuffer.substring(0, stringBuffer.indexOf(","));
        string = string.substring(0, string.length() - 2);
        string = string + ") VALUES";
        this.dumpData = this.dumpData + string;
        this.dumpChunkOfData(this.dumpData);
        this.dumpData = "";
        int n3 = 0;
        if (this.limits) {
            n3 = DBTablesPanel.getSelectedTableTabPanel().getValidDataRowCount();
        } else {
            try {
                n3 = this.getRowsCount(connection, this.dbSchemaTableName);
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "SQLDataDumpThread insertReplaceStatementData()");
            }
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        this.dumpProgressBar.setTaskLength(n3);
        this.dumpProgressBar.pack();
        this.dumpProgressBar.center();
        this.dumpProgressBar.setVisible(true);
        try (Statement statement = null;){
            ResultSet resultSet;
            statement = connection.createStatement();
            do {
                String string7 = this.limits ? DBTablesPanel.getSelectedTableTabPanel().getTableSQLStatement().toString() : (this.dataSourceType.equals("oracle") ? "SELECT " + stringBuffer.toString() + " FROM (SELECT ROW_NUMBER() OVER (ORDER BY " + string6 + " ASC) AS dmprownumber, " + stringBuffer2.toString() + " FROM " + this.dbSchemaTableName + ") WHERE dmprownumber BETWEEN " + (n5 + 1) + " AND " + (n5 + this.limitIncrement) : (this.dataSourceType.equals("odbc") ? "SELECT " + stringBuffer.toString() + " FROM " + this.dbSchemaTableName : (this.dataSourceType.equals("sqlserver") ? "SELECT " + stringBuffer.toString() + " FROM (SELECT *, ROW_NUMBER() OVER (ORDER BY " + string6 + " ASC) AS dmprownumber FROM " + this.dbSchemaTableName + " AS t) AS t1 WHERE t1.dmprownumber BETWEEN " + (n5 + 1) + " AND " + (n5 + this.limitIncrement) : (this.dataSourceType.equals("derby") ? "SELECT " + stringBuffer.toString() + " FROM " + this.dbSchemaTableName + " OFFSET " + n5 + " ROWS FETCH NEXT " + this.limitIncrement + " ROWS ONLY" : "SELECT " + stringBuffer.toString() + " FROM " + this.dbSchemaTableName + " LIMIT " + this.limitIncrement + " OFFSET " + n5))));
                resultSet = statement.executeQuery(string7);
                while (resultSet.next() && !this.dumpProgressBar.isCanceled()) {
                    this.dumpProgressBar.setCurrentValue(n6++);
                    ++n4;
                    this.dumpData = string2.equals("Singular") ? this.dumpData + "(" : this.dumpData + "\n(";
                    for (int i = 1; i <= n; ++i) {
                        Object object;
                        if (arrayList.contains(i)) {
                            object = resultSet.getBytes(i);
                            if (object != null) {
                                this.dumpData = this.dataSourceType.equals("postgresql") ? this.dumpData + "E'" : (this.dataSourceType.equals("hsql") ? this.dumpData + "'" : (this.dataSourceType.equals("hsql2") ? this.dumpData + "x'" : (this.dataSourceType.equals("oracle") ? this.dumpData + "HEXTORAW('" : (this.dataSourceType.equals("sqlite") ? this.dumpData + "x'" : (this.dataSourceType.equals("derby") ? this.dumpData + "CAST(X'" : (this.dataSourceType.equals("h2") ? this.dumpData + "x'" : (((Object)object).length != 0 ? this.dumpData + "0x" : this.dumpData + "''")))))));
                                this.dumpBinaryData((byte[])object, false);
                                continue;
                            }
                            this.dumpData = this.dumpData + "NULL, ";
                            continue;
                        }
                        if (hashMap.containsKey(i) && this.sqlDataExportOptions.getAutoIncrement()) {
                            if (this.dataSourceType.equals("postgresql")) {
                                this.schemaName = this.schemaTableName.substring(0, this.schemaTableName.indexOf(".") + 2);
                                this.tableName = this.schemaTableName.substring(this.schemaTableName.indexOf(".") + 1).replaceAll(this.identifierQuoteString, "");
                                this.dumpData = this.dumpData + "nextval('" + this.schemaName + this.tableName + "_" + (String)hashMap.get(i) + "_seq\"'), ";
                                continue;
                            }
                            if (this.dataSourceType.equals("oracle")) {
                                this.dumpData = this.dumpData + this.identifierQuoteString + (String)hashMap.get(i) + this.identifierQuoteString + ".NEXTVAL, ";
                                continue;
                            }
                            if (this.dataSourceType.equals("derby")) {
                                this.dumpData = this.dumpData + "DEFAULT, ";
                                continue;
                            }
                            this.dumpData = this.dumpData + "NULL, ";
                            continue;
                        }
                        if (arrayList3.contains(i) && this.sqlDataExportOptions.getTimeStamp()) {
                            if (arrayList9.contains(i)) {
                                this.dumpData = this.dumpData + "'{NOW()}', ";
                                continue;
                            }
                            if (this.dataSourceType.equals("oracle")) {
                                this.dumpData = this.dumpData + "SYSTIMESTAMP, ";
                                continue;
                            }
                            if (this.dataSourceType.equals("derby")) {
                                this.dumpData = this.dumpData + "CURRENT_TIMESTAMP, ";
                                continue;
                            }
                            if (this.dataSourceType.equals("sqlite")) {
                                if (arrayList4.contains(i)) {
                                    this.dumpData = this.dumpData + "STRFTIME('%Y-%m-%d %H:%M:%f', 'now', 'localtime'), ";
                                    continue;
                                }
                                this.dumpData = this.dumpData + "CAST((SELECT (julianday('now') - julianday('1970-01-01'))*24*60*60*1000) AS INTEGER), ";
                                continue;
                            }
                            this.dumpData = this.dumpData + "NOW(), ";
                            continue;
                        }
                        if (arrayList5.contains(i) && !this.sqlDataExportOptions.getTimeStamp()) {
                            object = resultSet.getTimestamp(i);
                            if (object != null) {
                                this.dumpData = this.dumpData + "TO_TIMESTAMP('" + object + "', 'YYYY-MM-DD HH24:MI:SS:FF'), ";
                                continue;
                            }
                            this.dumpData = this.dumpData + "NULL, ";
                            continue;
                        }
                        if (arrayList7.contains(i)) {
                            if (this.dataSourceType.equals("oracle")) {
                                object = resultSet.getDate(i);
                                if (object != null) {
                                    this.dumpData = this.dumpData + "TO_DATE('" + object + "', 'YYYY-MM-DD'), ";
                                    continue;
                                }
                                this.dumpData = this.dumpData + "NULL, ";
                                continue;
                            }
                            object = resultSet.getString(i);
                            if (object != null) {
                                if (arrayList10.contains(i)) {
                                    this.dumpData = this.dumpData + this.addEscapes((String)object) + ", ";
                                    continue;
                                }
                                this.dumpData = this.dumpData + "'" + this.addEscapes((String)object) + "', ";
                                continue;
                            }
                            this.dumpData = this.dumpData + "NULL, ";
                            continue;
                        }
                        if (arrayList8.contains(i)) {
                            object = resultSet.getString(i);
                            if (object != null) {
                                if (object.length() > 4) {
                                    this.dumpData = this.dumpData + "'" + this.addEscapes(object.substring(0, 4)) + "', ";
                                    continue;
                                }
                                this.dumpData = this.dumpData + "'" + this.addEscapes((String)object) + "', ";
                                continue;
                            }
                            this.dumpData = this.dumpData + "NULL, ";
                            continue;
                        }
                        if (arrayList2.contains(i)) {
                            object = resultSet.getString(i);
                            if (object != null) {
                                if (this.dataSourceType.equals("postgresql") || this.dataSourceType.equals("hsql2")) {
                                    if (arrayList9.contains(i)) {
                                        this.dumpData = this.dumpData + "'" + (String)object + "', ";
                                        continue;
                                    }
                                    this.dumpData = this.dumpData + "B'" + (String)object + "', ";
                                    continue;
                                }
                                if (this.dataSourceType.equals("mysql") || this.dataSourceType.equals("mariadb")) {
                                    String string8 = Byte.toString(resultSet.getByte(i));
                                    this.dumpData = this.dumpData + "B'" + Integer.toBinaryString(Integer.parseInt(string8)) + "', ";
                                    continue;
                                }
                                if (this.dataSourceType.equals("derby")) {
                                    this.dumpData = this.dumpData + "X'";
                                    this.dumpBinaryData(resultSet.getBytes(i), true);
                                    continue;
                                }
                                try {
                                    this.dumpData = this.dumpData + "B'" + Integer.toBinaryString(Integer.parseInt((String)object)) + "', ";
                                }
                                catch (NumberFormatException numberFormatException) {
                                    this.dumpData = this.dumpData + "B'0', ";
                                }
                                continue;
                            }
                            this.dumpData = this.dumpData + "NULL, ";
                            continue;
                        }
                        object = resultSet.getString(i);
                        if (object != null) {
                            if (arrayList6.contains(i) && !this.sqlDataExportOptions.getTimeStamp()) {
                                this.dumpData = this.dumpData + "TO_TIMESTAMP_TZ('" + (String)object + "', 'YYYY-MM-DD HH24:MI:SS TZH:TZM'), ";
                                continue;
                            }
                            if (arrayList10.contains(i)) {
                                this.dumpData = this.dumpData + (String)object + ", ";
                                continue;
                            }
                            this.dumpData = this.dumpData + "'" + this.addEscapes((String)object) + "', ";
                            continue;
                        }
                        this.dumpData = this.dumpData + "NULL, ";
                    }
                    this.dumpData = ((String)this.dumpData).substring(0, ((String)this.dumpData).length() - 2);
                    this.dumpData = string2.equals("Singular") ? this.dumpData + ");\n" : (n4 >= this.pluralValueLimit ? this.dumpData + ");\n" : this.dumpData + "),");
                    if (n6 >= n3) {
                        this.dumpData = string2.equals("Singular") ? ((String)this.dumpData).substring(0, ((String)this.dumpData).length() - 2) : (n4 >= this.pluralValueLimit ? ((String)this.dumpData).substring(0, ((String)this.dumpData).length() - 2) : ((String)this.dumpData).substring(0, ((String)this.dumpData).length() - 1));
                        this.dumpChunkOfData(this.dumpData);
                        this.dumpData = "";
                        n6 = 0;
                        continue;
                    }
                    this.dumpChunkOfData(this.dumpData);
                    if (string2.equals("Singular")) {
                        this.dumpData = string;
                        continue;
                    }
                    if (n4 >= this.pluralValueLimit) {
                        this.dumpData = string;
                        n4 = 0;
                        continue;
                    }
                    this.dumpData = "";
                }
            } while (!this.limits && (n5 += this.limitIncrement) < n3 && !this.dumpProgressBar.isCanceled());
            resultSet.close();
            this.dumpProgressBar.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void explicitStatementData(Connection connection) throws SQLException {
        ArrayList<Object> arrayList = new ArrayList();
        this.updateDump = false;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" WHERE ");
        this.dumpData = this.dumpData + this.sqlDataExportOptions.getInsertReplaceUpdate().toUpperCase(Locale.ENGLISH);
        this.dumpData = this.dumpData + this.sqlDataExportOptions.getType().toUpperCase(Locale.ENGLISH);
        if (this.sqlDataExportOptions.getInsertReplaceUpdate().toUpperCase(Locale.ENGLISH).equals("INSERT") || this.sqlDataExportOptions.getInsertReplaceUpdate().toUpperCase(Locale.ENGLISH).equals("REPLACE")) {
            this.dumpData = this.dumpData + "INTO ";
        } else {
            this.updateDump = true;
            arrayList = DBTablesPanel.getSelectedTableTabPanel().getPrimaryKeys();
        }
        this.dumpData = this.dumpData + this.schemaTableName + " SET ";
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        for (String string3 : this.columnNameFields) {
            if (this.dataSourceType.equals("oracle") && this.tableColumnTypeNameHashMap.get(string3).equals("TIMESTAMPLTZ")) {
                stringBuffer3.append("TO_CHAR(" + this.dbIdentifierQuoteString + this.tableColumnNames.get(string3) + this.dbIdentifierQuoteString + ", 'YYYY-MM-DD HH24:MM:SS TZR') AS " + this.dbIdentifierQuoteString + this.tableColumnNames.get(string3) + this.dbIdentifierQuoteString + ", ");
            } else {
                stringBuffer3.append(this.dbIdentifierQuoteString + this.tableColumnNames.get(string3) + this.dbIdentifierQuoteString + ", ");
            }
            stringBuffer2.append(this.dbIdentifierQuoteString + this.tableColumnNames.get(string3) + this.dbIdentifierQuoteString + ", ");
        }
        stringBuffer3.delete(stringBuffer3.length() - 2, stringBuffer3.length());
        stringBuffer2.delete(stringBuffer2.length() - 2, stringBuffer2.length());
        String string = stringBuffer2.substring(0, stringBuffer2.indexOf(","));
        this.dumpChunkOfData(this.dumpData);
        this.dumpData = "";
        int n = 0;
        if (this.limits) {
            n = DBTablesPanel.getSelectedTableTabPanel().getValidDataRowCount();
        } else {
            try {
                n = this.getRowsCount(connection, this.dbSchemaTableName);
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "SQLDataDumpThread explicitStatementData()");
            }
        }
        int n2 = 0;
        int n3 = 0;
        this.dumpProgressBar.setTaskLength(n);
        this.dumpProgressBar.pack();
        this.dumpProgressBar.center();
        this.dumpProgressBar.setVisible(true);
        try (Statement statement = null;){
            ResultSet resultSet;
            statement = connection.createStatement();
            do {
                String string2 = this.limits ? DBTablesPanel.getSelectedTableTabPanel().getTableSQLStatement().toString() : (this.dataSourceType.equals("oracle") ? "SELECT " + stringBuffer2.toString() + " FROM (SELECT ROW_NUMBER() OVER (ORDER BY " + string + " ASC) AS dmprownumber, " + stringBuffer3.toString() + " FROM " + this.dbSchemaTableName + ") WHERE dmprownumber BETWEEN " + (n2 + 1) + " AND " + (n2 + this.limitIncrement) : (this.dataSourceType.equals("odbc") ? "SELECT " + stringBuffer2.toString() + " FROM " + this.dbSchemaTableName : (this.dataSourceType.equals("sqlserver") ? "SELECT " + stringBuffer2.toString() + " FROM (SELECT *, ROW_NUMBER() OVER (ORDER BY " + string + " ASC) AS dmprownumber FROM " + this.dbSchemaTableName + " AS t) AS t1 WHERE t1.dmprownumber BETWEEN " + (n2 + 1) + " AND " + (n2 + this.limitIncrement) : (this.dataSourceType.equals("derby") ? "SELECT " + stringBuffer2.toString() + " FROM " + this.dbSchemaTableName + " OFFSET " + n2 + " ROWS FETCH NEXT " + this.limitIncrement + " ROWS ONLY" : "SELECT " + stringBuffer2.toString() + " FROM " + this.dbSchemaTableName + " LIMIT " + this.limitIncrement + " OFFSET " + n2))));
                resultSet = statement.executeQuery(string2);
                while (resultSet.next() && !this.dumpProgressBar.isCanceled()) {
                    this.dumpProgressBar.setCurrentValue(n3++);
                    for (String string3 : this.columnNameFields) {
                        Object object;
                        String string4 = this.tableColumnClassHashMap.get(string3);
                        int n4 = this.tableColumnSQLTypeHashMap.get(string3);
                        String string5 = this.tableColumnTypeNameHashMap.get(string3);
                        if (arrayList.contains(this.tableColumnNames.get(string3)) && this.updateDump) {
                            stringBuffer.append(this.identifierQuoteString + this.tableColumnNames.get(string3) + this.identifierQuoteString + "=");
                            object = resultSet.getString(this.tableColumnNames.get(string3));
                            if (object != null) {
                                if (this.dataSourceType.equals("odbc") || this.dataSourceType.equals("derby")) {
                                    if (string5.indexOf("CHAR") != -1 || string5.indexOf("TEXT") != -1) {
                                        stringBuffer.append("'" + (String)object + "' AND ");
                                        continue;
                                    }
                                    stringBuffer.append((String)object + " AND ");
                                    continue;
                                }
                                stringBuffer.append("'" + (String)object + "' AND ");
                                continue;
                            }
                            stringBuffer.append("NULL AND ");
                            continue;
                        }
                        this.dumpData = this.dumpData + this.identifierQuoteString + this.tableColumnNames.get(string3) + this.identifierQuoteString + "=";
                        if (Utils.isBlob(string4, string5) && string5.indexOf("BIT DATA") == -1) {
                            object = resultSet.getBytes(this.tableColumnNames.get(string3));
                            if (object != null) {
                                this.dumpData = this.dataSourceType.equals("postgresql") ? this.dumpData + "E'" : (this.dataSourceType.equals("hsql") ? this.dumpData + "'" : (this.dataSourceType.equals("hsql2") ? this.dumpData + "x'" : (this.dataSourceType.equals("oracle") && this.updateDump ? this.dumpData + "HEXTORAW('" : (this.dataSourceType.equals("sqlite") && this.updateDump ? this.dumpData + "x'" : (this.dataSourceType.equals("derby") && this.updateDump ? this.dumpData + "CAST(X'" : (this.dataSourceType.equals("h2") ? this.dumpData + "x'" : (((Object)object).length != 0 ? this.dumpData + "0x" : this.dumpData + "''")))))));
                                this.dumpBinaryData((byte[])object, false);
                                continue;
                            }
                            this.dumpData = this.dumpData + "NULL, ";
                            continue;
                        }
                        if (DBTablesPanel.getSelectedTableTabPanel().getAutoIncrementHashMap().containsKey(string3) && this.sqlDataExportOptions.getAutoIncrement()) {
                            if (this.dataSourceType.equals("postgresql")) {
                                this.schemaName = this.schemaTableName.substring(0, this.schemaTableName.indexOf(".") + 2);
                                this.tableName = this.schemaTableName.substring(this.schemaTableName.indexOf(".") + 1).replaceAll(this.identifierQuoteString, "");
                                this.dumpData = this.dumpData + "nextval('" + this.schemaName + this.tableName + "_" + string3 + "_seq\"'), ";
                                continue;
                            }
                            if (this.dataSourceType.equals("oracle")) {
                                this.dumpData = this.dumpData + this.identifierQuoteString + DBTablesPanel.getSelectedTableTabPanel().getAutoIncrementHashMap().get(string3) + this.identifierQuoteString + ".NEXTVAL, ";
                                continue;
                            }
                            if (this.dataSourceType.equals("derby")) {
                                this.dumpData = "DEFAULT, ";
                                continue;
                            }
                            this.dumpData = this.dumpData + "NULL, ";
                            continue;
                        }
                        if (string5.indexOf("TIMESTAMP") != -1 && this.sqlDataExportOptions.getTimeStamp()) {
                            if (string5.indexOf("_") != -1) {
                                this.dumpData = this.dumpData + "'{NOW()}'. ";
                                continue;
                            }
                            if (this.dataSourceType.equals("oracle")) {
                                this.dumpData = this.dumpData + "SYSTIMESTAMP, ";
                                continue;
                            }
                            if (this.dataSourceType.equals("derby")) {
                                this.dumpData = this.dumpData + "CURRENT_TIMESTAMP, ";
                                continue;
                            }
                            if (this.dataSourceType.equals("sqlite")) {
                                if (n4 == 12) {
                                    this.dumpData = this.dumpData + "STRFTIME('%Y-%m-%d %H:%M:%f', 'now', 'localtime'), ";
                                    continue;
                                }
                                this.dumpData = this.dumpData + "CAST((SELECT (julianday('now') - julianday('1970-01-01'))*24*60*60*1000) AS INTEGER), ";
                                continue;
                            }
                            this.dumpData = this.dumpData + "NOW(), ";
                            continue;
                        }
                        if ((string5.equals("TIMESTAMP") || string5.equals("TIMESTAMPTZ") || string5.equals("TIMESTAMP WITH TIME ZONE") || string5.equals("TIMESTAMP WITH LOCAL TIME ZONE")) && this.dataSourceType.equals("oracle") && !this.sqlDataExportOptions.getTimeStamp()) {
                            object = resultSet.getTimestamp(this.tableColumnNames.get(string3));
                            if (object != null) {
                                this.dumpData = this.dumpData + "TO_TIMESTAMP('" + object + "', 'YYYY-MM-DD HH24:MI:SS:FF'), ";
                                continue;
                            }
                            this.dumpData = this.dumpData + "NULL, ";
                            continue;
                        }
                        if (string5.equals("DATE")) {
                            if (this.dataSourceType.equals("oracle")) {
                                object = resultSet.getDate(this.tableColumnNames.get(string3));
                                if (object != null) {
                                    this.dumpData = this.dumpData + "TO_DATE('" + object + "', 'YYYY-MM-DD'), ";
                                    continue;
                                }
                                this.dumpData = this.dumpData + "NULL, ";
                                continue;
                            }
                            object = resultSet.getString(this.tableColumnNames.get(string3));
                            if (object != null) {
                                if (Utils.isNotQuoted(string4, n4, string5)) {
                                    this.dumpData = this.dumpData + this.addEscapes((String)object) + ", ";
                                    continue;
                                }
                                this.dumpData = this.dumpData + "'" + this.addEscapes((String)object) + "', ";
                                continue;
                            }
                            this.dumpData = this.dumpData + "NULL, ";
                            continue;
                        }
                        if (string5.equals("YEAR")) {
                            object = resultSet.getString(this.tableColumnNames.get(string3));
                            if (object != null) {
                                if (((String)object).length() > 4) {
                                    this.dumpData = this.dumpData + "'" + this.addEscapes(((String)object).substring(0, 4)) + "', ";
                                    continue;
                                }
                                this.dumpData = this.dumpData + "'" + this.addEscapes((String)object) + "', ";
                                continue;
                            }
                            this.dumpData = this.dumpData + "NULL, ";
                            continue;
                        }
                        if (string5.indexOf("BIT") != -1) {
                            object = resultSet.getString(this.tableColumnNames.get(string3));
                            if (object != null) {
                                if (this.dataSourceType.equals("postgresql") || this.dataSourceType.equals("hsql2")) {
                                    if (string5.indexOf("_") != -1) {
                                        this.dumpData = this.dumpData + "'" + (String)object + "', ";
                                        continue;
                                    }
                                    this.dumpData = this.dumpData + "B'" + (String)object + "', ";
                                    continue;
                                }
                                if (this.dataSourceType.equals("mysql") || this.dataSourceType.equals("mariadb")) {
                                    String string6 = Byte.toString(resultSet.getByte(this.tableColumnNames.get(string3)));
                                    this.dumpData = this.dumpData + "B'" + Integer.toBinaryString(Integer.parseInt(string6)) + "', ";
                                    continue;
                                }
                                if (this.dataSourceType.equals("derby")) {
                                    this.dumpData = this.dumpData + "X'";
                                    this.dumpBinaryData(resultSet.getBytes(this.tableColumnNames.get(string3)), true);
                                    continue;
                                }
                                if (this.dataSourceType.equals("odbc") || this.dataSourceType.equals("sqlserver")) {
                                    this.dumpData = this.dumpData + "'" + (String)object + "', ";
                                    continue;
                                }
                                try {
                                    this.dumpData = this.dumpData + "B'" + Integer.toBinaryString(Integer.parseInt((String)object)) + "', ";
                                }
                                catch (NumberFormatException numberFormatException) {
                                    this.dumpData = this.dumpData + "B'0', ";
                                }
                                continue;
                            }
                            this.dumpData = this.dumpData + "NULL, ";
                            continue;
                        }
                        object = resultSet.getString(this.tableColumnNames.get(string3));
                        if (object != null) {
                            if (string5.equals("TIMESTAMPLTZ") && this.dataSourceType.equals("oracle")) {
                                this.dumpData = this.dumpData + "TO_TIMESTAMP_TZ('" + (String)object + "', 'YYYY-MM-DD HH24:MI:SS TZH:TZM'), ";
                                continue;
                            }
                            if (Utils.isNotQuoted(string4, n4, string5)) {
                                this.dumpData = this.dumpData + (String)object + ", ";
                                continue;
                            }
                            this.dumpData = this.dumpData + "'" + this.addEscapes((String)object + "") + "', ";
                            continue;
                        }
                        this.dumpData = this.dumpData + "NULL, ";
                    }
                    if (n3 < n) {
                        this.dumpData = ((String)this.dumpData).substring(0, ((String)this.dumpData).length() - 2);
                        this.dumpData = this.updateDump && !arrayList.isEmpty() ? (String)this.dumpData + stringBuffer.delete(stringBuffer.length() - 5, stringBuffer.length()) + ";\n" : this.dumpData + ";\n";
                        this.dumpChunkOfData(this.dumpData);
                        this.dumpData = "";
                        stringBuffer.delete(0, stringBuffer.length());
                        stringBuffer.append(" WHERE ");
                        this.dumpData = this.dumpData + this.sqlDataExportOptions.getInsertReplaceUpdate().toUpperCase(Locale.ENGLISH);
                        this.dumpData = this.dumpData + this.sqlDataExportOptions.getType().toUpperCase(Locale.ENGLISH);
                        if (this.sqlDataExportOptions.getInsertReplaceUpdate().toUpperCase(Locale.ENGLISH).equals("INSERT") || this.sqlDataExportOptions.getInsertReplaceUpdate().toUpperCase(Locale.ENGLISH).equals("REPLACE")) {
                            this.dumpData = this.dumpData + "INTO ";
                        }
                        this.dumpData = this.dumpData + this.schemaTableName + " SET ";
                        continue;
                    }
                    if (this.updateDump) {
                        this.dumpData = ((String)this.dumpData).substring(0, ((String)this.dumpData).length() - 2) + stringBuffer.delete(stringBuffer.length() - 5, stringBuffer.length());
                        continue;
                    }
                    this.dumpData = ((String)this.dumpData).substring(0, ((String)this.dumpData).length() - 2);
                }
            } while (!this.limits && (n2 += this.limitIncrement) < n && !this.dumpProgressBar.isCanceled());
            resultSet.close();
            statement.close();
            this.dumpProgressBar.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getRowsCount(Connection connection, String string) throws SQLException {
        int n = 0;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            String string2 = "SELECT COUNT(*) FROM " + string;
            resultSet = statement.executeQuery(string2);
            resultSet.next();
            int n2 = n = resultSet.getInt(1);
            return n2;
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "SQLDataDumpThread getRowsCount()");
            int n3 = n;
            return n3;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "SQLDataDumpThread getRowsCount()");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    private void dumpBinaryData(byte[] byArray, boolean bl) {
        if (byArray != null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
            try {
                int n;
                while ((n = bufferedInputStream.read()) != -1) {
                    if (this.dataSourceType.equals("postgresql")) {
                        String string = Integer.toString(n, 8);
                        if (string.length() == 1) {
                            string = "00" + string;
                        }
                        if (string.length() > 1 && string.length() < 3) {
                            string = "0" + string;
                        }
                        this.dumpData = this.dumpData + "\\\\" + string;
                        this.dumpChunkOfData(this.dumpData);
                        this.dumpData = "";
                        continue;
                    }
                    String string = Integer.toString(n, 16);
                    if (string.length() < 2) {
                        string = "0" + string;
                    }
                    if (string.length() > 2) {
                        string = string.substring(string.length() - 2);
                    }
                    this.dumpData = this.dumpData + string;
                    this.dumpChunkOfData(this.dumpData);
                    this.dumpData = "";
                }
                if (this.dataSourceType.equals("postgresql") || this.dataSourceType.indexOf("hsql") != -1 || this.dataSourceType.equals("sqlite") || this.dataSourceType.equals("h2")) {
                    this.dumpData = this.dumpData + "', ";
                }
                if (this.dataSourceType.equals("derby")) {
                    if (!bl) {
                        this.dumpData = this.dumpData + "' AS BLOB), ";
                    }
                    this.dumpData = this.dumpData + "', ";
                }
                if (this.dataSourceType.equals("oracle") && (this.updateDump || this.insertReplaceDump)) {
                    this.dumpData = this.dumpData + "'), ";
                }
                this.dumpData = this.dumpData + ", ";
            }
            catch (IOException iOException) {
                String string = "Unable to Create Buffered InputStream for Blob Data";
                JOptionPane.showMessageDialog(null, string, this.fileName, 0);
                return;
            }
        } else {
            this.dumpData = this.dumpData + "NULL, ";
        }
    }
}

