/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.io;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.io.WriteDataFile;
import com.dandymadeproductions.ajqvue.structures.DataExportProperties;
import com.dandymadeproductions.ajqvue.utilities.ProgressBar;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JTable;

public class PDFDataTableDumpThread
implements PdfPageEvent,
Runnable {
    private JTable summaryListTable;
    private HashMap<String, String> tableColumnTypeNameHashMap;
    private String exportedTable;
    private String fileName;
    private DataExportProperties pdfDataExportOptions;
    private PdfTemplate pdfTemplate;
    private Font titleFont;
    private Font rowHeaderFont;
    private Font tableDataFont;
    private BaseFont rowHeaderBaseFont;
    private static final Font FONT = new Font();
    private static final BaseFont BASE_FONT = FONT.getCalculatedBaseFont(false);

    public PDFDataTableDumpThread(JTable jTable, HashMap<String, String> hashMap, String string, String string2) {
        this.summaryListTable = jTable;
        this.tableColumnTypeNameHashMap = hashMap;
        this.exportedTable = string;
        this.fileName = string2;
    }

    @Override
    public void run() {
        block19: {
            int n;
            int n2 = this.summaryListTable.getColumnCount();
            int n3 = this.summaryListTable.getRowCount();
            int[] nArray = new int[n2];
            PdfPTable pdfPTable = new PdfPTable(n2);
            pdfPTable.setWidthPercentage(100.0f);
            pdfPTable.getDefaultCell().setPaddingBottom(4.0f);
            pdfPTable.getDefaultCell().setBorderWidth(1.0f);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            this.pdfDataExportOptions = DBTablesPanel.getDataExportProperties();
            this.titleFont = new Font(this.pdfDataExportOptions.getFont());
            this.titleFont.setStyle(1);
            this.titleFont.setSize((float)this.pdfDataExportOptions.getTitleFontSize());
            this.titleFont.setColor(new BaseColor(this.pdfDataExportOptions.getTitleColor().getRGB()));
            this.rowHeaderFont = new Font(this.pdfDataExportOptions.getFont());
            this.rowHeaderFont.setStyle(1);
            this.rowHeaderFont.setSize((float)this.pdfDataExportOptions.getHeaderFontSize());
            this.rowHeaderFont.setColor(new BaseColor(this.pdfDataExportOptions.getHeaderColor().getRGB()));
            this.rowHeaderBaseFont = this.rowHeaderFont.getCalculatedBaseFont(false);
            this.tableDataFont = this.pdfDataExportOptions.getFont();
            ProgressBar progressBar = new ProgressBar(this.exportedTable + " Dump");
            progressBar.setTaskLength(n3);
            progressBar.pack();
            progressBar.center();
            progressBar.setVisible(true);
            String string = this.pdfDataExportOptions.getTitle();
            if (!string.equals("")) {
                if (string.equals("EXPORTED TABLE")) {
                    string = this.exportedTable;
                }
                PdfPCell pdfPCell = new PdfPCell(new Phrase(string, this.titleFont));
                pdfPCell.setBorder(0);
                pdfPCell.setPadding(10.0f);
                pdfPCell.setColspan(this.summaryListTable.getColumnCount());
                pdfPCell.setHorizontalAlignment(1);
                pdfPTable.addCell(pdfPCell);
                pdfPTable.setHeaderRows(2);
            } else {
                pdfPTable.setHeaderRows(1);
            }
            for (n = 0; n < n2; ++n) {
                String string2 = this.summaryListTable.getColumnName(n);
                PdfPCell pdfPCell = new PdfPCell(new Phrase(string2, this.rowHeaderFont));
                pdfPCell.setBorderWidth((float)this.pdfDataExportOptions.getHeaderBorderSize());
                pdfPCell.setHorizontalAlignment(1);
                pdfPCell.setBorderColor(new BaseColor(this.pdfDataExportOptions.getHeaderBorderColor().getRGB()));
                pdfPTable.addCell(pdfPCell);
                nArray[n] = Math.min(50000, Math.max(nArray[n], this.rowHeaderBaseFont.getWidth(string2 + " ")));
                if (this.tableColumnTypeNameHashMap != null) {
                    hashMap.put(Integer.toString(n), this.tableColumnTypeNameHashMap.get(string2));
                    continue;
                }
                hashMap.put(Integer.toString(n), "String");
            }
            for (n = 0; n < n3 && !progressBar.isCanceled(); ++n) {
                progressBar.setCurrentValue(n);
                if (this.summaryListTable.getValueAt(n, 0) == null) continue;
                for (int i = 0; i < this.summaryListTable.getColumnCount(); ++i) {
                    String string3 = this.summaryListTable.getValueAt(n, i) + "";
                    string3 = string3.replaceAll("\n", "");
                    string3 = string3.replaceAll("\r", "");
                    String string4 = (String)hashMap.get(Integer.toString(i));
                    if (string4 != null && (string4.equals("DATE") || string4.equals("DATETIME") || string4.indexOf("TIMESTAMP") != -1) && !string3.toLowerCase(Locale.ENGLISH).equals("null")) {
                        String string5;
                        if (string3.indexOf(" ") != -1) {
                            int n4 = string3.indexOf(" ");
                            string5 = string3.substring(n4);
                            string3 = string3.substring(0, n4);
                        } else {
                            string5 = "";
                        }
                        string3 = Utils.convertViewDateString_To_DBDateString(string3, DBTablesPanel.getGeneralDBProperties().getViewDateFormat());
                        string3 = Utils.convertDBDateString_To_ViewDateString(string3, this.pdfDataExportOptions.getPDFDateFormat()) + string5;
                    }
                    PdfPCell pdfPCell = new PdfPCell(new Phrase(string3, this.tableDataFont));
                    pdfPCell.setPaddingBottom(4.0f);
                    if (string4 != null) {
                        if (string4.indexOf("BIT") != -1 || string4.indexOf("BOOL") != -1 || string4.indexOf("NUM") != -1 || string4.indexOf("INT") != -1 || string4.indexOf("FLOAT") != -1 || string4.indexOf("DOUBLE") != -1 || string4.equals("REAL") || string4.equals("DECIMAL") || string4.indexOf("COUNTER") != -1 || string4.equals("BYTE") || string4.equals("CURRENCY")) {
                            pdfPCell.setHorizontalAlignment(this.pdfDataExportOptions.getNumberAlignment());
                            pdfPCell.setPaddingRight(4.0f);
                        }
                        if (string4.indexOf("DATE") != -1 || string4.indexOf("TIME") != -1 || string4.indexOf("YEAR") != -1) {
                            pdfPCell.setHorizontalAlignment(this.pdfDataExportOptions.getDateAlignment());
                        }
                    }
                    pdfPTable.addCell(pdfPCell);
                    nArray[i] = Math.min(50000, Math.max(nArray[i], BASE_FONT.getWidth(string3 + " ")));
                }
            }
            progressBar.dispose();
            if (pdfPTable.size() <= pdfPTable.getHeaderRows()) {
                return;
            }
            try {
                Rectangle rectangle;
                int n5 = 0;
                for (int n6 : nArray) {
                    n5 += n6;
                }
                if (this.pdfDataExportOptions.getPageLayout() == 0) {
                    rectangle = PageSize.A4;
                } else {
                    rectangle = PageSize.A4.rotate();
                    rectangle.setRight(rectangle.getRight() * Math.max(1.0f, (float)n5 / 53000.0f));
                    rectangle.setTop(rectangle.getTop() * Math.max(1.0f, (float)n5 / 53000.0f));
                }
                pdfPTable.setWidths(nArray);
                Document document = new Document(rectangle);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
                document.open();
                this.pdfTemplate = pdfWriter.getDirectContent().createTemplate(100.0f, 100.0f);
                this.pdfTemplate.setBoundingBox(new Rectangle(-20.0f, -20.0f, 100.0f, 100.0f));
                pdfWriter.setPageEvent((PdfPageEvent)this);
                document.add((Element)pdfPTable);
                document.close();
                WriteDataFile.mainWriteDataString(this.fileName, byteArrayOutputStream.toByteArray(), false);
            }
            catch (DocumentException documentException) {
                if (!Ajqvue.getDebug()) break block19;
                System.out.println("Failed to Create Document Needed to Output Data. \n" + documentException.toString());
            }
        }
    }

    public void onOpenDocument(PdfWriter pdfWriter, Document document) {
    }

    public void onCloseDocument(PdfWriter pdfWriter, Document document) {
        if (this.pdfTemplate != null) {
            this.pdfTemplate.beginText();
            this.pdfTemplate.setFontAndSize(BASE_FONT, 12.0f);
            this.pdfTemplate.showText("" + (pdfWriter.getPageNumber() - 1));
            this.pdfTemplate.endText();
        }
    }

    public void onStartPage(PdfWriter pdfWriter, Document document) {
    }

    public void onEndPage(PdfWriter pdfWriter, Document document) {
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        String string = "Page " + pdfWriter.getPageNumber() + " of ";
        float f = BASE_FONT.getWidthPoint(string, 12.0f);
        float f2 = document.bottom() - 20.0f;
        pdfContentByte.beginText();
        pdfContentByte.setFontAndSize(BASE_FONT, 12.0f);
        float f3 = BASE_FONT.getWidthPoint("000", 12.0f);
        pdfContentByte.setTextMatrix(document.right() - f - f3, f2);
        pdfContentByte.showText(string);
        pdfContentByte.endText();
        if (this.pdfTemplate != null) {
            pdfContentByte.addTemplate(this.pdfTemplate, document.right() - f3, f2);
        }
    }

    public void onParagraph(PdfWriter pdfWriter, Document document, float f) {
    }

    public void onParagraphEnd(PdfWriter pdfWriter, Document document, float f) {
    }

    public void onChapter(PdfWriter pdfWriter, Document document, float f, Paragraph paragraph) {
    }

    public void onChapterEnd(PdfWriter pdfWriter, Document document, float f) {
    }

    public void onSection(PdfWriter pdfWriter, Document document, float f, int n, Paragraph paragraph) {
    }

    public void onSectionEnd(PdfWriter pdfWriter, Document document, float f) {
    }

    public void onGenericTag(PdfWriter pdfWriter, Document document, Rectangle rectangle, String string) {
    }
}

