/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.sprites;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Random;

public class Blossom {
    private Point2D.Double position;
    private Dimension2D petalSize;
    private int petalNumber;
    private double rotation;
    private double petalSizeIncrement;
    private Stroke stroke;
    private Paint outlinePaint;
    private Paint fillPaint;
    private Random random;
    private boolean petalFilled;
    private static float STROKE_WIDTH = 1.0f;
    private static double DEFAULT_WIDTH = 5.0;
    private static double DEFAULT_MAX_WIDTH = 5.0 * DEFAULT_WIDTH;
    private static double DEFAULT_HEIGHT = 15.0;
    private static int DEFAULT_PETAL_NUMBER = 12;
    private static Paint DEFAULT_COLOR = Color.ORANGE;
    private static Paint DEFAULT_FILL = new GradientPaint(0.0f, 0.0f, Color.BLUE, 100.0f, 100.0f, Color.GREEN, true);
    private static double DEFAULT_OFFSET_ANGLE = 0.39269908169872414;

    public Blossom() {
        this(null, null);
    }

    public Blossom(Point2D.Double double_, Dimension2D dimension2D) {
        this(double_, dimension2D, DEFAULT_PETAL_NUMBER, new BasicStroke(STROKE_WIDTH, 2, 2), DEFAULT_COLOR, DEFAULT_FILL);
    }

    public Blossom(Point2D.Double double_, Dimension2D dimension2D, Paint paint) {
        this(double_, dimension2D, DEFAULT_PETAL_NUMBER, new BasicStroke(STROKE_WIDTH, 2, 2), paint, DEFAULT_FILL);
    }

    public Blossom(Point2D.Double double_, Dimension2D dimension2D, int n, Stroke stroke, Paint paint, Paint paint2) {
        if (double_ == null) {
            double_ = new Point2D.Double();
            double_.setLocation(0.0, 0.0);
        }
        this.position = double_;
        if (dimension2D == null) {
            dimension2D = new Dimension();
            dimension2D.setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);
        }
        this.petalSize = dimension2D;
        this.petalNumber = n;
        if (stroke == null) {
            stroke = new BasicStroke(STROKE_WIDTH, 2, 2);
        }
        this.stroke = stroke;
        if (paint == null) {
            paint = DEFAULT_COLOR;
        }
        this.outlinePaint = paint;
        if (paint2 == null) {
            paint2 = DEFAULT_FILL;
        }
        this.fillPaint = paint2;
        this.random = new Random();
        this.petalFilled = true;
        this.rotation = 0.0;
        this.petalSizeIncrement = 7.0 * this.random.nextDouble();
    }

    public void draw(Graphics2D graphics2D) {
        float f = 0.9f;
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
        double d = this.petalSize.getWidth();
        double d2 = this.petalSize.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double(this.position.getX(), this.position.getY(), d, d2);
        double d3 = Math.PI * 2 / (double)this.petalNumber;
        graphics2D.setComposite(alphaComposite);
        graphics2D.setStroke(this.stroke);
        this.rotation += DEFAULT_OFFSET_ANGLE;
        AffineTransform affineTransform = AffineTransform.getRotateInstance(this.rotation, this.position.getX() + d / 2.0, this.position.getY() + d2);
        graphics2D.transform(affineTransform);
        for (int i = 0; i < this.petalNumber; ++i) {
            if (this.petalFilled) {
                graphics2D.setPaint(this.fillPaint);
                graphics2D.fill(double_);
            }
            graphics2D.setPaint(this.outlinePaint);
            graphics2D.draw(double_);
            affineTransform = AffineTransform.getRotateInstance(d3, this.position.getX() + d / 2.0, this.position.getY() + d2);
            graphics2D.transform(affineTransform);
        }
        affineTransform.setToIdentity();
        graphics2D.setTransform(affineTransform);
        if (this.petalSize.getWidth() > DEFAULT_MAX_WIDTH) {
            this.petalSizeIncrement = -(5.2 * this.random.nextDouble());
            this.outlinePaint = new Color(this.random.nextInt(256), this.random.nextInt(256), this.random.nextInt(256));
        }
        if (this.petalSize.getWidth() < 0.0) {
            this.petalSizeIncrement = 2.4 * this.random.nextDouble();
            this.fillPaint = new GradientPaint(0.0f, 0.0f, new Color(this.random.nextInt(256), this.random.nextInt(256), this.random.nextInt(256)), 100.0f, 100.0f, new Color(this.random.nextInt(256), this.random.nextInt(256), this.random.nextInt(256)), true);
        }
        this.petalSize.setSize(this.petalSize.getWidth() + this.petalSizeIncrement, this.petalSize.getHeight() + this.petalSizeIncrement);
    }

    public Point2D.Double getPosition() {
        return this.position;
    }

    public Dimension2D getPetalSize() {
        return this.petalSize;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setPosition(Point2D.Double double_) {
        this.position = double_;
    }

    public void setPetalSize(Dimension2D dimension2D) {
        this.petalSize = dimension2D;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setOutlinePaint(GradientPaint gradientPaint) {
        this.outlinePaint = gradientPaint;
    }

    public void setFillPaint(Paint paint) {
        this.fillPaint = paint;
    }

    public void isPetalFilled(boolean bl) {
        this.petalFilled = bl;
    }
}

