/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.TableTabPanel;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TableRowSelectionPreferencesPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 184853367437167075L;
    private String tableName;
    private JSpinner rowSizeSpinner;
    private static final int defaultRowSize = 50;
    private JButton restoreDefaultsButton;
    private JButton applyButton;

    public TableRowSelectionPreferencesPanel(String string, AResourceBundle aResourceBundle) {
        this.tableName = string;
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        String string2 = aResourceBundle.getResourceString("TableRowSelectionPreferencesPanel.label.SummaryTableRowSize", "Summary Table Row Size");
        JLabel jLabel = new JLabel(string2);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(50, 0, 20000, 25);
        this.rowSizeSpinner = new JSpinner(spinnerNumberModel);
        this.rowSizeSpinner.addChangeListener(this);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.rowSizeSpinner, gridBagConstraints);
        jPanel.add(this.rowSizeSpinner);
        this.loadRowSize();
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder());
        jPanel2 = new JPanel();
        string2 = aResourceBundle.getResourceString("TableRowSelectionPreferencesPanel.button.RestoreDefaults", "Restore Defaults");
        this.restoreDefaultsButton = new JButton(string2);
        this.restoreDefaultsButton.addActionListener(this);
        jPanel2.add(this.restoreDefaultsButton);
        string2 = aResourceBundle.getResourceString("TableRowSelectionPreferencesPanel.button.Apply", "Apply");
        this.applyButton = new JButton(string2);
        this.applyButton.setEnabled(false);
        this.applyButton.addActionListener(this);
        jPanel2.add(this.applyButton);
        this.add((Component)jPanel2, "South");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            if (object == this.restoreDefaultsButton) {
                this.rowSizeSpinner.setValue(50);
                this.applyButton.setEnabled(true);
            } else if (object == this.applyButton) {
                this.updatePreferences();
                this.applyButton.setEnabled(false);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof JSpinner && this.applyButton != null) {
            this.applyButton.setEnabled(true);
        }
    }

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    private void loadRowSize() {
        TableTabPanel tableTabPanel = DBTablesPanel.getTableTabPanel(this.tableName);
        int n = tableTabPanel != null ? tableTabPanel.getTableRowSize() : 50;
        this.rowSizeSpinner.setValue(n);
    }

    public void updatePreferences() {
        if (this.applyButton.isEnabled()) {
            DBTablesPanel.startStatusTimer();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    int n = Integer.parseInt(TableRowSelectionPreferencesPanel.this.rowSizeSpinner.getValue().toString());
                    TableTabPanel tableTabPanel = DBTablesPanel.getTableTabPanel(TableRowSelectionPreferencesPanel.this.tableName);
                    tableTabPanel.setTableRowSize(n);
                    DBTablesPanel.setSelectedTableTabPanel(TableRowSelectionPreferencesPanel.this.tableName);
                    DBTablesPanel.stopStatusTimer();
                }
            }, "TableRowSelectionPreferencesPanel.updateTableTabPanelRowsThread");
            thread.start();
        }
    }
}

