/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.gui.Main_MouseAdapter;
import com.dandymadeproductions.ajqvue.gui.QueryFrame;
import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.TableTabPanel_SQLite;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.TableSorter;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import com.dandymadeproductions.ajqvue.utilities.db.SQLQuery;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.TransferHandler;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class SQLTabPanel
extends JPanel
implements ActionListener,
Printable {
    private static final long serialVersionUID = 8461814212715169033L;
    private String sqlString;
    private boolean validQuery;
    private int tableRowLimit;
    private int columnSizeScaling;
    private String dataSourceType;
    private ArrayList<String> tableHeadings;
    private HashMap<String, String> columnNamesHashMap;
    private HashMap<String, String> columnClassHashMap;
    private HashMap<String, Integer> columnSQLTypeHashMap;
    private HashMap<String, String> columnTypeNameHashMap;
    private HashMap<String, Integer> columnSizeHashMap;
    private HashMap<String, Integer> preferredColumnSizeHashMap;
    private AResourceBundle resourceBundle;
    private JPanel centerPanel;
    private transient MouseListener summaryTablePopupListener;
    private SQLTableModel tableModel;
    private JTable listTable;
    private JScrollPane tableScrollPane;
    private static final String ACTION_SELECT_ALL = "Select All";
    private static final String ACTION_DESELECT_ALL = "DeSelect All";
    private static final int MAX_PREFERRED_COLUMN_SIZE = 350;

    public SQLTabPanel(String string, int n, AResourceBundle aResourceBundle) {
        Object object;
        this.sqlString = string;
        this.tableRowLimit = n;
        this.resourceBundle = aResourceBundle;
        this.dataSourceType = ConnectionManager.getDataSourceType();
        this.validQuery = false;
        this.tableModel = new SQLTableModel();
        this.tableHeadings = new ArrayList();
        this.columnNamesHashMap = new HashMap();
        this.columnClassHashMap = new HashMap();
        this.columnSQLTypeHashMap = new HashMap();
        this.columnTypeNameHashMap = new HashMap();
        this.columnSizeHashMap = new HashMap();
        this.preferredColumnSizeHashMap = new HashMap();
        this.columnSizeScaling = Ajqvue.getGeneralProperties().getFontSize() > 16 ? Ajqvue.getGeneralProperties().getFontSize() - 12 + 8 : 11;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.centerPanel = new JPanel(new BorderLayout());
        try {
            this.executeSQL();
        }
        catch (SQLException sQLException) {
            object = "SQLException: " + sQLException.getMessage() + " SQLState: " + sQLException.getSQLState() + " VendorError: " + sQLException.getErrorCode();
            QueryFrame.setQueryResultTextArea((String)object);
        }
        if (this.validQuery) {
            TableSorter tableSorter = new TableSorter(this.tableModel);
            this.listTable = new JTable(tableSorter);
            tableSorter.setTableHeader(this.listTable.getTableHeader());
            this.listTable.setAutoResizeMode(0);
            this.listTable.getActionMap().put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
            this.createListTablePopupMenu();
            this.listTable.addMouseListener(this.summaryTablePopupListener);
            object = this.tableHeadings.iterator();
            TableColumn tableColumn = null;
            int n2 = 0;
            while (object.hasNext()) {
                tableColumn = this.listTable.getColumnModel().getColumn(n2++);
                tableColumn.setPreferredWidth(this.preferredColumnSizeHashMap.get(object.next()));
            }
            this.tableScrollPane = new JScrollPane(this.listTable);
            this.tableScrollPane.setVerticalScrollBarPolicy(22);
            this.centerPanel.add((Component)this.tableScrollPane, "Center");
        }
        this.add((Component)this.centerPanel, "Center");
        this.addMouseListener(Ajqvue.getPopupMenuListener());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if ((object instanceof JButton || object instanceof JMenuItem) && this.validQuery && object instanceof JMenuItem) {
            Action action;
            String string = ((JMenuItem)object).getActionCommand();
            if (string.equals(ACTION_SELECT_ALL)) {
                this.listTable.selectAll();
            } else if (string.equals(ACTION_DESELECT_ALL)) {
                this.listTable.clearSelection();
            } else if (string.equals((String)TransferHandler.getCopyAction().getValue("Name")) && (action = this.listTable.getActionMap().get(string)) != null) {
                action.actionPerformed(new ActionEvent(this.listTable, 1001, null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSQL() throws SQLException {
        if (this.sqlString.length() < 1) {
            this.validQuery = false;
            return;
        }
        Connection connection = ConnectionManager.getConnection("SQLTabPanel executeSQL()");
        if (connection == null) {
            this.validQuery = false;
            return;
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.setMaxRows(this.tableRowLimit);
            String string = this.sqlString;
            statement.execute(string);
            int n = statement.getUpdateCount();
            if (n == -1) {
                int n2;
                int n3;
                String string2;
                int n4;
                String string3;
                int n5;
                ResultSet resultSet = statement.getResultSet();
                if (resultSet == null) {
                    String string4 = "Result";
                    String string5 = "java.lang.String";
                    int n6 = 12;
                    String string6 = "VARCHAR";
                    int n7 = 30;
                    this.tableHeadings.add(string4);
                    this.columnNamesHashMap.put(string4, string4);
                    this.columnClassHashMap.put(string4, string5);
                    this.columnSQLTypeHashMap.put(string4, n6);
                    this.columnTypeNameHashMap.put(string4, string6.toUpperCase(Locale.ENGLISH));
                    this.columnSizeHashMap.put(string4, n7);
                    this.preferredColumnSizeHashMap.put(string4, string4.length() * this.columnSizeScaling);
                    this.tableModel.setHeader(this.tableHeadings.toArray());
                    Object[] objectArray = new Object[]{"(" + this.resourceBundle.getResourceString("SQLTabPanel.label.Empty", "Empty") + ")"};
                    this.tableModel.addRow(objectArray);
                    this.validQuery = true;
                    return;
                }
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                if (Ajqvue.getDebug()) {
                    System.out.println("SQLTabPanel executeSQL()\nindex\tName\tClass\tType\tType Name\tScale\tPrecision\tSize");
                }
                for (n5 = 1; n5 < resultSetMetaData.getColumnCount() + 1; ++n5) {
                    String string7 = resultSetMetaData.getColumnLabel(n5);
                    string3 = resultSetMetaData.getColumnClassName(n5);
                    n4 = resultSetMetaData.getColumnType(n5);
                    string2 = resultSetMetaData.getColumnTypeName(n5);
                    int n8 = resultSetMetaData.getScale(n5);
                    int n9 = resultSetMetaData.getPrecision(n5);
                    n3 = resultSetMetaData.getColumnDisplaySize(n5);
                    if (Ajqvue.getDebug()) {
                        System.out.println(n5 + "\t" + string7 + "\t" + string3 + "\t" + n4 + "\t" + string2 + "\t" + n8 + "\t" + n9 + "\t" + n3);
                    }
                    if (string3 == null && string2 == null || this.dataSourceType.equals("sqlserver") && string2.toUpperCase(Locale.ENGLISH).equals("TIMESTAMP")) continue;
                    if (string3 == null) {
                        if (string2.equals("BINARY_FLOAT") && this.dataSourceType.equals("oracle")) {
                            string3 = "java.lang.Float";
                            string2 = "FLOAT";
                        } else if (string2.equals("BINARY_DOUBLE") && this.dataSourceType.equals("oracle")) {
                            string3 = "java.lang.Double";
                            string2 = "DOUBLE";
                        } else {
                            string3 = string2;
                        }
                    }
                    this.tableHeadings.add(string7);
                    this.columnNamesHashMap.put(string7, string7);
                    if (this.dataSourceType.equals("sqlite") && (string2.toUpperCase(Locale.ENGLISH).equals("DATE") || string2.toUpperCase(Locale.ENGLISH).equals("TIME") || string2.toUpperCase(Locale.ENGLISH).indexOf("DATETIME") != -1 || string2.toUpperCase(Locale.ENGLISH).equals("TIMESTAMP"))) {
                        string3 = string2.toUpperCase(Locale.ENGLISH).equals("DATE") ? "java.sql.Date" : (string2.toUpperCase(Locale.ENGLISH).equals("TIME") ? "java.sql.Time" : "java.sql.Timestamp");
                        n2 = SQLQuery.getTypeof(connection, this.sqlString, string7);
                        if (n2 != 0) {
                            n4 = n2;
                        }
                    }
                    this.columnClassHashMap.put(string7, string3);
                    this.columnSQLTypeHashMap.put(string7, n4);
                    this.columnTypeNameHashMap.put(string7, string2.toUpperCase(Locale.ENGLISH));
                    this.columnSizeHashMap.put(string7, n3);
                    this.preferredColumnSizeHashMap.put(string7, string7.length() * this.columnSizeScaling);
                }
                this.tableModel.setHeader(this.tableHeadings.toArray());
                n5 = 0;
                n2 = 0;
                Object[] objectArray = new Object[this.tableHeadings.size()];
                while (resultSet.next()) {
                    for (String string7 : this.tableHeadings) {
                        String string8;
                        Object object;
                        string3 = this.columnClassHashMap.get(string7);
                        n4 = this.columnSQLTypeHashMap.get(string7);
                        string2 = this.columnTypeNameHashMap.get(string7);
                        n3 = this.columnSizeHashMap.get(string7);
                        int n10 = this.preferredColumnSizeHashMap.get(string7);
                        if (Ajqvue.getDebug()) {
                            System.out.println(n5 + " " + n2 + " " + string7 + " " + string3 + " " + n4 + " " + string2 + " " + n3 + " " + n10);
                        }
                        if (string3.indexOf("BigDecimal") != -1) {
                            object = resultSet.getString(string7);
                            objectArray[n2++] = object == null ? "NULL" : new BigDecimal(object.toString());
                        } else if (string2.equals("DATE")) {
                            object = resultSet.getObject(string7);
                            objectArray[n2++] = object == null ? "NULL" : (this.dataSourceType.equals("sqlite") ? TableTabPanel_SQLite.getDate(resultSet, n4, string7) : new SimpleDateFormat(DBTablesPanel.getGeneralDBProperties().getViewDateFormat()).format(object));
                        } else if (string2.equals("DATETIMEOFFSET")) {
                            object = resultSet.getString(string7);
                            if (object == null) {
                                objectArray[n2++] = "NULL";
                            } else {
                                string8 = object + "";
                                string8 = string8.substring(0, string8.indexOf(" "));
                                string8 = Utils.convertDBDateString_To_ViewDateString(string8, DBTablesPanel.getGeneralDBProperties().getViewDateFormat());
                                String string9 = object + "";
                                string9 = string9.substring(string9.indexOf(" "));
                                objectArray[n2++] = string8 + string9;
                            }
                        } else if (string2.indexOf("DATETIME") != -1) {
                            object = resultSet.getObject(string7);
                            objectArray[n2++] = object == null ? "NULL" : (this.dataSourceType.equals("sqlite") ? TableTabPanel_SQLite.getTimestamp(resultSet, n4, string2, string7) : new SimpleDateFormat(DBTablesPanel.getGeneralDBProperties().getViewDateFormat() + " HH:mm:ss").format(object));
                        } else if (string2.equals("TIME")) {
                            object = resultSet.getObject(string7);
                            if (object == null) {
                                objectArray[n2++] = "NULL";
                            } else if (this.dataSourceType.equals("sqlite")) {
                                objectArray[n2++] = TableTabPanel_SQLite.getTime(resultSet, n4, string7);
                            } else {
                                object = resultSet.getTime(string7);
                                objectArray[n2++] = new SimpleDateFormat("HH:mm:ss").format(object);
                            }
                        } else if (string2.equals("TIMETZ")) {
                            object = resultSet.getTime(string7);
                            objectArray[n2++] = object == null ? "NULL" : (this.dataSourceType.equals("sqlite") ? TableTabPanel_SQLite.getTimeTZ(resultSet, n4, string7) : new SimpleDateFormat("HH:mm:ss z").format(object));
                        } else if (string2.equals("TIMESTAMP")) {
                            object = resultSet.getObject(string7);
                            objectArray[n2++] = object == null ? "NULL" : (this.dataSourceType.equals("mysql") || this.dataSourceType.equals("mariadb") ? (n3 == 2 ? new SimpleDateFormat("yy").format(object) : (n3 == 4 ? new SimpleDateFormat("MM-yy").format(object) : (n3 == 6 ? new SimpleDateFormat("MM-dd-yy").format(object) : (n3 == 8 ? new SimpleDateFormat("MM-dd-yyyy").format(object) : (n3 == 10 ? new SimpleDateFormat("MM-dd-yy HH:mm").format(object) : (n3 == 12 ? new SimpleDateFormat("MM-dd-yyyy HH:mm").format(object) : new SimpleDateFormat(DBTablesPanel.getGeneralDBProperties().getViewDateFormat() + " HH:mm:ss").format(object))))))) : (this.dataSourceType.equals("sqlite") ? TableTabPanel_SQLite.getTimestamp(resultSet, n4, string2, string7) : new SimpleDateFormat(DBTablesPanel.getGeneralDBProperties().getViewDateFormat() + " HH:mm:ss").format(object)));
                        } else if (string2.equals("TIMESTAMPTZ") || string2.equals("TIMESTAMP WITH TIME ZONE") || string2.equals("TIMESTAMP WITH LOCAL TIME ZONE")) {
                            object = resultSet.getTimestamp(string7);
                            objectArray[n2++] = object == null ? "NULL" : (this.dataSourceType.equals("sqlite") ? TableTabPanel_SQLite.getTimestamp(resultSet, n4, string2, string7) : new SimpleDateFormat(DBTablesPanel.getGeneralDBProperties().getViewDateFormat() + " HH:mm:ss z").format(object));
                        } else if (string2.equals("YEAR")) {
                            object = resultSet.getObject(string7);
                            if (object == null) {
                                objectArray[n2++] = "NULL";
                            } else {
                                string8 = object + "";
                                if ((string8 = string8.trim()).length() >= 4) {
                                    string8 = string8.substring(0, 4);
                                }
                                objectArray[n2++] = string8;
                            }
                        } else if (string3.indexOf("String") == -1 && string2.indexOf("BLOB") != -1) {
                            objectArray[n2++] = n3 == 255 ? "Tiny Blob" : (n3 == 65535 ? "Blob" : (n3 == 0xFFFFFF ? "Medium Blob" : (n3 > 0xFFFFFF ? "Long Blob" : "Blob")));
                        } else if (string2.indexOf("CLOB") != -1) {
                            objectArray[n2++] = "Clob";
                        } else if (string2.equals("BYTEA")) {
                            objectArray[n2++] = "Bytea";
                        } else if (string2.indexOf("BINARY") != -1 || string2.indexOf("IMAGE") != -1) {
                            objectArray[n2++] = "Binary";
                        } else if (string2.indexOf("RAW") != -1) {
                            objectArray[n2++] = "Raw";
                        } else if (string2.indexOf("IMAGE") != -1) {
                            objectArray[n2++] = "IMAGE";
                        } else if (string3.indexOf("Boolean") != -1) {
                            object = resultSet.getString(string7);
                            objectArray[n2++] = object == null ? "NULL" : object.toString();
                        } else if (string2.indexOf("BIT") != -1 && (this.dataSourceType.equals("mysql") || this.dataSourceType.equals("mariadb"))) {
                            object = resultSet.getString(string7);
                            if (object == null) {
                                objectArray[n2++] = "NULL";
                            } else {
                                string8 = Byte.toString(resultSet.getByte(string7));
                                objectArray[n2++] = Integer.toBinaryString(Integer.parseInt(string8));
                            }
                        } else {
                            objectArray[n2++] = string3.indexOf("String") != -1 && !string2.equals("CHAR") && !string2.equals("NCHAR") && n3 > 255 ? ((object = resultSet.getObject(string7)) == null ? "NULL" : (n3 <= 65535 ? (String)object : (n3 == 0xFFFFFF ? "Medium Text" : (this.dataSourceType.equals("mysql") || this.dataSourceType.equals("mariadb") ? "Long Text" : (((String)object).length() > 512 ? ((String)object).substring(0, 512) : (String)object))))) : (string3.indexOf("String") != -1 && string2.equals("LONG") ? ((object = resultSet.getObject(string7)) == null ? "NULL" : (((String)object).length() > 512 ? ((String)object).substring(0, 512) : (String)object)) : ((string3.indexOf("Object") != -1 || string3.indexOf("Array") != -1) && string2.indexOf("_") != -1 ? ((object = resultSet.getString(string7)) == null ? "NULL" : ((string8 = (String)object).length() > 512 ? string8.substring(0, 512) : string8)) : ((object = resultSet.getString(string7)) == null ? "NULL" : object.toString().trim())));
                        }
                        if ((objectArray[n2 - 1] + "").length() * this.columnSizeScaling > n10 && (n10 = (objectArray[n2 - 1] + "").length() * this.columnSizeScaling) > 350) {
                            n10 = 350;
                        }
                        this.preferredColumnSizeHashMap.put(string7, n10);
                    }
                    this.tableModel.addRow(objectArray);
                    n2 = 0;
                    ++n5;
                }
                resultSet.close();
                statement.close();
            } else {
                String string10 = "Update Count";
                String string11 = "java.lang.String";
                int n11 = 12;
                String string12 = "VARCHAR";
                int n12 = 30;
                this.tableHeadings.add(string10);
                this.columnNamesHashMap.put(string10, string10);
                this.columnClassHashMap.put(string10, string11);
                this.columnSQLTypeHashMap.put(string10, n11);
                this.columnTypeNameHashMap.put(string10, string12.toUpperCase(Locale.ENGLISH));
                this.columnSizeHashMap.put(string10, n12);
                this.preferredColumnSizeHashMap.put(string10, string10.length() * this.columnSizeScaling);
                this.tableModel.setHeader(this.tableHeadings.toArray());
                Object[] objectArray = new Object[]{n};
                this.tableModel.addRow(objectArray);
            }
            this.validQuery = true;
        }
        catch (SQLException sQLException) {
            String string = "SQLException: " + sQLException.getMessage() + " SQLState: " + sQLException.getSQLState() + " VendorError: " + sQLException.getErrorCode();
            QueryFrame.setQueryResultTextArea(string);
            this.validQuery = false;
            return;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            ConnectionManager.closeConnection(connection, "SQLTabPanel executeSQL()");
        }
    }

    private void createListTablePopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        String string = this.resourceBundle.getResourceString("SQLTabPanel.menu.SelectAll", ACTION_SELECT_ALL);
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand(ACTION_SELECT_ALL);
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        string = this.resourceBundle.getResourceString("SQLTabPanel.menu.DeSelectAll", ACTION_DESELECT_ALL);
        jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand(ACTION_DESELECT_ALL);
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        string = this.resourceBundle.getResourceString("SQLTabPanel.menu.Copy", "Copy");
        jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand((String)TransferHandler.getCopyAction().getValue("Name"));
        jMenuItem.setMnemonic(67);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        this.summaryTablePopupListener = new Main_MouseAdapter(jPopupMenu);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        repaintManager.setDoubleBufferingEnabled(false);
        Rectangle rectangle = graphics2D.getClipBounds();
        double d = rectangle.getWidth() / (double)this.getWidth();
        graphics2D.scale(d, d);
        this.paintAll(graphics2D);
        repaintManager.setDoubleBufferingEnabled(true);
        return 0;
    }

    public ArrayList<String> getTableHeadings() {
        return this.tableHeadings;
    }

    public JTable getListTable() {
        return this.listTable;
    }

    public HashMap<String, String> getColumnNamesHashMap() {
        return this.columnNamesHashMap;
    }

    public HashMap<String, String> getColumnClassHashMap() {
        return this.columnClassHashMap;
    }

    public HashMap<String, Integer> getColumnSQLTypeHashMap() {
        return this.columnSQLTypeHashMap;
    }

    public HashMap<String, String> getColumnTypeNameHashMap() {
        return this.columnTypeNameHashMap;
    }

    public HashMap<String, Integer> getColumnSizeHashMap() {
        return this.columnSizeHashMap;
    }

    static class SQLTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1229214973355124583L;
        private Object[] headers = new Object[0];
        private ArrayList<Object[]> rows = new ArrayList();

        protected SQLTableModel() {
        }

        public void addRow(Object[] objectArray) {
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = objectArray[i];
            }
            this.rows.add(objectArray2);
        }

        public void clear() {
            this.rows.clear();
        }

        @Override
        public String getColumnName(int n) {
            return this.headers[n].toString();
        }

        @Override
        public int getColumnCount() {
            return this.headers.length;
        }

        public ArrayList<Object[]> getData() {
            return this.rows;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n >= this.rows.size()) {
                return null;
            }
            Object[] objectArray = this.rows.get(n);
            if (n2 >= objectArray.length) {
                return null;
            }
            return objectArray[n2];
        }

        public void setHeader(Object[] objectArray) {
            this.headers = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, this.headers, 0, objectArray.length);
        }
    }
}

