/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.structures.DataExportProperties;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SQLExportPreferencesPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = -5732424370606695238L;
    private JPanel dataContentOptionsPanel;
    private CardLayout dataOptionsCardLayout;
    private JCheckBox tableStructureCheckBox;
    private JCheckBox tableDataCheckBox;
    private JComboBox<Object> insertExpressionComboBox;
    private JComboBox<Object> replaceExpressionComboBox;
    private JSpinner insertPluralSpinner;
    private JSpinner replacePluralSpinner;
    private JCheckBox insertLockTableCheckBox;
    private JCheckBox insertTypeCheckBox;
    private JCheckBox replaceLockTableCheckBox;
    private JCheckBox replaceTypeCheckBox;
    private JCheckBox updateLockTableCheckBox;
    private JCheckBox updateTypeCheckBox;
    private JCheckBox autoIncrementCheckBox;
    private JCheckBox timeStampCheckBox;
    private JComboBox<Object> insertReplaceUpdateComboBox;
    private JComboBox<Object> insertTypeComboBox;
    private JComboBox<Object> replaceTypeComboBox;
    private JComboBox<Object> updateTypeComboBox;
    private JTextField identifierQuoteTextField;
    private JCheckBox summaryTableLimitCheckBox;
    private JButton restoreDefaultsButton;
    private JButton applyButton;
    private String dataSourceType;
    private static final int minimumPlural = 2;
    private static final int maxPlural = 50000;
    private static int spinnerPluralStep = 100;
    public static final int DEFAULT_PLURAL_SIZE = 250;
    public static final boolean DEFAULT_TABLE_STRUCTURE = false;
    public static final boolean DEFAULT_TABLE_DATA = true;
    public static final boolean DEFAULT_INSERT_LOCK = true;
    public static final boolean DEFAULT_INSERT_TYPE = false;
    public static final boolean DEFAULT_REPLACE_LOCK = true;
    public static final boolean DEFAULT_REPLACE_TYPE = false;
    public static final boolean DEFAULT_UPDATE_LOCK = true;
    public static final boolean DEFAULT_UPDATE_TYPE = false;
    public static final boolean DEFAULT_AUTO_INCREMENT = false;
    public static final boolean DEFAULT_TIMESTAMP = false;
    public static final boolean DEFAULT_SUMMARY_TABLE_USE_LIMIT = true;
    public static final String EXPRESSION_SINGULAR = "Singular";
    public static final String EXPRESSION_PLURAL = "Plural";
    public static final String EXPRESSION_EXPLICIT = "Explicit";
    public static final String TYPE_INSERT = "Insert";
    public static final String TYPE_REPLACE = "Replace";
    public static final String TYPE_UPDATE = "Update";
    public static final String PRIORITY_LOW = "Low_Priority";
    public static final String PRIORITY_DELAYED = "Delayed";
    public static final String PRIORITY_IGNORE = "Ignore";

    public SQLExportPreferencesPanel(AResourceBundle aResourceBundle) {
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.dataSourceType = ConnectionManager.getDataSourceType();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0), BorderFactory.createLoweredBevelBorder()));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 0, 0));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createEtchedBorder()));
        String string = aResourceBundle.getResourceString("SQLExportPreferencesPanel.checkbox.TableStructure", "Table Structure");
        this.tableStructureCheckBox = new JCheckBox(string, false);
        this.tableStructureCheckBox.setFocusPainted(false);
        this.tableStructureCheckBox.addActionListener(this);
        jPanel2.add(this.tableStructureCheckBox);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder());
        string = aResourceBundle.getResourceString("SQLExportPreferencesPanel.label.Warning", "Warning");
        JLabel jLabel = new JLabel(" " + string + "! ", 10);
        jLabel.setBorder(BorderFactory.createEmptyBorder());
        jLabel.setForeground(Color.RED);
        jPanel3.add(jLabel);
        string = aResourceBundle.getResourceString("SQLExportPreferencesPanel.label.DropExistingTable", "Inserts SQL statement DROP EXISTING TABLE.");
        JLabel jLabel2 = new JLabel(string);
        jLabel2.setBorder(BorderFactory.createEmptyBorder());
        jPanel3.add(jLabel2);
        jPanel2.add(jPanel3);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(gridBagLayout);
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 1, 1, 1), BorderFactory.createEtchedBorder()));
        string = aResourceBundle.getResourceString("SQLExportPreferencesPanel.checkbox.TableData", "Table Data");
        this.tableDataCheckBox = new JCheckBox(string, true);
        this.tableDataCheckBox.setFocusPainted(false);
        this.tableDataCheckBox.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 35.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.tableDataCheckBox, gridBagConstraints);
        jPanel4.add(this.tableDataCheckBox);
        JPanel jPanel5 = new JPanel(gridBagLayout);
        jPanel5.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        this.identifierQuoteTextField = new JTextField(2);
        this.identifierQuoteTextField.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 80.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.identifierQuoteTextField, gridBagConstraints);
        jPanel5.add(this.identifierQuoteTextField);
        string = aResourceBundle.getResourceString("SQLExportPreferencesPanel.label.IdentifierQuoteString", "Identifier Quote String");
        JLabel jLabel3 = new JLabel(" " + string);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 20.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel5.add(jLabel3);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 65.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel4.add(jPanel5);
        JPanel jPanel6 = new JPanel(gridBagLayout);
        this.insertReplaceUpdateComboBox = new JComboBox();
        this.insertReplaceUpdateComboBox.addItem(TYPE_INSERT);
        if (!(this.dataSourceType.equals("postgresql") || this.dataSourceType.equals("odbc") || this.dataSourceType.equals("sqlserver") || this.dataSourceType.equals("derby"))) {
            this.insertReplaceUpdateComboBox.addItem(TYPE_REPLACE);
        }
        this.insertReplaceUpdateComboBox.addItem(TYPE_UPDATE);
        this.insertReplaceUpdateComboBox.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 30.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.insertReplaceUpdateComboBox, gridBagConstraints);
        jPanel6.add(this.insertReplaceUpdateComboBox);
        this.dataOptionsCardLayout = new CardLayout();
        this.dataContentOptionsPanel = new JPanel(this.dataOptionsCardLayout);
        this.dataContentOptionsPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(gridBagLayout);
        this.createInsertOptionsPanel(jPanel7, gridBagLayout, gridBagConstraints, aResourceBundle);
        this.dataContentOptionsPanel.add((Component)jPanel7, TYPE_INSERT);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(gridBagLayout);
        this.createReplaceOptionsPanel(jPanel8, gridBagLayout, gridBagConstraints, aResourceBundle);
        this.dataContentOptionsPanel.add((Component)jPanel8, TYPE_REPLACE);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(gridBagLayout);
        this.createUpdateOptionsPanel(jPanel9, gridBagLayout, gridBagConstraints, aResourceBundle);
        this.dataContentOptionsPanel.add((Component)jPanel9, TYPE_UPDATE);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 70.0, 100.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.dataContentOptionsPanel, gridBagConstraints);
        jPanel6.add(this.dataContentOptionsPanel);
        this.buildConstraints(gridBagConstraints, 0, 1, 2, 1, 0.0, 80.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel6, gridBagConstraints);
        jPanel4.add(jPanel6);
        string = aResourceBundle.getResourceString("SQLExportPreferencesPanel.checkbox.SummaryTableUseLimit", "Summary Table Use LIMIT");
        this.summaryTableLimitCheckBox = new JCheckBox(string, true);
        this.summaryTableLimitCheckBox.setFocusPainted(false);
        this.summaryTableLimitCheckBox.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 0, 2, 2, 1, 100.0, 10.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.summaryTableLimitCheckBox, gridBagConstraints);
        jPanel4.add(this.summaryTableLimitCheckBox);
        jPanel.add((Component)jPanel4, "Center");
        this.add((Component)jPanel, "Center");
        this.setSQLExportOptions(DBTablesPanel.getDataExportProperties());
        JPanel jPanel10 = new JPanel();
        string = aResourceBundle.getResourceString("SQLExportPreferencesPanel.button.RestoreDefaults", "Restore Defaults");
        this.restoreDefaultsButton = new JButton(string);
        this.restoreDefaultsButton.addActionListener(this);
        jPanel10.add(this.restoreDefaultsButton);
        string = aResourceBundle.getResourceString("SQLExportPreferencesPanel.button.Apply", "Apply");
        this.applyButton = new JButton(string);
        this.applyButton.setEnabled(false);
        this.applyButton.addActionListener(this);
        jPanel10.add(this.applyButton);
        this.add((Component)jPanel10, "South");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            if (object == this.restoreDefaultsButton) {
                this.tableStructureCheckBox.setSelected(false);
                this.tableDataCheckBox.setSelected(true);
                this.identifierQuoteTextField.setText(ConnectionManager.getIdentifierQuoteString());
                this.insertLockTableCheckBox.setSelected(true);
                this.replaceLockTableCheckBox.setSelected(true);
                this.updateLockTableCheckBox.setSelected(true);
                this.autoIncrementCheckBox.setSelected(false);
                this.timeStampCheckBox.setSelected(false);
                if (this.dataSourceType.equals("mysql") || this.dataSourceType.equals("mariadb") || this.dataSourceType.equals("postgresql")) {
                    this.insertExpressionComboBox.setSelectedItem(EXPRESSION_PLURAL);
                    this.replaceExpressionComboBox.setSelectedItem(EXPRESSION_PLURAL);
                    this.insertPluralSpinner.setEnabled(true);
                    this.replacePluralSpinner.setEnabled(true);
                } else {
                    this.insertExpressionComboBox.setSelectedItem(EXPRESSION_SINGULAR);
                    this.replaceExpressionComboBox.setSelectedItem(EXPRESSION_SINGULAR);
                    this.insertPluralSpinner.setEnabled(false);
                    this.replacePluralSpinner.setEnabled(false);
                }
                this.insertPluralSpinner.setValue(250);
                this.replacePluralSpinner.setValue(250);
                this.insertTypeCheckBox.setSelected(false);
                this.replaceTypeCheckBox.setSelected(false);
                this.updateTypeCheckBox.setSelected(false);
                this.insertReplaceUpdateComboBox.setSelectedItem(TYPE_INSERT);
                this.insertReplaceUpdateComboBox.setEnabled(true);
                this.insertTypeComboBox.setSelectedItem(PRIORITY_LOW);
                this.insertTypeComboBox.setEnabled(false);
                this.replaceTypeComboBox.setSelectedItem(PRIORITY_LOW);
                this.replaceTypeComboBox.setEnabled(false);
                this.updateTypeComboBox.setSelectedItem(PRIORITY_LOW);
                this.updateTypeComboBox.setEnabled(false);
                this.summaryTableLimitCheckBox.setSelected(true);
                this.applyButton.setEnabled(true);
            } else if (object == this.applyButton) {
                DBTablesPanel.setDataExportProperties(this.getSQLExportOptions());
                this.applyButton.setEnabled(false);
            }
        }
        if (object instanceof JCheckBox && this.applyButton != null) {
            if (object == this.tableStructureCheckBox) {
                if (this.tableStructureCheckBox.isSelected()) {
                    this.insertReplaceUpdateComboBox.setSelectedItem(TYPE_INSERT);
                    this.insertReplaceUpdateComboBox.setEnabled(false);
                } else {
                    this.insertReplaceUpdateComboBox.setEnabled(true);
                }
            }
            if (object == this.insertTypeCheckBox) {
                if (this.insertTypeCheckBox.isSelected()) {
                    this.insertTypeComboBox.setEnabled(true);
                } else {
                    this.insertTypeComboBox.setEnabled(false);
                }
            }
            if (object == this.replaceTypeCheckBox) {
                if (this.replaceTypeCheckBox.isSelected()) {
                    this.replaceTypeComboBox.setEnabled(true);
                } else {
                    this.replaceTypeComboBox.setEnabled(false);
                }
            }
            if (object == this.updateTypeCheckBox) {
                if (this.updateTypeCheckBox.isSelected()) {
                    this.updateTypeComboBox.setEnabled(true);
                } else {
                    this.updateTypeComboBox.setEnabled(false);
                }
            }
            this.applyButton.setEnabled(true);
        }
        if (object instanceof JTextField && this.applyButton != null) {
            this.applyButton.setEnabled(true);
        }
        if (object instanceof JComboBox && this.applyButton != null) {
            if (object == this.insertReplaceUpdateComboBox) {
                this.dataOptionsCardLayout.show(this.dataContentOptionsPanel, (String)this.insertReplaceUpdateComboBox.getSelectedItem());
            }
            if (object == this.insertTypeComboBox && this.insertTypeComboBox.getSelectedItem().equals(PRIORITY_DELAYED)) {
                this.insertLockTableCheckBox.setSelected(false);
            }
            if (object == this.replaceTypeComboBox && this.replaceTypeComboBox.getSelectedItem().equals(PRIORITY_DELAYED)) {
                this.replaceLockTableCheckBox.setSelected(false);
            }
            if (object == this.insertExpressionComboBox) {
                if (this.insertExpressionComboBox.getSelectedItem().equals(EXPRESSION_PLURAL)) {
                    this.insertPluralSpinner.setEnabled(true);
                } else {
                    this.insertPluralSpinner.setEnabled(false);
                }
            }
            if (object == this.replaceExpressionComboBox) {
                if (this.replaceExpressionComboBox.getSelectedItem().equals(EXPRESSION_PLURAL)) {
                    this.replacePluralSpinner.setEnabled(true);
                } else {
                    this.replacePluralSpinner.setEnabled(false);
                }
            }
            this.applyButton.setEnabled(true);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof JSpinner && this.applyButton != null) {
            this.applyButton.setEnabled(true);
        }
    }

    private void createInsertOptionsPanel(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, AResourceBundle aResourceBundle) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder());
        this.insertExpressionComboBox = new JComboBox();
        this.insertExpressionComboBox.addItem(EXPRESSION_SINGULAR);
        this.insertExpressionComboBox.addItem(EXPRESSION_PLURAL);
        this.insertExpressionComboBox.addItem(EXPRESSION_EXPLICIT);
        this.insertExpressionComboBox.addActionListener(this);
        jPanel2.add(this.insertExpressionComboBox);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(250, 2, 50000, spinnerPluralStep);
        this.insertPluralSpinner = new JSpinner(spinnerNumberModel);
        this.insertPluralSpinner.addChangeListener(this);
        jPanel2.add(this.insertPluralSpinner);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        String string = aResourceBundle.getResourceString("SQLExportPreferencesPanel.checkbox.LockTable", "Lock Table");
        this.insertLockTableCheckBox = new JCheckBox(string, true);
        this.insertLockTableCheckBox.setFocusPainted(false);
        this.insertLockTableCheckBox.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.insertLockTableCheckBox, gridBagConstraints);
        jPanel.add(this.insertLockTableCheckBox);
        string = aResourceBundle.getResourceString("SQLExportPreferencesPanel.checkbox.Auto-Increment", "Auto-Increment");
        this.autoIncrementCheckBox = new JCheckBox(string + ": SEQ", false);
        this.autoIncrementCheckBox.setFocusPainted(false);
        this.autoIncrementCheckBox.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.autoIncrementCheckBox, gridBagConstraints);
        jPanel.add(this.autoIncrementCheckBox);
        string = aResourceBundle.getResourceString("SQLExportPreferencesPanel.checkbox.Timestamp", "Timestamp");
        this.timeStampCheckBox = new JCheckBox(string + ": NOW( )", false);
        this.timeStampCheckBox.setFocusPainted(false);
        this.timeStampCheckBox.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 1, 3, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.timeStampCheckBox, gridBagConstraints);
        jPanel.add(this.timeStampCheckBox);
        string = aResourceBundle.getResourceString("SQLExportPreferencesPanel.checkbox.Type", "Type");
        this.insertTypeCheckBox = new JCheckBox(string, false);
        this.insertTypeCheckBox.setFocusPainted(false);
        this.insertTypeCheckBox.addActionListener(this);
        if (this.dataSourceType.equals("postgresql")) {
            this.insertTypeCheckBox.setEnabled(false);
        }
        this.buildConstraints(gridBagConstraints, 1, 4, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.insertTypeCheckBox, gridBagConstraints);
        jPanel.add(this.insertTypeCheckBox);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder());
        this.insertTypeComboBox = new JComboBox();
        this.insertTypeComboBox.addItem(PRIORITY_LOW);
        this.insertTypeComboBox.addItem(PRIORITY_DELAYED);
        this.insertTypeComboBox.addItem(PRIORITY_IGNORE);
        this.insertTypeComboBox.setEnabled(false);
        this.insertTypeComboBox.addActionListener(this);
        jPanel3.add(this.insertTypeComboBox);
        this.buildConstraints(gridBagConstraints, 0, 5, 2, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
    }

    private void createReplaceOptionsPanel(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, AResourceBundle aResourceBundle) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder());
        this.replaceExpressionComboBox = new JComboBox();
        this.replaceExpressionComboBox.addItem(EXPRESSION_SINGULAR);
        this.replaceExpressionComboBox.addItem(EXPRESSION_PLURAL);
        this.replaceExpressionComboBox.addItem(EXPRESSION_EXPLICIT);
        this.replaceExpressionComboBox.addActionListener(this);
        jPanel2.add(this.replaceExpressionComboBox);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(250, 2, 50000, spinnerPluralStep);
        this.replacePluralSpinner = new JSpinner(spinnerNumberModel);
        this.replacePluralSpinner.addChangeListener(this);
        jPanel2.add(this.replacePluralSpinner);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        String string = aResourceBundle.getResourceString("SQLExportPreferencesPanel.checkbox.LockTable", "Lock Table");
        this.replaceLockTableCheckBox = new JCheckBox(string, true);
        this.replaceLockTableCheckBox.setFocusPainted(false);
        this.replaceLockTableCheckBox.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.replaceLockTableCheckBox, gridBagConstraints);
        jPanel.add(this.replaceLockTableCheckBox);
        string = aResourceBundle.getResourceString("SQLExportPreferencesPanel.checkbox.Type", "Type");
        this.replaceTypeCheckBox = new JCheckBox(string, false);
        this.replaceTypeCheckBox.setFocusPainted(false);
        this.replaceTypeCheckBox.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.replaceTypeCheckBox, gridBagConstraints);
        jPanel.add(this.replaceTypeCheckBox);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder());
        this.replaceTypeComboBox = new JComboBox();
        this.replaceTypeComboBox.addItem(PRIORITY_LOW);
        this.replaceTypeComboBox.addItem(PRIORITY_DELAYED);
        this.replaceTypeComboBox.setEnabled(false);
        this.replaceTypeComboBox.addActionListener(this);
        jPanel3.add(this.replaceTypeComboBox);
        this.buildConstraints(gridBagConstraints, 0, 3, 2, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
    }

    private void createUpdateOptionsPanel(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, AResourceBundle aResourceBundle) {
        String string = aResourceBundle.getResourceString("SQLExportPreferencesPanel.checkbox.LockTable", "Lock Table");
        this.updateLockTableCheckBox = new JCheckBox(string, true);
        this.updateLockTableCheckBox.setFocusPainted(false);
        this.updateLockTableCheckBox.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.updateLockTableCheckBox, gridBagConstraints);
        jPanel.add(this.updateLockTableCheckBox);
        string = aResourceBundle.getResourceString("SQLExportPreferencesPanel.checkbox.Type", "Type");
        this.updateTypeCheckBox = new JCheckBox(string, false);
        this.updateTypeCheckBox.setFocusPainted(false);
        this.updateTypeCheckBox.addActionListener(this);
        if (this.dataSourceType.equals("postgresql")) {
            this.updateTypeCheckBox.setEnabled(false);
        }
        this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.updateTypeCheckBox, gridBagConstraints);
        jPanel.add(this.updateTypeCheckBox);
        JPanel jPanel2 = new JPanel();
        this.updateTypeComboBox = new JComboBox();
        this.updateTypeComboBox.addItem(PRIORITY_LOW);
        this.updateTypeComboBox.addItem(PRIORITY_IGNORE);
        this.updateTypeComboBox.setEnabled(false);
        this.updateTypeComboBox.addActionListener(this);
        jPanel2.add(this.updateTypeComboBox);
        this.buildConstraints(gridBagConstraints, 0, 2, 2, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
    }

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    public DataExportProperties getSQLExportOptions() {
        DataExportProperties dataExportProperties = DBTablesPanel.getDataExportProperties();
        dataExportProperties.setTableStructure(this.tableStructureCheckBox.isSelected());
        dataExportProperties.setTableData(this.tableDataCheckBox.isSelected());
        dataExportProperties.setIdentifierQuoteString(this.identifierQuoteTextField.getText());
        dataExportProperties.setInsertPluralSize(Integer.parseInt(this.insertPluralSpinner.getValue().toString()));
        dataExportProperties.setReplacePluralSize(Integer.parseInt(this.replacePluralSpinner.getValue().toString()));
        dataExportProperties.setInsertLock(this.insertLockTableCheckBox.isSelected());
        dataExportProperties.setReplaceLock(this.replaceLockTableCheckBox.isSelected());
        dataExportProperties.setUpdateLock(this.updateLockTableCheckBox.isSelected());
        dataExportProperties.setInsertExpression((String)this.insertExpressionComboBox.getSelectedItem());
        dataExportProperties.setReplaceExpression((String)this.replaceExpressionComboBox.getSelectedItem());
        dataExportProperties.setAutoIncrement(this.autoIncrementCheckBox.isSelected());
        dataExportProperties.setTimeStamp(this.timeStampCheckBox.isSelected());
        dataExportProperties.setInsertType(this.insertTypeCheckBox.isSelected());
        dataExportProperties.setReplaceType(this.replaceTypeCheckBox.isSelected());
        dataExportProperties.setUpdateType(this.updateTypeCheckBox.isSelected());
        dataExportProperties.setInsertReplaceUpdate((String)this.insertReplaceUpdateComboBox.getSelectedItem());
        dataExportProperties.setInsertTypeSetting((String)this.insertTypeComboBox.getSelectedItem());
        dataExportProperties.setReplaceTypeSetting((String)this.replaceTypeComboBox.getSelectedItem());
        dataExportProperties.setUpdateTypeSetting((String)this.updateTypeComboBox.getSelectedItem());
        dataExportProperties.setSQLSummaryTableUseLimit(this.summaryTableLimitCheckBox.isSelected());
        return dataExportProperties;
    }

    public void setSQLExportOptions(DataExportProperties dataExportProperties) {
        this.tableStructureCheckBox.setSelected(dataExportProperties.getTableStructure());
        this.tableDataCheckBox.setSelected(dataExportProperties.getTableData());
        this.identifierQuoteTextField.setText(dataExportProperties.getIdentifierQuoteString());
        this.insertPluralSpinner.setValue(dataExportProperties.getInsertPluralSize());
        this.replacePluralSpinner.setValue(dataExportProperties.getReplacePluralSize());
        this.insertLockTableCheckBox.setSelected(dataExportProperties.getInsertLock());
        this.replaceLockTableCheckBox.setSelected(dataExportProperties.getReplaceLock());
        this.updateLockTableCheckBox.setSelected(dataExportProperties.getUpdateLock());
        this.insertExpressionComboBox.setSelectedItem(dataExportProperties.getInsertExpression());
        if (this.insertExpressionComboBox.getSelectedItem().equals(EXPRESSION_PLURAL)) {
            this.insertPluralSpinner.setEnabled(true);
        } else {
            this.insertPluralSpinner.setEnabled(false);
        }
        this.replaceExpressionComboBox.setSelectedItem(dataExportProperties.getReplaceExpression());
        if (this.replaceExpressionComboBox.getSelectedItem().equals(EXPRESSION_PLURAL)) {
            this.replacePluralSpinner.setEnabled(true);
        } else {
            this.replacePluralSpinner.setEnabled(false);
        }
        this.autoIncrementCheckBox.setSelected(dataExportProperties.getAutoIncrement());
        this.timeStampCheckBox.setSelected(dataExportProperties.getTimeStamp());
        this.insertTypeCheckBox.setSelected(dataExportProperties.getInsertType());
        this.replaceTypeCheckBox.setSelected(dataExportProperties.getReplaceType());
        this.updateTypeCheckBox.setSelected(dataExportProperties.getUpdateType());
        this.insertReplaceUpdateComboBox.setSelectedItem(dataExportProperties.getInsertReplaceUpdate());
        this.insertReplaceUpdateComboBox.setEnabled(!this.tableStructureCheckBox.isSelected());
        this.dataOptionsCardLayout.show(this.dataContentOptionsPanel, (String)this.insertReplaceUpdateComboBox.getSelectedItem());
        this.insertTypeComboBox.setSelectedItem(dataExportProperties.getInsertTypeSetting());
        this.insertTypeComboBox.setEnabled(this.insertTypeCheckBox.isSelected());
        this.replaceTypeComboBox.setSelectedItem(dataExportProperties.getReplaceTypeSetting());
        this.replaceTypeComboBox.setEnabled(this.replaceTypeCheckBox.isSelected());
        this.updateTypeComboBox.setSelectedItem(dataExportProperties.getUpdateTypeSetting());
        this.updateTypeComboBox.setEnabled(this.updateTypeCheckBox.isSelected());
        this.summaryTableLimitCheckBox.setSelected(dataExportProperties.getSQLSummaryTableUseLimit());
    }
}

