/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.gui.panels.PreferencesPanel;
import com.dandymadeproductions.ajqvue.gui.sprites.RainDrop;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Random;

public class PreferencesPanelEarlySpring
extends PreferencesPanel {
    private static final long serialVersionUID = -500197101860684191L;
    private transient Image backgroundImage;
    private int backgroundImageWidth;
    private int backgroundImageHeight;
    private transient Image offScreenGraphicsImage;
    private transient Image rainDropImage;
    private int rainDropImageWidth;
    private int rainDropImageHeight;
    private transient ArrayList<RainDrop> rainDrops;
    private volatile boolean runThread;
    private volatile boolean suspendThread;
    private static final int frameDelay = 40;

    public PreferencesPanelEarlySpring() {
        AResourceBundle aResourceBundle = Ajqvue.getResourceBundle();
        String string = Utils.getFileSeparator();
        this.backgroundImage = aResourceBundle.getResourceImage("images" + string + "PreferencesPanelEarlySpring.jpg").getImage();
        this.backgroundImageWidth = this.backgroundImage.getWidth(null);
        this.backgroundImageHeight = this.backgroundImage.getHeight(null);
        this.rainDropImage = aResourceBundle.getResourceImage("images" + string + "raindrop.gif").getImage();
        this.rainDropImageWidth = this.rainDropImage.getWidth(null);
        this.rainDropImageHeight = this.rainDropImage.getHeight(null);
        this.rainDrops = new ArrayList();
        this.runThread = true;
        this.suspendThread = false;
    }

    @Override
    public void run() {
        int n = 75;
        Random random = new Random(System.currentTimeMillis());
        Rectangle rectangle = new Rectangle(0, 0, this.backgroundImageWidth, this.backgroundImageHeight);
        for (int i = 0; i < n; ++i) {
            Point point = this.getEmptyPosition();
            this.rainDrops.add(new RainDrop(this, rectangle, this.rainDropImage, point, new Point(random.nextInt() % 4, random.nextInt() % 4)));
        }
        while (this.runThread) {
            this.updateRainDrops();
            this.render();
            this.timeStep();
        }
    }

    private Point getEmptyPosition() {
        Rectangle rectangle = new Rectangle(0, 0, this.rainDropImageWidth, this.rainDropImageHeight);
        Random random = new Random(System.currentTimeMillis());
        boolean bl = false;
        int n = 0;
        while (!bl && n++ < 100) {
            rectangle.x = Math.abs(random.nextInt() % this.backgroundImageWidth);
            rectangle.y = Math.abs(random.nextInt() % this.backgroundImageHeight);
            boolean bl2 = false;
            for (int i = 0; i < this.rainDrops.size(); ++i) {
                Rectangle rectangle2 = this.rainDrops.get(i).getSpaceOccupied();
                if (!rectangle.intersects(rectangle2)) continue;
                bl2 = true;
            }
            bl = !bl2;
        }
        return new Point(rectangle.x, rectangle.y);
    }

    private void updateRainDrops() {
        for (int i = 0; i < this.rainDrops.size(); ++i) {
            RainDrop rainDrop = this.rainDrops.get(i);
            rainDrop.updatePosition();
            int n = this.testForCollision(rainDrop);
            if (n < 0) continue;
            Point point = rainDrop.getNextPosition();
            rainDrop.setNextPosition(this.rainDrops.get(n).getNextPosition());
            this.rainDrops.get(n).setNextPosition(point);
        }
    }

    private int testForCollision(RainDrop rainDrop) {
        for (int i = 0; i < this.rainDrops.size(); ++i) {
            RainDrop rainDrop2 = this.rainDrops.get(i);
            if (rainDrop2 == rainDrop || !rainDrop.testCollision(rainDrop2)) continue;
            return i;
        }
        return -1;
    }

    private void render() {
        Dimension dimension;
        if (this.getGraphics() != null && this.checkImage(dimension = this.getSize())) {
            this.drawPanel(this.offScreenGraphicsImage.getGraphics());
            this.getGraphics().drawImage(this.offScreenGraphicsImage, 0, 0, null);
        }
    }

    private boolean checkImage(Dimension dimension) {
        if (dimension.width <= 0 || dimension.height <= 0) {
            return false;
        }
        if (this.offScreenGraphicsImage == null || this.offScreenGraphicsImage.getWidth(null) != dimension.width || this.offScreenGraphicsImage.getHeight(null) != dimension.height) {
            this.offScreenGraphicsImage = this.createImage(dimension.width, dimension.height);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeStep() {
        try {
            Thread.sleep(40L);
            PreferencesPanelEarlySpring preferencesPanelEarlySpring = this;
            synchronized (preferencesPanelEarlySpring) {
                while (this.suspendThread) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Process Interrupted.");
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.drawPanel(graphics);
    }

    private void drawPanel(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth();
        int n2 = this.getHeight();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, n, n2);
        if (n != this.backgroundImageWidth || n2 != this.backgroundImageHeight) {
            AffineTransform affineTransform2 = AffineTransform.getScaleInstance((double)n / (double)this.backgroundImageWidth, (double)n2 / (double)this.backgroundImageHeight);
            graphics2D.setTransform(affineTransform2);
        }
        graphics2D.drawImage(this.backgroundImage, 0, 0, this);
        graphics2D.setFont(this.fontSerifPlain_12);
        graphics2D.drawString(this.dateString, 10, 20);
        for (int i = 0; i < this.rainDrops.size(); ++i) {
            graphics2D.drawImage(this.rainDrops.get(i).getImage(), this.rainDrops.get((int)i).getSpaceOccupied().x, this.rainDrops.get((int)i).getSpaceOccupied().y, this);
        }
        graphics2D.setTransform(affineTransform);
        graphics2D.dispose();
    }

    @Override
    public synchronized void setThreadAction(boolean bl) {
        this.suspendThread = bl;
        if (!this.suspendThread) {
            this.notifyAll();
        }
    }

    @Override
    public void suspendPanel(boolean bl) {
        this.runThread = !bl;
    }
}

