/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.plugin.Plugin;
import com.dandymadeproductions.ajqvue.plugin.PluginRepository;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.TableModel;
import com.dandymadeproductions.ajqvue.utilities.TableSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class PluginRepositoryPanel
extends JPanel {
    private static final long serialVersionUID = -6184477994877347629L;
    private transient PluginRepository pluginRepository;
    private JTable pluginListTable;
    private TableModel tableModel;
    private Object[][] pluginsTableData;
    private JScrollPane tableScrollPane;
    private ImageIcon tabIcon;
    private static final int TABICON_COLUMN = 0;
    private static final int NAME_COLUMN = 1;
    private static final int VERSION_COLUMN = 2;
    private static final int CATEGORY_COLUMN = 3;
    private static final int SIZE_COLUMN = 4;

    public PluginRepositoryPanel(PluginRepository pluginRepository, ListSelectionListener listSelectionListener) {
        this.pluginRepository = pluginRepository;
        ArrayList<String> arrayList = new ArrayList<String>();
        AResourceBundle aResourceBundle = Ajqvue.getResourceBundle();
        this.setLayout(new BorderLayout());
        String string = aResourceBundle.getResourceString("PluginRepositoryPanel.label.TabIcon", "Tab Icon");
        arrayList.add(string);
        this.tabIcon = aResourceBundle.getResourceImage("images/icons/newsiteLeafIcon.png");
        String string2 = aResourceBundle.getResourceString("PluginRepositoryPanel.label.Name", "Name");
        arrayList.add(string2);
        string2 = aResourceBundle.getResourceString("PluginRepositoryPanel.label.Version", "Version");
        arrayList.add(string2);
        string2 = aResourceBundle.getResourceString("PluginRepositoryPanel.label.Category", "Category");
        arrayList.add(string2);
        string2 = aResourceBundle.getResourceString("PluginRepositoryPanel.label.Size", "Size");
        arrayList.add(string2);
        this.loadPluginTableData();
        this.tableModel = new TableModel(arrayList, this.pluginsTableData);
        TableSorter tableSorter = new TableSorter(this.tableModel);
        this.pluginListTable = new JTable(tableSorter);
        this.pluginListTable.getTableHeader().setFont(new Font(this.getFont().getName(), 1, this.getFont().getSize()));
        tableSorter.setTableHeader(this.pluginListTable.getTableHeader());
        TableColumn tableColumn = this.pluginListTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(string.length() - 10);
        this.pluginListTable.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.tableScrollPane = new JScrollPane(this.pluginListTable);
        this.add((Component)this.tableScrollPane, "Center");
    }

    private void loadPluginTableData() {
        ArrayList<Plugin> arrayList = this.pluginRepository.getPluginItems();
        this.pluginsTableData = new Object[arrayList.size()][5];
        Iterator<Plugin> iterator = this.pluginRepository.getPluginItems().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Plugin plugin = iterator.next();
            this.pluginsTableData[n][0] = this.tabIcon;
            this.pluginsTableData[n][1] = plugin.getControlledName();
            this.pluginsTableData[n][2] = plugin.getControlledVersion();
            this.pluginsTableData[n][3] = plugin.getControlledCategory();
            this.pluginsTableData[n][4] = PluginRepositoryPanel.formatSize(plugin.getSize());
            ++n;
        }
    }

    private static String formatSize(int n) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(3);
        numberFormat.setMinimumFractionDigits(1);
        String string = n < 0x100000 ? numberFormat.format((double)n / 1000.0) + "KB" : numberFormat.format((double)n / 1048576.0) + "MB";
        return string;
    }

    public String getRepositoryName() {
        return this.pluginRepository.getName();
    }

    public String getRepositoryPath() {
        return this.pluginRepository.getPath();
    }

    public String getRepositoryType() {
        return this.pluginRepository.getRepositoryType();
    }

    public String[] getRepositoryOptions() {
        return this.pluginRepository.getRepositoryOptions();
    }

    public Object[] getSelectedPluginInfo() {
        int n = this.pluginListTable.getSelectedRow();
        if (n != -1 && this.pluginListTable.getValueAt(n, 0) != null) {
            Object[] objectArray = new Object[5];
            Plugin plugin = this.pluginRepository.getPluginItems().get(n);
            objectArray[0] = plugin.getName();
            objectArray[1] = plugin.getAuthor();
            objectArray[2] = plugin.getVersion();
            objectArray[3] = plugin.getPath_FileName();
            objectArray[4] = plugin.getDescription();
            return objectArray;
        }
        return null;
    }

    public String getSelectedPluginPath() {
        String string = "";
        int n = this.pluginListTable.getSelectedRow();
        if (n != -1 && this.pluginListTable.getValueAt(n, 0) != null) {
            string = this.pluginRepository.getPluginItems().get(n).getPath_FileName();
        }
        return string;
    }

    public void refreshRepository() {
        this.pluginRepository.clearPluginItems();
        this.pluginRepository.refresh();
        this.loadPluginTableData();
        this.tableModel.setValues(this.pluginsTableData);
        this.tableScrollPane.getVerticalScrollBar().setValue(0);
    }
}

