/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class PluginFrameFillerPanel
extends JPanel
implements Runnable {
    private static final long serialVersionUID = 4904842189669960218L;
    private transient Image baseImage;
    private transient BufferedImage waveImage;
    private transient Image offScreenGraphicsImage;
    private int waveImageIndex = 0;
    private Color waveBackgroundColor = Color.decode("0x474a05");
    private transient BasicStroke widePen = new BasicStroke(3.0f, 0, 1);
    private transient BasicStroke narrowPen = new BasicStroke(2.0f, 0, 1);
    private boolean runThread;
    private boolean suspendThread;
    private int baseImageWidth;
    private int baseImageHeight;
    private static final int WAVE_FRAME_NUMBER = 12;
    private static final int FRAME_DELAY = 85;

    public PluginFrameFillerPanel() {
        AResourceBundle aResourceBundle = Ajqvue.getResourceBundle();
        String string = Utils.getFileSeparator();
        this.baseImage = aResourceBundle.getResourceImage("images" + string + "pluginframe.jpg").getImage();
        this.baseImageWidth = this.baseImage.getWidth(null);
        this.baseImageHeight = this.baseImage.getHeight(null);
        if (this.baseImageWidth <= 0 || this.baseImageHeight <= 0) {
            this.runThread = false;
            this.suspendThread = true;
            System.out.println("Failed to Load Background Image.");
        } else {
            this.createBaseImages();
            this.runThread = true;
            this.suspendThread = false;
        }
        this.setPreferredSize(new Dimension(this.baseImageWidth, 2 * this.baseImageHeight - 30));
    }

    private void createBaseImages() {
        BufferedImage bufferedImage = new BufferedImage(this.baseImageWidth, this.baseImageHeight + 1, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(this.baseImage, 0, 1, this);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0, -1.0);
        affineTransform.translate(0.0, -this.baseImageHeight);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
        bufferedImage = affineTransformOp.filter(bufferedImage, null);
        this.waveImage = new BufferedImage(13 * this.baseImageWidth, this.baseImageHeight, 1);
        Graphics graphics2 = this.waveImage.getGraphics();
        graphics2.drawImage(bufferedImage, 12 * this.baseImageWidth, 0, this);
        for (int i = 0; i < 12; ++i) {
            this.makeWaves(graphics2, i);
        }
    }

    private void makeWaves(Graphics graphics, int n) {
        double d = Math.PI * 2 * (double)n / 12.0;
        int n2 = (12 - n) * this.baseImageWidth;
        for (int i = 0; i < this.baseImageHeight; ++i) {
            int n3 = (int)((double)this.baseImageHeight / 14.0 * ((double)i + 28.0) * Math.sin((double)(this.baseImageHeight / 14 * (this.baseImageHeight - i)) / (double)(i + 1) + d) / (double)this.baseImageHeight);
            if (i < -n3) {
                graphics.copyArea(12 * this.baseImageWidth, i, this.baseImageWidth, 1, -n2, 0);
                continue;
            }
            graphics.copyArea(12 * this.baseImageWidth, i + n3, this.baseImageWidth, 1, -n2, -n3);
        }
    }

    @Override
    public void run() {
        while (this.runThread) {
            this.updateAnimation();
            this.render();
            this.timeStep();
        }
    }

    private void updateAnimation() {
        if (++this.waveImageIndex == 12) {
            this.waveImageIndex = 0;
        }
    }

    private void render() {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D != null) {
            Dimension dimension = this.getSize();
            if (this.checkImage(dimension)) {
                Graphics2D graphics2D2 = (Graphics2D)this.offScreenGraphicsImage.getGraphics();
                this.drawAnimation(graphics2D2);
                graphics2D.drawImage(this.offScreenGraphicsImage, 0, 0, null);
                graphics2D2.dispose();
            }
            graphics2D.dispose();
        }
    }

    private boolean checkImage(Dimension dimension) {
        if (dimension.width <= 0 || dimension.height <= 0) {
            return false;
        }
        if (this.offScreenGraphicsImage == null || this.offScreenGraphicsImage.getWidth(null) != dimension.width || this.offScreenGraphicsImage.getHeight(null) != dimension.height) {
            this.offScreenGraphicsImage = this.createImage(dimension.width, dimension.height);
        }
        return true;
    }

    private void drawAnimation(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth();
        int n2 = this.getHeight();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setPaint(this.waveBackgroundColor);
        graphics2D.fillRect(0, 0, n, n2);
        if (n != this.baseImageWidth || n2 != 2 * this.baseImageHeight) {
            AffineTransform affineTransform2 = AffineTransform.getScaleInstance((double)n / (double)this.baseImageWidth, (double)n2 / (2.0 * (double)this.baseImageHeight));
            graphics2D.setTransform(affineTransform2);
        }
        if (this.waveImage != null) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.4f));
            graphics2D.drawImage((Image)this.waveImage, -this.waveImageIndex * this.baseImageWidth, this.baseImageHeight, this);
            graphics2D.drawImage((Image)this.waveImage, (12 - this.waveImageIndex) * this.baseImageWidth, this.baseImageHeight, this);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        graphics2D.drawImage(this.baseImage, 0, 0, this);
        graphics2D.setTransform(affineTransform);
        graphics2D.setStroke(this.widePen);
        graphics2D.setPaint(this.getForeground());
        graphics2D.draw(new Line2D.Double(0.0, 0.0, n, 0.0));
        graphics2D.draw(new Line2D.Double(0.0, 0.0, 0.0, n2));
        graphics2D.setStroke(this.narrowPen);
        graphics2D.setPaint(Color.white);
        graphics2D.draw(new Line2D.Double(n, 3.0, n, n2));
        graphics2D.draw(new Line2D.Double(3.0, n2, n, n2));
        graphics2D.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeStep() {
        try {
            Thread.sleep(85L);
            PluginFrameFillerPanel pluginFrameFillerPanel = this;
            synchronized (pluginFrameFillerPanel) {
                while (this.suspendThread) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Process Interrupted.");
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.drawAnimation(graphics);
    }

    public synchronized void setThreadAction(boolean bl) {
        this.suspendThread = bl;
        if (!this.suspendThread) {
            this.notifyAll();
        }
    }

    public void suspendPanel(boolean bl) {
        this.runThread = !bl;
    }
}

