/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.gui.panels.CSVImportPreferencesFiller;
import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.structures.DataImportProperties;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class CSVImportPreferencesPanel
extends JPanel
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = -6741991351990181356L;
    public CSVImportPreferencesFiller csvImportPanelFiller;
    private JRadioButton tabRadioButton;
    private JRadioButton semicolonRadioButton;
    private JRadioButton commaRadioButton;
    private JRadioButton spaceRadioButton;
    private JRadioButton otherRadioButton;
    private JTextField otherTextField;
    private JComboBox<Object> dateFormatComboBox;
    private JButton restoreDefaultsButton;
    private JButton applyButton;
    public static final String DEFAULT_DATA_DELIMITER = ",";
    public static final String DEFAULT_DATE_FORMAT = "MM-dd-yyyy";

    public CSVImportPreferencesPanel(AResourceBundle aResourceBundle) {
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), BorderFactory.createLoweredBevelBorder()));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 0, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), BorderFactory.createLoweredBevelBorder()));
        this.csvImportPanelFiller = new CSVImportPreferencesFiller();
        this.csvImportPanelFiller.setThreadAction(true);
        jPanel3.add((Component)this.csvImportPanelFiller, "Center");
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(gridBagLayout);
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder()));
        this.createDelimiterPanel(jPanel4, gridBagLayout, gridBagConstraints, aResourceBundle);
        jPanel2.add(jPanel4);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel5 = new JPanel(gridBagLayout);
        jPanel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder()));
        String string = aResourceBundle.getResourceString("CSVImportPreferencesPanel.label.DateFormat", "Date Format");
        JLabel jLabel = new JLabel(string);
        jLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 24.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel5.add(jLabel);
        this.dateFormatComboBox = new JComboBox<Object>(Utils.getDateFormatOption());
        this.dateFormatComboBox.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 76.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.dateFormatComboBox, gridBagConstraints);
        jPanel5.add(this.dateFormatComboBox);
        jPanel.add((Component)jPanel5, "South");
        this.add((Component)jPanel, "Center");
        JPanel jPanel6 = new JPanel();
        string = aResourceBundle.getResourceString("CSVImportPreferencesPanel.button.RestoreDefaults", "Restore Defaults");
        this.restoreDefaultsButton = new JButton(string);
        this.restoreDefaultsButton.addActionListener(this);
        jPanel6.add(this.restoreDefaultsButton);
        string = aResourceBundle.getResourceString("CSVImportPreferencesPanel.button.Apply", "Apply");
        this.applyButton = new JButton(string);
        this.applyButton.addActionListener(this);
        jPanel6.add(this.applyButton);
        this.add((Component)jPanel6, "South");
        this.setCSVImportProperties(DBTablesPanel.getDataImportProperties());
        this.applyButton.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            if (object == this.restoreDefaultsButton) {
                this.commaRadioButton.setSelected(true);
                this.otherTextField.setEnabled(false);
                this.dateFormatComboBox.setSelectedItem(DBTablesPanel.getGeneralDBProperties().getViewDateFormat());
                this.applyButton.setEnabled(true);
            } else if (object == this.applyButton) {
                DBTablesPanel.setDataImportProperties(this.getCSVImportOptions());
                this.applyButton.setEnabled(false);
            }
        }
        if (object instanceof JRadioButton || object instanceof JComboBox) {
            this.applyButton.setEnabled(true);
            if (object instanceof JRadioButton) {
                if (this.otherRadioButton.isSelected()) {
                    this.otherTextField.setEnabled(true);
                } else {
                    this.otherTextField.setEnabled(false);
                }
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.otherTextField) {
            this.applyButton.setEnabled(true);
        }
    }

    private void createDelimiterPanel(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, AResourceBundle aResourceBundle) {
        String string = aResourceBundle.getResourceString("CSVImportPreferencesPanel.label.Delimiter", "Delimiter");
        JLabel jLabel = new JLabel(string);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 30.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), BorderFactory.createLoweredBevelBorder()));
        ButtonGroup buttonGroup = new ButtonGroup();
        string = aResourceBundle.getResourceString("CSVImportPreferencesPanel.radiobutton.Tab", "Tab");
        this.tabRadioButton = new JRadioButton(string, false);
        this.tabRadioButton.setFocusPainted(false);
        this.tabRadioButton.addActionListener(this);
        buttonGroup.add(this.tabRadioButton);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.tabRadioButton, gridBagConstraints);
        jPanel2.add(this.tabRadioButton);
        string = aResourceBundle.getResourceString("CSVImportPreferencesPanel.radiobutton.Semicolon", "Semicolon");
        this.semicolonRadioButton = new JRadioButton(string, false);
        this.semicolonRadioButton.setFocusPainted(false);
        this.semicolonRadioButton.addActionListener(this);
        buttonGroup.add(this.semicolonRadioButton);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.semicolonRadioButton, gridBagConstraints);
        jPanel2.add(this.semicolonRadioButton);
        string = aResourceBundle.getResourceString("CSVImportPreferencesPanel.radiobutton.Comma", "Comma");
        this.commaRadioButton = new JRadioButton(string, true);
        this.commaRadioButton.setFocusPainted(false);
        this.commaRadioButton.addActionListener(this);
        buttonGroup.add(this.commaRadioButton);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.commaRadioButton, gridBagConstraints);
        jPanel2.add(this.commaRadioButton);
        string = aResourceBundle.getResourceString("CSVImportPreferencesPanel.radiobutton.Space", "Space");
        this.spaceRadioButton = new JRadioButton(string, false);
        this.spaceRadioButton.setFocusPainted(false);
        this.spaceRadioButton.addActionListener(this);
        buttonGroup.add(this.spaceRadioButton);
        this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.spaceRadioButton, gridBagConstraints);
        jPanel2.add(this.spaceRadioButton);
        string = aResourceBundle.getResourceString("CSVImportPreferencesPanel.radiobutton.Other", "Other");
        this.otherRadioButton = new JRadioButton(string, false);
        this.otherRadioButton.setFocusPainted(false);
        this.otherRadioButton.addActionListener(this);
        buttonGroup.add(this.otherRadioButton);
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.otherRadioButton, gridBagConstraints);
        jPanel2.add(this.otherRadioButton);
        this.otherTextField = new JTextField(10);
        this.otherTextField.addKeyListener(this);
        this.otherTextField.setEnabled(false);
        this.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.otherTextField, gridBagConstraints);
        jPanel2.add(this.otherTextField);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 70.0, 100.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
    }

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    public DataImportProperties getCSVImportOptions() {
        DataImportProperties dataImportProperties = DBTablesPanel.getDataImportProperties();
        if (this.tabRadioButton.isSelected()) {
            dataImportProperties.setDataDelimiter("\t");
        } else if (this.semicolonRadioButton.isSelected()) {
            dataImportProperties.setDataDelimiter(";");
        } else if (this.commaRadioButton.isSelected()) {
            dataImportProperties.setDataDelimiter(DEFAULT_DATA_DELIMITER);
        } else if (this.spaceRadioButton.isSelected()) {
            dataImportProperties.setDataDelimiter(" ");
        } else {
            dataImportProperties.setDataDelimiter(this.otherTextField.getText());
        }
        dataImportProperties.setDateFormat((String)this.dateFormatComboBox.getSelectedItem());
        return dataImportProperties;
    }

    public void setCSVImportProperties(DataImportProperties dataImportProperties) {
        if (dataImportProperties.getDataDelimiter().equals("\t")) {
            this.tabRadioButton.setSelected(true);
        } else if (dataImportProperties.getDataDelimiter().equals(";")) {
            this.semicolonRadioButton.setSelected(true);
        } else if (dataImportProperties.getDataDelimiter().equals(DEFAULT_DATA_DELIMITER)) {
            this.commaRadioButton.setSelected(true);
        } else if (dataImportProperties.getDataDelimiter().equals(" ")) {
            this.spaceRadioButton.setSelected(true);
        } else {
            this.otherRadioButton.setSelected(true);
            this.otherTextField.setText(dataImportProperties.getDataDelimiter());
            this.otherTextField.setEnabled(true);
        }
        this.dateFormatComboBox.setSelectedItem(dataImportProperties.getDateFormat());
    }
}

