/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.util.Random;

public class CSVImportPreferencesFiller
extends Canvas
implements Runnable,
KeyListener {
    private static final long serialVersionUID = 5857069898307163066L;
    private transient Image backgroundImage;
    private transient Image mountainsImage;
    private transient Image shipImage;
    private int backgroundImageWidth;
    private int backgroundImageHeight;
    private int mountainsImageWidth;
    private int shipImageWidth;
    private int shipImageHeight;
    private transient Image offScreenGraphicsImage;
    private Color star1_Color;
    private Color star2_Color;
    private Point shipPositionHome;
    private Point shipPosition;
    private Point mountainsPosition;
    private boolean runThread;
    private boolean suspendThread;
    private static final int frameDelay = 30;

    public CSVImportPreferencesFiller() {
        AResourceBundle aResourceBundle = Ajqvue.getResourceBundle();
        String string = Utils.getFileSeparator();
        this.backgroundImage = aResourceBundle.getResourceImage("images" + string + "csvImport_sky.jpg").getImage();
        this.backgroundImageWidth = this.backgroundImage.getWidth(null);
        this.backgroundImageHeight = this.backgroundImage.getHeight(null);
        this.setSize(this.backgroundImageWidth, this.backgroundImageHeight);
        this.mountainsImage = aResourceBundle.getResourceImage("images" + string + "csvImport_wosky.png").getImage();
        this.mountainsImageWidth = this.mountainsImage.getWidth(null);
        this.mountainsPosition = new Point(0, 0);
        this.shipImage = aResourceBundle.getResourceImage("images" + string + "csvImport_ship.png").getImage();
        this.shipImageWidth = this.shipImage.getWidth(null);
        this.shipImageHeight = this.shipImage.getHeight(null);
        this.shipPositionHome = new Point();
        this.shipPosition = new Point();
        if (this.getWidth() >= 0 && this.getHeight() >= 0) {
            this.shipPositionHome.x = this.backgroundImageWidth / 3;
            this.shipPositionHome.y = this.backgroundImageHeight / 3;
            this.shipPosition = this.shipPositionHome;
        } else {
            this.shipPositionHome.x = 100;
            this.shipPositionHome.y = 40;
            this.shipPosition = this.shipPositionHome;
        }
        this.addKeyListener(this);
        this.runThread = true;
        this.suspendThread = false;
    }

    @Override
    public void run() {
        while (this.runThread) {
            this.updateAnimatedObjects();
            this.render();
            this.timeStep();
        }
    }

    private void updateAnimatedObjects() {
        Random random = new Random(System.currentTimeMillis());
        if (Math.abs(random.nextInt() % 20) == 3) {
            this.star1_Color = new Color(Math.abs(random.nextInt() % 255), Math.abs(random.nextInt() % 255), Math.abs(random.nextInt() % 255));
        }
        if (Math.abs(random.nextInt() % 30) == 21) {
            this.star2_Color = new Color(Math.abs(random.nextInt() % 255), Math.abs(random.nextInt() % 255), Math.abs(random.nextInt() % 255));
        }
        if (Math.abs(random.nextInt() % 40) == 8) {
            int n = random.nextInt() % 2;
            this.shipPosition.x = this.shipPosition.x < this.shipPositionHome.x - 10 ? (this.shipPosition.x += Math.abs(n)) : (this.shipPosition.x > this.shipPositionHome.x + 10 ? (this.shipPosition.x -= Math.abs(n)) : (this.shipPosition.x += n));
        }
        if (Math.abs(random.nextInt() % 25) == 17) {
            int n = random.nextInt() % 3;
            this.shipPosition.y = this.shipPosition.y < this.shipPositionHome.y - 12 ? (this.shipPosition.y += Math.abs(n)) : (this.shipPosition.y > this.shipPositionHome.y + 15 ? (this.shipPosition.y -= Math.abs(n)) : (this.shipPosition.y += n));
        }
        this.mountainsPosition.x = this.mountainsPosition.x <= -this.mountainsImageWidth ? (this.mountainsPosition.x += this.mountainsImageWidth) : (this.mountainsPosition.x -= 3);
    }

    private void render() {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D != null) {
            Dimension dimension = this.getSize();
            if (this.checkImage(dimension)) {
                Graphics2D graphics2D2 = (Graphics2D)this.offScreenGraphicsImage.getGraphics();
                this.paint(graphics2D2);
                graphics2D.drawImage(this.offScreenGraphicsImage, 0, 0, null);
                graphics2D2.dispose();
            }
            graphics2D.dispose();
        }
    }

    private boolean checkImage(Dimension dimension) {
        if (dimension.width <= 0 || dimension.height <= 0) {
            return false;
        }
        if (this.offScreenGraphicsImage == null || this.offScreenGraphicsImage.getWidth(null) != dimension.width || this.offScreenGraphicsImage.getHeight(null) != dimension.height) {
            this.offScreenGraphicsImage = this.createImage(dimension.width, dimension.height);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeStep() {
        try {
            Thread.sleep(30L);
            CSVImportPreferencesFiller cSVImportPreferencesFiller = this;
            synchronized (cSVImportPreferencesFiller) {
                while (this.suspendThread) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Process Interrupted.");
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth();
        int n2 = this.getHeight();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, n, n2);
        if (n != this.backgroundImageWidth || n2 != this.backgroundImageHeight) {
            AffineTransform affineTransform2 = AffineTransform.getScaleInstance((double)n / (double)this.backgroundImageWidth, (double)n2 / (double)this.backgroundImageHeight);
            graphics2D.setTransform(affineTransform2);
        }
        graphics2D.drawImage(this.backgroundImage, 0, 0, this);
        float f = 0.7f;
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.setColor(this.star1_Color);
        graphics2D.setStroke(new BasicStroke(1.0f));
        Point point = new Point(25, 26);
        graphics2D.drawLine(point.x, point.y - 3, point.x, point.y + 3);
        graphics2D.drawLine(point.x - 3, point.y, point.x + 3, point.y);
        graphics2D.setStroke(new BasicStroke(0.5f));
        graphics2D.drawLine(point.x, point.y - 6, point.x, point.y + 6);
        graphics2D.drawLine(point.x - 6, point.y, point.x + 6, point.y);
        graphics2D.setColor(this.star2_Color);
        graphics2D.setStroke(new BasicStroke(1.0f));
        Point point2 = new Point(100, 15);
        graphics2D.drawLine(point2.x, point2.y - 3, point2.x, point2.y + 3);
        graphics2D.drawLine(point2.x - 3, point2.y, point2.x + 3, point2.y);
        graphics2D.setStroke(new BasicStroke(0.5f));
        graphics2D.drawLine(point2.x, point2.y - 6, point2.x, point2.y + 6);
        graphics2D.drawLine(point2.x - 6, point2.y, point2.x + 6, point2.y);
        f = 1.0f;
        alphaComposite = AlphaComposite.getInstance(3, f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.drawImage(this.mountainsImage, this.mountainsPosition.x, this.mountainsPosition.y, this);
        if (this.mountainsPosition.x + this.mountainsImageWidth < this.getWidth()) {
            graphics2D.drawImage(this.mountainsImage, this.mountainsPosition.x + this.mountainsImageWidth, this.mountainsPosition.y, this);
        }
        graphics2D.drawImage(this.shipImage, this.shipPosition.x, this.shipPosition.y, this);
        graphics2D.setTransform(affineTransform);
        graphics2D.dispose();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 37 && this.shipPosition.x != 0) {
            --this.shipPosition.x;
        }
        if (n == 39 && this.shipPosition.x < this.backgroundImageWidth - this.shipImageWidth) {
            ++this.shipPosition.x;
        }
        if (n == 38 && this.shipPosition.y != 0) {
            --this.shipPosition.y;
        }
        if (n == 40 && this.shipPosition.y < this.backgroundImageWidth - this.shipImageHeight) {
            ++this.shipPosition.y;
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public synchronized void setThreadAction(boolean bl) {
        this.suspendThread = bl;
        if (!this.suspendThread) {
            this.notifyAll();
        }
    }

    public void suspendPanel(boolean bl) {
        this.runThread = !bl;
    }
}

