/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.structures.DataExportProperties;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CSVExportPreferencesPanel
extends JPanel
implements ActionListener,
KeyListener,
ChangeListener {
    private static final long serialVersionUID = -2715315124472653218L;
    private JCheckBox includeTextCheckBox;
    private JSpinner textMaxCharsSpinner;
    private JRadioButton tabRadioButton;
    private JRadioButton semicolonRadioButton;
    private JRadioButton commaRadioButton;
    private JRadioButton spaceRadioButton;
    private JRadioButton otherRadioButton;
    private JTextField otherTextField;
    private JComboBox<Object> dateFormatComboBox;
    private JCheckBox summaryTableLimitCheckBox;
    private JButton restoreDefaultsButton;
    private JButton applyButton;
    public static final boolean DEFAULT_CHAR_INCLUSION = false;
    public static final int DEFAULT_CHARS_LENGTH = 50;
    public static final String DEFAULT_DATA_DELIMITER = ",";
    public static final boolean DEFAULT_SUMMARY_TABLE_USE_LIMIT = true;

    public CSVExportPreferencesPanel(AResourceBundle aResourceBundle) {
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0), BorderFactory.createLoweredBevelBorder()));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 2, 2));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder()));
        this.createTextOptionsPanel(jPanel2, gridBagLayout, gridBagConstraints, aResourceBundle);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(gridBagLayout);
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder()));
        this.createDelimiterPanel(jPanel3, gridBagLayout, gridBagConstraints, aResourceBundle);
        jPanel.add((Component)jPanel3, "Center");
        this.add((Component)jPanel, "Center");
        JPanel jPanel4 = new JPanel(new GridLayout(2, 1, 0, 0));
        JPanel jPanel5 = new JPanel(gridBagLayout);
        jPanel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder()));
        String string = aResourceBundle.getResourceString("CSVExportPreferencesPanel.label.DateFormat", "Date Format");
        JLabel jLabel = new JLabel(string);
        jLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 24.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel5.add(jLabel);
        this.dateFormatComboBox = new JComboBox<Object>(Utils.getDateFormatOption());
        this.dateFormatComboBox.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 76.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.dateFormatComboBox, gridBagConstraints);
        jPanel5.add(this.dateFormatComboBox);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100.0, 65.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel4.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder()));
        string = aResourceBundle.getResourceString("CSVExportPreferencesPanel.checkbox.SummaryTableUseLimit", "Summary Table Use LIMIT");
        this.summaryTableLimitCheckBox = new JCheckBox(string, true);
        this.summaryTableLimitCheckBox.setBorder(BorderFactory.createEmptyBorder());
        this.summaryTableLimitCheckBox.setFocusPainted(false);
        this.summaryTableLimitCheckBox.addActionListener(this);
        jPanel6.add(this.summaryTableLimitCheckBox);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100.0, 35.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel6, gridBagConstraints);
        jPanel4.add(jPanel6);
        jPanel.add((Component)jPanel4, "South");
        this.add((Component)jPanel, "Center");
        JPanel jPanel7 = new JPanel();
        string = aResourceBundle.getResourceString("CSVExportPreferencesPanel.button.RestoreDefaults", "Restore Defaults");
        this.restoreDefaultsButton = new JButton(string);
        this.restoreDefaultsButton.addActionListener(this);
        jPanel7.add(this.restoreDefaultsButton);
        string = aResourceBundle.getResourceString("CSVExportPreferencesPanel.button.Apply", "Apply");
        this.applyButton = new JButton(string);
        this.applyButton.addActionListener(this);
        jPanel7.add(this.applyButton);
        this.add((Component)jPanel7, "South");
        this.setCSVExportProperties(DBTablesPanel.getDataExportProperties());
        this.applyButton.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            if (object == this.restoreDefaultsButton) {
                this.includeTextCheckBox.setSelected(false);
                this.textMaxCharsSpinner.setValue(50);
                this.textMaxCharsSpinner.setEnabled(false);
                this.commaRadioButton.setSelected(true);
                this.otherTextField.setEnabled(false);
                this.dateFormatComboBox.setSelectedItem(DBTablesPanel.getGeneralDBProperties().getViewDateFormat());
                this.applyButton.setEnabled(true);
                this.summaryTableLimitCheckBox.setSelected(true);
            } else if (object == this.applyButton) {
                DBTablesPanel.setDataExportProperties(this.getCSVExportOptions());
                this.applyButton.setEnabled(false);
            }
        }
        if (object instanceof JCheckBox) {
            if (object == this.includeTextCheckBox) {
                if (this.includeTextCheckBox.isSelected()) {
                    this.textMaxCharsSpinner.setEnabled(true);
                } else {
                    this.textMaxCharsSpinner.setEnabled(false);
                }
            }
            this.applyButton.setEnabled(true);
        }
        if (object instanceof JRadioButton || object instanceof JComboBox) {
            this.applyButton.setEnabled(true);
            if (object instanceof JRadioButton) {
                if (this.otherRadioButton.isSelected()) {
                    this.otherTextField.setEnabled(true);
                } else {
                    this.otherTextField.setEnabled(false);
                }
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.otherTextField) {
            this.applyButton.setEnabled(true);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof JSpinner && this.applyButton != null) {
            this.applyButton.setEnabled(true);
        }
    }

    private void createTextOptionsPanel(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, AResourceBundle aResourceBundle) {
        String string = aResourceBundle.getResourceString("CSVExportPreferencesPanel.checkbox.Include", "Include");
        this.includeTextCheckBox = new JCheckBox(string + " CLOB, TEXT, MEDIUMTEXT & LONGTEXT", false);
        this.includeTextCheckBox.setFocusPainted(false);
        this.includeTextCheckBox.addActionListener(this);
        jPanel.add(this.includeTextCheckBox);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        string = aResourceBundle.getResourceString("CSVExportPreferencesPanel.label.TextCharacterNumber", "Text Character Number");
        JLabel jLabel = new JLabel(string);
        jLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(50, 0, 0xFFFFFF, 50);
        this.textMaxCharsSpinner = new JSpinner(spinnerNumberModel);
        this.textMaxCharsSpinner.setEnabled(false);
        this.textMaxCharsSpinner.addChangeListener(this);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.textMaxCharsSpinner, gridBagConstraints);
        jPanel2.add(this.textMaxCharsSpinner);
        jPanel.add(jPanel2);
    }

    private void createDelimiterPanel(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, AResourceBundle aResourceBundle) {
        String string = aResourceBundle.getResourceString("CSVExportPreferencesPanel.label.Delimiter", "Delimiter");
        JLabel jLabel = new JLabel(string);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 30.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), BorderFactory.createLoweredBevelBorder()));
        ButtonGroup buttonGroup = new ButtonGroup();
        string = aResourceBundle.getResourceString("CSVExportPreferencesPanel.radiobutton.Tab", "Tab");
        this.tabRadioButton = new JRadioButton(string, false);
        this.tabRadioButton.setFocusPainted(false);
        this.tabRadioButton.addActionListener(this);
        buttonGroup.add(this.tabRadioButton);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.tabRadioButton, gridBagConstraints);
        jPanel2.add(this.tabRadioButton);
        string = aResourceBundle.getResourceString("CSVExportPreferencesPanel.radiobutton.Semicolon", "Semicolon");
        this.semicolonRadioButton = new JRadioButton(string, false);
        this.semicolonRadioButton.setFocusPainted(false);
        this.semicolonRadioButton.addActionListener(this);
        buttonGroup.add(this.semicolonRadioButton);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.semicolonRadioButton, gridBagConstraints);
        jPanel2.add(this.semicolonRadioButton);
        string = aResourceBundle.getResourceString("CSVExportPreferencesPanel.radiobutton.Comma", "Comma");
        this.commaRadioButton = new JRadioButton(string, true);
        this.commaRadioButton.setFocusPainted(false);
        this.commaRadioButton.addActionListener(this);
        buttonGroup.add(this.commaRadioButton);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.commaRadioButton, gridBagConstraints);
        jPanel2.add(this.commaRadioButton);
        string = aResourceBundle.getResourceString("CSVExportPreferencesPanel.radiobutton.Space", "Space");
        this.spaceRadioButton = new JRadioButton(string, false);
        this.spaceRadioButton.setFocusPainted(false);
        this.spaceRadioButton.addActionListener(this);
        buttonGroup.add(this.spaceRadioButton);
        this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.spaceRadioButton, gridBagConstraints);
        jPanel2.add(this.spaceRadioButton);
        string = aResourceBundle.getResourceString("CSVExportPreferencesPanel.radiobutton.Other", "Other");
        this.otherRadioButton = new JRadioButton(string, false);
        this.otherRadioButton.setFocusPainted(false);
        this.otherRadioButton.addActionListener(this);
        buttonGroup.add(this.otherRadioButton);
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.otherRadioButton, gridBagConstraints);
        jPanel2.add(this.otherRadioButton);
        this.otherTextField = new JTextField(10);
        this.otherTextField.addKeyListener(this);
        this.otherTextField.setEnabled(false);
        this.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 100.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.otherTextField, gridBagConstraints);
        jPanel2.add(this.otherTextField);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 70.0, 100.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
    }

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    public DataExportProperties getCSVExportOptions() {
        DataExportProperties dataExportProperties = DBTablesPanel.getDataExportProperties();
        dataExportProperties.setTextInclusion(this.includeTextCheckBox.isSelected());
        dataExportProperties.setTextCharsNumber(Integer.parseInt(this.textMaxCharsSpinner.getValue().toString()));
        if (this.tabRadioButton.isSelected()) {
            dataExportProperties.setDataDelimiter("\t");
        } else if (this.semicolonRadioButton.isSelected()) {
            dataExportProperties.setDataDelimiter(";");
        } else if (this.commaRadioButton.isSelected()) {
            dataExportProperties.setDataDelimiter(DEFAULT_DATA_DELIMITER);
        } else if (this.spaceRadioButton.isSelected()) {
            dataExportProperties.setDataDelimiter(" ");
        } else {
            dataExportProperties.setDataDelimiter(this.otherTextField.getText());
        }
        dataExportProperties.setCSVDateFormat((String)this.dateFormatComboBox.getSelectedItem());
        dataExportProperties.setCSVSummaryTableUseLimit(this.summaryTableLimitCheckBox.isSelected());
        return dataExportProperties;
    }

    public void setCSVExportProperties(DataExportProperties dataExportProperties) {
        this.includeTextCheckBox.setSelected(dataExportProperties.getTextInclusion());
        if (this.includeTextCheckBox.isSelected()) {
            this.textMaxCharsSpinner.setEnabled(true);
        }
        this.textMaxCharsSpinner.setValue(dataExportProperties.getTextCharsNumber());
        if (dataExportProperties.getDataDelimiter().equals("\t")) {
            this.tabRadioButton.setSelected(true);
        } else if (dataExportProperties.getDataDelimiter().equals(";")) {
            this.semicolonRadioButton.setSelected(true);
        } else if (dataExportProperties.getDataDelimiter().equals(DEFAULT_DATA_DELIMITER)) {
            this.commaRadioButton.setSelected(true);
        } else if (dataExportProperties.getDataDelimiter().equals(" ")) {
            this.spaceRadioButton.setSelected(true);
        } else {
            this.otherRadioButton.setSelected(true);
            this.otherTextField.setText(dataExportProperties.getDataDelimiter());
            this.otherTextField.setEnabled(true);
        }
        this.dateFormatComboBox.setSelectedItem(dataExportProperties.getCSVDateFormat());
        this.summaryTableLimitCheckBox.setSelected(dataExportProperties.getCSVSummaryTableUseLimit());
    }
}

