/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.gui.Main_JMenuBarActions;
import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.TableTabPanel;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.SearchResultTableCellRenderer;
import com.dandymadeproductions.ajqvue.utilities.TableModel;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import com.dandymadeproductions.ajqvue.utilities.db.SearchDatabaseThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.table.TableColumn;
import javax.swing.text.DefaultEditorKit;

class SearchFrame
extends JFrame
implements ActionListener,
KeyListener,
MouseListener {
    private static final long serialVersionUID = -4730639399999597935L;
    private transient SearchDatabaseThread searchDatabase;
    private JPopupMenu resultTablePopupMenu;
    private JTextField searchTextField;
    private JButton searchButton;
    private JButton clearSearchButton;
    private JButton searchCompleteButton;
    private AResourceBundle resourceBundle;
    private Object[][] defaultTableData;
    private JTable resultTable;
    private TableModel tableModel;
    private TableTabPanel selectedTableTab;
    private String selectedTable;
    private JProgressBar searchProgressBar;
    private JButton cancelButton;
    private String iconsDirectory = Utils.getIconsDirectory() + Utils.getFileSeparator();

    protected SearchFrame() {
        this.resourceBundle = Ajqvue.getResourceBundle();
        String string = this.resourceBundle.getResourceString("SearchFrame.message.Title", "Search Frame");
        this.setTitle("Ajqvue " + string);
        this.setIconImage(Utils.getFrameIcon());
        ImageIcon imageIcon = this.resourceBundle.getResourceImage(this.iconsDirectory + "searchIcon.png");
        ImageIcon imageIcon2 = this.resourceBundle.getResourceImage(this.iconsDirectory + "removeIcon.png");
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Main_JMenuBarActions.setSearchFrameNotVisisble();
                SearchFrame.this.dispose();
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }
        };
        this.addWindowListener(windowAdapter);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setBorder(BorderFactory.createEtchedBorder());
        this.createMenuBar(jMenuBar);
        this.setJMenuBar(jMenuBar);
        this.resultTablePopupMenu = new JPopupMenu();
        this.createPopupMenu();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createRaisedBevelBorder());
        string = this.resourceBundle.getResourceString("SearchFrame.label.SearchDatabaseFor", "Search Database For");
        JLabel jLabel = new JLabel(string + " : ");
        jPanel2.add(jLabel);
        this.searchTextField = new JTextField(15);
        this.searchTextField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.searchTextField.addMouseListener(Ajqvue.getPopupMenuListener());
        this.searchTextField.addKeyListener(this);
        jPanel2.add(this.searchTextField);
        this.searchButton = new JButton(imageIcon);
        this.searchButton.setMargin(new Insets(0, 0, 0, 0));
        this.searchButton.setFocusPainted(false);
        this.searchButton.addActionListener(this);
        jPanel2.add(this.searchButton);
        this.clearSearchButton = new JButton(imageIcon2);
        this.clearSearchButton.setMargin(new Insets(2, 2, 2, 2));
        this.clearSearchButton.setFocusPainted(false);
        this.clearSearchButton.addActionListener(this);
        jPanel2.add(this.clearSearchButton);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1, 0, 0));
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.resourceBundle.getResourceString("SearchFrame.label.Include", "Include");
        arrayList.add(string2);
        string = this.resourceBundle.getResourceString("SearchFrame.label.Table", "Table");
        arrayList.add(string);
        string = this.resourceBundle.getResourceString("SearchFrame.label.SearchResultCount", "Search Result Count");
        arrayList.add(string);
        this.defaultTableData = new Object[DBTablesPanel.getTableCount()][3];
        Iterator<String> iterator = ConnectionManager.getTableNames().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.defaultTableData[n][0] = true;
            this.defaultTableData[n][1] = "   " + iterator.next();
            this.defaultTableData[n++][2] = 0;
        }
        this.tableModel = new TableModel(arrayList, this.defaultTableData);
        this.resultTable = new JTable(this.tableModel);
        this.resultTable.getTableHeader().setFont(new Font(jPanel3.getFont().getName(), 1, jPanel3.getFont().getSize()));
        this.resultTable.getActionMap().put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        TableColumn tableColumn = this.resultTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(string2.length());
        this.resultTable.getColumnModel().getColumn(1).setCellRenderer(new SearchResultTableCellRenderer());
        this.resultTable.getColumnModel().getColumn(2).setCellRenderer(new SearchResultTableCellRenderer());
        this.resultTable.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.resultTable);
        jPanel3.add(jScrollPane);
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.searchProgressBar = new JProgressBar();
        this.searchProgressBar.setIndeterminate(true);
        this.searchProgressBar.setValue(0);
        this.searchProgressBar.setStringPainted(true);
        jPanel4.add(this.searchProgressBar);
        string = this.resourceBundle.getResourceString("SearchFrame.label.Cancel", "Cancel");
        this.cancelButton = new JButton(string);
        this.cancelButton.setMargin(new Insets(0, 0, 0, 0));
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(this);
        jPanel4.add(this.cancelButton);
        jPanel.add((Component)jPanel4, "South");
        this.getContentPane().add(jPanel);
        this.getContentPane().addMouseListener(Ajqvue.getPopupMenuListener());
        this.searchCompleteButton = new JButton();
        this.searchCompleteButton.addActionListener(this);
        this.searchTextField.grabFocus();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Serializable serializable;
        Object object2 = actionEvent.getSource();
        if (object2 instanceof JMenuItem) {
            Action action;
            int n;
            serializable = (JMenuItem)object2;
            object = ((AbstractButton)serializable).getActionCommand();
            if (((String)object).equals("FE")) {
                Main_JMenuBarActions.setSearchFrameNotVisisble();
                this.dispose();
            }
            if (((String)object).equals("SelectAll")) {
                this.resultTable.selectAll();
                for (n = 0; n < this.resultTable.getRowCount(); ++n) {
                    this.resultTable.setValueAt(true, n, 0);
                }
            }
            if (((String)object).equals("DeSelectAll")) {
                this.resultTable.clearSelection();
                for (n = 0; n < this.resultTable.getRowCount(); ++n) {
                    this.resultTable.setValueAt(false, n, 0);
                }
            } else if (((String)object).equals((String)TransferHandler.getCopyAction().getValue("Name")) && (action = this.resultTable.getActionMap().get(object)) != null) {
                action.actionPerformed(new ActionEvent(this.resultTable, 1001, null));
            }
        }
        if (object2 instanceof JButton) {
            if (object2 == this.searchButton && !this.searchTextField.getText().equals("")) {
                serializable = ConnectionManager.getTableNames();
                object = new boolean[((ArrayList)serializable).size()];
                int n = 0;
                if (!((ArrayList)serializable).isEmpty()) {
                    for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                        if (((ArrayList)serializable).contains(this.resultTable.getValueAt(i, 1).toString().trim()) && ((Boolean)this.resultTable.getValueAt(i, 0)).booleanValue()) {
                            object[i] = true;
                            ++n;
                            continue;
                        }
                        object[i] = false;
                    }
                    this.searchProgressBar.setMaximum(n);
                    this.searchProgressBar.setValue(0);
                    this.searchProgressBar.setIndeterminate(false);
                    this.searchDatabase = new SearchDatabaseThread((ArrayList<String>)serializable, (boolean[])object, this.searchTextField.getText(), this.searchProgressBar, this.searchCompleteButton);
                    Thread thread = new Thread((Runnable)this.searchDatabase, "SearchDatabase");
                    thread.start();
                }
            }
            if (object2 == this.clearSearchButton) {
                this.searchProgressBar.setValue(0);
                this.searchProgressBar.setIndeterminate(true);
                this.tableModel.setValues(this.defaultTableData);
                this.searchButton.setEnabled(true);
            }
            if (object2 == this.cancelButton && this.searchDatabase != null) {
                this.searchDatabase.cancel();
            }
            if (object2 == this.searchCompleteButton && this.searchDatabase != null && (serializable = this.searchDatabase.getResultData()) != null) {
                this.tableModel.setValues((Object[][])serializable);
                this.searchButton.setEnabled(false);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\n') {
            this.searchButton.doClick();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.resultTablePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.resultTablePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.resultTable.rowAtPoint(point);
        int n2 = this.resultTable.columnAtPoint(point);
        if (n >= this.resultTable.getRowCount() || n < 0) {
            return;
        }
        if (n2 == 0) {
            Boolean bl = (Boolean)this.resultTable.getValueAt(n, n2);
            if (bl.booleanValue()) {
                this.resultTable.setValueAt(false, n, n2);
            } else {
                this.resultTable.setValueAt(true, n, n2);
            }
            return;
        }
        this.selectedTable = this.resultTable.getValueAt(n, 1).toString().trim();
        this.selectedTableTab = DBTablesPanel.getTableTabPanel(this.selectedTable);
        if (this.selectedTableTab != null) {
            DBTablesPanel.startStatusTimer();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    SearchFrame.this.selectedTableTab.setSearchTextField(SearchFrame.this.searchTextField.getText());
                    DBTablesPanel.setSelectedTableTabPanel(SearchFrame.this.selectedTable);
                    DBTablesPanel.stopStatusTimer();
                }
            }, "SearchFrame.showResultsTableTabPanelThread");
            thread.start();
        }
    }

    private void createMenuBar(JMenuBar jMenuBar) {
        JMenuItem jMenuItem = null;
        String string = this.resourceBundle.getResourceString("SearchFrame.menu.File", "File");
        JMenu jMenu = new JMenu(string);
        jMenu.setFont(jMenu.getFont().deriveFont(1));
        jMenu.addSeparator();
        string = this.resourceBundle.getResourceString("SearchFrame.menu.Exit", "Exit");
        jMenu.add(this.menuItem(string, "FE"));
        jMenuBar.add(jMenu);
        string = this.resourceBundle.getResourceString("SearchFrame.menu.Edit", "Edit");
        JMenu jMenu2 = new JMenu(string);
        jMenu2.setFont(jMenu2.getFont().deriveFont(1));
        jMenuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        string = this.resourceBundle.getResourceString("SearchFrame.menu.Cut", "Cut");
        jMenuItem.setText(string + "          Ctrl+x");
        jMenuItem.setMnemonic(88);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        string = this.resourceBundle.getResourceString("SearchFrame.menu.Copy", "Copy");
        jMenuItem.setText(string + "       Ctrl+c");
        jMenuItem.setMnemonic(67);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        string = this.resourceBundle.getResourceString("SearchFrame.menu.Paste", "Past");
        jMenuItem.setText(string + "       Ctrl+v");
        jMenuItem.setMnemonic(86);
        jMenu2.add(jMenuItem);
        jMenuBar.add(jMenu2);
        jMenuBar.add(Box.createHorizontalGlue());
        ImageIcon imageIcon = this.resourceBundle.getResourceImage(this.iconsDirectory + "ajqvueIcon.gif");
        JButton jButton = new JButton(imageIcon);
        jButton.setDisabledIcon(imageIcon);
        jButton.setFocusPainted(false);
        jButton.setBorder(BorderFactory.createLoweredBevelBorder());
        jMenuBar.add(jButton);
    }

    private void createPopupMenu() {
        JMenuItem jMenuItem = null;
        String string = this.resourceBundle.getResourceString("SearchFrame.menu.SelectAll", "Select All");
        jMenuItem = this.menuItem(string, "SelectAll");
        this.resultTablePopupMenu.add(jMenuItem);
        string = this.resourceBundle.getResourceString("SearchFrame.menu.DeSelectAll", "DeSelect All");
        jMenuItem = this.menuItem(string, "DeSelectAll");
        this.resultTablePopupMenu.add(jMenuItem);
        this.resultTablePopupMenu.addSeparator();
        string = this.resourceBundle.getResourceString("SearchFrame.menu.Copy", "Copy");
        jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand((String)TransferHandler.getCopyAction().getValue("Name"));
        jMenuItem.setMnemonic(67);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        jMenuItem.addActionListener(this);
        this.resultTablePopupMenu.add(jMenuItem);
    }

    private JMenuItem menuItem(String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(string2);
        return jMenuItem;
    }

    protected void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setLocation(n, n2);
    }
}

