/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.datasource.ConnectionProperties;
import com.dandymadeproductions.ajqvue.gui.Main_Frame;
import com.dandymadeproductions.ajqvue.gui.Main_JMenuBarActions;
import com.dandymadeproductions.ajqvue.gui.panels.SQLTabPanel;
import com.dandymadeproductions.ajqvue.io.CSVDataTableDumpThread;
import com.dandymadeproductions.ajqvue.io.CSVQueryDataDumpThread;
import com.dandymadeproductions.ajqvue.io.PDFDataTableDumpThread;
import com.dandymadeproductions.ajqvue.io.WriteDataFile;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.InputDialog;
import com.dandymadeproductions.ajqvue.utilities.TableClearingThread;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultEditorKit;

public class QueryFrame
extends JFrame
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 8893658072886277975L;
    private static JTabbedPane queryTabsPane = new JTabbedPane();
    private JPanel tabPanel;
    private static final int maxTabs = 50;
    private int currentQueryIndex;
    private int workingQueryIndex;
    private int oldQueryIndex;
    private int queryCount;
    private boolean clearingTabs;
    private boolean newTabState;
    private JCheckBoxMenuItem showQueryCheckBox;
    private transient Connection query_dbConnection;
    private ImageIcon statusIdleIcon;
    private ImageIcon statusWorkingIcon;
    private ImageIcon[] statusIndicatorIcon = new ImageIcon[50];
    private JLabel statusIndicator;
    private String[] status = new String[50];
    private JTextField statusLabel;
    private JButton sqlQueryBucketButton;
    private JComboBox<Object> statementTypeComboBox;
    private int[] tabStatementType = new int[50];
    private JTextArea queryTextArea;
    private String[] queryTextAreaData = new String[50];
    private int[] summaryTableRowSize = new int[50];
    private JButton executeButton;
    private JButton removeTabButton;
    private JCheckBox newTabCheckBox;
    private static JTextArea queryResultTextArea = new JTextArea(4, 40);
    private AResourceBundle resourceBundle;
    private String resourceAlert;
    private String resourceFileNOTFound;
    private String dataSourceType;
    private String fileSeparator;
    private String iconsDirectory;
    private String scriptLastDirectory;
    private String dataLastDirectory;
    private transient PrinterJob currentPrintJob = PrinterJob.getPrinterJob();
    private transient PageFormat mPageFormat = this.currentPrintJob.defaultPage();
    private static String FILE_OPEN_SCRIPT = "FOS";
    private static String FILE_SAVE_SCRIPT = "FSS";
    private static String FILE_PRINT = "FP";
    private static String FILE_PAGE_FORMAT = "FPG";
    private static String FILE_EXIT = "FE";
    private static String EDITPREFERENCES_TABLE_ROWS = "EPTR";
    private static String DATAEXPORT_CSV_QUERY = "DECSVQ";
    private static String DATAEXPORT_CSV_SUMMARY_TABLE = "DECSVST";
    private static String DATAEXPORT_PDF_SUMMARY_TABLE = "DEPDFST";

    public QueryFrame(Main_Frame main_Frame) {
        this.resourceBundle = Ajqvue.getResourceBundle();
        ConnectionProperties connectionProperties = ConnectionManager.getConnectionProperties();
        this.dataSourceType = ConnectionManager.getDataSourceType();
        String string = connectionProperties.getProperty("Host");
        String string2 = connectionProperties.getProperty("DB");
        String string3 = this.resourceBundle.getResourceString("QueryFrame.message.Title", "Query Frame");
        this.setTitle("Ajqvue " + string3 + "   " + string + ":" + string2);
        this.setIconImage(Utils.getFrameIcon());
        this.resourceAlert = string3 = this.resourceBundle.getResourceString("QueryFrame.dialogtitle.Alert", "Alert");
        this.resourceFileNOTFound = string3 = this.resourceBundle.getResourceString("QueryFrame.dialogmessage.FileNOTFound", "File NOT Found");
        this.currentQueryIndex = 0;
        this.workingQueryIndex = 0;
        this.oldQueryIndex = this.currentQueryIndex;
        this.queryCount = 0;
        this.clearingTabs = false;
        this.newTabState = true;
        this.fileSeparator = Utils.getFileSeparator();
        this.iconsDirectory = Utils.getIconsDirectory() + this.fileSeparator;
        this.scriptLastDirectory = "";
        this.dataLastDirectory = "";
        this.statusIdleIcon = this.resourceBundle.getResourceImage(this.iconsDirectory + "statusIdleIcon.png");
        this.statusWorkingIcon = this.resourceBundle.getResourceImage(this.iconsDirectory + "statusWorkingIcon.png");
        ImageIcon imageIcon = this.resourceBundle.getResourceImage(this.iconsDirectory + "addSQLQueryIcon.png");
        ImageIcon imageIcon2 = this.resourceBundle.getResourceImage(this.iconsDirectory + "removeTabIcon.png");
        for (int i = 0; i < 50; ++i) {
            this.statusIndicatorIcon[i] = this.statusIdleIcon;
            this.status[i] = "Idle";
            this.summaryTableRowSize[i] = 50;
        }
        this.query_dbConnection = ConnectionManager.getConnection("QueryFrame");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (QueryFrame.this.dataSourceType.indexOf("hsql") != -1 || QueryFrame.this.dataSourceType.equals("oracle")) {
                    Thread thread = new Thread((Runnable)new TableClearingThread(QueryFrame.this.queryCount), "TableClearingThread");
                    thread.start();
                }
                QueryFrame.this.clearingTabs = true;
                queryTabsPane.removeAll();
                queryResultTextArea.setText("");
                Ajqvue.getGeneralProperties().setQueryFramePosition(new Point(QueryFrame.this.getX(), QueryFrame.this.getY()));
                Ajqvue.getGeneralProperties().setQueryFrameDimension(QueryFrame.this.getSize());
                if (QueryFrame.this.query_dbConnection != null) {
                    ConnectionManager.closeConnection(QueryFrame.this.query_dbConnection, "QueryFrame");
                }
                Main_JMenuBarActions.setQueryFrameNotVisisble();
                QueryFrame.this.dispose();
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setBorder(BorderFactory.createEtchedBorder());
        this.createMenuBar(main_Frame, jMenuBar);
        this.setJMenuBar(jMenuBar);
        JToolBar jToolBar = new JToolBar("Ajqvue QueryFrame ToolBar");
        jToolBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.createToolBar(main_Frame, jToolBar);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jToolBar, "First");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder());
        jSplitPane.setOneTouchExpandable(true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel jPanel4 = new JPanel(gridBagLayout);
        jPanel4.setBorder(BorderFactory.createRaisedBevelBorder());
        JPanel jPanel5 = new JPanel(gridBagLayout);
        jPanel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.statusIndicator = new JLabel("", 2);
        this.statusIndicator.setIcon(this.statusIdleIcon);
        this.statusIndicator.setDisabledIcon(this.statusWorkingIcon);
        this.statusIndicator.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 15.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.statusIndicator, gridBagConstraints);
        jPanel5.add(this.statusIndicator);
        this.statusLabel = new JTextField("Idle", 10);
        this.statusLabel.setHorizontalAlignment(2);
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.statusLabel.setEditable(false);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 85.0, 100.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.statusLabel, gridBagConstraints);
        jPanel5.add(this.statusLabel);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 6.0, 100.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel4.add(jPanel5);
        this.sqlQueryBucketButton = new JButton(imageIcon);
        this.sqlQueryBucketButton.setMargin(new Insets(0, 0, 0, 0));
        this.sqlQueryBucketButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), this.sqlQueryBucketButton.getBorder()));
        this.sqlQueryBucketButton.setFocusPainted(false);
        this.sqlQueryBucketButton.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 1.0, 100.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.sqlQueryBucketButton, gridBagConstraints);
        jPanel4.add(this.sqlQueryBucketButton);
        this.statementTypeComboBox = new JComboBox();
        this.statementTypeComboBox.setBorder(BorderFactory.createRaisedBevelBorder());
        string3 = this.resourceBundle.getResourceString("QueryFrame.combobox.SQLStatement", "SQL Statement");
        this.statementTypeComboBox.addItem(string3 + " : ");
        this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 72.0, 100.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.statementTypeComboBox, gridBagConstraints);
        jPanel4.add(this.statementTypeComboBox);
        string3 = this.resourceBundle.getResourceString("QueryFrame.checkbox.NewTab", "New Tab");
        this.newTabCheckBox = new JCheckBox(string3, true);
        this.newTabCheckBox.setIcon(this.resourceBundle.getResourceImage(this.iconsDirectory + "limitUpIcon.png"));
        this.newTabCheckBox.setSelectedIcon(this.resourceBundle.getResourceImage(this.iconsDirectory + "limitDownIcon.png"));
        this.newTabCheckBox.setMargin(new Insets(4, 1, 4, 1));
        this.newTabCheckBox.setBorder(BorderFactory.createRaisedBevelBorder());
        this.newTabCheckBox.setFocusPainted(false);
        this.buildConstraints(gridBagConstraints, 3, 0, 1, 1, 10.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.newTabCheckBox, gridBagConstraints);
        jPanel4.add(this.newTabCheckBox);
        string3 = this.resourceBundle.getResourceString("QueryFrame.button.Execute", "Execute");
        this.executeButton = new JButton(string3);
        this.executeButton.setFocusPainted(false);
        this.executeButton.setMnemonic(10);
        this.executeButton.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 4, 0, 1, 1, 10.0, 100.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.executeButton, gridBagConstraints);
        jPanel4.add(this.executeButton);
        this.removeTabButton = new JButton(imageIcon2);
        this.removeTabButton.setMargin(new Insets(0, 0, 0, 0));
        this.removeTabButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), this.removeTabButton.getBorder()));
        this.removeTabButton.setFocusPainted(false);
        this.removeTabButton.setEnabled(false);
        this.removeTabButton.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 5, 0, 1, 1, 1.0, 100.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.removeTabButton, gridBagConstraints);
        jPanel4.add(this.removeTabButton);
        jPanel3.add((Component)jPanel4, "North");
        this.queryTextArea = new JTextArea(5, 40);
        this.queryTextArea.setBorder(BorderFactory.createLoweredBevelBorder());
        this.queryTextArea.setLineWrap(true);
        this.queryTextArea.setDragEnabled(true);
        this.queryTextArea.addMouseListener(Ajqvue.getPopupMenuListener());
        JScrollPane jScrollPane = new JScrollPane(this.queryTextArea);
        jPanel3.add((Component)jScrollPane, "Center");
        jSplitPane.setTopComponent(jPanel3);
        JPanel jPanel6 = new JPanel(new GridLayout(1, 1, 0, 0));
        jPanel6.setBorder(BorderFactory.createEtchedBorder());
        queryTabsPane.setTabPlacement(1);
        queryTabsPane.setTabLayoutPolicy(1);
        queryTabsPane.addChangeListener(this);
        jPanel6.add(queryTabsPane);
        jSplitPane.setBottomComponent(jPanel6);
        jPanel2.add((Component)jSplitPane, "Center");
        JPanel jPanel7 = new JPanel(new GridLayout(1, 1, 0, 0));
        jPanel7.setBorder(BorderFactory.createEtchedBorder());
        queryResultTextArea.setBorder(BorderFactory.createLoweredBevelBorder());
        queryResultTextArea.setLineWrap(true);
        queryResultTextArea.addMouseListener(Ajqvue.getPopupMenuListener());
        JScrollPane jScrollPane2 = new JScrollPane(queryResultTextArea);
        jPanel7.add(jScrollPane2);
        jPanel2.add((Component)jPanel7, "South");
        jPanel.add((Component)jPanel2, "Center");
        this.getContentPane().add(jPanel);
        this.queryTextArea.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.sqlQueryBucketButton) {
            if (!this.queryTextArea.getText().isEmpty()) {
                Main_Frame.getSQLBucket().addSQLStatement(new StringBuffer(this.queryTextArea.getText()));
            }
            return;
        }
        if (object == this.executeButton) {
            queryTabsPane.removeChangeListener(this);
            this.executeSQL();
            queryTabsPane.addChangeListener(this);
            this.newTabCheckBox.setSelected(false);
            this.removeTabButton.setEnabled(true);
            return;
        }
        if (object == this.removeTabButton) {
            if (queryTabsPane.getTabCount() >= 2) {
                queryTabsPane.remove(queryTabsPane.getSelectedIndex());
            }
            return;
        }
        if (object instanceof JMenuItem || object instanceof JButton) {
            String string;
            Object object2;
            if (object instanceof JMenuItem) {
                object2 = (JMenuItem)object;
                string = ((AbstractButton)object2).getActionCommand();
            } else {
                object2 = (JButton)object;
                string = ((AbstractButton)object2).getActionCommand();
            }
            if (string.equals(FILE_OPEN_SCRIPT)) {
                this.openScriptFile();
            }
            if (string.equals(FILE_SAVE_SCRIPT)) {
                this.saveScriptFile();
            }
            if (string.equals(FILE_PRINT)) {
                this.printData();
            }
            if (string.equals(FILE_PAGE_FORMAT)) {
                object2 = PrinterJob.getPrinterJob();
                this.mPageFormat = ((PrinterJob)object2).pageDialog(this.mPageFormat);
            }
            if (string.equals(FILE_EXIT)) {
                if (this.dataSourceType.indexOf("hsql") != -1 || this.dataSourceType.equals("oracle")) {
                    object2 = new Thread((Runnable)new TableClearingThread(queryTabsPane.getTabCount()), "TableClearingThread");
                    ((Thread)object2).start();
                }
                this.clearingTabs = true;
                queryTabsPane.removeAll();
                queryResultTextArea.setText("");
                Ajqvue.getGeneralProperties().setQueryFramePosition(new Point(this.getX(), this.getY()));
                Ajqvue.getGeneralProperties().setQueryFrameDimension(this.getSize());
                if (this.query_dbConnection != null) {
                    ConnectionManager.closeConnection(this.query_dbConnection, "QueryFrame");
                }
                Main_JMenuBarActions.setQueryFrameNotVisisble();
                this.dispose();
            }
            if (string.equals(EDITPREFERENCES_TABLE_ROWS)) {
                this.setRowPreferences();
            }
            if (QueryFrame.getSelectedTab() != null && (string.indexOf("DECSV") != -1 || string.indexOf("DEPDF") != -1 || string.indexOf("DESQL") != -1)) {
                this.exportData(string);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof JTabbedPane && !this.clearingTabs) {
            this.oldQueryIndex = this.currentQueryIndex;
            this.currentQueryIndex = Integer.parseInt(QueryFrame.getSelectedTabTitle());
            if (this.oldQueryIndex != this.currentQueryIndex) {
                this.queryTextArea.setText(this.queryTextAreaData[this.currentQueryIndex]);
                this.statementTypeComboBox.setSelectedIndex(this.tabStatementType[this.currentQueryIndex]);
                this.statusIndicator.setIcon(this.statusIndicatorIcon[this.currentQueryIndex]);
                this.statusLabel.setText(this.status[this.currentQueryIndex]);
            }
        }
    }

    private void executeSQL() {
        if (this.query_dbConnection != null) {
            queryResultTextArea.setText("");
            if (this.newTabCheckBox.isSelected()) {
                this.oldQueryIndex = this.currentQueryIndex;
                this.currentQueryIndex = this.queryCount;
                this.newTabState = true;
            } else {
                this.newTabState = false;
            }
            this.queryTextAreaData[this.currentQueryIndex] = this.queryTextArea.getText();
            this.tabStatementType[this.currentQueryIndex] = this.statementTypeComboBox.getSelectedIndex();
            this.workingQueryIndex = this.currentQueryIndex;
            this.statusIndicator.setIcon(this.statusWorkingIcon);
            this.statusIndicatorIcon[this.currentQueryIndex] = this.statusWorkingIcon;
            this.statusLabel.setText("Working");
            this.status[this.currentQueryIndex] = "Working";
            Thread thread = new Thread(new Runnable(){
                boolean isNewTab;
                {
                    this.isNewTab = QueryFrame.this.newTabState;
                }

                @Override
                public void run() {
                    QueryFrame.this.tabPanel = new SQLTabPanel(QueryFrame.this.queryTextArea.getText(), QueryFrame.this.summaryTableRowSize[QueryFrame.this.workingQueryIndex], QueryFrame.this.resourceBundle);
                    if (this.isNewTab) {
                        queryTabsPane.addTab(QueryFrame.this.workingQueryIndex + "", QueryFrame.this.tabPanel);
                    } else {
                        queryTabsPane.setComponentAt(queryTabsPane.getSelectedIndex(), QueryFrame.this.tabPanel);
                    }
                    queryTabsPane.setSelectedIndex(queryTabsPane.indexOfTab(QueryFrame.this.workingQueryIndex + ""));
                    QueryFrame.this.statusIndicator.setIcon(QueryFrame.this.statusIdleIcon);
                    ((QueryFrame)QueryFrame.this).statusIndicatorIcon[((QueryFrame)QueryFrame.this).workingQueryIndex] = QueryFrame.this.statusIdleIcon;
                    QueryFrame.this.statusLabel.setText("Idle");
                    ((QueryFrame)QueryFrame.this).status[((QueryFrame)QueryFrame.this).currentQueryIndex] = "Idle";
                }
            }, "QueryFrame.executeSQLThread");
            thread.start();
            ++this.queryCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openScriptFile() {
        int n = 100;
        JFileChooser jFileChooser = this.scriptLastDirectory.equals("") ? new JFileChooser() : new JFileChooser(new File(this.scriptLastDirectory));
        int n2 = jFileChooser.showOpenDialog(null);
        if (n2 != 0) return;
        this.scriptLastDirectory = jFileChooser.getCurrentDirectory().toString();
        String string = jFileChooser.getSelectedFile().getName();
        string = jFileChooser.getCurrentDirectory() + this.fileSeparator + string;
        if (string.equals("")) {
            JOptionPane.showMessageDialog(null, this.resourceFileNOTFound, this.resourceAlert, 0);
            return;
        }
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
            int n3 = 1;
            this.queryTextArea.setText("");
            while ((string2 = bufferedReader.readLine()) != null) {
                if (n3 >= n) return;
                this.queryTextArea.append(string2);
                ++n3;
            }
            return;
        }
        catch (IOException iOException) {
            String string3;
            String string4 = string3 = this.resourceBundle.getResourceString("QueryFrame.dialogmessage.InputFile", "Unalbe to Read Input File");
            JOptionPane.showMessageDialog(null, string4, this.resourceAlert, 0);
            return;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                if (Ajqvue.getDebug()) {
                    System.out.println("QueryFrame openScriptFile() Failed to Close BufferedReader. " + iOException);
                }
            }
            finally {
                block42: {
                    try {
                        if (fileReader != null) {
                            fileReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!Ajqvue.getDebug()) break block42;
                        System.out.println("QueryFrame openScriptFile() Failed to Close FileReader. " + iOException);
                    }
                }
            }
        }
    }

    private void saveScriptFile() {
        JFileChooser jFileChooser = this.scriptLastDirectory.equals("") ? new JFileChooser() : new JFileChooser(new File(this.scriptLastDirectory));
        int n = Utils.processFileChooserSelection(this, jFileChooser);
        if (n == 0) {
            this.scriptLastDirectory = jFileChooser.getCurrentDirectory().toString();
            String string = jFileChooser.getSelectedFile().getName();
            string = jFileChooser.getCurrentDirectory() + this.fileSeparator + string;
            if (!string.equals("")) {
                WriteDataFile.mainWriteDataString(string, this.queryTextArea.getText().getBytes(), false);
            }
        }
    }

    private void printData() {
        Paper paper = new Paper();
        double d = 36.0;
        paper.setImageableArea(d, d, paper.getWidth() - d * 2.0, paper.getHeight() - d * 2.0);
        this.mPageFormat.setPaper(paper);
        if (QueryFrame.getSelectedTab() != null) {
            this.currentPrintJob.setPrintable((SQLTabPanel)QueryFrame.getSelectedTab(), this.mPageFormat);
            if (this.currentPrintJob.printDialog()) {
                try {
                    this.currentPrintJob.print();
                }
                catch (PrinterException printerException) {
                    String string;
                    String string2 = string = this.resourceBundle.getResourceString("QueryFrame.dialogmessage.PrinterException", "Printer Exception");
                    JOptionPane.showMessageDialog(null, string2, printerException.getMessage(), 0);
                }
            }
        }
    }

    private void setRowPreferences() {
        JTextField jTextField = new JTextField();
        jTextField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(0), BorderFactory.createLoweredBevelBorder()));
        if (this.currentQueryIndex <= this.summaryTableRowSize.length) {
            jTextField.setText(Integer.toString(this.summaryTableRowSize[this.currentQueryIndex]));
        }
        String string = this.resourceBundle.getResourceString("QueryFrame.label.Warning", "Warning!");
        JLabel jLabel = new JLabel(string, 0);
        jLabel.setForeground(Color.RED);
        string = this.resourceBundle.getResourceString("QueryFrame.label.LargeRowSize", "A large row size may adversely effect");
        JLabel jLabel2 = new JLabel(string, 0);
        string = this.resourceBundle.getResourceString("QueryFrame.label.ApplicationServerPerformance", "application/server performance");
        JLabel jLabel3 = new JLabel(string, 0);
        Object[] objectArray = new Object[]{jLabel, jLabel2, jLabel3, jTextField};
        string = this.resourceBundle.getResourceString("QueryFrame.label.SetSummaryTableRowSize", "Set Summary Table Row Size");
        String string2 = this.resourceBundle.getResourceString("QueryFrame.button.OK", "OK");
        String string3 = this.resourceBundle.getResourceString("QueryFrame.button.Cancel", "Cancel");
        InputDialog inputDialog = new InputDialog(null, string, string2, string3, objectArray, null);
        inputDialog.pack();
        inputDialog.setResizable(false);
        inputDialog.center();
        inputDialog.setVisible(true);
        if (inputDialog.isActionResult()) {
            try {
                this.summaryTableRowSize[this.currentQueryIndex] = Integer.parseInt(jTextField.getText());
                JPanel jPanel = (JPanel)queryTabsPane.getSelectedComponent();
                if (jPanel != null && jPanel instanceof SQLTabPanel) {
                    queryTabsPane.removeChangeListener(this);
                    this.executeSQL();
                    queryTabsPane.addChangeListener(this);
                }
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = this.resourceBundle.getResourceString("QueryFrame.dialogmessage.RowSize", "The Row Size Input Appears To NOT Be A Valid Integer!");
                JOptionPane.showMessageDialog(null, string4, this.resourceAlert, 0);
            }
        }
        inputDialog.dispose();
    }

    private void exportData(String string) {
        HashMap<String, String> hashMap = new HashMap();
        HashMap<String, String> hashMap2 = new HashMap();
        JFileChooser jFileChooser = this.dataLastDirectory.equals("") ? new JFileChooser() : new JFileChooser(new File(this.dataLastDirectory));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        String string2 = "sqlData" + QueryFrame.getSelectedTabTitle();
        String string3 = string2 + "_" + simpleDateFormat.format(new Date());
        string3 = string.indexOf("DECSV") != -1 ? string3 + ".csv" : (string.indexOf("DEPDF") != -1 ? string3 + ".pdf" : string3 + ".sql");
        jFileChooser.setSelectedFile(new File(string3));
        int n = Utils.processFileChooserSelection(this, jFileChooser);
        if (n == 0) {
            this.dataLastDirectory = jFileChooser.getCurrentDirectory().toString();
            string3 = jFileChooser.getSelectedFile().getName();
            string3 = jFileChooser.getCurrentDirectory() + this.fileSeparator + string3;
            if (!string3.equals("")) {
                JTable jTable;
                if (string.indexOf("DECSV") != -1 || string.indexOf("DESQL") != -1) {
                    hashMap = ((SQLTabPanel)QueryFrame.getSelectedTab()).getColumnNamesHashMap();
                    hashMap2 = ((SQLTabPanel)QueryFrame.getSelectedTab()).getColumnTypeNameHashMap();
                }
                if (string.equals(DATAEXPORT_CSV_QUERY)) {
                    Thread thread = new Thread(new CSVQueryDataDumpThread(this.query_dbConnection, this.queryTextArea.getText().replaceAll(";", ""), string3, true, true));
                    thread.start();
                } else if ((string.equals(DATAEXPORT_CSV_SUMMARY_TABLE) || string.equals(DATAEXPORT_PDF_SUMMARY_TABLE)) && (jTable = ((SQLTabPanel)QueryFrame.getSelectedTab()).getListTable()) != null) {
                    if (string.equals(DATAEXPORT_CSV_SUMMARY_TABLE)) {
                        Thread thread = new Thread(new CSVDataTableDumpThread(jTable, hashMap, hashMap2, string2, string3));
                        thread.start();
                    } else {
                        Thread thread = new Thread(new PDFDataTableDumpThread(jTable, hashMap2, string2, string3));
                        thread.start();
                    }
                }
            } else {
                JOptionPane.showMessageDialog(null, this.resourceFileNOTFound, this.resourceAlert, 0);
            }
        }
    }

    private void createMenuBar(Main_Frame main_Frame, JMenuBar jMenuBar) {
        JMenuItem jMenuItem = null;
        String string = this.resourceBundle.getResourceString("QueryFrame.menu.File", "File");
        JMenu jMenu = new JMenu(string);
        jMenu.setFont(jMenu.getFont().deriveFont(1));
        string = this.resourceBundle.getResourceString("QueryFrame.menu.OpenScript", "Open Script");
        jMenu.add(this.menuItem(string, FILE_OPEN_SCRIPT));
        string = this.resourceBundle.getResourceString("QueryFrame.menu.SaveScript", "Save Script");
        jMenu.add(this.menuItem(string, FILE_SAVE_SCRIPT));
        jMenu.addSeparator();
        string = this.resourceBundle.getResourceString("QueryFrame.menu.Print", "Print");
        jMenu.add(this.menuItem(string, FILE_PRINT));
        string = this.resourceBundle.getResourceString("QueryFrame.menu.PageFormat", "Page Format");
        jMenu.add(this.menuItem(string, FILE_PAGE_FORMAT));
        jMenu.addSeparator();
        string = this.resourceBundle.getResourceString("QueryFrame.menu.Exit", "Exit");
        jMenu.add(this.menuItem(string, FILE_EXIT));
        jMenuBar.add(jMenu);
        string = this.resourceBundle.getResourceString("QueryFrame.menu.Edit", "Edit");
        JMenu jMenu2 = new JMenu(string);
        jMenu2.setFont(jMenu2.getFont().deriveFont(1));
        jMenuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        string = this.resourceBundle.getResourceString("QueryFrame.menu.Cut", "Cut");
        jMenuItem.setText(string + "          Ctrl+x");
        jMenuItem.setMnemonic(88);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        string = this.resourceBundle.getResourceString("QueryFrame.menu.Copy", "Copy");
        jMenuItem.setText(string + "       Ctrl+c");
        jMenuItem.setMnemonic(67);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        string = this.resourceBundle.getResourceString("QueryFrame.menu.Paste", "Paste");
        jMenuItem.setText(string + "       Ctrl+v");
        jMenuItem.setMnemonic(86);
        jMenu2.add(jMenuItem);
        jMenu2.addSeparator();
        string = this.resourceBundle.getResourceString("QueryFrame.menu.Preferences", "Preferences");
        JMenu jMenu3 = new JMenu(string);
        string = this.resourceBundle.getResourceString("QueryFrame.menu.TableRows", "Table Rows");
        jMenu3.add(this.menuItem(string, EDITPREFERENCES_TABLE_ROWS));
        string = this.resourceBundle.getResourceString("QueryFrame.menu.ShowQuery", "Show Query");
        this.showQueryCheckBox = new JCheckBoxMenuItem(string, false);
        jMenu3.add(this.showQueryCheckBox);
        jMenu2.add(jMenu3);
        jMenuBar.add(jMenu2);
        string = this.resourceBundle.getResourceString("QueryFrame.menu.Data", "Data");
        JMenu jMenu4 = new JMenu(string);
        jMenu4.setFont(jMenu4.getFont().deriveFont(1));
        string = this.resourceBundle.getResourceString("QueryFrame.menu.Export", "Export");
        JMenu jMenu5 = new JMenu(string);
        string = this.resourceBundle.getResourceString("QueryFrame.menu.CSV", "CSV");
        JMenu jMenu6 = new JMenu(string);
        string = this.resourceBundle.getResourceString("QueryFrame.menu.Query", "Query");
        jMenu6.add(this.menuItem(string, DATAEXPORT_CSV_QUERY));
        string = this.resourceBundle.getResourceString("QueryFrame.menu.SummaryTable", "Summary Table");
        jMenu6.add(this.menuItem(string, DATAEXPORT_CSV_SUMMARY_TABLE));
        jMenu5.add(jMenu6);
        string = this.resourceBundle.getResourceString("QueryFrame.menu.PDF", "PDF");
        jMenu6 = new JMenu(string);
        string = this.resourceBundle.getResourceString("QueryFrame.menu.SummaryTable", "Summary Table");
        jMenu6.add(this.menuItem(string, DATAEXPORT_PDF_SUMMARY_TABLE));
        jMenu5.add(jMenu6);
        jMenu4.add(jMenu5);
        jMenuBar.add(jMenu4);
        string = this.resourceBundle.getResourceString("QueryFrame.menu.Tools", "Tools");
        JMenu jMenu7 = new JMenu(string);
        jMenu7.setFont(jMenu.getFont().deriveFont(1));
        string = this.resourceBundle.getResourceString("QueryFrame.menu.SQLQueryBucket", "SQL Query Bucket");
        jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(main_Frame);
        jMenuItem.setActionCommand("TSQB");
        jMenu7.add(jMenuItem);
        jMenuBar.add(jMenu7);
        jMenuBar.add(Box.createHorizontalGlue());
        ImageIcon imageIcon = this.resourceBundle.getResourceImage(this.iconsDirectory + "ajqvueIcon.gif");
        JButton jButton = new JButton(imageIcon);
        jButton.setDisabledIcon(imageIcon);
        jButton.setFocusPainted(false);
        jButton.setBorder(BorderFactory.createLoweredBevelBorder());
        jMenuBar.add(jButton);
    }

    private void createToolBar(Main_Frame main_Frame, JToolBar jToolBar) {
        ImageIcon imageIcon = this.resourceBundle.getResourceImage(this.iconsDirectory + "openScriptIcon_20x20.png");
        String string = this.resourceBundle.getResourceString("QueryFrame.tooltip.OpenScript", "Open Script");
        JButton jButton = this.buttonItem(string, imageIcon, FILE_OPEN_SCRIPT);
        jToolBar.add(jButton);
        ImageIcon imageIcon2 = this.resourceBundle.getResourceImage(this.iconsDirectory + "saveScriptIcon_20x20.png");
        string = this.resourceBundle.getResourceString("QueryFrame.tooltip.SaveScript", "Save Script");
        jButton = this.buttonItem(string, imageIcon2, FILE_SAVE_SCRIPT);
        jToolBar.add(jButton);
        ImageIcon imageIcon3 = this.resourceBundle.getResourceImage(this.iconsDirectory + "printIcon_20x20.png");
        string = this.resourceBundle.getResourceString("QueryFrame.tooltip.Print", "Print");
        jButton = this.buttonItem(string, imageIcon3, FILE_PRINT);
        jToolBar.add(jButton);
        ImageIcon imageIcon4 = this.resourceBundle.getResourceImage(this.iconsDirectory + "pageFormatIcon_20x20.png");
        string = this.resourceBundle.getResourceString("QueryFrame.tooltip.PageFormat", "Page Format");
        jButton = this.buttonItem(string, imageIcon4, FILE_PAGE_FORMAT);
        jToolBar.add(jButton);
        ImageIcon imageIcon5 = this.resourceBundle.getResourceImage(this.iconsDirectory + "exitIcon_20x20.png");
        string = this.resourceBundle.getResourceString("QueryFrame.tooltip.Exit", "Exit");
        jButton = this.buttonItem(string, imageIcon5, FILE_EXIT);
        jToolBar.add(jButton);
        jToolBar.addSeparator();
        ImageIcon imageIcon6 = this.resourceBundle.getResourceImage(this.iconsDirectory + "tableRowsIcon_20x20.png");
        string = this.resourceBundle.getResourceString("QueryFrame.tooltip.TableRows", "Table Rows");
        jButton = this.buttonItem(string, imageIcon6, EDITPREFERENCES_TABLE_ROWS);
        jToolBar.add(jButton);
        jToolBar.addSeparator();
        ImageIcon imageIcon7 = this.resourceBundle.getResourceImage(this.iconsDirectory + "csvExportSummaryTableIcon_20x20.png");
        string = this.resourceBundle.getResourceString("QueryFrame.tooltip.ExportCSVSummaryTable", "Export CSV Tab Summary Table");
        jButton = this.buttonItem(string, imageIcon7, DATAEXPORT_CSV_SUMMARY_TABLE);
        jToolBar.add(jButton);
        imageIcon7 = this.resourceBundle.getResourceImage(this.iconsDirectory + "csvExportTableIcon_20x20.png");
        string = this.resourceBundle.getResourceString("QueryFrame.tooltip.ExportCSVQuery", "Export CSV Query");
        jButton = this.buttonItem(string, imageIcon7, DATAEXPORT_CSV_QUERY);
        jToolBar.add(jButton);
        jToolBar.addSeparator();
        ImageIcon imageIcon8 = this.resourceBundle.getResourceImage(this.iconsDirectory + "pdfExportSummaryTableIcon_20x20.png");
        string = this.resourceBundle.getResourceString("QueryFrame.tooltip.ExportPDFSummaryTable", "Export PDF Tab Summary Table");
        jButton = this.buttonItem(string, imageIcon8, DATAEXPORT_PDF_SUMMARY_TABLE);
        jToolBar.add(jButton);
        jToolBar.addSeparator();
        ImageIcon imageIcon9 = this.resourceBundle.getResourceImage(this.iconsDirectory + "sqlQueryBucketIcon_20x20.png");
        string = this.resourceBundle.getResourceString("QueryFrame.tooltip.SQLQueryBucket", "SQL Query Bucket");
        jButton = new JButton(imageIcon9);
        jButton.setFocusable(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setToolTipText(string);
        jButton.setActionCommand("TSQB");
        jButton.addActionListener(main_Frame);
        jToolBar.add(jButton);
    }

    private JMenuItem menuItem(String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(string2);
        return jMenuItem;
    }

    private JButton buttonItem(String string, ImageIcon imageIcon, String string2) {
        JButton jButton = new JButton(imageIcon);
        jButton.setFocusable(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setToolTipText(string);
        jButton.setActionCommand(string2);
        jButton.addActionListener(this);
        return jButton;
    }

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    public void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setLocation(n, n2);
    }

    public static void clearQueryResultTextArea() {
        queryResultTextArea.setText("");
    }

    public static Object getSelectedTab() {
        Component component = queryTabsPane.getSelectedComponent();
        if (component instanceof SQLTabPanel) {
            return (SQLTabPanel)component;
        }
        return null;
    }

    public static String getSelectedTabTitle() {
        return queryTabsPane.getTitleAt(queryTabsPane.getSelectedIndex());
    }

    public static void setQueryResultTextArea(String string) {
        queryResultTextArea.append(string + "\n");
    }
}

