/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.gui.Main_JMenuBar;
import com.dandymadeproductions.ajqvue.gui.Main_JMenuBarActions;
import com.dandymadeproductions.ajqvue.gui.Main_JToolBar;
import com.dandymadeproductions.ajqvue.gui.SQLQueryBucketFrame;
import com.dandymadeproductions.ajqvue.gui.Top_JMenuBar;
import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.TopTabStaticPanel;
import com.dandymadeproductions.ajqvue.plugin.Default_JToolBar;
import com.dandymadeproductions.ajqvue.plugin.PluginLoader;
import com.dandymadeproductions.ajqvue.plugin.Plugin_Module;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Main_Frame
extends JFrame
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 9033690016117959449L;
    private TopTabStaticPanel mainTabPanel;
    private Main_JMenuBar menuBar;
    private Top_JMenuBar topMenuBar;
    private int lastTabIndex;
    private static JTabbedPane mainTabsPane = new JTabbedPane();
    private static CardLayout toolBarCardLayout = new CardLayout();
    private static JPanel toolBarPanel = new JPanel(toolBarCardLayout);
    private static DBTablesPanel dbTablesPanel;
    private static ArrayList<Plugin_Module> loadedPluginModules;
    private static SQLQueryBucketFrame sqlQueryBucketFrame;
    protected static final JButton pluginFrameListenButton;
    public static final int FRAME_DEFAULT_WIDTH = 800;
    public static final int FRAME_DEFAULT_HEIGHT = 600;

    public Main_Frame() {
        super("Ajqvue   " + ConnectionManager.getConnectionProperties().getProperty("Host") + ":" + ConnectionManager.getConnectionProperties().getProperty("DB"));
        final Main_Frame main_Frame = this;
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                sqlQueryBucketFrame.saveLastUsedList();
                ConnectionManager.shutdown("Main_Frame WINDOW_CLOSING");
                for (Plugin_Module plugin_Module : loadedPluginModules) {
                    plugin_Module.shutdown();
                }
                Utils.clearCache();
                Ajqvue.getGeneralProperties().setPosition(new Point(main_Frame.getX(), main_Frame.getY()));
                Ajqvue.getGeneralProperties().setDimension(main_Frame.getSize());
                System.exit(0);
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }
        };
        this.addWindowListener(windowAdapter);
    }

    public void createGUI() {
        AResourceBundle aResourceBundle = Ajqvue.getResourceBundle();
        String string = Utils.getFileSeparator();
        String string2 = Utils.getIconsDirectory() + string;
        ImageIcon imageIcon = aResourceBundle.getResourceImage(string2 + "mainTabIcon.png");
        ImageIcon imageIcon2 = aResourceBundle.getResourceImage(string2 + "databasetablesIcon.png");
        this.setIconImage(Utils.getFrameIcon());
        this.topMenuBar = new Top_JMenuBar(this);
        this.setJMenuBar(this.topMenuBar);
        JPanel jPanel = new JPanel(new BorderLayout());
        Default_JToolBar default_JToolBar = new Default_JToolBar("Default ToolBar");
        toolBarPanel.add("0", default_JToolBar);
        jPanel.add((Component)toolBarPanel, "First");
        mainTabsPane.setTabPlacement(4);
        mainTabsPane.setBorder(BorderFactory.createLoweredBevelBorder());
        mainTabsPane.setTabLayoutPolicy(1);
        this.mainTabPanel = new TopTabStaticPanel();
        mainTabsPane.addTab(null, imageIcon, this.mainTabPanel, "Dandy Made Productions");
        this.menuBar = new Main_JMenuBar(this);
        Main_JToolBar main_JToolBar = new Main_JToolBar(this, "Ajqvue ToolBar");
        toolBarPanel.add("1", main_JToolBar);
        mainTabsPane.add(new JPanel(), imageIcon2, 1);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Connection connection = ConnectionManager.getConnection("Main_Frame createGUI()");
                AResourceBundle aResourceBundle = Ajqvue.getResourceBundle();
                dbTablesPanel = new DBTablesPanel(connection, ConnectionManager.getTableNames());
                mainTabsPane.setComponentAt(1, dbTablesPanel);
                String string = aResourceBundle.getResourceString("Main_Frame.tab.DatabaseTables", "Database Tables");
                mainTabsPane.setToolTipTextAt(1, string);
                ConnectionManager.closeConnection(connection, "Main_Frame createGUI()");
            }
        }, "Main_Frame.createGUI(), databaseTablesThread");
        thread.start();
        new PluginLoader(this);
        mainTabsPane.addChangeListener(this);
        jPanel.add((Component)mainTabsPane, "Center");
        this.getContentPane().add(jPanel);
        this.lastTabIndex = 0;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Main_JMenuBarActions.actionsSelection(this, actionEvent, sqlQueryBucketFrame);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object != null && (JTabbedPane)object == mainTabsPane) {
            int n = ((JTabbedPane)object).getSelectedIndex();
            if (n > mainTabsPane.getTabCount()) {
                return;
            }
            if (n == 0) {
                this.mainTabPanel.resetPanel();
                this.mainTabPanel.setThreadAction(false);
            } else if (n == 1) {
                this.mainTabPanel.setThreadAction(true);
            } else {
                this.mainTabPanel.setThreadAction(true);
                if (n - 2 <= loadedPluginModules.size()) {
                    loadedPluginModules.get(n - 2).start();
                }
            }
            if (this.lastTabIndex != 0 && this.lastTabIndex != 1) {
                loadedPluginModules.get(this.lastTabIndex - 2).stop();
            }
            this.lastTabIndex = n;
            if (n == 0) {
                this.setJMenuBar(this.topMenuBar);
            } else if (n == 1) {
                this.setJMenuBar(this.menuBar);
            } else if (n - 2 <= loadedPluginModules.size()) {
                this.setJMenuBar(loadedPluginModules.get(n - 2).getControlledMenuBar());
            }
            if (n == 0) {
                toolBarCardLayout.show(toolBarPanel, "0");
            } else if (n == 1) {
                toolBarCardLayout.show(toolBarPanel, "1");
            } else {
                toolBarCardLayout.show(toolBarPanel, loadedPluginModules.get(n - 2).getName());
            }
        }
    }

    public static synchronized void addTab(Plugin_Module plugin_Module, Main_Frame main_Frame) {
        if (plugin_Module != null) {
            mainTabsPane.invalidate();
            mainTabsPane.removeChangeListener(main_Frame);
            loadedPluginModules.add(plugin_Module);
            mainTabsPane.addTab(null, plugin_Module.getControlledTabIcon(), plugin_Module.getControlledPanel(), plugin_Module.getControlledName());
            if (plugin_Module.getName().isEmpty()) {
                plugin_Module.name = Integer.toString(loadedPluginModules.size() + 1);
            }
            toolBarPanel.add(plugin_Module.getControlledName(), plugin_Module.getControlledToolBar());
            pluginFrameListenButton.doClick();
            mainTabsPane.addChangeListener(main_Frame);
            mainTabsPane.validate();
        }
    }

    public static synchronized void removeTab(int n) {
        mainTabsPane.removeTabAt(n + 2);
        if (loadedPluginModules.get(n).getToolBar() != null) {
            toolBarPanel.remove(loadedPluginModules.get(n).getToolBar());
        }
        loadedPluginModules.remove(n);
    }

    public static void reloadDBTables() {
        Connection connection = ConnectionManager.getConnection("Main_Frame reloadDBTables()");
        if (connection == null) {
            return;
        }
        try {
            String string = DBTablesPanel.getSelectedTableTabPanel() != null ? DBTablesPanel.getSelectedTableTabPanel().getTableName() : "";
            ConnectionManager.loadDBTables(connection);
            DBTablesPanel.reloadPanel(connection, ConnectionManager.getTableNames());
            dbTablesPanel.repaint();
            for (Plugin_Module plugin_Module : loadedPluginModules) {
                plugin_Module.setDBTables(ConnectionManager.getTableNames());
            }
            if (!string.equals("")) {
                DBTablesPanel.setSelectedTableTabPanel(string);
            }
            mainTabsPane.validate();
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "Main_Frame reloadDBTables()");
        }
        ConnectionManager.closeConnection(connection, "Main_Frame reloadDBTables()");
    }

    public void loadQueryBucketList() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                sqlQueryBucketFrame.setSize(600, 450);
                sqlQueryBucketFrame.setResizable(true);
                sqlQueryBucketFrame.center();
                sqlQueryBucketFrame.openLastUsedList(ConnectionManager.getConnectionProperties().getProperty("DB"));
            }
        }, "Main_Frame.loadQueryBucketList");
        thread.start();
    }

    public static ArrayList<Plugin_Module> getPlugins() {
        return loadedPluginModules;
    }

    public static SQLQueryBucketFrame getSQLBucket() {
        return sqlQueryBucketFrame;
    }

    protected void setFontSize(int n) {
        Ajqvue.getGeneralProperties().setFontSize(n);
        Utils.setUIManagerFont(n);
        try {
            SwingUtilities.updateComponentTreeUI(this);
            SwingUtilities.updateComponentTreeUI(this.menuBar);
        }
        catch (Exception exception) {
            System.err.println("Failed to update UI Tree.");
        }
    }

    static {
        loadedPluginModules = new ArrayList();
        sqlQueryBucketFrame = new SQLQueryBucketFrame();
        pluginFrameListenButton = new JButton();
    }
}

