/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.datasource.ConnectionProperties;
import com.dandymadeproductions.ajqvue.datasource.DatabaseProperties;
import com.dandymadeproductions.ajqvue.gui.LoginManagerFrame;
import com.dandymadeproductions.ajqvue.gui.SiteParameters;
import com.dandymadeproductions.ajqvue.gui.XMLTranslator;
import com.dandymadeproductions.ajqvue.gui.panels.AdvancedParametersPanel;
import com.dandymadeproductions.ajqvue.gui.panels.GraphicsCanvasPanel;
import com.dandymadeproductions.ajqvue.gui.panels.SplashPanel;
import com.dandymadeproductions.ajqvue.gui.panels.StandardParametersPanel;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.NormalizeString;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class LoginFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 3415491604328645598L;
    private LoginManagerFrame loginManagerFrame;
    private AResourceBundle resourceBundle;
    private JWindow splashWindow;
    private SplashPanel splashPanel;
    private String resource;
    private String fileSeparator;
    private JMenuBar accessDialogMenuBar;
    private JButton loginManagerFrame_AccessButton;
    private JButton advancedOptionsButton;
    private StandardParametersPanel standardParametersPanel;
    private AdvancedParametersPanel advancedParametersPanel;
    private JCheckBox sshCheckBox;
    private JButton validLoginButton;
    private JButton loginButton;
    private JButton cancelButton;
    private ArrayList<String> sitesNameList;
    private ArrayList<String> driverList;
    private ArrayList<String> protocolList;
    private ArrayList<String> subProtocolList;
    private ArrayList<String> hostList;
    private ArrayList<String> portList;
    private ArrayList<String> databaseList;
    private ArrayList<String> userList;
    private transient HashMap<String, SiteParameters> sites;
    private transient SiteParameters lastSite;
    private transient XMLTranslator xmlTranslator;
    private transient NormalizeString normString;
    private JButton loginManagerFrame_SaveExitButton;
    private JButton loginManagerFrame_CancelButton;
    private boolean loggedIn = false;
    private boolean advancedOptionsShowing = false;

    public LoginFrame(JButton jButton) {
        this.validLoginButton = jButton;
        this.resourceBundle = Ajqvue.getResourceBundle();
        this.resource = this.resourceBundle.getResourceString("LoginFrame.message.Title", "Login");
        this.setTitle("Ajqvue " + this.resource);
        this.setIconImage(Utils.getFrameIcon());
        this.setDefaultCloseOperation(3);
        this.xmlTranslator = new XMLTranslator();
        this.normString = new NormalizeString();
        this.sites = new HashMap();
        this.sitesNameList = new ArrayList();
        this.driverList = new ArrayList();
        this.protocolList = new ArrayList();
        this.subProtocolList = new ArrayList();
        this.hostList = new ArrayList();
        this.portList = new ArrayList();
        this.databaseList = new ArrayList();
        this.userList = new ArrayList();
        this.fileSeparator = Utils.getFileSeparator();
        String string = Utils.getIconsDirectory() + this.fileSeparator;
        ImageIcon imageIcon = new ImageIcon(string + "connectionManagerIcon.png");
        ImageIcon imageIcon2 = new ImageIcon(string + "advancedConnectionsIcon.png");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("k");
        int n = Integer.parseInt(simpleDateFormat.format(new Date()));
        ImageIcon imageIcon3 = n >= 5 && n <= 10 ? new ImageIcon(string + "loginFrameIconA.gif") : (n >= 11 && n <= 16 ? new ImageIcon(string + "loginFrameIconB.gif") : (n >= 17 && n <= 21 ? new ImageIcon(string + "loginFrameIconC.gif") : new ImageIcon(string + "loginFrameIconD.gif")));
        ImageIcon imageIcon4 = new ImageIcon("images" + this.fileSeparator + "Ajqvue_Logo.png");
        ImageIcon imageIcon5 = new ImageIcon(string + "sshUpIcon.png");
        ImageIcon imageIcon6 = new ImageIcon(string + "sshDownIcon.png");
        this.accessDialogMenuBar = new JMenuBar();
        this.accessDialogMenuBar.setBorder(BorderFactory.createEtchedBorder());
        this.accessDialogMenuBar.setMargin(new Insets(0, 0, 0, 0));
        if (this.xmlTranslator.getXMLTranslatorResult()) {
            this.sites = this.xmlTranslator.getSites();
            this.lastSite = this.xmlTranslator.getLastSite();
            this.sites.put(this.lastSite.getSiteName(), this.lastSite);
        } else {
            this.fillSitesDefaults();
        }
        this.resource = this.resourceBundle.getResourceString("LoginFrame.menu.Sites", "Sites");
        JMenu jMenu = new JMenu(this.resource);
        this.resource = this.resourceBundle.getResourceString("LoginFrame.tooltip.SiteSelection", "Site Selection");
        jMenu.setToolTipText(this.resource);
        this.fillSiteDataStructures(jMenu);
        this.accessDialogMenuBar.add(jMenu);
        this.loginManagerFrame_AccessButton = new JButton(imageIcon);
        this.loginManagerFrame_AccessButton.setFocusable(false);
        this.loginManagerFrame_AccessButton.setMargin(new Insets(0, 0, 0, 0));
        this.resource = this.resourceBundle.getResourceString("LoginFrame.tooltip.LoginManager", "Login Manager");
        this.loginManagerFrame_AccessButton.setToolTipText(this.resource);
        if (this.xmlTranslator.getXMLTranslatorResult()) {
            this.loginManagerFrame_AccessButton.addActionListener(this);
        } else {
            this.loginManagerFrame_AccessButton.setEnabled(false);
        }
        this.accessDialogMenuBar.add(this.loginManagerFrame_AccessButton);
        this.advancedOptionsButton = new JButton(imageIcon2);
        this.advancedOptionsButton.setFocusable(false);
        this.advancedOptionsButton.setMargin(new Insets(0, 0, 0, 0));
        this.resource = this.resourceBundle.getResourceString("LoginFrame.tooltip.AdvancedOptions", "Advanced Options");
        this.advancedOptionsButton.setToolTipText(this.resource);
        this.advancedOptionsButton.addActionListener(this);
        this.accessDialogMenuBar.add(this.advancedOptionsButton);
        this.accessDialogMenuBar.add(Box.createHorizontalGlue());
        JButton jButton2 = new JButton(imageIcon3);
        jButton2.setPressedIcon(imageIcon3);
        jButton2.setDisabledIcon(imageIcon3);
        jButton2.setFocusPainted(false);
        jButton2.setMargin(new Insets(1, 0, 0, 0));
        jButton2.setBorder(BorderFactory.createEtchedBorder());
        this.accessDialogMenuBar.add(jButton2);
        this.setJMenuBar(this.accessDialogMenuBar);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel(gridBagLayout);
        GraphicsCanvasPanel graphicsCanvasPanel = new GraphicsCanvasPanel(imageIcon4.getImage());
        graphicsCanvasPanel.setBorder(BorderFactory.createEtchedBorder());
        graphicsCanvasPanel.add(new JLabel(imageIcon4));
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 20.0, 100.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(graphicsCanvasPanel, gridBagConstraints);
        jPanel2.add(graphicsCanvasPanel);
        this.standardParametersPanel = new StandardParametersPanel(this.resourceBundle, this.hostList, this.databaseList, this.userList);
        this.standardParametersPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 40.0, 100.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.standardParametersPanel, gridBagConstraints);
        jPanel2.add(this.standardParametersPanel);
        this.advancedParametersPanel = new AdvancedParametersPanel(this.resourceBundle, this.driverList, this.protocolList, this.subProtocolList, this.portList);
        this.advancedParametersPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 40.0, 100.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.advancedParametersPanel, gridBagConstraints);
        jPanel2.add(this.advancedParametersPanel);
        this.advancedParametersPanel.setVisible(false);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createRaisedBevelBorder());
        this.resource = this.resourceBundle.getResourceString("LoginFrame.checkbox.SSH", "SSH");
        this.sshCheckBox = new JCheckBox(this.resource, imageIcon5);
        this.sshCheckBox.setSelectedIcon(imageIcon6);
        this.sshCheckBox.setHorizontalTextPosition(10);
        this.sshCheckBox.setFocusPainted(false);
        jPanel3.add(this.sshCheckBox);
        this.resource = this.resourceBundle.getResourceString("LoginFrame.button.cancel", "cancel");
        this.cancelButton = new JButton(this.resource);
        this.cancelButton.addActionListener(this);
        jPanel3.add(this.cancelButton);
        this.resource = this.resourceBundle.getResourceString("LoginFrame.button.login", "login");
        this.loginButton = new JButton(this.resource);
        this.loginButton.addActionListener(this);
        jPanel3.add(this.loginButton);
        this.setSelectedSite(this.lastSite);
        jPanel.add((Component)jPanel3, "South");
        this.getContentPane().add(jPanel);
        this.getRootPane().setDefaultButton(this.loginButton);
        this.resource = this.resourceBundle.getResourceString("LoginFrame.button.saveandexit", "save and exit");
        this.loginManagerFrame_SaveExitButton = new JButton(this.resource);
        this.loginManagerFrame_SaveExitButton.addActionListener(this);
        this.resource = this.resourceBundle.getResourceString("LoginFrame.button.cancel", "cancel");
        this.loginManagerFrame_CancelButton = new JButton(this.resource);
        this.loginManagerFrame_CancelButton.addActionListener(this);
    }

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem;
        String string;
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            JButton jButton = (JButton)object;
            if (jButton == this.loginManagerFrame_AccessButton) {
                if (this.loginManagerFrame == null) {
                    StandardParametersPanel standardParametersPanel = new StandardParametersPanel(this.resourceBundle, this.hostList, this.databaseList, this.userList);
                    standardParametersPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
                    AdvancedParametersPanel advancedParametersPanel = new AdvancedParametersPanel(this.resourceBundle, this.driverList, this.protocolList, this.subProtocolList, this.portList);
                    advancedParametersPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
                    this.loginManagerFrame = new LoginManagerFrame(this.resourceBundle, this.sites, this.normString, standardParametersPanel, advancedParametersPanel, this.loginManagerFrame_SaveExitButton, this.loginManagerFrame_CancelButton);
                    this.loginManagerFrame.pack();
                    this.loginManagerFrame.setResizable(true);
                    this.loginManagerFrame.center(-50, 50);
                    this.loginManagerFrame.setVisible(true);
                } else {
                    this.loginManagerFrame.setVisible(false);
                    this.loginManagerFrame.dispose();
                    this.loginManagerFrame = null;
                }
            } else if (jButton == this.advancedOptionsButton) {
                if (this.advancedOptionsShowing) {
                    this.advancedParametersPanel.setVisible(false);
                    this.advancedOptionsShowing = false;
                } else {
                    this.advancedParametersPanel.setVisible(true);
                    this.advancedOptionsShowing = true;
                }
                this.pack();
            } else if (jButton == this.loginButton) {
                this.setVisible(false);
                if (this.accessCheck()) {
                    if (this.xmlTranslator.getXMLTranslatorResult()) {
                        this.lastSite.setSiteName("Last Site");
                        this.lastSite.setDriver(this.advancedParametersPanel.getDriver());
                        this.lastSite.setProtocol(this.advancedParametersPanel.getProtocol());
                        this.lastSite.setSubProtocol(this.advancedParametersPanel.getSubProtocol());
                        this.lastSite.setHost(this.standardParametersPanel.getHost());
                        this.lastSite.setPort(this.advancedParametersPanel.getPort());
                        this.lastSite.setDatabase(this.standardParametersPanel.getDatabase());
                        this.lastSite.setUser(this.standardParametersPanel.getUser());
                        this.lastSite.setPassword(" ".toCharArray());
                        if (this.sshCheckBox.isSelected()) {
                            this.lastSite.setSsh("1");
                        } else {
                            this.lastSite.setSsh("0");
                        }
                        this.xmlTranslator.setLastSite(this.lastSite);
                    }
                    if (this.loginManagerFrame != null) {
                        this.loginManagerFrame.setVisible(false);
                        this.loginManagerFrame.dispose();
                        this.loginManagerFrame = null;
                    }
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(1000L);
                                LoginFrame.this.splashPanel.suspendPanel(true);
                                LoginFrame.this.splashWindow.dispose();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }, "LoginFrame.splashDelayThread");
                    thread.start();
                    this.validLoginButton.doClick();
                } else {
                    this.standardParametersPanel.setPassword(" ".toCharArray());
                    this.setVisible(true);
                }
            } else if (jButton == this.cancelButton) {
                this.dispose();
            } else if (jButton == this.loginManagerFrame_SaveExitButton) {
                this.sites = this.loginManagerFrame.getSites();
                this.loginManagerFrame.setVisible(false);
                this.loginManagerFrame.dispose();
                this.loginManagerFrame = null;
                this.resource = this.resourceBundle.getResourceString("LoginFrame.menu.Sites", "Sites");
                JMenu jMenu = new JMenu(this.resource);
                this.resource = this.resourceBundle.getResourceString("LoginFrame.tooltip.SiteSelection", "Site Selection");
                jMenu.setToolTipText(this.resource);
                this.fillSiteDataStructures(jMenu);
                this.accessDialogMenuBar.remove(0);
                this.accessDialogMenuBar.add((Component)jMenu, 0);
                this.setJMenuBar(this.accessDialogMenuBar);
                this.xmlTranslator.setSites(this.sites);
            } else if (jButton == this.loginManagerFrame_CancelButton) {
                this.loginManagerFrame.setVisible(false);
                this.loginManagerFrame.dispose();
                this.loginManagerFrame = null;
            }
        } else if (object instanceof JMenuItem && !(string = (jMenuItem = (JMenuItem)object).getActionCommand()).equals("Cut") && !string.equals("Copy") && !string.equals("Paste")) {
            SiteParameters siteParameters = this.sites.get(string);
            this.setSelectedSite(siteParameters);
        }
    }

    private void fillSiteDataStructures(JMenu jMenu) {
        Object object;
        String string;
        String string2;
        jMenu.removeAll();
        Iterator<Map.Entry<String, SiteParameters>> iterator = this.sites.entrySet().iterator();
        TreeSet<String> treeSet = new TreeSet<String>();
        while (iterator.hasNext()) {
            string2 = iterator.next().getKey();
            if (!string2.equals("Last Site") && string2.indexOf(35) != -1) {
                string2 = string2.substring(0, string2.indexOf(35));
            } else {
                jMenu.add(this.createMenuItem(string2, string2));
            }
            if (treeSet.contains(string2) || string2.equals("Last Site")) continue;
            treeSet.add(string2);
        }
        Iterator iterator2 = treeSet.iterator();
        HashMap<String, JMenu> hashMap = new HashMap<String, JMenu>();
        while (iterator2.hasNext()) {
            string = (String)iterator2.next();
            object = new JMenu(string);
            hashMap.put(string, (JMenu)object);
            jMenu.add((JMenuItem)object);
        }
        this.driverList.clear();
        this.protocolList.clear();
        this.subProtocolList.clear();
        this.hostList.clear();
        this.portList.clear();
        this.databaseList.clear();
        this.userList.clear();
        for (Map.Entry<String, SiteParameters> entry : this.sites.entrySet()) {
            SiteParameters siteParameters;
            string2 = entry.getKey();
            this.sitesNameList.add(string2);
            if (!string2.equals("Last Site") && string2.indexOf(35) != -1) {
                string = string2.substring(0, string2.indexOf(35));
                object = string2.substring(string2.indexOf(35) + 1);
                JMenu jMenu2 = (JMenu)hashMap.get(string);
                jMenu2.add(this.createMenuItem((String)object, string2));
            }
            if (!this.driverList.contains((siteParameters = entry.getValue()).getDriver())) {
                this.driverList.add(siteParameters.getDriver());
            }
            if (!this.protocolList.contains(siteParameters.getProtocol())) {
                this.protocolList.add(siteParameters.getProtocol());
            }
            if (!this.subProtocolList.contains(siteParameters.getSubProtocol())) {
                this.subProtocolList.add(siteParameters.getSubProtocol());
            }
            if (!this.hostList.contains(siteParameters.getHost())) {
                this.hostList.add(siteParameters.getHost());
            }
            if (!this.portList.contains(siteParameters.getPort())) {
                this.portList.add(siteParameters.getPort());
            }
            if (!this.databaseList.contains(siteParameters.getDatabase())) {
                this.databaseList.add(siteParameters.getDatabase());
            }
            if (this.userList.contains(siteParameters.getUser())) continue;
            this.userList.add(siteParameters.getUser());
        }
    }

    private void fillSitesDefaults() {
        String[] stringArray = new String[]{"com.mysql.jdbc.Driver", "org.postgresql.Driver", "org.hsqldb.jdbcDriver", "oracle.jdbc.driver.OracleDriver", "org.sqlite.JDBC", "sun.jdbc.odbc.JdbcOdbcDriver", "org.apache.derby.jdbc.ClientDriver", "org.h2.Driver"};
        String[] stringArray2 = new String[]{"mysql", "postgresql", "hsqldb:hsql", "oracle:thin", "sqlite", "odbc", "derby", "h2"};
        String[] stringArray3 = new String[]{"3306", "5432", "9001", "1521", "0000", "0000", "1527", "9092"};
        String[] stringArray4 = new String[]{"mysql", "postgresql", "hsql;", "oracle", "test/sqlite_test.db", "ms_access", "test/derby_db/toursdb", "test/h2_db/h2_test"};
        this.driverList.clear();
        this.protocolList.clear();
        this.subProtocolList.clear();
        this.hostList.clear();
        this.portList.clear();
        this.databaseList.clear();
        this.userList.clear();
        for (int i = 0; i < stringArray4.length; ++i) {
            String string = "LocalHost#" + stringArray4[i];
            SiteParameters siteParameters = new SiteParameters();
            siteParameters.setSiteName("LocalHost");
            siteParameters.setDriver(stringArray[i]);
            siteParameters.setProtocol("jdbc");
            siteParameters.setSubProtocol(stringArray2[i]);
            siteParameters.setHost("127.0.0.1");
            siteParameters.setPort(stringArray3[i]);
            siteParameters.setDatabase(stringArray4[i]);
            siteParameters.setUser("");
            siteParameters.setPassword("".toCharArray());
            siteParameters.setSsh("0");
            this.sites.put(string, siteParameters);
            this.sitesNameList.add(string);
            if (!this.driverList.contains(siteParameters.getDriver())) {
                this.driverList.add(siteParameters.getDriver());
            }
            if (!this.protocolList.contains(siteParameters.getProtocol())) {
                this.protocolList.add(siteParameters.getProtocol());
            }
            if (!this.subProtocolList.contains(siteParameters.getSubProtocol())) {
                this.subProtocolList.add(siteParameters.getSubProtocol());
            }
            if (!this.hostList.contains(siteParameters.getHost())) {
                this.hostList.add(siteParameters.getHost());
            }
            if (!this.portList.contains(siteParameters.getPort())) {
                this.portList.add(siteParameters.getPort());
            }
            if (!this.databaseList.contains(siteParameters.getDatabase())) {
                this.databaseList.add(siteParameters.getDatabase());
            }
            if (this.userList.contains(siteParameters.getUser())) continue;
            this.userList.add(siteParameters.getUser());
        }
    }

    private JMenuItem createMenuItem(String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(string2);
        return jMenuItem;
    }

    private void setSelectedSite(SiteParameters siteParameters) {
        if (siteParameters == null) {
            return;
        }
        this.advancedParametersPanel.setDriver(siteParameters.getDriver());
        this.advancedParametersPanel.setProtocol(siteParameters.getProtocol());
        this.advancedParametersPanel.setSubProtocol(siteParameters.getSubProtocol());
        this.standardParametersPanel.setHostItem(siteParameters.getHost());
        this.advancedParametersPanel.setPort(siteParameters.getPort());
        this.standardParametersPanel.setDatabaseItem(siteParameters.getDatabase());
        this.standardParametersPanel.setUserItem(siteParameters.getUser());
        this.standardParametersPanel.setPassword(XMLTranslator.textConversion(this.normString.execute(String.valueOf(siteParameters.getPassword()), false), true));
        if (siteParameters.getSsh().equals("0")) {
            this.sshCheckBox.setSelected(false);
        } else {
            this.sshCheckBox.setSelected(true);
        }
    }

    private boolean accessCheck() {
        if (this.advancedParametersPanel.getDriver().equals("") || this.advancedParametersPanel.getProtocol().equals("") || this.advancedParametersPanel.getSubProtocol().equals("") || this.standardParametersPanel.getHost().equals("") || this.advancedParametersPanel.getPort().equals("") || this.standardParametersPanel.getUser().equals("")) {
            this.loggedIn = false;
        } else {
            String string;
            String string2;
            try {
                string2 = this.advancedParametersPanel.getDriver();
                if (Ajqvue.getDebug()) {
                    System.out.println("LoginFrame accessCheck() Driver: " + string2);
                }
                if (this.advancedParametersPanel.getSubProtocol().indexOf("sqlite") != -1) {
                    System.setProperty("sqlite.purejava", "true");
                }
                Class.forName(string2);
                if (Ajqvue.getDebug()) {
                    System.out.println("LoginFrame accessCheck() Driver Loaded");
                }
            }
            catch (Exception exception) {
                String string3;
                String string4 = exception.getMessage();
                if (string4 != null && string4.length() > 200) {
                    string4 = string4.substring(0, 200);
                }
                if ((string3 = System.getProperty("java.ext.dirs")) == null || string3.equals("")) {
                    string3 = "Java JRE/lib/ext";
                }
                String string5 = "Unable to Find or Load JDBC Driver\nInsure the Appropriate JDBC Driver is Located in the \n" + string3 + this.fileSeparator + " directory.\nExeception: " + string4;
                JOptionPane.showMessageDialog(null, string5, "Alert", 0);
                this.loggedIn = false;
                return false;
            }
            ConnectionProperties connectionProperties = new ConnectionProperties();
            Properties properties = new Properties();
            String string6 = this.advancedParametersPanel.getProtocol();
            String string7 = this.advancedParametersPanel.getSubProtocol().toLowerCase(Locale.ENGLISH);
            String string8 = this.standardParametersPanel.getHost();
            String string9 = this.advancedParametersPanel.getPort();
            String string10 = this.standardParametersPanel.getDatabase();
            String string11 = this.standardParametersPanel.getUser();
            properties.setProperty("user", string11);
            String string12 = "";
            char[] cArray = this.standardParametersPanel.getPassword();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < cArray.length; ++i) {
                stringBuffer.append(cArray[i]);
                cArray[i] = 48;
            }
            string12 = stringBuffer.toString();
            if (string7.indexOf("hsql") != -1 || string7.equals("derby") || string7.equals("postgresql") || string7.equals("mariadb") || string7.equals("mysql")) {
                string12 = string12.replaceAll("%", "%" + Integer.toHexString(37));
            }
            properties.setProperty("password", string12);
            if (this.sshCheckBox.isSelected()) {
                string = "true";
                if (string7.indexOf("hsql") != -1 || string7.equals("mariadb") || string7.equals("mysql") || string7.equals("postgresql")) {
                    properties.setProperty("useSSL", "1");
                }
            } else {
                string = "false";
            }
            if (string10.indexOf("?") != -1) {
                String[] stringArray = "?".equals("?") ? string10.split("\\?") : string10.split("?");
                string10 = stringArray[0];
                String[] stringArray2 = stringArray[1].split("&");
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (stringArray2[i].indexOf("=") == -1) continue;
                    properties.setProperty(stringArray2[i].substring(0, stringArray2[i].indexOf("=")), stringArray2[i].substring(stringArray2[i].indexOf("=") + 1, stringArray2[i].length()));
                }
            }
            connectionProperties.setProperties(properties);
            connectionProperties.setProperty("Driver", string2);
            connectionProperties.setProperty("Protocol", string6);
            connectionProperties.setProperty("SubProtocol", string7);
            connectionProperties.setProperty("Host", string8);
            connectionProperties.setProperty("Port", string9);
            connectionProperties.setProperty("DB", string10);
            connectionProperties.setProperty("User", string11);
            connectionProperties.setProperty("Password", string12);
            connectionProperties.setProperty("SSH", string);
            String string13 = ConnectionManager.createConnectionURLString(connectionProperties);
            if (Ajqvue.getDebug()) {
                System.out.println("LoginFrame accessCheck() Connection URL: " + string13);
                System.out.println("LoginFrame accessCheck() Connection Properties: " + connectionProperties.toString());
            }
            connectionProperties.setConnectionURLString(string13);
            try {
                Connection connection = DriverManager.getConnection(string13, properties);
                if (Ajqvue.getDebug()) {
                    System.out.println("LoginFrame accessCheck() Connection Established Initializing:");
                }
                this.createSplashWindow();
                ConnectionManager.setConnectionProperties(connectionProperties);
                DatabaseProperties databaseProperties = new DatabaseProperties(connectionProperties);
                databaseProperties.init(connection);
                ConnectionManager.setDatabaseProperties(databaseProperties);
                databaseProperties.overideDefaults();
                databaseProperties.loadDBTables(connection);
                if (string7.equals("sqlite") && string10.toLowerCase(Locale.ENGLISH).equals(":memory:") || string7.indexOf("hsql") != -1 && string10.toLowerCase(Locale.ENGLISH).indexOf("mem:") != -1 || string7.equals("derby") && string10.toLowerCase(Locale.ENGLISH).indexOf("memory:") != -1 || string7.equals("h2") && string10.toLowerCase(Locale.ENGLISH).indexOf("mem:") != -1) {
                    ConnectionManager.setMemoryConnection(DriverManager.getConnection(string13, properties));
                }
                connection.close();
                this.loggedIn = true;
            }
            catch (SQLException sQLException) {
                if (this.splashPanel != null) {
                    this.splashPanel.suspendPanel(true);
                    this.splashWindow.dispose();
                }
                this.loggedIn = false;
                ConnectionManager.displaySQLErrors(sQLException, "LoginFrame accessCheck()");
                return false;
            }
        }
        return this.loggedIn;
    }

    private void createSplashWindow() {
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = new Dimension(420, 315);
        this.splashWindow = new JWindow();
        this.splashWindow.getContentPane().setLayout(new BorderLayout());
        this.splashWindow.setSize(dimension2);
        this.splashPanel = new SplashPanel(this.resourceBundle);
        Thread thread = new Thread((Runnable)this.splashPanel, "SplashPanelThread");
        thread.start();
        this.splashWindow.getContentPane().add((Component)this.splashPanel, "Center");
        this.splashWindow.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.splashWindow.setVisible(true);
    }

    public void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setLocation(n, n2);
    }
}

