/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.gui.HelpFrame;
import com.dandymadeproductions.ajqvue.gui.panels.CreditsPanel;
import com.dandymadeproductions.ajqvue.gui.panels.GraphicsCanvasPanel;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

class AboutFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -5650626289707582042L;
    private CreditsPanel creditsPanel;
    private JButton licenseButton;
    private JButton readmeButton;
    private JButton closeButton;
    private transient WindowListener aboutFrameListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            AboutFrame.this.creditsPanel.suspendPanel(true);
            AboutFrame.this.dispose();
        }
    };

    protected AboutFrame(ImageIcon imageIcon) {
        AResourceBundle aResourceBundle = Ajqvue.getResourceBundle();
        String string = aResourceBundle.getResourceString("AboutFrame.message.Title", "About");
        this.setTitle(string + " Ajqvue");
        this.setIconImage(Utils.getFrameIcon());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        GraphicsCanvasPanel graphicsCanvasPanel = new GraphicsCanvasPanel(imageIcon.getImage());
        graphicsCanvasPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        Utils.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 30.0, 100.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(graphicsCanvasPanel, gridBagConstraints);
        jPanel2.add(graphicsCanvasPanel);
        this.creditsPanel = new CreditsPanel();
        Thread thread = new Thread((Runnable)this.creditsPanel, "Credits");
        thread.start();
        Utils.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 70.0, 100.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.creditsPanel, gridBagConstraints);
        jPanel2.add(this.creditsPanel);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        string = aResourceBundle.getResourceString("AboutFrame.button.ReadMe", "Read Me");
        this.readmeButton = new JButton(string);
        this.readmeButton.setFocusPainted(false);
        this.readmeButton.addActionListener(this);
        jPanel3.add(this.readmeButton);
        string = aResourceBundle.getResourceString("AboutFrame.button.License", "License");
        this.licenseButton = new JButton(string);
        this.licenseButton.setFocusPainted(false);
        this.licenseButton.addActionListener(this);
        jPanel3.add(this.licenseButton);
        string = aResourceBundle.getResourceString("AboutFrame.button.Close", "Close");
        this.closeButton = new JButton(string);
        this.closeButton.setFocusPainted(false);
        this.closeButton.addActionListener(this);
        jPanel3.add(this.closeButton);
        jPanel.add((Component)jPanel3, "South");
        this.getContentPane().add(jPanel);
        this.addWindowListener(this.aboutFrameListener);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            if (object == this.readmeButton) {
                Thread thread = new Thread((Runnable)new HelpFrameThread("Ajqvue Readme", "/docs/Release/readme.html"), "HelpFrameThread Readme");
                thread.start();
                return;
            }
            if (object == this.licenseButton) {
                Thread thread = new Thread((Runnable)new HelpFrameThread("Ajqvue Legal", "/docs/Release/legal.html"), "HelpFrameThread Legal");
                thread.start();
                return;
            }
            if (object == this.closeButton) {
                this.creditsPanel.suspendPanel(true);
                this.dispose();
            }
        }
    }

    protected void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setLocation(n, n2);
    }

    protected static class HelpFrameThread
    implements Runnable {
        String title;
        String document;

        protected HelpFrameThread(String string, String string2) {
            this.title = string;
            this.document = string2;
        }

        @Override
        public void run() {
            HelpFrame helpFrame = new HelpFrame(this.title, this.document, null);
            if (helpFrame.failedToLoadContents) {
                helpFrame.dispose();
            } else {
                helpFrame.setSize(Ajqvue.getGeneralProperties().getDimension());
                helpFrame.setLocation(Ajqvue.getGeneralProperties().getPosition());
                helpFrame.setVisible(true);
            }
        }
    }
}

