/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.datasource;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionProperties;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

public class DatabaseProperties {
    private ConnectionProperties connectionProperties;
    private String db;
    private String subProtocol;
    private ArrayList<String> schemas;
    private ArrayList<String> tables;
    private String[] tableTypes;
    private String dbType;
    private String catalog;
    private String schemaPattern;
    private String tableNamePattern;
    private String dbProductNameVersion;
    private String catalogSeparator;
    private String identifierQuoteString;
    private int maxColumnNameLength;
    private boolean filter;
    private static final String TABLE_SCHEM = "TABLE_SCHEM";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String TABLE_TYPE = "TABLE_TYPE";
    private static final String CONFIGURATION_FILE_NAME = "ajqvue.conf";

    public DatabaseProperties(ConnectionProperties connectionProperties) {
        this(connectionProperties, true);
    }

    public DatabaseProperties(ConnectionProperties connectionProperties, boolean bl) {
        this.connectionProperties = connectionProperties;
        this.filter = bl;
        this.db = connectionProperties.getProperty("DB");
        this.subProtocol = connectionProperties.getProperty("SubProtocol");
        this.schemas = new ArrayList();
        this.tables = new ArrayList();
    }

    public void init(Connection connection) throws SQLException {
        if (this.db.indexOf(";") != -1) {
            this.db = this.db.substring(0, this.db.indexOf(";"));
        }
        if (this.subProtocol.indexOf("hsql") != -1) {
            this.catalog = null;
            this.schemaPattern = "%";
            this.tableNamePattern = "%";
            this.dbType = "hsql";
        } else if (this.subProtocol.indexOf("oracle") != -1) {
            this.catalog = this.db;
            this.schemaPattern = "%";
            this.tableNamePattern = "%";
            this.dbType = "oracle";
        } else if (this.subProtocol.equals("mysql") || this.subProtocol.equals("mariadb") || this.subProtocol.equals("postgresql")) {
            this.catalog = this.db;
            this.schemaPattern = "";
            this.tableNamePattern = "%";
            this.dbType = this.subProtocol.equals("mysql") ? "mysql" : (this.subProtocol.equals("mariadb") ? "mariadb" : "postgresql");
        } else if (this.subProtocol.equals("sqlite")) {
            this.catalog = this.db;
            this.schemaPattern = null;
            this.tableNamePattern = null;
            this.dbType = "sqlite";
        } else if (this.subProtocol.equals("derby")) {
            this.catalog = this.db;
            this.schemaPattern = null;
            this.tableNamePattern = "%";
            this.dbType = "derby";
        } else if (this.subProtocol.equals("h2")) {
            this.catalog = null;
            this.schemaPattern = null;
            this.tableNamePattern = "%";
            this.dbType = "h2";
        } else if (this.subProtocol.equals("sqlserver")) {
            this.catalog = this.db;
            this.schemaPattern = null;
            this.tableNamePattern = "%";
            this.dbType = "sqlserver";
        } else {
            this.catalog = null;
            this.schemaPattern = null;
            this.tableNamePattern = null;
            this.dbType = "other";
        }
        if (this.db.toLowerCase(Locale.ENGLISH).equals("null")) {
            this.catalog = null;
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            this.dbProductNameVersion = !databaseMetaData.getDatabaseProductName().isEmpty() ? databaseMetaData.getDatabaseProductName() + " " : (this.subProtocol.equals("mysql") ? "MySQL " : (this.subProtocol.equals("mariadb") ? "MarianDB " : (this.subProtocol.equals("postgresql") ? "PostgreSQL " : (this.subProtocol.indexOf("hsql") != -1 ? "HSQL " : (this.subProtocol.indexOf("oracle") != -1 ? "Oracle " : (this.subProtocol.equals("sqlite") ? "SQLite " : (this.subProtocol.equals("odbc") ? "MS Access " : (this.subProtocol.equals("sqlserver") ? "Microsoft SQL Server " : (this.subProtocol.equals("derby") ? "Apache Derby " : (this.subProtocol.equals("h2") ? "H2 " : "Unknown Data Source "))))))))));
            if (!databaseMetaData.getDatabaseProductVersion().isEmpty()) {
                this.dbProductNameVersion = this.dbProductNameVersion + databaseMetaData.getDatabaseProductVersion();
            }
            this.catalogSeparator = databaseMetaData.getCatalogSeparator();
            if (this.catalogSeparator == null || this.catalogSeparator.equals("")) {
                this.catalogSeparator = ".";
            }
            this.identifierQuoteString = databaseMetaData.getIdentifierQuoteString();
            if (this.identifierQuoteString == null || this.identifierQuoteString.equals(" ")) {
                this.identifierQuoteString = "";
            }
            this.maxColumnNameLength = databaseMetaData.getMaxColumnNameLength();
            int n = 0;
            ResultSet resultSet = databaseMetaData.getTableTypes();
            while (resultSet.next()) {
                ++n;
            }
            this.tableTypes = new String[n];
            n = 0;
            resultSet = databaseMetaData.getTableTypes();
            while (resultSet.next()) {
                this.tableTypes[n] = resultSet.getString(TABLE_TYPE);
                ++n;
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new SQLException("DatabaseProperties init() " + sQLException);
        }
    }

    public void loadDBTables(Connection connection) throws SQLException {
        try {
            String string6;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(this.catalog, this.schemaPattern, this.tableNamePattern, this.tableTypes);
            HashSet<String> hashSet = new HashSet<String>();
            String[] stringArray = new String[]{"CTXSYS", "DBSNMP", "DSSYS", "MDSYS", "ODM", "ODM_MTR", "OLAPSYS", "ORDPLUGINS", "ORDSYS", "OUTLN", "PERFSTAT", "REPADMIN", "SYS", "SYSTEM", "TRACESVR", "TSMSYS", "WKPROXY", "WKSYS", "WMSYS", "XDB"};
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
            this.schemas.clear();
            this.tables.clear();
            while (resultSet.next()) {
                String string2 = resultSet.getString(TABLE_SCHEM);
                string6 = resultSet.getString(TABLE_NAME);
                String string3 = resultSet.getString(TABLE_TYPE);
                if (string3 == null || string3.indexOf("INDEX") != -1 || string3.indexOf("SEQUENCE") != -1 || string3.indexOf("SYNONYM") != -1 || !string3.equals("TABLE") && !string3.equals("BASE TABLE") && !string3.equals("VIEW") && this.filter || this.subProtocol.indexOf("oracle") != -1 && this.filter && (hashSet.contains(string2) || string2.indexOf("FLOWS") != -1 || string2.indexOf("APEX") != -1 || string6.indexOf("BIN$") != -1) || this.subProtocol.indexOf("sqlserver") != -1 && this.filter && (string2.toUpperCase(Locale.ENGLISH).indexOf("SYS") != -1 || string2.toUpperCase(Locale.ENGLISH).indexOf("INFORMATION_SCHEMA") != -1)) continue;
                if (string2 != null && !string2.equals("")) {
                    this.tables.add(string2 + this.catalogSeparator + string6);
                    continue;
                }
                this.tables.add(string6);
            }
            if (this.subProtocol.equals("postgresql")) {
                resultSet = databaseMetaData.getTablePrivileges(this.db, " ", "%");
                while (resultSet.next()) {
                    string6 = resultSet.getString(TABLE_NAME);
                    if (!this.tables.contains(string6)) continue;
                    String string4 = resultSet.getString("GRANTEE");
                    String string5 = this.connectionProperties.getProperty("User");
                    if (Ajqvue.getDebug()) {
                        System.out.println("Unauthorized Table Access: " + string6 + " : " + string4 + " : " + string5);
                    }
                    if (!this.tables.contains(string6) || string4.equals(string5)) continue;
                    this.tables.remove(string6);
                }
            }
            for (String string6 : this.tables) {
                String string7;
                if (string6.indexOf(".") == -1 || this.schemas.contains(string7 = string6.substring(0, string6.indexOf(".")))) continue;
                this.schemas.add(string7);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new SQLException("DatabaseProperties loadDBTables() " + sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void overideDefaults() {
        String string = Utils.getAjqvueConfDirectory() + Utils.getFileSeparator() + CONFIGURATION_FILE_NAME;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            File file = new File(string);
            try {
                if (!file.exists()) {
                    return;
                }
            }
            catch (SecurityException securityException) {
                return;
            }
            inputStreamReader = new FileReader(string);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).startsWith("#")) continue;
                if (string2.toLowerCase(Locale.ENGLISH).indexOf("filter") != -1) {
                    if (string2.toLowerCase(Locale.ENGLISH).indexOf("on") != -1) {
                        this.filter = true;
                    } else if (string2.toLowerCase(Locale.ENGLISH).indexOf("off") != -1) {
                        this.filter = false;
                    }
                }
                if (string2.toLowerCase(Locale.ENGLISH).indexOf(this.dbType) == -1) continue;
                if (string2.toLowerCase(Locale.ENGLISH).indexOf("schemapattern") != -1 && string2.indexOf("=") != -1) {
                    this.schemaPattern = string2.substring(string2.indexOf("=") + 1).trim();
                    if (this.schemaPattern.equals("null")) {
                        this.schemaPattern = null;
                    }
                }
                if (string2.toLowerCase(Locale.ENGLISH).indexOf("tablenamepattern") != -1 && string2.indexOf("=") != -1) {
                    this.tableNamePattern = string2.substring(string2.indexOf("=") + 1).trim();
                    if (this.tableNamePattern.equals("null")) {
                        this.tableNamePattern = null;
                    }
                }
                if (string2.toLowerCase(Locale.ENGLISH).indexOf("types") == -1 || string2.indexOf("=") == -1) continue;
                if ((string2 = string2.substring(string2.indexOf("=") + 1).trim()).equals("null")) {
                    this.tableTypes = null;
                    continue;
                }
                this.tableTypes = string2.split(",");
            }
            return;
        }
        catch (IOException iOException) {
            if (!Ajqvue.getDebug()) return;
            System.out.println("DatabaseProperties overideDefaults() File I/O Problem. " + iOException);
            return;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                if (Ajqvue.getDebug()) {
                    System.out.println("DatabaseProperties overideDefaults() Failed to Close BufferedReader. " + iOException);
                }
            }
            finally {
                block75: {
                    try {
                        if (inputStreamReader != null) {
                            inputStreamReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!Ajqvue.getDebug()) break block75;
                        System.out.println("DatabaseProperties overideDefaults() Failed to Close FileReader. " + iOException);
                    }
                }
            }
        }
    }

    public String getAllSchemasPattern() {
        String string = this.getDataSourceType();
        if (string.equals("hsql") || string.equals("oracle")) {
            return "%";
        }
        if (string.equals("mysql") || string.equals("mariadb") || string.equals("postgresql")) {
            return "";
        }
        return null;
    }

    public String getCatalogSeparator() {
        return this.catalogSeparator;
    }

    public String getDataSourceType() {
        if (this.subProtocol.equals("mysql")) {
            return "mysql";
        }
        if (this.subProtocol.equals("mariadb")) {
            return "mariadb";
        }
        if (this.subProtocol.equals("postgresql")) {
            return "postgresql";
        }
        if (this.subProtocol.indexOf("hsql") != -1) {
            if (this.dbProductNameVersion.indexOf(" 2.") != -1) {
                return "hsql2";
            }
            return "hsql";
        }
        if (this.subProtocol.indexOf("oracle") != -1) {
            return "oracle";
        }
        if (this.subProtocol.equals("sqlite")) {
            return "sqlite";
        }
        if (this.subProtocol.equals("odbc")) {
            return "odbc";
        }
        if (this.subProtocol.equals("sqlserver")) {
            return "sqlserver";
        }
        if (this.subProtocol.equals("derby")) {
            return "derby";
        }
        if (this.subProtocol.equals("h2")) {
            return "h2";
        }
        return "other";
    }

    public String getDBProductName_And_Version() {
        return this.dbProductNameVersion;
    }

    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    public int getMaxColumnNameLength() {
        return this.maxColumnNameLength;
    }

    public ArrayList<String> getSchemas() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<String> iterator = this.schemas.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public ArrayList<String> getTableNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<String> iterator = this.tables.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public void setSchemaPattern(String string) {
        this.schemaPattern = string;
    }
}

