/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.datasource;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionProperties;
import com.dandymadeproductions.ajqvue.datasource.DatabaseProperties;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import com.sun.rowset.CachedRowSetImpl;
import com.sun.rowset.FilteredRowSetImpl;
import com.sun.rowset.WebRowSetImpl;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import javax.sound.sampled.Clip;
import javax.sql.RowSet;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.FilteredRowSet;
import javax.sql.rowset.WebRowSet;
import javax.swing.JOptionPane;

public class ConnectionManager {
    private static Connection memoryConnection;
    private static ConnectionProperties connectionProperties;
    private static DatabaseProperties databaseProperties;
    private static Clip errorSoundClip;
    public static final String MYSQL = "mysql";
    public static final String MARIADB = "mariadb";
    public static final String POSTGRESQL = "postgresql";
    public static final String HSQL = "hsql";
    public static final String HSQL2 = "hsql2";
    public static final String ORACLE = "oracle";
    public static final String SQLITE = "sqlite";
    public static final String MSACCESS = "odbc";
    public static final String MSSQL = "sqlserver";
    public static final String DERBY = "derby";
    public static final String H2 = "h2";
    public static final String OTHERDB = "other";

    public static synchronized Connection getConnection(String string) {
        String string2 = connectionProperties.getConnectionURLString();
        String string3 = connectionProperties.getProperty("DB");
        String string4 = connectionProperties.getProperty("SubProtocol");
        Properties properties = connectionProperties.getConnectionProperties();
        try {
            if (Ajqvue.getDebug()) {
                System.out.println(string + " (CM) Connection Created");
            }
            if (memoryConnection != null && string4.equals(SQLITE) && string3.toLowerCase(Locale.ENGLISH).indexOf(":memory:") != -1 || string4.indexOf(HSQL) != -1 && string3.toLowerCase(Locale.ENGLISH).indexOf("mem:") != -1 || string4.equals(DERBY) && string3.toLowerCase(Locale.ENGLISH).indexOf("memory:") != -1 || string4.equals(H2) && string3.toLowerCase(Locale.ENGLISH).indexOf("mem:") != -1) {
                return memoryConnection;
            }
            return DriverManager.getConnection(string2, properties);
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "ConnectionManager getConnection()");
            return null;
        }
    }

    public static synchronized void closeConnection(Connection connection, String string) {
        String string2 = connectionProperties.getProperty("DB");
        String string3 = connectionProperties.getProperty("SubProtocol");
        try {
            if (Ajqvue.getDebug()) {
                System.out.println(string + " (CM) Connection Closed");
            }
            if (memoryConnection != null && string3.equals(SQLITE) && string2.toLowerCase(Locale.ENGLISH).indexOf(":memory:") != -1 || string3.indexOf(HSQL) != -1 && string2.toLowerCase(Locale.ENGLISH).indexOf("mem:") != -1 || string3.equals(DERBY) && string2.toLowerCase(Locale.ENGLISH).indexOf("memory:") != -1 || string3.equals(H2) && string2.toLowerCase(Locale.ENGLISH).indexOf("mem:") != -1) {
                return;
            }
            connection.close();
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "ConnectionManager closeConnection()");
        }
    }

    public static void shutdown(String string) {
        ConnectionManager.closeMemoryConnection(string);
        ConnectionManager.shutdownDatabase(string);
    }

    private static void closeMemoryConnection(String string) {
        try {
            if (memoryConnection != null) {
                if (Ajqvue.getDebug()) {
                    System.out.println(string + " (CM) Memory Connection Closed");
                }
                memoryConnection.close();
            }
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "ConnectionManager closeMemoryConnection()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdownDatabase(String string) {
        String string2 = connectionProperties.getConnectionURLString();
        String string3 = connectionProperties.getProperty("SubProtocol");
        String string4 = string2.indexOf(";") != -1 ? string2.substring(0, string2.indexOf(";")) : string2;
        Connection connection = null;
        try {
            if (string3.indexOf(HSQL) != -1) {
                if (string4.toLowerCase(Locale.ENGLISH).indexOf("file:") != -1) {
                    if (Ajqvue.getDebug()) {
                        System.out.println(string + " (CM) Shutting Down HSQL File/Memory Database");
                    }
                    connection = DriverManager.getConnection(string4 + ";shutdown=true");
                    connection.close();
                }
                return;
            }
        }
        catch (SQLException sQLException) {
            if (string3.equals(DERBY) && sQLException.getSQLState() != null && (sQLException.getSQLState().equals("08006") || sQLException.getSQLState().equals("XJ015"))) {
                if (Ajqvue.getDebug()) {
                    System.out.println("SQLException: " + sQLException.getMessage());
                    System.out.println("SQLState: " + sQLException.getSQLState());
                }
            } else if (Ajqvue.getDebug()) {
                ConnectionManager.displaySQLErrors(sQLException, "ConnectionManager shutdownDatabase()");
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "finally{} ConnectionManager shutdownDatabase()");
            }
        }
    }

    public static synchronized void displaySQLErrors(SQLException sQLException, String string) {
        String string2;
        Object object;
        if (errorSoundClip != null) {
            errorSoundClip.setFramePosition(0);
            errorSoundClip.start();
        }
        if (Ajqvue.getDebug()) {
            System.out.println(string);
            for (object = sQLException; object != null; object = ((SQLException)object).getNextException()) {
                System.out.println("SQLException: " + ((Throwable)object).getMessage());
                System.out.println("SQLState: " + ((SQLException)object).getSQLState());
                System.out.println("VendorError: " + ((SQLException)object).getErrorCode());
                for (Throwable throwable = ((Throwable)object).getCause(); throwable != null; throwable = throwable.getCause()) {
                    System.out.println("Cause: " + throwable);
                }
            }
        }
        if ((string2 = sQLException.getMessage()).length() > 200) {
            string2 = sQLException.getMessage().substring(0, 200);
        }
        object = string + "\nSQLException: " + string2 + "\nSQLState: " + sQLException.getSQLState() + ",  VendorError: " + sQLException.getErrorCode();
        JOptionPane.showMessageDialog(null, object, "Alert", 0);
    }

    public static void loadDBTables(Connection connection) throws SQLException {
        databaseProperties.loadDBTables(connection);
    }

    public static String createConnectionURLString(ConnectionProperties connectionProperties) {
        String string = connectionProperties.getProperty("Driver");
        String string2 = connectionProperties.getProperty("Protocol");
        String string3 = connectionProperties.getProperty("SubProtocol");
        String string4 = connectionProperties.getProperty("Host");
        String string5 = connectionProperties.getProperty("Port");
        String string6 = connectionProperties.getProperty("DB");
        String string7 = string2 + ":";
        if (string3.indexOf(ORACLE) != -1) {
            string7 = string3.indexOf("thin") != -1 ? string7 + string3 + ":@//" + string4 + ":" + string5 + "/" + string6 : string7 + string3 + ":@" + string6;
        } else if (string3.equals(SQLITE)) {
            string7 = string7 + string3 + ":" + string6.replace("\\", "/");
        } else if (string3.indexOf(HSQL) != -1 && string6.indexOf("mem:") != -1 || string6.indexOf("file:") != -1 || string6.indexOf("res:") != -1) {
            string7 = string7 + "hsqldb:" + string6;
        } else if (string3.indexOf(DERBY) != -1) {
            if (string.indexOf("EmbeddedDriver") != -1) {
                if (string6.toLowerCase(Locale.ENGLISH).indexOf("jar:") != -1) {
                    string7 = string7 + string3 + ":" + string6;
                } else {
                    if (string6.toLowerCase(Locale.ENGLISH).indexOf(";create=true") == -1) {
                        string6 = string6 + ";create=true";
                    }
                    string7 = string7 + string3 + ":" + string6;
                }
            } else if (string6.indexOf("memory:") != -1) {
                if (string6.toLowerCase(Locale.ENGLISH).indexOf(";create=true") == -1) {
                    string6 = string6 + ";create=true";
                }
                string7 = string7 + string3 + "://" + string4 + ":" + string5 + "/" + string6;
            } else {
                string7 = string7 + string3 + "://" + string4 + ":" + string5 + "/" + string6;
            }
        } else {
            string7 = string3.equals(MSACCESS) ? string7 + string3 + ":" + string6 : (string3.equals(MSSQL) ? (string6.isEmpty() ? string7 + string3 + "://" + string4 + ":" + string5 : string7 + string3 + "://" + string4 + ":" + string5 + ";databaseName=" + string6) : (string3.equals(H2) ? (string6.indexOf("tcp:") != -1 ? string7 + string3 + ":tcp://" + string4 + ":" + string5 + "/" + string6.substring(string6.indexOf("tcp:") + 4) : (string6.indexOf("ssl:") != -1 ? string7 + string3 + ":ssl://" + string4 + ":" + string5 + "/" + string6.substring(string6.indexOf("ssl:") + 4) : string7 + string3 + ":" + string6)) : string7 + string3 + "://" + string4 + ":" + string5 + "/" + string6));
        }
        return string7;
    }

    public static String getCatalogSeparator() {
        return databaseProperties.getCatalogSeparator();
    }

    public static ConnectionProperties getConnectionProperties() {
        return connectionProperties;
    }

    public static String getDataSourceType() {
        return databaseProperties.getDataSourceType();
    }

    public static String getDBProductName_And_Version() {
        return databaseProperties.getDBProductName_And_Version();
    }

    public static String getIdentifierQuoteString() {
        return databaseProperties.getIdentifierQuoteString();
    }

    public static int getMaxColumnNameLength() {
        return databaseProperties.getMaxColumnNameLength();
    }

    public static ArrayList<String> getSchemas() {
        return databaseProperties.getSchemas();
    }

    public static String getAllSchemasPattern() {
        return databaseProperties.getAllSchemasPattern();
    }

    public static ArrayList<String> getTableNames() {
        return databaseProperties.getTableNames();
    }

    public static CachedRowSet getCachedRowSet() throws SQLException {
        CachedRowSetImpl cachedRowSetImpl = new CachedRowSetImpl();
        ConnectionManager.setRowSet(cachedRowSetImpl);
        return cachedRowSetImpl;
    }

    public static FilteredRowSet getFilteredRowSet() throws SQLException {
        FilteredRowSetImpl filteredRowSetImpl = new FilteredRowSetImpl();
        ConnectionManager.setRowSet(filteredRowSetImpl);
        return filteredRowSetImpl;
    }

    public static WebRowSet getWebRowSet() throws SQLException {
        WebRowSetImpl webRowSetImpl = new WebRowSetImpl();
        ConnectionManager.setRowSet(webRowSetImpl);
        return webRowSetImpl;
    }

    private static void setRowSet(RowSet rowSet) throws SQLException {
        rowSet.setUrl(connectionProperties.getConnectionURLString());
        rowSet.setUsername(connectionProperties.getProperty("User"));
        rowSet.setPassword(connectionProperties.getPassword());
    }

    public static void setConnectionProperties(ConnectionProperties connectionProperties) {
        ConnectionManager.connectionProperties = connectionProperties;
    }

    public static void setDatabaseProperties(DatabaseProperties databaseProperties) {
        ConnectionManager.databaseProperties = databaseProperties;
    }

    public static void setMemoryConnection(Connection connection) {
        memoryConnection = connection;
    }

    public static void setSchemaPattern(String string) {
        databaseProperties.setSchemaPattern(string);
    }

    static {
        connectionProperties = new ConnectionProperties();
        databaseProperties = new DatabaseProperties(connectionProperties);
        errorSoundClip = Utils.getAudioClip("sounds" + Utils.getFileSeparator() + "huh.wav");
    }
}

