/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue;

import com.dandymadeproductions.ajqvue.gui.LoginFrame;
import com.dandymadeproductions.ajqvue.gui.Main_Frame;
import com.dandymadeproductions.ajqvue.gui.Main_MouseAdapter;
import com.dandymadeproductions.ajqvue.structures.GeneralProperties;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Ajqvue
implements ActionListener {
    private static boolean debug;
    private static String localeString;
    private JButton validLoginButton;
    private LoginFrame loginFrame;
    protected Main_Frame mainFrame;
    private static MouseListener popupListener;
    private static AResourceBundle resourceBundle;
    private static String[] VERSION;
    private static final String WEBSITE = "http://ajqvue.com";
    private static GeneralProperties generalProperties;

    public Ajqvue() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            Utils.setUIManagerFont(generalProperties.getFontSize());
        }
        catch (ClassNotFoundException classNotFoundException) {
            stringBuilder.append(classNotFoundException.toString());
        }
        catch (InstantiationException instantiationException) {
            stringBuilder.append(instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Can't set look and feel.");
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            System.err.println("Can't set look and feel.");
        }
        if (!stringBuilder.toString().isEmpty()) {
            System.err.println("Ajqvue Constructor: " + stringBuilder);
        }
        resourceBundle = new AResourceBundle("file:" + Utils.getAjqvueDirectory() + Utils.getFileSeparator(), debug);
        resourceBundle.setLocaleResource("locale" + Utils.getFileSeparator(), "AjqvueBundle", localeString);
        popupListener = new Main_MouseAdapter(Utils.createPopupMenu());
        this.validLoginButton = new JButton();
        this.validLoginButton.addActionListener(this);
        this.loginFrame = new LoginFrame(this.validLoginButton);
        this.loginFrame.setDefaultCloseOperation(3);
        this.loginFrame.addMouseListener(popupListener);
        this.loginFrame.pack();
        this.loginFrame.setResizable(true);
        this.loginFrame.center();
        this.loginFrame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton && object == this.validLoginButton) {
            this.loginFrame.dispose();
            this.mainFrame = new Main_Frame();
            this.mainFrame.loadQueryBucketList();
            this.mainFrame.setDefaultCloseOperation(3);
            this.mainFrame.createGUI();
            this.mainFrame.addMouseListener(popupListener);
            this.mainFrame.setLocation(generalProperties.getPosition());
            this.mainFrame.setSize(generalProperties.getDimension());
            this.mainFrame.setVisible(true);
        }
    }

    public static void main(String[] stringArray) {
        debug = false;
        localeString = "";
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-debug")) {
                    debug = true;
                }
                if (stringArray[i].indexOf("-lang") == -1 || stringArray[i].indexOf("=") == -1) continue;
                localeString = stringArray[i].substring(stringArray[i].indexOf("=") + 1);
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (localeString.equals("") || localeString.length() != 5) {
                    localeString = Utils.processLocaleLanguage();
                }
                new Ajqvue();
            }
        });
    }

    public static boolean getDebug() {
        return debug;
    }

    public static GeneralProperties getGeneralProperties() {
        return generalProperties;
    }

    public static String getLocaleString() {
        return localeString;
    }

    public static Locale getLocale() {
        return new Locale(localeString.substring(0, localeString.indexOf("_")), localeString.substring(localeString.indexOf("_") + 1));
    }

    public static MouseListener getPopupMenuListener() {
        return popupListener;
    }

    public static AResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public static String[] getVersion() {
        return (String[])VERSION.clone();
    }

    public static String getWebSite() {
        return WEBSITE;
    }

    public static void setGeneralProperties(GeneralProperties generalProperties) {
        Ajqvue.generalProperties = generalProperties;
    }

    static {
        VERSION = new String[]{"Ajqvue", "2.0", "Build ID: 20180730"};
        generalProperties = new GeneralProperties();
    }
}

