/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.utilities.db;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.structures.DataExportProperties;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class TableDefinitionGenerator {
    private String databaseName;
    private String schemaTableName;
    private String schemaName;
    private String tableName;
    private Connection dbConnection;
    private String dbIdentifierQuoteString;
    private String identifierQuoteString;
    private DataExportProperties sqlDataExportOptions;
    private StringBuffer tableDefinition;

    public TableDefinitionGenerator(Connection connection, String string) {
        this.dbConnection = connection;
        this.schemaTableName = string;
        this.databaseName = ConnectionManager.getConnectionProperties().getProperty("DB");
        if (this.databaseName.indexOf(";") != -1) {
            this.databaseName = this.databaseName.substring(0, this.databaseName.indexOf(";"));
        }
        this.dbIdentifierQuoteString = ConnectionManager.getIdentifierQuoteString();
        this.sqlDataExportOptions = DBTablesPanel.getDataExportProperties();
        this.identifierQuoteString = this.sqlDataExportOptions.getIdentifierQuoteString();
        if (this.schemaTableName.indexOf(".") != -1) {
            this.schemaName = this.schemaTableName.substring(0, this.schemaTableName.indexOf("."));
            this.schemaName = this.schemaName.replaceAll(this.dbIdentifierQuoteString, "");
            this.tableName = this.schemaTableName.substring(this.schemaTableName.indexOf(".") + 1);
            this.tableName = this.tableName.replaceAll(this.dbIdentifierQuoteString, "");
        } else {
            this.schemaName = "";
            this.tableName = this.schemaTableName.replaceAll(this.dbIdentifierQuoteString, "");
        }
        this.tableDefinition = new StringBuffer("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createSQLTableDefinition() throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.dbConnection.createStatement();
            String string = "SHOW CREATE TABLE " + this.schemaTableName;
            resultSet = statement.executeQuery(string);
            if (DBTablesPanel.getDataExportProperties().getTableStructure()) {
                this.tableDefinition.append("DROP " + resultSet.getMetaData().getColumnName(1).toUpperCase(Ajqvue.getLocale()) + " IF EXISTS " + this.schemaTableName + ";\n");
            }
            resultSet.next();
            this.tableDefinition.append(resultSet.getString(2) + ";\n");
            return;
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "TableDefinitionGenerator createMySQLTableDefinition()");
            return;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "TableDefinitionGenerator createMySQLTableDefinition()");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createPostgreSQLTableDefinition() throws SQLException {
        ResultSet resultSet;
        Statement statement = null;
        Statement statement2 = null;
        try {
            Object object;
            String string;
            statement = this.dbConnection.createStatement();
            statement2 = this.dbConnection.createStatement();
            String string2 = "SELECT table_type FROM information_schema.tables WHERE table_catalog='" + this.databaseName + "' AND table_schema='" + this.schemaName + "' AND table_name='" + this.tableName + "'";
            resultSet = statement.executeQuery(string2);
            String string3 = resultSet.next() ? (resultSet.getString(1).equals("BASE TABLE") ? "TABLE" : resultSet.getString(1)) : "TABLE";
            if (DBTablesPanel.getDataExportProperties().getTableStructure()) {
                this.tableDefinition.append("DROP " + string3 + " IF EXISTS " + this.schemaTableName + ";\n");
            }
            if (string3.equals("VIEW")) {
                string2 = "SELECT view_definition FROM information_schema.views WHERE table_catalog='" + this.databaseName + "' AND table_schema='" + this.schemaName + "' AND table_name='" + this.tableName + "'";
                resultSet = statement.executeQuery(string2);
                if (resultSet.next()) {
                    this.tableDefinition.append("CREATE " + string3 + " " + this.schemaTableName + " AS " + resultSet.getString(1) + "\n");
                }
                resultSet.close();
                return;
            }
            this.tableDefinition.append("CREATE " + string3 + " " + this.schemaTableName + " (\n    ");
            string2 = "SELECT table_catalog, table_name, column_name, ordinal_position, column_default, is_nullable, data_type, character_maximum_length, numeric_precision, numeric_scale, datetime_precision, udt_name FROM information_schema.columns WHERE table_catalog='" + this.databaseName + "' AND table_schema='" + this.schemaName + "' AND table_name='" + this.tableName + "' ORDER BY ordinal_position";
            resultSet.close();
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                block71: {
                    String string4;
                    block76: {
                        block77: {
                            block75: {
                                block74: {
                                    block73: {
                                        string = resultSet.getString("column_name");
                                        string4 = resultSet.getString("data_type");
                                        this.tableDefinition.append(this.identifierQuoteString + string + this.identifierQuoteString + " ");
                                        if (string4.indexOf("int") == -1) break block73;
                                        if (string4.equals("integer") && resultSet.getString("column_default") != null && resultSet.getString("column_default").indexOf("nextval") != -1) {
                                            this.tableDefinition.append("serial");
                                            break block71;
                                        } else if (string4.equals("bigint") && resultSet.getString("column_default") != null && resultSet.getString("column_default").indexOf("nextval") != -1) {
                                            this.tableDefinition.append("bigserial");
                                            break block71;
                                        } else {
                                            this.tableDefinition.append(string4);
                                        }
                                        break block71;
                                    }
                                    if (!string4.equals("numeric")) break block74;
                                    if (resultSet.getString("numeric_precision") != null || resultSet.getString("numeric_scale") != null) {
                                        this.tableDefinition.append(string4 + "(" + resultSet.getString("numeric_precision") + "," + resultSet.getString("numeric_scale") + ")");
                                        break block71;
                                    } else {
                                        this.tableDefinition.append(string4);
                                    }
                                    break block71;
                                }
                                if (string4.indexOf("character") == -1) break block75;
                                if (string4.equals("character")) {
                                    this.tableDefinition.append("char(" + resultSet.getString("character_maximum_length") + ")");
                                    break block71;
                                } else {
                                    this.tableDefinition.append("varchar(" + resultSet.getString("character_maximum_length") + ")");
                                }
                                break block71;
                            }
                            if (string4.indexOf("time") == -1) break block76;
                            if (resultSet.getString("datetime_precision") == null) break block77;
                            if (string4.indexOf("timestamp") != -1) {
                                if (string4.indexOf("without") != -1) {
                                    this.tableDefinition.append("timestamp(" + resultSet.getString("datetime_precision") + ") without time zone");
                                    break block71;
                                } else {
                                    this.tableDefinition.append("timestamp(" + resultSet.getString("datetime_precision") + ") with time zone");
                                }
                                break block71;
                            } else if (string4.indexOf("without") != -1) {
                                this.tableDefinition.append("time(" + resultSet.getString("datetime_precision") + ") without time zone");
                                break block71;
                            } else {
                                this.tableDefinition.append("time(" + resultSet.getString("datetime_precision") + ") with time zone");
                            }
                            break block71;
                        }
                        this.tableDefinition.append(string4);
                        break block71;
                    }
                    if (string4.equals("interval") && resultSet.getString("datetime_precision") != null) {
                        this.tableDefinition.append(string4 + "(" + resultSet.getString("datetime_precision") + ")");
                    } else if (string4.indexOf("bit") != -1 && resultSet.getString("character_maximum_length") != null) {
                        this.tableDefinition.append(string4 + "(" + resultSet.getString("character_maximum_length") + ")");
                    } else if (string4.equals("ARRAY")) {
                        string2 = "SELECT format_type(atttypid, atttypmod) FROM pg_attribute WHERE attrelid='" + this.tableName + "'::regclass AND attname='" + string + "'";
                        ResultSet resultSet2 = statement2.executeQuery(string2);
                        resultSet2.next();
                        this.tableDefinition.append(resultSet2.getString(1));
                        resultSet2.close();
                    } else if (string4.equals("USER-DEFINED")) {
                        if (resultSet.getString("udt_name") != null) {
                            this.tableDefinition.append(resultSet.getString("udt_name"));
                        } else {
                            this.tableDefinition.append(string4);
                        }
                    } else {
                        this.tableDefinition.append(string4);
                    }
                }
                if (resultSet.getString("column_default") != null && resultSet.getString("column_default").indexOf("nextval") == -1) {
                    object = resultSet.getString("column_default");
                    if (((String)object).indexOf("::") != -1) {
                        this.tableDefinition.append(" DEFAULT " + ((String)object).substring(0, ((String)object).indexOf("::")));
                    } else {
                        this.tableDefinition.append(" DEFAULT " + (String)object);
                    }
                    if (resultSet.getString("is_nullable").equals("NO")) {
                        this.tableDefinition.append(" NOT NULL,\n    ");
                        continue;
                    }
                    this.tableDefinition.append(",\n    ");
                    continue;
                }
                if (resultSet.getString("column_default") == null && resultSet.getString("is_nullable").equals("YES")) {
                    this.tableDefinition.append(" DEFAULT NULL,\n    ");
                    continue;
                }
                if (resultSet.getString("is_nullable").equals("NO")) {
                    this.tableDefinition.append(" NOT NULL,\n    ");
                    continue;
                }
                this.tableDefinition.append(",\n    ");
            }
            string2 = "SELECT table_catalog, table_name, column_name, constraint_name FROM information_schema.key_column_usage WHERE table_catalog='" + this.databaseName + "' AND table_schema='" + this.schemaName + "' AND table_name='" + this.tableName + "'";
            resultSet = statement.executeQuery(string2);
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string5 = "";
            String string6 = "";
            String string7 = "";
            StringBuffer stringBuffer3 = new StringBuffer();
            String string8 = "";
            String string9 = "";
            while (resultSet.next()) {
                string8 = resultSet.getString("constraint_name");
                string = resultSet.getString("column_name");
                if (string8.indexOf("_key") != -1) {
                    stringBuffer2.append(this.identifierQuoteString + string + this.identifierQuoteString + ",");
                    continue;
                }
                if (string8.indexOf("pkey") != -1) {
                    stringBuffer.append(this.identifierQuoteString + string + this.identifierQuoteString + ",");
                    continue;
                }
                if (string8.indexOf("fkey") == -1) continue;
                if (hashMap.containsKey(string8)) {
                    hashMap.put(string8, (String)hashMap.get(string8) + "," + this.identifierQuoteString + string + this.identifierQuoteString);
                    continue;
                }
                hashMap.put(string8, this.identifierQuoteString + string + this.identifierQuoteString);
            }
            if (!stringBuffer2.toString().equals("")) {
                this.tableDefinition.append("UNIQUE (" + stringBuffer2.substring(0, stringBuffer2.length() - 1) + "),\n    ");
            }
            if (!stringBuffer.toString().equals("")) {
                this.tableDefinition.append("PRIMARY KEY (" + stringBuffer.substring(0, stringBuffer.length() - 1) + "),\n    ");
            }
            if (!hashMap.isEmpty()) {
                object = hashMap.entrySet();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    string5 = (String)entry.getValue();
                    string2 = "SELECT table_catalog, table_schema, table_name, column_name, constraint_name FROM information_schema.constraint_column_usage WHERE table_catalog='" + this.databaseName + "' AND constraint_name='" + string8 + "'";
                    resultSet = statement.executeQuery(string2);
                    while (resultSet.next()) {
                        string6 = this.identifierQuoteString + resultSet.getString("table_schema") + this.identifierQuoteString;
                        string7 = this.identifierQuoteString + resultSet.getString("table_name") + this.identifierQuoteString;
                        if (!resultSet.isLast()) {
                            stringBuffer3.append(this.identifierQuoteString + resultSet.getString("column_name") + this.identifierQuoteString + ",");
                            continue;
                        }
                        stringBuffer3.append(this.identifierQuoteString + resultSet.getString("column_name") + this.identifierQuoteString);
                    }
                    string2 = "SELECT constraint_catalog, constraint_name, delete_rule FROM information_schema.referential_constraints WHERE constraint_catalog='" + this.databaseName + "' AND constraint_name='" + string8 + "'";
                    resultSet = statement.executeQuery(string2);
                    resultSet.next();
                    string9 = resultSet.getString("delete_rule");
                    this.tableDefinition.append("FOREIGN KEY (" + string5 + ") REFERENCES " + string6 + "." + string7 + "(" + stringBuffer3 + ") ON DELETE " + string9);
                    if (iterator.hasNext()) {
                        this.tableDefinition.append(",\n    ");
                    } else {
                        this.tableDefinition.append(" \n    ");
                    }
                    stringBuffer3.delete(0, stringBuffer3.length());
                }
            }
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "TableDefinitionGenerator createPostgreSQLTableDefinition()");
            return;
        }
        this.tableDefinition.delete(this.tableDefinition.length() - 6, this.tableDefinition.length());
        this.tableDefinition.append("\n);\n");
        resultSet.close();
        return;
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "TableDefinitionGenerator createPostgreSQLTableDefinition()");
            }
            finally {
                if (statement2 != null) {
                    statement2.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createHSQLTableDefinition() throws SQLException {
        String string = ConnectionManager.getDataSourceType();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        HashMap<String, Integer> hashMap4 = new HashMap<String, Integer>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string2;
            int n;
            statement = this.dbConnection.createStatement();
            String string3 = "SELECT " + this.dbIdentifierQuoteString + "TABLE_TYPE" + this.dbIdentifierQuoteString + " FROM " + this.dbIdentifierQuoteString + "INFORMATION_SCHEMA" + this.dbIdentifierQuoteString + "." + this.dbIdentifierQuoteString + "SYSTEM_TABLES" + this.dbIdentifierQuoteString + " WHERE " + this.dbIdentifierQuoteString + "TABLE_SCHEM" + this.dbIdentifierQuoteString + "='" + this.schemaName + "' AND TABLE_NAME='" + this.tableName + "'";
            resultSet = statement.executeQuery(string3);
            String string4 = resultSet.next() ? resultSet.getString(1) : "TABLE";
            if (DBTablesPanel.getDataExportProperties().getTableStructure()) {
                this.tableDefinition.append("DROP " + string4 + " IF EXISTS " + this.schemaTableName + ";\n");
            }
            if (string4.equals("VIEW")) {
                string3 = string.equals("hsql") ? "SELECT " + this.dbIdentifierQuoteString + "VIEW_DEFINITION" + this.dbIdentifierQuoteString + " FROM " + this.dbIdentifierQuoteString + "INFORMATION_SCHEMA" + this.dbIdentifierQuoteString + "." + this.dbIdentifierQuoteString + "SYSTEM_VIEWS" + this.dbIdentifierQuoteString + " WHERE " + this.dbIdentifierQuoteString + "TABLE_SCHEMA" + this.dbIdentifierQuoteString + "='" + this.schemaName + "' AND TABLE_NAME='" + this.tableName + "'" : "SELECT " + this.dbIdentifierQuoteString + "VIEW_DEFINITION" + this.dbIdentifierQuoteString + " FROM " + this.dbIdentifierQuoteString + "INFORMATION_SCHEMA" + this.dbIdentifierQuoteString + "." + this.dbIdentifierQuoteString + "VIEWS" + this.dbIdentifierQuoteString + " WHERE " + this.dbIdentifierQuoteString + "TABLE_SCHEMA" + this.dbIdentifierQuoteString + "='" + this.schemaName + "' AND TABLE_NAME='" + this.tableName + "'";
                resultSet.close();
                resultSet = statement.executeQuery(string3);
                if (resultSet.next()) {
                    this.tableDefinition.append("CREATE " + string4 + " " + this.schemaTableName + " AS " + resultSet.getString(1) + ";\n");
                }
                resultSet.close();
                return;
            }
            this.tableDefinition.append("CREATE " + string4 + " " + this.schemaTableName + " (\n    ");
            string3 = "SELECT " + this.dbIdentifierQuoteString + "COLUMN_NAME" + this.dbIdentifierQuoteString + "," + this.dbIdentifierQuoteString + "DATA_TYPE" + this.dbIdentifierQuoteString + "," + this.dbIdentifierQuoteString + "DATETIME_PRECISION" + this.dbIdentifierQuoteString + "," + this.dbIdentifierQuoteString + "DTD_IDENTIFIER" + this.dbIdentifierQuoteString + " FROM " + this.dbIdentifierQuoteString + "INFORMATION_SCHEMA" + this.dbIdentifierQuoteString + "." + this.dbIdentifierQuoteString + "COLUMNS" + this.dbIdentifierQuoteString + " WHERE " + this.dbIdentifierQuoteString + "TABLE_SCHEMA" + this.dbIdentifierQuoteString + "='" + this.schemaName + "' AND TABLE_NAME='" + this.tableName + "'";
            resultSet.close();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                if (resultSet.getString("DATA_TYPE").equals("TIMESTAMP WITH TIME ZONE")) {
                    hashMap.put(resultSet.getString("COLUMN_NAME"), "TIMESTAMP(" + resultSet.getString("DATETIME_PRECISION") + ") WITH TIME ZONE");
                }
                if (resultSet.getString("DATA_TYPE").equals("TIME WITH TIME ZONE")) {
                    hashMap2.put(resultSet.getString("COLUMN_NAME"), resultSet.getString("DTD_IDENTIFIER"));
                }
                if (!resultSet.getString("DATA_TYPE").equals("INTERVAL")) continue;
                hashMap3.put(resultSet.getString("COLUMN_NAME"), resultSet.getString("DTD_IDENTIFIER"));
            }
            DatabaseMetaData databaseMetaData = this.dbConnection.getMetaData();
            string3 = "SELECT LIMIT 0 1 * FROM " + this.schemaTableName;
            resultSet.close();
            resultSet = statement.executeQuery(string3);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            String string5 = resultSetMetaData.getCatalogName(1);
            if (string5 != null && string5.equals("")) {
                string5 = null;
            }
            resultSet.close();
            resultSet = databaseMetaData.getColumns(string5, resultSetMetaData.getSchemaName(1), resultSetMetaData.getTableName(1), "%");
            String string6 = "";
            for (n = 1; n < resultSetMetaData.getColumnCount() + 1; ++n) {
                string2 = resultSetMetaData.getColumnName(n);
                if (resultSetMetaData.isAutoIncrement(n)) {
                    string6 = string2;
                }
                hashMap4.put(string2, resultSetMetaData.getPrecision(n));
            }
            while (resultSet.next()) {
                block81: {
                    String string7;
                    String string8;
                    block91: {
                        block90: {
                            block89: {
                                int n2;
                                block88: {
                                    block87: {
                                        block85: {
                                            block86: {
                                                block83: {
                                                    block84: {
                                                        string2 = resultSet.getString("COLUMN_NAME");
                                                        string8 = resultSet.getString("TYPE_NAME");
                                                        string7 = resultSet.getString("COLUMN_SIZE");
                                                        n2 = hashMap4.get(string2) != null ? (Integer)hashMap4.get(string2) : 0;
                                                        this.tableDefinition.append(this.identifierQuoteString + string2 + this.identifierQuoteString + " ");
                                                        if (string8.indexOf("CHAR") == -1) break block83;
                                                        if (!string8.equals("CHAR") && !string8.equals("CHARACTER")) break block84;
                                                        this.tableDefinition.append("CHAR(" + string7 + ")");
                                                        break block81;
                                                    }
                                                    if (ConnectionManager.getDataSourceType().equals("hsql")) {
                                                        if (string8.equals("VARCHAR") || string8.equals("VARCHAR_IGNORECASE")) {
                                                            this.tableDefinition.append("VARCHAR(" + string7 + ")");
                                                            break block81;
                                                        } else {
                                                            this.tableDefinition.append(string8);
                                                        }
                                                        break block81;
                                                    } else if (string7.equals("16777216")) {
                                                        this.tableDefinition.append("LONGVARCHAR");
                                                        break block81;
                                                    } else {
                                                        this.tableDefinition.append("VARCHAR(" + string7 + ")");
                                                    }
                                                    break block81;
                                                }
                                                if (string8.indexOf("BINARY") == -1 || !ConnectionManager.getDataSourceType().equals("hsql2")) break block85;
                                                if (!string8.equals("BINARY")) break block86;
                                                try {
                                                    n = 0;
                                                    Integer.parseInt(string7);
                                                }
                                                catch (NumberFormatException numberFormatException) {
                                                    n = 1;
                                                }
                                                if (n != 0) {
                                                    this.tableDefinition.append("BINARY");
                                                    break block81;
                                                } else if (Integer.parseInt(string7) == 0) {
                                                    this.tableDefinition.append("BINARY(1)");
                                                    break block81;
                                                } else {
                                                    this.tableDefinition.append("BINARY(" + string7 + ")");
                                                }
                                                break block81;
                                            }
                                            if (string7.equals("16777216")) {
                                                this.tableDefinition.append("LONGVARBINARY");
                                                break block81;
                                            } else {
                                                this.tableDefinition.append("VARBINARY(" + string7 + ")");
                                            }
                                            break block81;
                                        }
                                        if (!string8.equals("INTEGER") && !string8.equals("BIGINT")) break block87;
                                        this.tableDefinition.append(string8);
                                        if (string2.equals(string6)) {
                                            this.tableDefinition.append(" IDENTITY");
                                        }
                                        break block81;
                                    }
                                    if (!string8.equals("DOUBLE")) break block88;
                                    this.tableDefinition.append(string8);
                                    break block81;
                                }
                                if (!string8.equals("DECIMAL") && !string8.equals("NUMERIC")) break block89;
                                if (string.equals("hsql") && string8.equals("NUMERIC")) {
                                    this.tableDefinition.append(string8);
                                    break block81;
                                } else {
                                    this.tableDefinition.append(string8 + "(" + n2 + "," + resultSet.getString("DECIMAL_DIGITS") + ")");
                                }
                                break block81;
                            }
                            if (!string8.equals("TIME WITH TIME ZONE")) break block90;
                            if (hashMap2.get(string2) != null) {
                                this.tableDefinition.append((String)hashMap2.get(string2));
                                break block81;
                            } else {
                                this.tableDefinition.append(string8);
                            }
                            break block81;
                        }
                        if (string8.indexOf("TIMESTAMP") == -1) break block91;
                        if (string.equals("hsql")) {
                            if (string7.equals("29")) {
                                this.tableDefinition.append(string8 + "(0)");
                                break block81;
                            } else {
                                this.tableDefinition.append(string8);
                            }
                            break block81;
                        } else if (hashMap.get(string2) != null) {
                            this.tableDefinition.append((String)hashMap.get(string2));
                            break block81;
                        } else {
                            this.tableDefinition.append(string8);
                        }
                        break block81;
                    }
                    if (string8.indexOf("INTERVAL") != -1) {
                        if (hashMap3.get(string2) != null) {
                            this.tableDefinition.append((String)hashMap3.get(string2));
                        } else {
                            this.tableDefinition.append(string8);
                        }
                    } else if (string8.equals("BIT") && string7 != null) {
                        this.tableDefinition.append(string8 + "(" + string7 + ")");
                    } else if (string8.equals("BIT VARYING") && string7 != null) {
                        this.tableDefinition.append(string8 + "(" + string7 + ")");
                    } else {
                        this.tableDefinition.append(string8);
                    }
                }
                String string9 = resultSet.getString("COLUMN_DEF");
                if (string9 != null && string9.equals("NULL")) {
                    string9 = null;
                }
                if (string9 != null) {
                    if ((string9 = string9.trim()).indexOf("::") != -1) {
                        this.tableDefinition.append(" DEFAULT " + string9.substring(0, string9.indexOf(":")));
                    } else {
                        this.tableDefinition.append(" DEFAULT " + string9);
                    }
                    if (resultSet.getString("IS_NULLABLE").equals("NO")) {
                        this.tableDefinition.append(" NOT NULL,\n    ");
                        continue;
                    }
                    this.tableDefinition.append(",\n    ");
                    continue;
                }
                if (resultSet.getString("IS_NULLABLE").equals("YES")) {
                    this.tableDefinition.append(" DEFAULT NULL,\n    ");
                    continue;
                }
                if (resultSet.getString("IS_NULLABLE").equals("NO")) {
                    this.tableDefinition.append(" NOT NULL,\n    ");
                    continue;
                }
                this.tableDefinition.append(",\n    ");
            }
            string2 = "";
            String string10 = "";
            StringBuffer stringBuffer = new StringBuffer();
            String string11 = "";
            String string12 = "";
            String string13 = "";
            String string14 = "";
            resultSet.close();
            resultSet = databaseMetaData.getPrimaryKeys(string5, resultSetMetaData.getSchemaName(1), resultSetMetaData.getTableName(1));
            while (resultSet.next()) {
                string2 = resultSet.getString("COLUMN_NAME");
                if (string2.equals(string6)) continue;
                string10 = string10 + this.identifierQuoteString + string2 + this.identifierQuoteString + ",";
            }
            resultSet.close();
            resultSet = databaseMetaData.getIndexInfo(string5, resultSetMetaData.getSchemaName(1), resultSetMetaData.getTableName(1), true, false);
            while (resultSet.next()) {
                string2 = resultSet.getString("COLUMN_NAME");
                if (string10.indexOf(string2) != -1 || string2.equals(string6)) continue;
                stringBuffer.append(this.identifierQuoteString + string2 + this.identifierQuoteString + ",");
            }
            if (!stringBuffer.toString().equals("")) {
                this.tableDefinition.append("UNIQUE (" + stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length()) + "),\n    ");
            }
            if (!string10.equals("")) {
                this.tableDefinition.append("PRIMARY KEY (" + string10.substring(0, string10.length() - 1) + "),\n    ");
            }
            resultSet.close();
            resultSet = databaseMetaData.getImportedKeys(string5, resultSetMetaData.getSchemaName(1), resultSetMetaData.getTableName(1));
            while (resultSet.next()) {
                string2 = resultSet.getString("FKCOLUMN_NAME");
                string12 = resultSet.getString("PKTABLE_NAME");
                string13 = resultSet.getString("PKCOLUMN_NAME");
                string14 = "CASCADE";
                string11 = this.identifierQuoteString + string2 + this.identifierQuoteString;
                this.tableDefinition.append("FOREIGN KEY (" + string11 + ") REFERENCES " + this.identifierQuoteString + string12 + this.identifierQuoteString + "(" + this.identifierQuoteString + string13 + this.identifierQuoteString + ") ON DELETE " + string14);
                if (resultSet.isLast()) {
                    this.tableDefinition.append(" \n    ");
                    continue;
                }
                this.tableDefinition.append(",\n    ");
            }
            this.tableDefinition.delete(this.tableDefinition.length() - 6, this.tableDefinition.length());
            this.tableDefinition.append("\n);\n");
            return;
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "TableDefinitionGenerator createHSQLTableDefinition()");
            return;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "TableDefinitionGenerator createHSQLTableDefinition()");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createOracleTableDefinition() throws SQLException {
        Statement statement = null;
        Statement statement2 = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        try {
            String[] stringArray;
            String string;
            int n;
            statement = this.dbConnection.createStatement();
            statement2 = this.dbConnection.createStatement();
            DatabaseMetaData databaseMetaData = this.dbConnection.getMetaData();
            String string2 = "SELECT OBJECT_TYPE FROM USER_OBJECTS WHERE OBJECT_NAME='" + this.tableName + "'";
            resultSet = statement.executeQuery(string2);
            String string3 = resultSet.next() ? resultSet.getString(1) : "TABLE";
            resultSet.close();
            if (DBTablesPanel.getDataExportProperties().getTableStructure()) {
                if (string3.equals("VIEW")) {
                    this.tableDefinition.append("DROP VIEW " + this.schemaTableName + ";\n");
                } else {
                    this.tableDefinition.append("DROP " + string3 + " " + this.schemaTableName + ";\n");
                }
            }
            if (string3.equals("VIEW")) {
                string2 = "SELECT TEXT FROM ALL_VIEWS WHERE VIEW_NAME='" + this.tableName + "'";
                resultSet = statement.executeQuery(string2);
                if (resultSet.next()) {
                    this.tableDefinition.append("CREATE " + string3 + " " + this.schemaTableName + " AS " + resultSet.getString(1) + ";\n");
                }
                resultSet.close();
                return;
            }
            this.tableDefinition.append("CREATE " + string3 + " " + this.schemaTableName + " (\n    ");
            string2 = "SELECT * FROM " + this.schemaTableName + " WHERE ROWNUM=1";
            resultSet = statement.executeQuery(string2);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            String string4 = "";
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            for (n = 1; n < resultSetMetaData.getColumnCount() + 1; ++n) {
                string = resultSetMetaData.getColumnName(n);
                string2 = "SELECT USER_IND_COLUMNS.INDEX_NAME, ALL_SEQUENCES.MIN_VALUE, ALL_SEQUENCES.MAX_VALUE, ALL_SEQUENCES.INCREMENT_BY, ALL_SEQUENCES.CYCLE_FLAG, ALL_SEQUENCES.ORDER_FLAG, ALL_SEQUENCES.CACHE_SIZE FROM USER_IND_COLUMNS, ALL_SEQUENCES WHERE USER_IND_COLUMNS.INDEX_NAME=ALL_SEQUENCES.SEQUENCE_NAME AND USER_IND_COLUMNS.TABLE_NAME='" + this.tableName + "' AND USER_IND_COLUMNS.COLUMN_NAME='" + string + "'";
                resultSet2 = statement2.executeQuery(string2);
                if (resultSet2.next()) {
                    stringArray = resultSet2.getString("INDEX_NAME");
                    hashMap.put(string, stringArray);
                    hashMap2.put(string, resultSet2.getString("MIN_VALUE").trim() + "," + resultSet2.getString("MAX_VALUE").trim() + "," + resultSet2.getString("INCREMENT_BY").trim() + "," + resultSet2.getString("CYCLE_FLAG").trim() + "," + resultSet2.getString("ORDER_FLAG").trim() + "," + resultSet2.getString("CACHE_SIZE").trim());
                }
                resultSet2.close();
            }
            statement2.close();
            resultSet.close();
            resultSet = databaseMetaData.getColumns(this.databaseName, this.schemaName, this.tableName, "%");
            while (resultSet.next()) {
                String string5;
                String string6;
                block279: {
                    String string7;
                    block294: {
                        block293: {
                            block292: {
                                block291: {
                                    block290: {
                                        int n2;
                                        block289: {
                                            block288: {
                                                block287: {
                                                    int n3;
                                                    String string8;
                                                    block284: {
                                                        block286: {
                                                            block285: {
                                                                string = resultSet.getString("COLUMN_NAME");
                                                                string8 = resultSet.getString("DATA_TYPE");
                                                                string7 = resultSet.getString("TYPE_NAME");
                                                                n2 = resultSet.getInt("COLUMN_SIZE");
                                                                n3 = resultSet.getInt("DECIMAL_DIGITS");
                                                                string6 = resultSet.getString("COLUMN_DEF");
                                                                string5 = resultSet.getString("IS_NULLABLE");
                                                                this.tableDefinition.append(this.identifierQuoteString + string + this.identifierQuoteString + " ");
                                                                if (string7.indexOf("CHAR") == -1) break block284;
                                                                if (!string7.equals("CHAR")) break block285;
                                                                this.tableDefinition.append("CHAR(" + n2 + ")");
                                                                break block279;
                                                            }
                                                            if (!string7.equals("NCHAR")) break block286;
                                                            this.tableDefinition.append("NCHAR(" + n2 + ")");
                                                            break block279;
                                                        }
                                                        if (string7.equals("VARCHAR2")) {
                                                            this.tableDefinition.append("VARCHAR2(" + n2 + ")");
                                                            break block279;
                                                        } else if (string7.equals("NVARCHAR2")) {
                                                            this.tableDefinition.append("NVARCHAR2(" + n2 + ")");
                                                            break block279;
                                                        } else {
                                                            this.tableDefinition.append(string7);
                                                        }
                                                        break block279;
                                                    }
                                                    if (!string7.equals("NUMBER")) break block287;
                                                    if (string8.toLowerCase(Locale.ENGLISH).indexOf("double") != -1) {
                                                        this.tableDefinition.append("FLOAT");
                                                        break block279;
                                                    } else if (n3 < 0) {
                                                        this.tableDefinition.append("NUMBER");
                                                        break block279;
                                                    } else {
                                                        this.tableDefinition.append("NUMBER(" + n2 + "," + n3 + ")");
                                                    }
                                                    break block279;
                                                }
                                                if (!string7.equals("BINARY_FLOAT")) break block288;
                                                this.tableDefinition.append(string7);
                                                break block279;
                                            }
                                            if (!string7.equals("BINARY_DOUBLE")) break block289;
                                            this.tableDefinition.append(string7);
                                            break block279;
                                        }
                                        if (!string7.equals("RAW")) break block290;
                                        this.tableDefinition.append("RAW(" + n2 + ")");
                                        break block279;
                                    }
                                    if (!string7.equals("TIMESTAMP")) break block291;
                                    this.tableDefinition.append(string7);
                                    break block279;
                                }
                                if (!string7.equals("TIMESTAMPTZ") && !string7.equals("TIMESTAMP WITH TIME ZONE")) break block292;
                                this.tableDefinition.append("TIMESTAMP WITH TIME ZONE");
                                break block279;
                            }
                            if (!string7.equals("TIMESTAMPLTZ") && !string7.equals("TIMESTAMP WITH LOCAL TIME ZONE")) break block293;
                            this.tableDefinition.append("TIMESTAMP WITH LOCAL TIME ZONE");
                            break block279;
                        }
                        if (string7.indexOf("INTERVAL") == -1) break block294;
                        if (string7.equals("INTERVALYM")) {
                            this.tableDefinition.append("INTERVAL YEAR TO MONTH");
                            break block279;
                        } else if (string7.equals("INTERVALDS")) {
                            this.tableDefinition.append("INTERVAL DAY TO SECOND");
                            break block279;
                        } else {
                            this.tableDefinition.append(string7);
                        }
                        break block279;
                    }
                    this.tableDefinition.append(string7);
                }
                if (string6 != null) {
                    if (string6.indexOf("::") != -1) {
                        this.tableDefinition.append(" DEFAULT " + string6.substring(0, string6.indexOf(":")).trim());
                    } else {
                        this.tableDefinition.append(" DEFAULT " + string6.trim());
                    }
                    if (string5.equals("NO")) {
                        this.tableDefinition.append(" NOT NULL,\n    ");
                        continue;
                    }
                    this.tableDefinition.append(",\n    ");
                    continue;
                }
                if (string5.equals("YES")) {
                    this.tableDefinition.append(" DEFAULT NULL,\n    ");
                    continue;
                }
                if (string5.equals("NO")) {
                    this.tableDefinition.append(" NOT NULL,\n    ");
                    continue;
                }
                this.tableDefinition.append(",\n    ");
            }
            string = "";
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            String string9 = "";
            String string10 = "";
            String string11 = "";
            String string12 = "";
            resultSet.close();
            resultSet = databaseMetaData.getPrimaryKeys(this.databaseName, this.schemaName, this.tableName);
            while (resultSet.next()) {
                string = resultSet.getString("COLUMN_NAME");
                if (hashMap.containsKey(string)) {
                    string4 = "primary_" + string;
                }
                stringBuffer.append(this.identifierQuoteString + string + this.identifierQuoteString + ",");
            }
            resultSet.close();
            resultSet = databaseMetaData.getIndexInfo(this.databaseName, this.dbIdentifierQuoteString + this.schemaName + this.dbIdentifierQuoteString, this.dbIdentifierQuoteString + this.tableName + this.dbIdentifierQuoteString, false, false);
            while (resultSet.next()) {
                string = resultSet.getString("COLUMN_NAME");
                if (string == null || stringBuffer.indexOf(string) != -1) continue;
                if (hashMap.containsKey(string)) {
                    string4 = "unique_" + string;
                }
                stringBuffer2.append(this.identifierQuoteString + string + this.identifierQuoteString + ",");
            }
            if (stringBuffer2.length() != 0 && string4.indexOf("unique") == -1) {
                this.tableDefinition.append("UNIQUE (" + stringBuffer2.substring(0, stringBuffer2.length() - 1) + "),\n    ");
            }
            if (stringBuffer.length() != 0 && string4.indexOf("primary") == -1) {
                this.tableDefinition.append("PRIMARY KEY (" + stringBuffer.substring(0, stringBuffer.length() - 1) + "),\n    ");
            }
            resultSet.close();
            resultSet = databaseMetaData.getImportedKeys(this.databaseName, this.schemaName, this.tableName);
            int n4 = 0;
            while (resultSet.next()) {
                ++n4;
            }
            resultSet = databaseMetaData.getImportedKeys(this.databaseName, this.schemaName, this.tableName);
            n = 0;
            while (resultSet.next()) {
                string = resultSet.getString("FKCOLUMN_NAME");
                string10 = resultSet.getString("PKTABLE_NAME");
                string11 = resultSet.getString("PKCOLUMN_NAME");
                string12 = "CASCADE";
                string9 = this.identifierQuoteString + string + this.identifierQuoteString;
                this.tableDefinition.append("FOREIGN KEY (" + string9 + ") REFERENCES " + this.identifierQuoteString + string10 + this.identifierQuoteString + "(" + this.identifierQuoteString + string11 + this.identifierQuoteString + ") ON DELETE " + string12);
                if (n < n4) {
                    this.tableDefinition.append(",\n    ");
                } else {
                    this.tableDefinition.append(" \n    ");
                }
                ++n;
            }
            this.tableDefinition.delete(this.tableDefinition.length() - 6, this.tableDefinition.length());
            this.tableDefinition.append("\n);\n");
            if (string4.equals("")) return;
            string = string4.substring(string4.indexOf("_") + 1);
            try {
                stringArray = ((String)hashMap2.get(string)).split(",");
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 1.0;
                double d4 = 0.0;
                boolean bl = false;
                boolean bl2 = false;
                block233: for (int i = 0; i < stringArray.length; ++i) {
                    switch (i) {
                        case 0: {
                            d = Double.parseDouble(stringArray[i]);
                            continue block233;
                        }
                        case 1: {
                            d2 = Double.parseDouble(stringArray[i]);
                            continue block233;
                        }
                        case 2: {
                            d3 = Double.parseDouble(stringArray[i]);
                            continue block233;
                        }
                        case 3: {
                            bl = !stringArray[i].equals("N");
                            continue block233;
                        }
                        case 4: {
                            bl2 = !stringArray[i].equals("N");
                            continue block233;
                        }
                        case 5: {
                            d4 = Double.parseDouble(stringArray[i]);
                            continue block233;
                        }
                    }
                }
                this.tableDefinition.append("CREATE SEQUENCE " + this.identifierQuoteString + (String)hashMap.get(string) + this.identifierQuoteString + "\n");
                this.tableDefinition.append("   INCREMENT BY " + d3 + "\n");
                if (d3 > 0.0) {
                    this.tableDefinition.append("   START WITH " + d + "\n");
                } else {
                    this.tableDefinition.append("   START WITH " + d2 + "\n");
                }
                if (d2 < 1.0E28) {
                    this.tableDefinition.append("   MAXVALUE " + d2 + "\n");
                } else {
                    this.tableDefinition.append("   NOMAXVALUE\n");
                }
                if (d > -1.0E27) {
                    this.tableDefinition.append("   MINVALUE " + d + "\n");
                } else {
                    this.tableDefinition.append("   NOMINVALUE\n");
                }
                if (bl) {
                    this.tableDefinition.append("   CYCLE\n");
                } else {
                    this.tableDefinition.append("   NOCYCLE\n");
                }
                this.tableDefinition.append("   CACHE " + d4 + "\n");
                if (bl2) {
                    this.tableDefinition.append("   ORDER\n");
                } else {
                    this.tableDefinition.append("   NOORDER;\n");
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.tableDefinition.append("CREATE SEQUENCE " + this.identifierQuoteString + (String)hashMap.get(string) + this.identifierQuoteString + ";\n");
            }
            this.tableDefinition.append("ALTER TABLE " + this.identifierQuoteString + this.tableName + this.identifierQuoteString + " ADD CONSTRAINT " + this.identifierQuoteString + (String)hashMap.get(string) + this.identifierQuoteString + " ");
            if (string4.indexOf("primary") != -1) {
                this.tableDefinition.append("PRIMARY KEY (" + stringBuffer.substring(0, stringBuffer.length() - 1) + ");\n\n  ");
                return;
            }
            this.tableDefinition.append("UNIQUE (" + stringBuffer2.substring(0, stringBuffer2.length() - 1) + ");\n\n  ");
            return;
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "TableDefinitionGenerator createOracleTableDefinition()");
            return;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "TableDefinitionGenerator createOracleTableDefinition()");
            }
            finally {
                try {
                    if (resultSet2 != null) {
                        resultSet2.close();
                    }
                }
                catch (SQLException sQLException) {
                    ConnectionManager.displaySQLErrors(sQLException, "TableDefinitionGenerator createOracleTableDefinition()");
                }
                finally {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        ConnectionManager.displaySQLErrors(sQLException, "TableDefinitionGenerator createOracleTableDefinition()");
                    }
                    finally {
                        if (statement2 != null) {
                            statement2.close();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createSQLiteTableDefinition() throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.dbConnection.createStatement();
            String string = "SELECT type, sql FROM (SELECT * FROM sqlite_master UNION ALL SELECT * FROM sqlite_temp_master) WHERE type!='meta' AND sql NOT NULL AND name='" + this.tableName + "'";
            resultSet = statement.executeQuery(string);
            if (resultSet.next()) {
                String string2;
                if (DBTablesPanel.getDataExportProperties().getTableStructure() && (string2 = resultSet.getString("type")) != null) {
                    this.tableDefinition.append("DROP " + string2.toUpperCase(Ajqvue.getLocale()) + " IF EXISTS " + this.schemaTableName + ";\n");
                }
                this.tableDefinition.append(resultSet.getString("sql") + ";\n");
                return;
            }
            this.tableDefinition.append("\n");
            return;
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "TableDefinitionGenerator createSQLiteTableDefinition()");
            return;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "TableDefinitionGenerator createSQLiteTableDefinition()");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    private void createMSAccessTableDefinition() {
        this.tableDefinition.append("-- MSAccess Table Definition, DDL, Not Supported At This Time.\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createMSSQLTableDefinition() throws SQLException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Statement statement = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        try {
            String string;
            String string2;
            statement = this.dbConnection.createStatement();
            String string3 = "SELECT " + this.dbIdentifierQuoteString + "TABLE_TYPE" + this.dbIdentifierQuoteString + " FROM " + this.dbIdentifierQuoteString + "INFORMATION_SCHEMA" + this.dbIdentifierQuoteString + "." + this.dbIdentifierQuoteString + "TABLES" + this.dbIdentifierQuoteString + " WHERE " + this.dbIdentifierQuoteString + "TABLE_SCHEMA" + this.dbIdentifierQuoteString + "='" + this.schemaName + "' AND TABLE_NAME='" + this.tableName + "'";
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                string2 = resultSet.getString(1);
                if (string2.equals("BASE TABLE")) {
                    string2 = "TABLE";
                }
            } else {
                string2 = "TABLE";
            }
            resultSet.close();
            if (DBTablesPanel.getDataExportProperties().getTableStructure()) {
                this.tableDefinition.append("DROP " + string2 + " " + this.schemaTableName + ";\n");
            }
            if (string2.equals("VIEW")) {
                string3 = "SELECT " + this.dbIdentifierQuoteString + "VIEW_DEFINITION" + this.dbIdentifierQuoteString + " FROM " + this.dbIdentifierQuoteString + "INFORMATION_SCHEMA" + this.dbIdentifierQuoteString + "." + this.dbIdentifierQuoteString + "VIEWS" + this.dbIdentifierQuoteString + " WHERE " + this.dbIdentifierQuoteString + "TABLE_SCHEMA" + this.dbIdentifierQuoteString + "='" + this.schemaName + "' AND TABLE_NAME='" + this.tableName + "'";
                resultSet = statement.executeQuery(string3);
                if (!resultSet.next()) return;
                String string4 = resultSet.getString(1).replaceAll("\n", " ");
                if (string4.indexOf("/*") != -1) {
                    this.tableDefinition.append(string4.substring(0, string4.indexOf("/*")).trim() + ";\n");
                    return;
                }
                this.tableDefinition.append(resultSet.getString(1) + ";\n");
                return;
            }
            this.tableDefinition.append("CREATE " + string2 + " " + this.schemaTableName + " (\n    ");
            DatabaseMetaData databaseMetaData = this.dbConnection.getMetaData();
            string3 = "SELECT TOP 1 * FROM " + this.schemaTableName;
            resultSet.close();
            resultSet = statement.executeQuery(string3);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            resultSet = databaseMetaData.getColumns(this.databaseName, this.schemaName, this.tableName, "%");
            String string5 = "";
            for (int i = 1; i < resultSetMetaData.getColumnCount() + 1; ++i) {
                string = resultSetMetaData.getColumnName(i);
                if (resultSetMetaData.isAutoIncrement(i)) {
                    string5 = string;
                }
                hashMap.put(string, resultSetMetaData.getPrecision(i));
            }
            while (resultSet.next()) {
                string = resultSet.getString("COLUMN_NAME");
                String string6 = resultSet.getString("TYPE_NAME").toUpperCase(Locale.ENGLISH);
                String string7 = resultSet.getString("COLUMN_SIZE");
                int n = hashMap.get(string) != null ? (Integer)hashMap.get(string) : 0;
                this.tableDefinition.append(this.identifierQuoteString + string + this.identifierQuoteString + " ");
                if (string6.indexOf("CHAR") != -1) {
                    this.tableDefinition.append(string6 + "(" + string7 + ")");
                } else if (string6.indexOf("INT") != -1 || string6.indexOf("BIGINT") != -1) {
                    this.tableDefinition.append(string6);
                    if (string.equals(string5)) {
                        if (string6.indexOf("IDENTITY") != -1) {
                            this.tableDefinition.append("(1,1)");
                        } else {
                            this.tableDefinition.append(" IDENTITY(1,)");
                        }
                        this.tableDefinition.append(",\n    ");
                        continue;
                    }
                } else if (string6.equals("DECIMAL") || string6.equals("NUMERIC")) {
                    this.tableDefinition.append(string6 + "(" + n + "," + resultSet.getString("DECIMAL_DIGITS") + ")");
                } else if (string6.equals("BLOB") || string6.indexOf("BINARY") != -1) {
                    this.tableDefinition.append(string6 + "(" + string7 + ")");
                } else if (string6.equals("CLOB")) {
                    this.tableDefinition.append(string6 + "(" + string7 + ")");
                } else if (string6.equals("DATETIMEOFFSET")) {
                    string3 = "SELECT " + this.dbIdentifierQuoteString + "DATETIME_PRECISION" + this.dbIdentifierQuoteString + " FROM " + this.dbIdentifierQuoteString + "INFORMATION_SCHEMA" + this.dbIdentifierQuoteString + "." + this.dbIdentifierQuoteString + "COLUMNS" + this.dbIdentifierQuoteString + " WHERE " + this.dbIdentifierQuoteString + "TABLE_SCHEMA" + this.dbIdentifierQuoteString + "='" + this.schemaName + "' AND TABLE_NAME='" + this.tableName + "' AND COLUMN_NAME='" + string + "'";
                    resultSet2 = statement.executeQuery(string3);
                    int n2 = resultSet2.next() ? resultSet2.getInt("DATETIME_PRECISION") : 0;
                    resultSet2.close();
                    this.tableDefinition.append(string6 + "(" + n2 + ")");
                } else {
                    this.tableDefinition.append(string6);
                }
                String string8 = resultSet.getString("COLUMN_DEF");
                if (string8 != null) {
                    if ((string8 = string8.trim()).indexOf("(") != -1) {
                        string8 = string8.substring(string8.lastIndexOf("(") + 1);
                    }
                    if (string8.indexOf("") != -1) {
                        string8 = string8.substring(0, string8.indexOf(")"));
                    }
                    if (string8.equals("NULL")) {
                        string8 = null;
                    }
                }
                if (string8 != null) {
                    if (resultSet.getString("IS_NULLABLE").equals("NO")) {
                        if (!string8.toUpperCase(Locale.ENGLISH).equals("NULL")) {
                            this.tableDefinition.append(" DEFAULT " + string8);
                        }
                        this.tableDefinition.append(" NOT NULL,\n    ");
                        continue;
                    }
                    this.tableDefinition.append(" DEFAULT " + string8);
                    this.tableDefinition.append(",\n    ");
                    continue;
                }
                if (resultSet.getString("IS_NULLABLE").equals("YES")) {
                    this.tableDefinition.append(" DEFAULT NULL,\n    ");
                    continue;
                }
                if (resultSet.getString("IS_NULLABLE").equals("NO")) {
                    this.tableDefinition.append(" NOT NULL,\n    ");
                    continue;
                }
                this.tableDefinition.append(",\n    ");
            }
            string = "";
            String string9 = "";
            StringBuffer stringBuffer = new StringBuffer();
            String string10 = "";
            String string11 = "";
            String string12 = "";
            String string13 = "";
            resultSet.close();
            resultSet = databaseMetaData.getPrimaryKeys(this.databaseName, this.schemaName, this.tableName);
            while (resultSet.next()) {
                string = resultSet.getString("COLUMN_NAME");
                string9 = string9 + this.identifierQuoteString + string + this.identifierQuoteString + ",";
            }
            resultSet.close();
            resultSet = databaseMetaData.getIndexInfo(this.databaseName, this.schemaName, this.tableName, true, false);
            while (resultSet.next()) {
                string = resultSet.getString("COLUMN_NAME");
                if (string == null || string9.indexOf(string) != -1 || string.equals(string5)) continue;
                stringBuffer.append(this.identifierQuoteString + string + this.identifierQuoteString + ",");
            }
            if (!stringBuffer.toString().equals("")) {
                this.tableDefinition.append("UNIQUE (" + stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length()) + "),\n    ");
            }
            if (!string9.equals("")) {
                this.tableDefinition.append("PRIMARY KEY (" + string9.substring(0, string9.length() - 1) + "),\n    ");
            }
            resultSet.close();
            resultSet = databaseMetaData.getImportedKeys(this.databaseName, this.schemaName, this.tableName);
            while (resultSet.next()) {
                string = resultSet.getString("FKCOLUMN_NAME");
                string11 = resultSet.getString("PKTABLE_NAME");
                string12 = resultSet.getString("PKCOLUMN_NAME");
                string13 = "CASCADE";
                string10 = this.identifierQuoteString + string + this.identifierQuoteString;
                this.tableDefinition.append("FOREIGN KEY (" + string10 + ") REFERENCES " + this.identifierQuoteString + string11 + this.identifierQuoteString + "(" + this.identifierQuoteString + string12 + this.identifierQuoteString + ") ON DELETE " + string13);
                this.tableDefinition.append(",\n    ");
            }
            this.tableDefinition.delete(this.tableDefinition.length() - 6, this.tableDefinition.length());
            this.tableDefinition.append("\n);\n");
            return;
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "TableDefinitionGenerator createMSSQLTableDefinition()");
            return;
        }
        finally {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    ConnectionManager.displaySQLErrors(sQLException, "TableDefinitionGenerator createMSSQLTableDefinition()");
                }
                finally {
                    if (resultSet2 != null) {
                        resultSet2.close();
                    }
                }
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "TableDefinitionGenerator createMSSQLTableDefinition()");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createDerbyTableDefinition() throws SQLException {
        String string = "";
        String string2 = "";
        String string3 = "";
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        HashMap<String, Integer> hashMap3 = new HashMap<String, Integer>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string4;
            statement = this.dbConnection.createStatement();
            DatabaseMetaData databaseMetaData = this.dbConnection.getMetaData();
            String string5 = "SELECT SCHEMAID FROM SYS.SYSSCHEMAS WHERE SCHEMANAME='" + this.schemaName + "'";
            resultSet = statement.executeQuery(string5);
            if (!resultSet.next()) return;
            string = resultSet.getString(1);
            resultSet.close();
            string5 = "SELECT TABLEID, TABLETYPE FROM SYS.SYSTABLES WHERE TABLENAME='" + this.tableName + "' AND SCHEMAID='" + string + "'";
            resultSet = statement.executeQuery(string5);
            if (!resultSet.next()) return;
            string2 = resultSet.getString(1);
            string3 = resultSet.getString(2);
            resultSet.close();
            string3 = string3.equals("T") ? "TABLE" : (string3.equals("V") ? "VIEW" : "SYSTEM");
            if (DBTablesPanel.getDataExportProperties().getTableStructure()) {
                this.tableDefinition.append("DROP " + string3 + " " + this.schemaTableName + ";\n");
            }
            if (string3.equals("VIEW")) {
                string5 = "SELECT VIEWDEFINITION FROM SYS.SYSVIEWS WHERE COMPILATIONSCHEMAID='" + string + "' AND TABLEID='" + string2 + "'";
                resultSet = statement.executeQuery(string5);
                if (resultSet.next()) {
                    this.tableDefinition.append("CREATE " + string3 + " " + this.schemaTableName + " AS " + resultSet.getString(1) + ";\n");
                }
                resultSet.close();
                return;
            }
            this.tableDefinition.append("CREATE " + string3 + " " + this.schemaTableName + " (\n    ");
            string5 = "SELECT * FROM " + this.schemaTableName + " FETCH FIRST ROW ONLY";
            resultSet.close();
            resultSet = statement.executeQuery(string5);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            resultSet.close();
            resultSet = databaseMetaData.getColumns(resultSetMetaData.getCatalogName(1), resultSetMetaData.getSchemaName(1), resultSetMetaData.getTableName(1), "%");
            for (int i = 1; i < resultSetMetaData.getColumnCount() + 1; ++i) {
                string4 = resultSetMetaData.getColumnName(i);
                if (resultSetMetaData.isAutoIncrement(i)) {
                    string5 = "SELECT AUTOINCREMENTSTART, AUTOINCREMENTINC FROM SYS.SYSCOLUMNS WHERE REFERENCEID='" + string2 + "' AND  COLUMNNAME='" + string4 + "'";
                    ResultSet resultSet2 = statement.executeQuery(string5);
                    if (resultSet2.next()) {
                        hashMap2.put(string4, resultSet2.getInt(1));
                        hashMap3.put(string4, resultSet2.getInt(2));
                    }
                    resultSet2.close();
                }
                hashMap.put(string4, resultSetMetaData.getPrecision(i));
            }
            while (resultSet.next()) {
                String string6;
                String string7;
                block68: {
                    int n;
                    int n2;
                    int n3;
                    String string8;
                    block70: {
                        block73: {
                            block72: {
                                block71: {
                                    string4 = resultSet.getString("COLUMN_NAME");
                                    string8 = resultSet.getString("TYPE_NAME");
                                    n3 = resultSet.getInt("COLUMN_SIZE");
                                    n2 = resultSet.getInt("DECIMAL_DIGITS");
                                    string7 = resultSet.getString("COLUMN_DEF");
                                    string6 = resultSet.getString("IS_NULLABLE");
                                    n = hashMap.get(string4) != null ? (Integer)hashMap.get(string4) : 0;
                                    this.tableDefinition.append(this.identifierQuoteString + string4 + this.identifierQuoteString + " ");
                                    if (string8.indexOf("CHAR") == -1) break block70;
                                    if (!string8.equals("CHAR")) break block71;
                                    this.tableDefinition.append("CHAR(" + n3 + ")");
                                    break block68;
                                }
                                if (!string8.equals("VARCHAR")) break block72;
                                this.tableDefinition.append("VARCHAR(" + n3 + ")");
                                break block68;
                            }
                            if (string8.indexOf("FOR BIT DATA") == -1) break block73;
                            if (string8.indexOf("VARCHAR") != -1) {
                                if (string8.indexOf("LONG") != -1) {
                                    this.tableDefinition.append("LONG VARCHAR FOR BIT DATA");
                                    break block68;
                                } else {
                                    this.tableDefinition.append("VARCHAR(" + n3 + ") FOR BIT DATA");
                                }
                                break block68;
                            } else {
                                this.tableDefinition.append("CHAR(" + n3 + ") FOR BIT DATA");
                            }
                            break block68;
                        }
                        this.tableDefinition.append(string8);
                        break block68;
                    }
                    if (string8.equals("BLOB")) {
                        this.tableDefinition.append(string8 + "(" + n3 + ")");
                    } else if (string8.equals("CLOB")) {
                        this.tableDefinition.append(string8 + "(" + n3 + ")");
                    } else if (string8.equals("DECIMAL")) {
                        this.tableDefinition.append(string8 + "(" + n + "," + n2 + ")");
                    } else {
                        this.tableDefinition.append(string8);
                    }
                }
                if (string7 != null && string7.equals("NULL")) {
                    string7 = null;
                }
                if (string7 != null) {
                    if ((string7 = string7.trim()).indexOf("::") != -1) {
                        this.tableDefinition.append(" WITH DEFAULT " + string7.substring(0, string7.indexOf(":")).trim());
                    } else if (string7.indexOf("AUTOINCREMENT") != -1) {
                        this.tableDefinition.append(" GENERATED ALWAYS AS IDENTITY (START WITH " + hashMap2.get(string4) + ", INCREMENT BY " + hashMap3.get(string4) + ")");
                    } else if (string7.indexOf("GENERATED") != -1) {
                        this.tableDefinition.append(" GENERATED BY DEFAULT AS IDENTITY (START WITH " + hashMap2.get(string4) + ", INCREMENT BY " + hashMap3.get(string4) + ")");
                    } else {
                        this.tableDefinition.append(" WITH DEFAULT " + string7.trim());
                    }
                    if (string6.equals("NO")) {
                        this.tableDefinition.append(" NOT NULL,\n    ");
                        continue;
                    }
                    this.tableDefinition.append(",\n    ");
                    continue;
                }
                if (string6.equals("YES")) {
                    this.tableDefinition.append(" WITH DEFAULT NULL,\n    ");
                    continue;
                }
                if (string6.equals("NO")) {
                    this.tableDefinition.append(" NOT NULL,\n    ");
                    continue;
                }
                this.tableDefinition.append(",\n    ");
            }
            resultSet.close();
            string4 = "";
            String string9 = "";
            StringBuffer stringBuffer = new StringBuffer();
            String string10 = "";
            String string11 = "";
            String string12 = "";
            String string13 = "";
            resultSet = databaseMetaData.getPrimaryKeys(resultSetMetaData.getCatalogName(1), resultSetMetaData.getSchemaName(1), resultSetMetaData.getTableName(1));
            while (resultSet.next()) {
                string4 = resultSet.getString("COLUMN_NAME");
                string9 = string9 + this.identifierQuoteString + string4 + this.identifierQuoteString + ",";
            }
            resultSet.close();
            resultSet = databaseMetaData.getIndexInfo(resultSetMetaData.getCatalogName(1), resultSetMetaData.getSchemaName(1), resultSetMetaData.getTableName(1), true, false);
            while (resultSet.next()) {
                string4 = resultSet.getString("COLUMN_NAME");
                if (string9.indexOf(string4) != -1) continue;
                stringBuffer.append(this.identifierQuoteString + string4 + this.identifierQuoteString + ",");
            }
            if (!stringBuffer.toString().equals("")) {
                this.tableDefinition.append("UNIQUE (" + stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length()) + "),\n    ");
            }
            if (!string9.equals("")) {
                this.tableDefinition.append("PRIMARY KEY (" + string9.substring(0, string9.length() - 1) + "),\n    ");
            }
            resultSet.close();
            resultSet = databaseMetaData.getImportedKeys(resultSetMetaData.getCatalogName(1), resultSetMetaData.getSchemaName(1), resultSetMetaData.getTableName(1));
            while (resultSet.next()) {
                string4 = resultSet.getString("FKCOLUMN_NAME");
                string11 = resultSet.getString("PKTABLE_NAME");
                string12 = resultSet.getString("PKCOLUMN_NAME");
                string13 = "CASCADE";
                string10 = this.identifierQuoteString + string4 + this.identifierQuoteString;
                this.tableDefinition.append("FOREIGN KEY (" + string10 + ") REFERENCES " + this.identifierQuoteString + string11 + this.identifierQuoteString + "(" + this.identifierQuoteString + string12 + this.identifierQuoteString + ") ON DELETE " + string13);
                this.tableDefinition.append(",\n    ");
            }
            this.tableDefinition.delete(this.tableDefinition.length() - 6, this.tableDefinition.length());
            this.tableDefinition.append("\n);\n");
            return;
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "TableDefinitionGenerator createDerbyTableDefinition()");
            return;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "TableDefinitionGenerator createDerbyTableDefinition()");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createH2TableDefinition() throws SQLException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string;
            statement = this.dbConnection.createStatement();
            String string2 = "SELECT " + this.dbIdentifierQuoteString + "TABLE_TYPE" + this.dbIdentifierQuoteString + " FROM " + this.dbIdentifierQuoteString + "INFORMATION_SCHEMA" + this.dbIdentifierQuoteString + "." + this.dbIdentifierQuoteString + "TABLES" + this.dbIdentifierQuoteString + " WHERE " + this.dbIdentifierQuoteString + "TABLE_SCHEMA" + this.dbIdentifierQuoteString + "='" + this.schemaName + "' AND TABLE_NAME='" + this.tableName + "'";
            resultSet = statement.executeQuery(string2);
            String string3 = resultSet.next() ? resultSet.getString(1) : "TABLE";
            if (DBTablesPanel.getDataExportProperties().getTableStructure()) {
                this.tableDefinition.append("DROP " + string3 + " IF EXISTS " + this.schemaTableName + ";\n");
            }
            if (string3.equals("VIEW")) {
                string2 = "SELECT " + this.dbIdentifierQuoteString + "SQL" + this.dbIdentifierQuoteString + " FROM " + this.dbIdentifierQuoteString + "INFORMATION_SCHEMA" + this.dbIdentifierQuoteString + "." + this.dbIdentifierQuoteString + "TABLES" + this.dbIdentifierQuoteString + " WHERE " + this.dbIdentifierQuoteString + "TABLE_SCHEMA" + this.dbIdentifierQuoteString + "='" + this.schemaName + "' AND TABLE_NAME='" + this.tableName + "'";
                resultSet.close();
                resultSet = statement.executeQuery(string2);
                if (!resultSet.next()) return;
                String string4 = resultSet.getString(1).replaceAll("\n", " ");
                if (string4.indexOf("/*") != -1) {
                    this.tableDefinition.append(string4.substring(0, string4.indexOf("/*")).trim() + ";\n");
                    return;
                }
                this.tableDefinition.append(resultSet.getString(1) + ";\n");
                return;
            }
            this.tableDefinition.append("CREATE " + string3 + " " + this.schemaTableName + " (\n    ");
            DatabaseMetaData databaseMetaData = this.dbConnection.getMetaData();
            string2 = "SELECT * FROM " + this.schemaTableName + " LIMIT 1";
            resultSet.close();
            resultSet = statement.executeQuery(string2);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            resultSet = databaseMetaData.getColumns(resultSetMetaData.getCatalogName(1), resultSetMetaData.getSchemaName(1), resultSetMetaData.getTableName(1), "%");
            String string5 = "";
            for (int i = 1; i < resultSetMetaData.getColumnCount() + 1; ++i) {
                string = resultSetMetaData.getColumnName(i);
                if (resultSetMetaData.isAutoIncrement(i)) {
                    string5 = string;
                }
                hashMap.put(string, resultSetMetaData.getPrecision(i));
            }
            while (resultSet.next()) {
                string = resultSet.getString("COLUMN_NAME");
                String string6 = resultSet.getString("TYPE_NAME");
                String string7 = resultSet.getString("COLUMN_SIZE");
                int n = hashMap.get(string) != null ? (Integer)hashMap.get(string) : 0;
                this.tableDefinition.append(this.identifierQuoteString + string + this.identifierQuoteString + " ");
                if (string6.indexOf("CHAR") != -1) {
                    this.tableDefinition.append(string6 + "(" + string7 + ")");
                } else if (string6.equals("INTEGER") || string6.equals("BIGINT")) {
                    this.tableDefinition.append(string6);
                    if (string.equals(string5)) {
                        this.tableDefinition.append(" IDENTITY");
                        this.tableDefinition.append(",\n    ");
                        continue;
                    }
                } else if (string6.equals("DOUBLE")) {
                    this.tableDefinition.append(string6);
                } else if (string6.equals("DECIMAL") || string6.equals("NUMERIC")) {
                    this.tableDefinition.append(string6 + "(" + n + "," + resultSet.getString("DECIMAL_DIGITS") + ")");
                } else if (string6.equals("BLOB") || string6.equals("BINARY")) {
                    this.tableDefinition.append(string6 + "(" + string7 + ")");
                } else if (string6.equals("CLOB")) {
                    this.tableDefinition.append(string6 + "(" + string7 + ")");
                } else {
                    this.tableDefinition.append(string6);
                }
                String string8 = resultSet.getString("COLUMN_DEF");
                if (string8 != null && string8.equals("NULL")) {
                    string8 = null;
                }
                if (string8 != null) {
                    if ((string8 = string8.trim()).indexOf("::") != -1) {
                        this.tableDefinition.append(" DEFAULT " + string8.substring(0, string8.indexOf(":")));
                    } else {
                        this.tableDefinition.append(" DEFAULT " + string8);
                    }
                    if (resultSet.getString("IS_NULLABLE").equals("NO")) {
                        this.tableDefinition.append(" NOT NULL,\n    ");
                        continue;
                    }
                    this.tableDefinition.append(",\n    ");
                    continue;
                }
                if (resultSet.getString("IS_NULLABLE").equals("YES")) {
                    this.tableDefinition.append(" DEFAULT NULL,\n    ");
                    continue;
                }
                if (resultSet.getString("IS_NULLABLE").equals("NO")) {
                    this.tableDefinition.append(" NOT NULL,\n    ");
                    continue;
                }
                this.tableDefinition.append(",\n    ");
            }
            string = "";
            String string9 = "";
            StringBuffer stringBuffer = new StringBuffer();
            String string10 = "";
            String string11 = "";
            String string12 = "";
            String string13 = "";
            resultSet.close();
            resultSet = databaseMetaData.getPrimaryKeys(resultSetMetaData.getCatalogName(1), resultSetMetaData.getSchemaName(1), resultSetMetaData.getTableName(1));
            while (resultSet.next()) {
                string = resultSet.getString("COLUMN_NAME");
                string9 = string9 + this.identifierQuoteString + string + this.identifierQuoteString + ",";
            }
            resultSet.close();
            resultSet = databaseMetaData.getIndexInfo(resultSetMetaData.getCatalogName(1), resultSetMetaData.getSchemaName(1), resultSetMetaData.getTableName(1), true, false);
            while (resultSet.next()) {
                string = resultSet.getString("COLUMN_NAME");
                if (string9.indexOf(string) != -1 || string.equals(string5)) continue;
                stringBuffer.append(this.identifierQuoteString + string + this.identifierQuoteString + ",");
            }
            if (!stringBuffer.toString().equals("")) {
                this.tableDefinition.append("UNIQUE (" + stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length()) + "),\n    ");
            }
            if (!string9.equals("")) {
                this.tableDefinition.append("PRIMARY KEY (" + string9.substring(0, string9.length() - 1) + "),\n    ");
            }
            resultSet.close();
            resultSet = databaseMetaData.getImportedKeys(resultSetMetaData.getCatalogName(1), resultSetMetaData.getSchemaName(1), resultSetMetaData.getTableName(1));
            while (resultSet.next()) {
                string = resultSet.getString("FKCOLUMN_NAME");
                string11 = resultSet.getString("PKTABLE_NAME");
                string12 = resultSet.getString("PKCOLUMN_NAME");
                string13 = "CASCADE";
                string10 = this.identifierQuoteString + string + this.identifierQuoteString;
                this.tableDefinition.append("FOREIGN KEY (" + string10 + ") REFERENCES " + this.identifierQuoteString + string11 + this.identifierQuoteString + "(" + this.identifierQuoteString + string12 + this.identifierQuoteString + ") ON DELETE " + string13);
                if (resultSet.isLast()) {
                    this.tableDefinition.append(" \n    ");
                    continue;
                }
                this.tableDefinition.append(",\n    ");
            }
            this.tableDefinition.delete(this.tableDefinition.length() - 6, this.tableDefinition.length());
            this.tableDefinition.append("\n);\n");
            return;
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "TableDefinitionGenerator createH2TableDefinition()");
            return;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "TableDefinitionGenerator createH2TableDefinition()");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    public String getTableDefinition() {
        String string = ConnectionManager.getDataSourceType();
        this.tableDefinition.delete(0, this.tableDefinition.length());
        try {
            if (string.equals("mysql") || string.equals("mariadb")) {
                this.createSQLTableDefinition();
            } else if (string.equals("postgresql")) {
                this.createPostgreSQLTableDefinition();
            } else if (string.indexOf("hsql") != -1) {
                this.createHSQLTableDefinition();
            } else if (string.equals("oracle")) {
                this.createOracleTableDefinition();
            } else if (string.equals("sqlite")) {
                this.createSQLiteTableDefinition();
            } else if (string.equals("odbc")) {
                this.createMSAccessTableDefinition();
            } else if (string.equals("sqlserver")) {
                this.createMSSQLTableDefinition();
            } else if (string.equals("derby")) {
                this.createDerbyTableDefinition();
            } else if (string.indexOf("h2") != -1) {
                this.createH2TableDefinition();
            } else {
                this.tableDefinition.append(";\n");
            }
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "TableDefinitionGenerator getTableDefinition()");
        }
        return this.tableDefinition.toString().replaceAll(this.dbIdentifierQuoteString, this.identifierQuoteString);
    }
}

