/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.utilities.db;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.gui.panels.TableTabPanel_SQLite;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import com.dandymadeproductions.ajqvue.utilities.db.SQLQuery;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JProgressBar;

public class SearchDatabaseThread
implements Runnable {
    private ArrayList<String> databaseTables;
    private boolean[] selectedTables;
    private String searchQueryString;
    private JProgressBar searchProgressBar;
    private JButton searchCompleteButton;
    private int[] tableSearchResultCounts;
    private int resultsCount;
    private Object[][] resultData;
    private boolean cancelSearch;

    public SearchDatabaseThread(ArrayList<String> arrayList, boolean[] blArray, String string, JProgressBar jProgressBar, JButton jButton) {
        this.databaseTables = arrayList;
        this.selectedTables = (boolean[])blArray.clone();
        this.searchQueryString = string;
        this.searchProgressBar = jProgressBar;
        this.searchCompleteButton = jButton;
        this.cancelSearch = false;
    }

    @Override
    public void run() {
        int n;
        int n2;
        final Connection connection = ConnectionManager.getConnection("SearchDatabaseThread queryDatabase()");
        if (connection == null) {
            return;
        }
        String string = ConnectionManager.getIdentifierQuoteString();
        Thread[] threadArray = new Thread[this.databaseTables.size()];
        this.tableSearchResultCounts = new int[this.databaseTables.size()];
        for (n2 = 0; n2 < this.tableSearchResultCounts.length; ++n2) {
            this.tableSearchResultCounts[n2] = -1;
        }
        this.resultsCount = 0;
        n2 = 0;
        do {
            n = n2;
            if (!this.selectedTables[n2]) {
                ++this.resultsCount;
                ++n2;
                continue;
            }
            String string2 = this.databaseTables.get(n);
            String string3 = Utils.getSchemaTableName(string2);
            String string4 = "";
            try {
                string4 = this.createColumnsSQLQuery(connection, string3, this.searchQueryString);
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "SearchDatabaseThread run()");
            }
            if (string4.equals("")) {
                ++this.resultsCount;
                ++n2;
                continue;
            }
            final String string5 = "SELECT COUNT(*) AS " + string + "Count" + string + " FROM " + string3 + " WHERE " + string4;
            this.searchProgressBar.setValue(n + 1);
            threadArray[n2] = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    Statement statement = null;
                    ResultSet resultSet = null;
                    try {
                        statement = connection.createStatement();
                        resultSet = statement.executeQuery(string5);
                        while (resultSet.next()) {
                            int n2;
                            ((SearchDatabaseThread)SearchDatabaseThread.this).tableSearchResultCounts[n] = n2 = resultSet.getInt(1);
                            if (n2 <= 0) continue;
                            SearchDatabaseThread.this.resultsCount++;
                        }
                        return;
                    }
                    catch (SQLException sQLException) {
                        if (Ajqvue.getDebug()) {
                            System.out.println("SearchDatabaseThread run() " + sQLException.toString());
                        }
                        SearchDatabaseThread.this.resultsCount++;
                        return;
                    }
                    finally {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            ConnectionManager.displaySQLErrors(sQLException, "SearchDatabaseThread run()");
                        }
                        finally {
                            try {
                                if (statement != null) {
                                    statement.close();
                                }
                            }
                            catch (SQLException sQLException) {
                                ConnectionManager.displaySQLErrors(sQLException, "SearchDatabaseThread run()");
                            }
                        }
                    }
                }
            });
            threadArray[n2].start();
            ++n2;
        } while (n2 < this.databaseTables.size() && !this.cancelSearch);
        for (n = 0; n < this.databaseTables.size(); ++n) {
            try {
                if (threadArray[n] == null) continue;
                threadArray[n].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                if (!Ajqvue.getDebug()) continue;
                System.out.println("SearchDatabaseThread run() " + interruptedException.toString());
            }
        }
        this.resultData = new Object[this.resultsCount][3];
        int n3 = 0;
        for (n = 0; n < this.databaseTables.size() && n3 < this.resultsCount; ++n) {
            if (this.tableSearchResultCounts[n] == 0) continue;
            this.resultData[n3][0] = this.selectedTables[n];
            this.resultData[n3][1] = this.databaseTables.get(n);
            this.resultData[n3++][2] = this.tableSearchResultCounts[n];
        }
        this.searchCompleteButton.doClick();
        ConnectionManager.closeConnection(connection, "SearchDatabaseThread queryDatabase()");
    }

    private String createColumnsSQLQuery(Connection connection, String string, String string2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = ConnectionManager.getIdentifierQuoteString();
        try {
            String string4 = ConnectionManager.getDataSourceType();
            String string5 = string4.equals("hsql") ? "SELECT LIMIT 0 1 * FROM " + string : (string4.equals("oracle") ? "SELECT * FROM " + string + " WHERE ROWNUM=1" : (string4.equals("odbc") ? "SELECT * FROM " + string : (string4.equals("sqlserver") ? "SELECT TOP 1 * FROM " + string : (string4.equals("derby") ? "SELECT * FROM " + string + " FETCH FIRST ROW ONLY" : "SELECT * FROM " + string + " LIMIT 1"))));
            SQLQuery sQLQuery = new SQLQuery(string5);
            if (sQLQuery.executeSQL(connection) != 1) {
                return "";
            }
            for (int i = 0; i < sQLQuery.getColumnNames().size(); ++i) {
                String string6 = sQLQuery.getColumnNames().get(i);
                String string7 = sQLQuery.getColumnClassHashMap().get(string6);
                int n = sQLQuery.getColumnSQLTypeHashMap().get(string6);
                String string8 = sQLQuery.getColumnTypeNameHashMap().get(string6);
                String string9 = string2;
                if (Utils.isBlob(string7, string8) || string8.indexOf("FILE") != -1) continue;
                if (string8.equals("DATE")) {
                    if (string4.equals("oracle")) {
                        if ((string9 = Utils.processDateFormatSearch(string9)).equals("0") || string9.equals(string2)) {
                            string9 = string2;
                            string8 = "";
                        }
                    } else if ((string9 = Utils.processDateFormatSearch(string9)).equals("0")) {
                        string9 = string2;
                    }
                } else if (string8.indexOf("DATETIME") != -1 || string8.equals("TIMESTAMP") && !string4.equals("sqlserver") || string8.equals("TIMESTAMPTZ")) {
                    if (string9.indexOf(" ") != -1) {
                        string9 = Utils.processDateFormatSearch(string9.substring(0, string9.indexOf(" "))) + string9.substring(string9.indexOf(" "));
                    } else if (string9.indexOf("-") != -1 || string9.indexOf("/") != -1) {
                        string9 = Utils.processDateFormatSearch(string9);
                    }
                }
                if (string4.equals("postgresql")) {
                    stringBuffer.append(string3 + string6 + string3 + "::TEXT LIKE '%" + string9 + "%' OR ");
                    continue;
                }
                if (string4.equals("derby")) {
                    if (string7.indexOf("STRING") != -1) {
                        stringBuffer.append(string3 + string6 + string3 + " LIKE '%" + string9 + "%' OR ");
                        continue;
                    }
                    if (string8.equals("DOUBLE") || string8.equals("REAL")) {
                        stringBuffer.append(string3 + string6 + string3 + "=" + string9 + " OR ");
                        continue;
                    }
                    stringBuffer.append("CAST(" + string3 + string6 + string3 + " AS CHAR(254)) LIKE '%" + string9 + "%' OR ");
                    continue;
                }
                if (string4.equals("oracle")) {
                    if (string8.equals("DATE")) {
                        stringBuffer.append(string3 + string6 + string3 + " LIKE TO_DATE('" + string9 + "', 'YYYY-MM-dd') OR ");
                        continue;
                    }
                    stringBuffer.append(string3 + string6 + string3 + " LIKE '%" + string9 + "%' OR ");
                    continue;
                }
                if (string4.equalsIgnoreCase("sqlite")) {
                    TableTabPanel_SQLite.createSearch(stringBuffer, string7, n, string8, string3 + string6 + string3, string2, "LIKE", "%");
                    stringBuffer.append(" OR ");
                    continue;
                }
                stringBuffer.append(string3 + string6 + string3 + " LIKE '%" + string9 + "%' OR ");
            }
            if (stringBuffer.length() > 4) {
                return stringBuffer.delete(stringBuffer.length() - 4, stringBuffer.length()).toString();
            }
            return "";
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "SearchDatabaseThread createColumnSQLQuery()");
            return "";
        }
    }

    public void cancel() {
        this.cancelSearch = true;
    }

    public Object[][] getResultData() {
        if (this.resultData != null) {
            return (Object[][])this.resultData.clone();
        }
        return null;
    }
}

