/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.utilities.db;

import com.dandymadeproductions.ajqvue.datasource.ConnectionInstance;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class SQLQuery {
    private String sqlString;
    private int validQuery;
    private int tableRowLimit;
    private ArrayList<String> columnNames;
    private HashMap<String, String> columnClassHashMap;
    private HashMap<String, Integer> columnSQLTypeHashMap;
    private HashMap<String, String> columnTypeNameHashMap;
    private HashMap<String, Integer> columnPrecisionHashMap;
    private HashMap<String, Integer> columnScaleHashMap;
    private HashMap<String, Integer> columnSizeHashMap;
    private HashMap<String, Integer> columnIsNullableHashMap;
    private HashMap<String, Boolean> columnIsAutoIncrementHashMap;
    private StringBuilder sqlColumnNamesString;
    private StringBuilder sqlOracleColumnNamesString;

    public SQLQuery(String string) {
        this(string, 1);
    }

    public SQLQuery(String string, int n) {
        this.sqlString = string;
        this.tableRowLimit = n;
        this.validQuery = -1;
        this.columnNames = new ArrayList();
        this.columnClassHashMap = new HashMap();
        this.columnSQLTypeHashMap = new HashMap();
        this.columnTypeNameHashMap = new HashMap();
        this.columnScaleHashMap = new HashMap();
        this.columnPrecisionHashMap = new HashMap();
        this.columnSizeHashMap = new HashMap();
        this.columnIsNullableHashMap = new HashMap();
        this.columnIsAutoIncrementHashMap = new HashMap();
        this.sqlColumnNamesString = new StringBuilder();
        this.sqlOracleColumnNamesString = new StringBuilder();
    }

    public int executeSQL() {
        Connection connection = ConnectionManager.getConnection("SQLQuery executeSQL()");
        try {
            this.executeSQL(connection);
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "SQLQuery executeSQL()");
        }
        ConnectionManager.closeConnection(connection, "SQLQuery executeSQL()");
        return this.validQuery;
    }

    public int executeSQL(ConnectionInstance connectionInstance) {
        Connection connection = connectionInstance.getConnection("SQLQuery executeSQL()");
        try {
            this.executeSQL(connection);
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "SQLQuery executeSQL()");
        }
        connectionInstance.closeConnection(connection, "SQLQuery executeSQL()");
        return this.validQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeSQL(Connection var1_1) throws SQLException {
        if (this.sqlString.length() < 1) return this.validQuery;
        if (var1_1 == null) {
            return this.validQuery;
        }
        var16_2 = null;
        var3_3 = null;
        var5_4 = var1_1.getMetaData().getIdentifierQuoteString();
        var6_5 = var1_1.getMetaData().getDatabaseProductName().toUpperCase(Locale.ENGLISH).indexOf("ORACLE") != -1;
        try {
            var3_3 = var1_1.createStatement();
            var3_3.setMaxRows(this.tableRowLimit);
            var2_6 = this.sqlString;
            var3_3.execute(var2_6);
            var4_7 = var3_3.getUpdateCount();
            if (var4_7 == -1) {
                var16_2 = var3_3.getResultSet();
                if (var16_2 == null) {
                    var7_8 = "Result";
                    var8_10 = "java.lang.String";
                    var9_12 = 12;
                    var10_14 = "VARCHAR";
                    var11_16 = 0;
                    var12_18 = 0;
                    var13_20 = 30;
                    var14_22 = 0;
                    var15_24 = false;
                    this.columnNames.add(var7_8);
                    this.columnClassHashMap.put(var7_8, var8_10);
                    this.columnSQLTypeHashMap.put(var7_8, var9_12);
                    this.columnTypeNameHashMap.put(var7_8, var10_14.toUpperCase(Locale.ENGLISH));
                    this.columnScaleHashMap.put(var7_8, var11_16);
                    this.columnPrecisionHashMap.put(var7_8, var12_18);
                    this.columnSizeHashMap.put(var7_8, var13_20);
                    this.columnIsNullableHashMap.put(var7_8, var14_22);
                    this.columnIsAutoIncrementHashMap.put(var7_8, var15_24);
                    var18_26 = this.validQuery = 0;
                    return var18_26;
                }
            } else {
                this.validQuery = 0;
lbl49:
                // 2 sources

                while (true) {
                    var18_27 = this.validQuery;
                    return var18_27;
                }
            }
            var17_38 = var16_2.getMetaData();
        }
        catch (SQLException var18_28) {
            ConnectionManager.displaySQLErrors(var18_28, "SQLQuery executeSQL()");
            var19_32 = this.validQuery = -1;
            return var19_32;
        }
        finally {
            try {
                if (var16_2 != null) {
                    var16_2.close();
                }
            }
            catch (SQLException var20_35) {
                ConnectionManager.displaySQLErrors(var20_35, "SQLQuery executeSQL()");
                var21_37 = this.validQuery = -1;
                return var21_37;
            }
            finally {
                if (var3_3 != null) {
                    var3_3.close();
                }
            }
        }
        for (var18_27 = 1; var18_27 < var17_38.getColumnCount() + 1; ++var18_27) {
            var7_9 = var17_38.getColumnLabel(var18_27);
            var8_11 = var17_38.getColumnClassName(var18_27);
            var9_13 = var17_38.getColumnType(var18_27);
            var10_15 = var17_38.getColumnTypeName(var18_27);
            var11_17 = var17_38.getScale(var18_27);
            var12_19 = var17_38.getPrecision(var18_27);
            var13_21 = var17_38.getColumnDisplaySize(var18_27);
            var14_23 = var17_38.isNullable(var18_27);
            var15_25 = var17_38.isAutoIncrement(var18_27);
            if (var8_11 == null && var10_15 == null) continue;
            if (var8_11 == null) {
                if (var10_15.toUpperCase(Locale.ENGLISH).equals("BINARY_FLOAT")) {
                    var8_11 = "java.lang.Float";
                    var9_13 = 6;
                    var10_15 = "FLOAT";
                } else if (var10_15.toUpperCase(Locale.ENGLISH).equals("BINARY_DOUBLE")) {
                    var8_11 = "java.lang.Double";
                    var9_13 = 8;
                    var10_15 = "DOUBLE";
                } else {
                    var8_11 = "java.lang.Object";
                }
            }
            this.columnNames.add(var7_9);
            if (var1_1.getMetaData().getDatabaseProductName().toUpperCase(Locale.ENGLISH).indexOf("SQLITE") != -1 && (var10_15.toUpperCase(Locale.ENGLISH).equals("DATE") || var10_15.toUpperCase(Locale.ENGLISH).equals("TIME") || var10_15.toUpperCase(Locale.ENGLISH).indexOf("DATETIME") != -1 || var10_15.toUpperCase(Locale.ENGLISH).equals("TIMESTAMP")) && (var19_30 = SQLQuery.getTypeof(var1_1, this.sqlString, var7_9)) != 0) {
                var9_13 = var19_30;
            }
            this.columnTypeNameHashMap.put(var7_9, var10_15.toUpperCase(Locale.ENGLISH));
            this.columnClassHashMap.put(var7_9, var8_11);
            this.columnSQLTypeHashMap.put(var7_9, var9_13);
            this.columnScaleHashMap.put(var7_9, var11_17);
            this.columnPrecisionHashMap.put(var7_9, var12_19);
            this.columnSizeHashMap.put(var7_9, var13_21);
            this.columnIsNullableHashMap.put(var7_9, var14_23);
            this.columnIsAutoIncrementHashMap.put(var7_9, var15_25);
            if (var6_5 && var10_15.equals("TIMESTAMPLTZ")) {
                this.sqlOracleColumnNamesString.append("TO_CHAR(" + var5_4 + var7_9 + var5_4 + ", 'YYYY-MM-DD HH24:MM:SS TZR') AS " + var5_4 + var7_9 + var5_4 + ", ");
            } else {
                this.sqlOracleColumnNamesString.append(var5_4 + var7_9 + var5_4 + ", ");
            }
            this.sqlColumnNamesString.append(var5_4 + var7_9 + var5_4 + ", ");
        }
        if (this.sqlColumnNamesString.length() != 0) {
            this.sqlOracleColumnNamesString.delete(this.sqlOracleColumnNamesString.length() - 2, this.sqlOracleColumnNamesString.length());
            this.sqlColumnNamesString.delete(this.sqlColumnNamesString.length() - 2, this.sqlColumnNamesString.length());
        }
        this.validQuery = 1;
        ** while (true)
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTypeof(Connection connection, String string, String string2) {
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            statement = connection.createStatement();
            String string3 = "SELECT typeof(" + string2 + ") FROM (" + string.replaceAll(";", "") + ") LIMIT 1";
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                if (string4.equalsIgnoreCase("INTEGER")) {
                    n = 4;
                    continue;
                }
                if (string4.equalsIgnoreCase("TEXT")) {
                    n = 12;
                    continue;
                }
                if (string4.equalsIgnoreCase("REAL")) {
                    n = 7;
                    continue;
                }
                if (string4.equalsIgnoreCase("BLOB")) {
                    n = 2004;
                    continue;
                }
                n = 0;
            }
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "SQLQuery getTypeof()");
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "SQLQuery getTypeof()");
            }
        }
        return n;
    }

    public static Object getDate(ResultSet resultSet, int n, String string) throws SQLException {
        Object object = n == 0 || n == 4 || n == 7 ? resultSet.getDate(string) : resultSet.getString(string);
        if (object != null) {
            return object + "";
        }
        return null;
    }

    public static Object getTime(ResultSet resultSet, int n, String string) throws SQLException {
        Object object;
        if (n == 0 || n == 4 || n == 7) {
            object = resultSet.getTime(string);
            if (object != null) {
                object = new SimpleDateFormat("HH:mm:ss").format(object);
            }
        } else {
            object = resultSet.getString(string);
        }
        return object;
    }

    public static Object getTimeTZ(ResultSet resultSet, int n, String string) throws SQLException {
        Object object;
        if (n == 0 || n == 4 || n == 7) {
            object = resultSet.getTime(string);
            if (object != null) {
                object = new SimpleDateFormat("HH:mm:ss z").format(object);
            }
        } else {
            object = resultSet.getString(string);
        }
        return object;
    }

    public static Object getTimestamp(ResultSet resultSet, int n, String string, String string2) throws SQLException {
        if (n == 0 || n == 4 || n == 7) {
            Timestamp timestamp = resultSet.getTimestamp(string2);
            if (timestamp == null) {
                return null;
            }
            if (string.equals("DATETIME")) {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Object)timestamp);
            }
            if (string.equals("TIMESTAMP")) {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format((Object)timestamp);
            }
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format((Object)timestamp);
        }
        String string3 = resultSet.getString(string2);
        if (string3 == null) {
            return null;
        }
        if (string3.indexOf(" ") != -1) {
            String string4 = string3 + "";
            string4 = string4.substring(0, string4.indexOf(" "));
            String string5 = string3 + "";
            string5 = string5.substring(string5.indexOf(" "));
            string3 = string4 + string5;
            return string3;
        }
        throw new SQLException("Timestamp String Invalid Format");
    }

    public ArrayList<String> getColumnNames() {
        return this.columnNames;
    }

    public HashMap<String, String> getColumnClassHashMap() {
        return this.columnClassHashMap;
    }

    public HashMap<String, Integer> getColumnSQLTypeHashMap() {
        return this.columnSQLTypeHashMap;
    }

    public HashMap<String, String> getColumnTypeNameHashMap() {
        return this.columnTypeNameHashMap;
    }

    public HashMap<String, Integer> getColumnScaleHashMap() {
        return this.columnScaleHashMap;
    }

    public HashMap<String, Integer> getColumnPrecisionHashMap() {
        return this.columnPrecisionHashMap;
    }

    public HashMap<String, Integer> getColumnSizeHashMap() {
        return this.columnSizeHashMap;
    }

    public HashMap<String, Integer> getColumnIsNullableHashMap() {
        return this.columnIsNullableHashMap;
    }

    public HashMap<String, Boolean> getColumnIsAutoIncrementHashMap() {
        return this.columnIsAutoIncrementHashMap;
    }

    public StringBuilder getSqlColumnNamesString() {
        return this.sqlColumnNamesString;
    }

    public StringBuilder getSqlOrcaleColumnNamesString() {
        return this.sqlOracleColumnNamesString;
    }

    public int getRowCount() {
        Connection connection = ConnectionManager.getConnection("SQLQuery getRowCount()");
        int n = this.getRowCount(connection, ConnectionManager.getDataSourceType());
        ConnectionManager.closeConnection(connection, "SQLQuery getRowCount()");
        return n;
    }

    public int getRowCount(ConnectionInstance connectionInstance) {
        Connection connection = connectionInstance.getConnection("SQLQuery getRowCount()");
        int n = this.getRowCount(connection, connectionInstance.getDataSourceType());
        connectionInstance.closeConnection(connection, "SQLQuery getRowCount()");
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getRowCount(Connection connection, String string) {
        if (this.validQuery != 1) {
            return 0;
        }
        int n = 0;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            String string2 = "SELECT COUNT(*) AS row_count FROM (" + this.sqlString;
            string2 = string.equals("mysql") || string.equals("mariadb") || string.equals("postgresql") || string.equals("derby") || string.equals("sqlserver") ? string2 + ") AS AS1" : string2 + ")";
            resultSet = statement.executeQuery(string2);
            resultSet.next();
            n = resultSet.getInt("row_count");
            return n;
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "SQLQuery getRowCount()");
            return n;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "SQLQuery getRowCount()");
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    ConnectionManager.displaySQLErrors(sQLException, "SQLQuery getRowCount()");
                }
            }
        }
    }

    public String getSQLQuery() {
        return this.sqlString;
    }

    public int getValidQuery() {
        return this.validQuery;
    }
}

