/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.utilities.db;

import com.dandymadeproductions.ajqvue.datasource.ConnectionInstance;
import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import com.dandymadeproductions.ajqvue.utilities.db.DB_To_DBThread;
import com.dandymadeproductions.ajqvue.utilities.db.SQLLoadThread;
import com.dandymadeproductions.ajqvue.utilities.db.SQLQuery;
import com.dandymadeproductions.ajqvue.utilities.db.TableRowElements;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.rowset.serial.SerialBlob;

public class SQLInsertPrepareThread
implements Runnable {
    private SQLLoadThread sqlLoadThread;
    private Connection db_Connection;
    private PreparedStatement prepared_sqlStatement;
    private SQLQuery sqlQuery;
    private ArrayBlockingQueue<TableRowElements> tableRowDataQueue;
    private TableRowElements rowElementsData;
    private String dataSinkType;
    private String sqlTable;
    private String identifierQuoteString;
    private String resourceInvalidInput;
    private String resourceType;
    private int columnIndex;
    private int batchSize;
    private boolean batchSizeEnabled;
    private Logger threadLogger;

    public SQLInsertPrepareThread(SQLLoadThread sQLLoadThread, ConnectionInstance connectionInstance, Connection connection, SQLQuery sQLQuery, ArrayBlockingQueue<TableRowElements> arrayBlockingQueue, String string) {
        this(sQLLoadThread, connectionInstance, connection, sQLQuery, arrayBlockingQueue, string, DBTablesPanel.getGeneralDBProperties().getBatchSizeEnabled(), DBTablesPanel.getGeneralDBProperties().getBatchSize());
    }

    public SQLInsertPrepareThread(SQLLoadThread sQLLoadThread, ConnectionInstance connectionInstance, Connection connection, SQLQuery sQLQuery, ArrayBlockingQueue<TableRowElements> arrayBlockingQueue, String string, boolean bl, int n) {
        this.sqlLoadThread = sQLLoadThread;
        this.db_Connection = connection;
        this.sqlQuery = sQLQuery;
        this.tableRowDataQueue = arrayBlockingQueue;
        this.sqlTable = Utils.getSchemaTableName(string, connectionInstance.getCatalogSeparator(), connectionInstance.getIdentifierQuoteString());
        this.batchSizeEnabled = bl;
        this.batchSize = n;
        this.dataSinkType = connectionInstance.getDataSourceType();
        this.identifierQuoteString = connectionInstance.getIdentifierQuoteString();
        this.resourceInvalidInput = "Invalid Input";
        this.resourceType = "Type";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!(this.dataSinkType.equals("h2") || this.dataSinkType.equals("hsql2") || this.dataSinkType.equals("derby") || this.dataSinkType.equals("sqlite"))) {
            return;
        }
        Statement statement = null;
        this.prepared_sqlStatement = null;
        int n = 0;
        boolean bl = false;
        try {
            this.db_Connection.setAutoCommit(false);
            statement = this.db_Connection.createStatement();
            String string = this.initializePrepare();
            this.log(Level.INFO, "SQLInsertPrepareThread", "run()", "Prepare Statement Created:\n" + string);
            this.prepared_sqlStatement = this.db_Connection.prepareStatement(string);
            this.rowElementsData = this.tableRowDataQueue.take();
            while (!this.rowElementsData.getMessage().equals("Last Element")) {
                this.columnIndex = 0;
                bl = this.addTableEntry(statement, this.prepared_sqlStatement);
                if (bl) {
                    if (this.batchSizeEnabled) {
                        if (n > this.batchSize) {
                            this.prepared_sqlStatement.executeBatch();
                            this.db_Connection.commit();
                            n = 0;
                        } else {
                            ++n;
                        }
                    }
                } else {
                    this.log(Level.WARNING, "SQLInsertPrepareThread", "run()", "validImport: " + bl);
                    this.sqlLoadThread.cancelLoad("SQLInsertPrepareThread run()");
                    break;
                }
                this.rowElementsData = this.tableRowDataQueue.take();
            }
            if (bl) {
                this.prepared_sqlStatement.executeBatch();
                this.db_Connection.commit();
            } else {
                this.db_Connection.rollback();
            }
        }
        catch (Exception exception) {
            this.log(Level.WARNING, "SQLInsertPrepareThread", "run()", exception.toString());
            try {
                this.db_Connection.rollback();
            }
            catch (SQLException sQLException) {
                ConnectionInstance.displaySQLErrors(sQLException, "SQLInsertPrepare run() rollback failed", true);
            }
        }
        finally {
            try {
                if (this.prepared_sqlStatement != null) {
                    this.prepared_sqlStatement.close();
                }
            }
            catch (SQLException sQLException) {
                ConnectionInstance.displaySQLErrors(sQLException, "SQLInsertPrepare run() failed to close", true);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    ConnectionInstance.displaySQLErrors(sQLException, "SQLInsertPrepare run() failed to close", true);
                }
                finally {
                    try {
                        this.db_Connection.setAutoCommit(true);
                    }
                    catch (SQLException sQLException) {
                        ConnectionInstance.displaySQLErrors(sQLException, "SQLInsertPrepare run() failed to setAutoCommit", true);
                    }
                }
            }
        }
    }

    private String initializePrepare() {
        StringBuilder stringBuilder = new StringBuilder("INSERT INTO " + this.sqlTable + " ");
        StringBuilder stringBuilder2 = new StringBuilder("(");
        StringBuilder stringBuilder3 = new StringBuilder("VALUES (");
        this.columnIndex = 0;
        for (String string : this.sqlQuery.getColumnNames()) {
            stringBuilder2.append(this.identifierQuoteString + string + this.identifierQuoteString + ", ");
            stringBuilder3.append("?, ");
        }
        if (stringBuilder2.length() >= 3) {
            stringBuilder2.delete(stringBuilder2.length() - 2, stringBuilder2.length());
            stringBuilder2.append(")");
        } else {
            stringBuilder2.append(")");
        }
        if (stringBuilder3.length() > 8) {
            stringBuilder3.delete(stringBuilder3.length() - 2, stringBuilder3.length());
            stringBuilder3.append(")");
        } else {
            stringBuilder3.append(")");
        }
        stringBuilder.append(stringBuilder2 + " " + stringBuilder3);
        return stringBuilder.toString();
    }

    private boolean addTableEntry(Statement statement, PreparedStatement preparedStatement) {
        boolean bl = false;
        try {
            Iterator<String> iterator = this.sqlQuery.getColumnNames().iterator();
            int n = 1;
            while (iterator.hasNext()) {
                boolean bl2;
                Object object = this.rowElementsData.getRowElement(this.columnIndex);
                String string = iterator.next();
                String string2 = this.sqlQuery.getColumnClassHashMap().get(string);
                String string3 = this.sqlQuery.getColumnTypeNameHashMap().get(string);
                int n2 = this.sqlQuery.getColumnSizeHashMap().get(string);
                boolean bl3 = bl2 = string2.indexOf("Array") != -1 || string3.indexOf("_") != -1;
                if (object == null) {
                    preparedStatement.setObject(n++, null);
                } else if (string2.indexOf("Byte") != -1 && string3.indexOf("CHAR") == -1 || string2.indexOf("Short") != -1 || string2.indexOf("Integer") != -1 || string2.indexOf("Long") != -1 || string2.indexOf("Float") != -1 || string2.indexOf("Double") != -1 || string2.indexOf("BigDecimal") != -1 || string2.indexOf("Object") != -1 && string3.equals("REAL") || string2.indexOf("Object") != -1 && string3.equals("INTEGER")) {
                    String string4 = null;
                    try {
                        string4 = ((String)object).trim();
                        if (string2.indexOf("Byte") != -1) {
                            preparedStatement.setByte(n++, Byte.parseByte(string4));
                        }
                        if (string2.indexOf("Short") != -1) {
                            preparedStatement.setShort(n++, Short.parseShort(string4));
                        }
                        if (string2.indexOf("Integer") != -1 || string2.indexOf("Object") != -1 && string3.equals("INTEGER")) {
                            if (string2.indexOf("Integer") != -1) {
                                preparedStatement.setInt(n++, Integer.parseInt(string4));
                            }
                            long l = Long.parseLong(string4);
                            if (l > (long)n2 || l < (long)(-n2)) {
                                preparedStatement.setLong(n++, l);
                            }
                            preparedStatement.setInt(n++, Integer.parseInt(string4));
                        }
                        if (string2.indexOf("Long") != -1) {
                            preparedStatement.setLong(n++, Long.parseLong(string4));
                        }
                        if (string2.indexOf("Float") != -1 || string2.indexOf("Object") != -1 && string3.equals("REAL")) {
                            preparedStatement.setFloat(n++, Float.parseFloat(string4));
                        }
                        if (string2.indexOf("Double") != -1) {
                            preparedStatement.setDouble(n++, Double.parseDouble(string4));
                        }
                        BigDecimal bigDecimal = new BigDecimal(string4);
                        preparedStatement.setBigDecimal(n++, bigDecimal);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.log(Level.WARNING, "SQLInsertPrepareThread", "addTableEntry()", numberFormatException.toString());
                        this.log(Level.WARNING, "SQLInsertPrepareThread", "addTableEntry()", this.resourceInvalidInput + " " + string + ", " + this.resourceType + ": " + string3 + " value: " + string4);
                        bl = false;
                        return bl;
                    }
                } else if (string2.indexOf("Date") != -1 || string2.toUpperCase(Locale.ENGLISH).indexOf("TIME") != -1) {
                    String string5 = ((String)object).trim();
                    try {
                        String string6;
                        if (string3.equals("DATE")) {
                            if (string5.length() <= 4) {
                                string5 = string5.length() == 2 ? "20" + string5 + "-01-01" : string5 + "-01-01";
                            }
                            Date date = Date.valueOf(string5);
                            preparedStatement.setDate(n++, date);
                        }
                        if (string3.equals("TIME") || string3.equals("TIMETZ") || string3.equals("TIME WITH TIME ZONE")) {
                            if (string3.equals("TIME WITH TIME ZONE")) {
                                preparedStatement.setString(n++, string5);
                            }
                            preparedStatement.setTime(n++, Time.valueOf(string5.substring(0, 8)));
                        }
                        if (string3.indexOf("DATETIME") != -1) {
                            string6 = string5.substring(0, string5.indexOf(" "));
                            String string7 = string5.substring(string5.indexOf(" "));
                            if (string3.equals("DATETIMEOFFSET")) {
                                preparedStatement.setString(n++, string6 + string7);
                            }
                            preparedStatement.setTimestamp(n++, Timestamp.valueOf(string6 + string7));
                        }
                        if (string3.equals("TIMESTAMP") || string3.equals("TIMESTAMP WITH TIME ZONE") || string3.equals("TIMESTAMPTZ") || string3.equals("TIMESTAMPLTZ") || string3.equals("TIMESTAMP WITH LOCAL TIME ZONE")) {
                            if (string3.equals("TIMESTAMPLTZ") || string3.equals("TIMESTAMP WITH LOCAL TIME ZONE")) {
                                Utils.setLocalTimeZone(statement);
                            }
                            try {
                                java.util.Date date;
                                SimpleDateFormat simpleDateFormat = string3.equals("TIMESTAMP") ? (this.dataSinkType.equals("mysql") || this.dataSinkType.equals("mariadb") ? (n2 == 2 ? new SimpleDateFormat("yy") : (n2 == 4 ? new SimpleDateFormat("MM-yy") : (n2 == 6 ? new SimpleDateFormat("MM-dd-yy") : (n2 == 8 ? new SimpleDateFormat("MM-dd-yyyy") : (n2 == 10 ? new SimpleDateFormat("MM-dd-yy HH:mm") : (n2 == 12 ? new SimpleDateFormat("MM-dd-yyyy HH:mm") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"))))))) : (this.dataSinkType.equals("sqlite") ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"))) : (string3.equals("TIMESTAMPLTZ") || string3.equals("TIMESTAMP WITH LOCAL TIMEZONE") ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z"));
                                if (string3.equals("TIMESTAMPLTZ")) {
                                    string6 = string5;
                                    string6 = string6.substring(0, string6.lastIndexOf(58)) + string6.substring(string6.lastIndexOf(58) + 1);
                                    date = simpleDateFormat.parse(string6);
                                } else {
                                    date = simpleDateFormat.parse(string5);
                                }
                                Timestamp timestamp = new Timestamp(date.getTime());
                                preparedStatement.setTimestamp(n++, timestamp);
                            }
                            catch (ParseException parseException) {
                                throw new IllegalArgumentException(parseException + "");
                            }
                        }
                        string6 = string5;
                        Date date = Date.valueOf(string6 + "-01-01");
                        preparedStatement.setString(n++, date.toString().substring(0, 4));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        String string8 = "Invalid Date/Time Input for Field";
                        this.log(Level.WARNING, "SQLInsertPrepareThread", "addTableEntry()", illegalArgumentException.toString());
                        this.log(Level.WARNING, "SQLInsertPrepareThread", "addTableEntry()", string8 + " " + string + ", " + this.resourceType + ": " + string3);
                        bl = false;
                        return bl;
                    }
                } else if (DB_To_DBThread.isBlob(string2, string3)) {
                    if (this.dataSinkType.equals("hsql2")) {
                        SerialBlob serialBlob = new SerialBlob((byte[])object);
                        preparedStatement.setBlob(n++, serialBlob);
                    } else {
                        preparedStatement.setBytes(n++, (byte[])object);
                    }
                } else if (bl2) {
                    String string9 = (String)object;
                    string9 = string9.replaceAll("\\}", "(");
                    string9 = string9.replaceAll("\\}", ")");
                    if (this.dataSinkType.equals("h2")) {
                        string9 = string9.substring(1, string9.length() - 1);
                    }
                    preparedStatement.setString(n++, string9);
                } else if (string2.indexOf("Boolean") != -1) {
                    String string10 = ((String)object).toUpperCase(Locale.ENGLISH);
                    boolean bl4 = string10.equals("TRUE") || string10.equals("T") || string10.equals("1");
                    preparedStatement.setBoolean(n++, bl4);
                } else if (string3.indexOf("BIT") != -1 && string3.indexOf("_") == -1) {
                    String string11 = (String)object;
                    if (this.dataSinkType.equals("hsql2") && n2 > 1) {
                        if (string3.equals("BIT")) {
                            preparedStatement.setBytes(n++, Utils.convertBitsToHSQL_Bits(string11));
                        } else {
                            preparedStatement.setString(n++, string11);
                        }
                    } else {
                        try {
                            int n3 = Integer.parseInt(string11, 2);
                            preparedStatement.setInt(n++, n3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            String string12 = "Type: " + string3;
                            this.log(Level.WARNING, "SQLInsertPrepareThread", "addTableEntry()", numberFormatException.toString());
                            this.log(Level.WARNING, "SQLInsertPrepareThread", "addTableEntry()", this.resourceInvalidInput + " " + string + ", " + string12);
                            bl = false;
                            return bl;
                        }
                    }
                } else if (DB_To_DBThread.isText(string2, string3, n2, 65535)) {
                    if (object instanceof String) {
                        preparedStatement.setString(n++, (String)object);
                    } else {
                        preparedStatement.setBytes(n++, (byte[])object);
                    }
                } else {
                    preparedStatement.setString(n, (String)object);
                    ++n;
                }
                ++this.columnIndex;
            }
            preparedStatement.addBatch();
            bl = true;
        }
        catch (SQLException sQLException) {
            ConnectionInstance.displaySQLErrors(sQLException, "SQLInsertPrepare addTableEntry()", true);
            bl = false;
        }
        return bl;
    }

    private void log(Level level, String string, String string2, String string3) {
        if (this.threadLogger != null) {
            this.threadLogger.logp(level, string, string2, string3);
        }
    }

    public String convertSQLiteClass(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        this.log(Level.INFO, "SQLInsertPrepareThread", "convertSQLiteClass()", "typeName: " + string);
        if (string.equals("TEXT")) {
            stringBuilder.append("java.lang.String");
        } else if (string.equals("NUMERIC")) {
            stringBuilder.append("java.math.BigDecimal");
        } else if (string.equals("INTEGER")) {
            stringBuilder.append("java.lang.Integer");
        } else if (string.equals("REAL")) {
            stringBuilder.append("java.lang.Float");
        } else {
            stringBuilder.append("java.lang.Object");
        }
        this.log(Level.INFO, "SQLInsertPrepareThread", "convertSQLiteClass()", "className: " + stringBuilder.toString());
        return stringBuilder.toString();
    }

    public void setLogger(Logger logger) {
        this.threadLogger = logger;
    }
}

