/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.utilities.db;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.datasource.TypesInfoCache;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import com.dandymadeproductions.ajqvue.utilities.db.SQLQuery;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

public class DDLGenerator {
    private String dataSourceType;
    private String dataSinkType;
    private int indexCount;
    private int autoIncrementCount;
    private SQLQuery sqlQuery;
    private TypesInfoCache infoCache;
    private boolean useSQLiteCast;
    private String columnName;
    private String columnClass;
    private String columnType;
    private int columnPrecision;
    private int columnScale;
    private int columnSize;
    private int columnIsNullable;
    private boolean columnIsAutoIncrement;
    private StringBuffer tableDefinition;
    private ArrayList<String> indexList;
    public static final String DEFAULT_DATASINK_TYPE = "hsql2";
    public static final int INDEXCOUNT = 1;

    public DDLGenerator(String string) {
        this(new SQLQuery(string), ConnectionManager.getDataSourceType(), DEFAULT_DATASINK_TYPE, 1);
    }

    public DDLGenerator(SQLQuery sQLQuery) {
        this(sQLQuery, ConnectionManager.getDataSourceType(), DEFAULT_DATASINK_TYPE, 1);
    }

    public DDLGenerator(String string, String string2) {
        this(new SQLQuery(string), ConnectionManager.getDataSourceType(), string2, 1);
    }

    public DDLGenerator(SQLQuery sQLQuery, String string) {
        this(sQLQuery, ConnectionManager.getDataSourceType(), string, 1);
    }

    public DDLGenerator(String string, String string2, int n) {
        this(new SQLQuery(string), ConnectionManager.getDataSourceType(), string2, n);
    }

    public DDLGenerator(SQLQuery sQLQuery, String string, int n) {
        this(sQLQuery, ConnectionManager.getDataSourceType(), string, n);
    }

    public DDLGenerator(SQLQuery sQLQuery, String string, String string2, int n) {
        this.sqlQuery = sQLQuery;
        this.dataSourceType = string;
        this.dataSinkType = string2;
        this.indexCount = n;
        this.infoCache = new TypesInfoCache(string, string2);
        this.useSQLiteCast = false;
        this.tableDefinition = new StringBuffer();
        this.indexList = new ArrayList();
    }

    public String getDDL(String string, String string2, String string3) {
        Connection connection = ConnectionManager.getConnection("DDLGenerator getDDL()");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDDL(connection, string, string2, string3));
        ConnectionManager.closeConnection(connection, "DDLGenerator getDDL()");
        return stringBuffer.toString();
    }

    public String getDDL(Connection connection, String string, String string2, String string3) {
        this.tableDefinition.delete(0, this.tableDefinition.length());
        this.indexList.clear();
        int n = 0;
        this.autoIncrementCount = 0;
        String string4 = Utils.getSchemaTableName(string, string2, string3);
        this.tableDefinition.append("CREATE TABLE " + string4 + " (\n    ");
        try {
            if (this.sqlQuery.getValidQuery() == -1) {
                if (Ajqvue.getDebug()) {
                    System.out.println("DDLGenerator getDDL() Running SQLQuery");
                }
                this.sqlQuery.executeSQL(connection);
            }
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "DDLGenerator getDDL()");
        }
        for (String this.columnName : this.sqlQuery.getColumnNames()) {
            this.columnClass = this.sqlQuery.getColumnClassHashMap().get(this.columnName);
            this.columnType = this.dataSinkType.equals("sqlite") && this.useSQLiteCast || this.dataSourceType.equals("sqlite") && this.dataSinkType.equals("sqlite") ? this.sqlQuery.getColumnTypeNameHashMap().get(this.columnName) : (this.dataSourceType.equals("sqlite") ? this.infoCache.getType(this.sqlQuery.getColumnSQLTypeHashMap().get(this.columnName), this.convertToSQLiteType(this.sqlQuery.getColumnTypeNameHashMap().get(this.columnName))) : this.infoCache.getType(this.sqlQuery.getColumnSQLTypeHashMap().get(this.columnName), this.sqlQuery.getColumnTypeNameHashMap().get(this.columnName)));
            this.columnPrecision = this.sqlQuery.getColumnPrecisionHashMap().get(this.columnName);
            this.columnScale = this.sqlQuery.getColumnScaleHashMap().get(this.columnName);
            this.columnSize = this.sqlQuery.getColumnSizeHashMap().get(this.columnName);
            this.columnIsNullable = this.sqlQuery.getColumnIsNullableHashMap().get(this.columnName);
            this.columnIsAutoIncrement = this.sqlQuery.getColumnIsAutoIncrementHashMap().get(this.columnName);
            this.tableDefinition.append(string3 + this.columnName + string3 + " ");
            if (this.dataSinkType.equals("h2")) {
                this.createH2_DDL();
            } else if (this.dataSinkType.equals("derby")) {
                this.createDerby_DDL(n < this.indexCount);
            } else if (this.dataSinkType.equals("sqlite")) {
                this.tableDefinition.append(this.columnType);
            } else {
                this.createHSQL_DDL();
            }
            if (this.columnIsNullable == 0) {
                this.tableDefinition.append(" NOT NULL,\n    ");
            } else {
                this.tableDefinition.append(",\n    ");
            }
            if (n >= this.indexCount) continue;
            this.indexList.add(this.columnName);
            ++n;
        }
        this.tableDefinition.delete(this.tableDefinition.length() - 6, this.tableDefinition.length());
        this.tableDefinition.append("\n);\n");
        if (!this.indexList.isEmpty()) {
            this.tableDefinition.append("CREATE INDEX " + string3 + this.indexList.get(0) + string3 + " ON " + string4 + "(");
            Iterator<String> iterator = this.indexList.iterator();
            while (iterator.hasNext()) {
                this.tableDefinition.append(string3 + iterator.next() + string3 + ", ");
            }
            this.tableDefinition.delete(this.tableDefinition.length() - 2, this.tableDefinition.length());
            this.tableDefinition.append(");\n");
        }
        return this.tableDefinition.toString();
    }

    private String convertToSQLiteType(String string) {
        if (string.indexOf("CHAR") != -1 && string.indexOf("BIT DATA") == -1 || string.indexOf("CLOB") != -1 || string.indexOf("TEXT") != -1 || string.indexOf("XML") != -1) {
            return "TEXT";
        }
        if (string.indexOf("BYTEA") != -1 || string.indexOf("BINARY") != -1 || string.indexOf("RAW") != -1 || string.indexOf("IMAGE") != -1 || string.indexOf("BIT DATA") != -1) {
            return "BLOB";
        }
        if (string.indexOf("NUMERIC") != -1 || string.indexOf("DECIMAL") != -1) {
            return "NUMERIC";
        }
        if (string.indexOf("TINYINT") != -1 || string.indexOf("INT") != -1 && string.indexOf("POINT") == -1 || string.indexOf("SMALLINT") != -1 || string.indexOf("MEDIUMINT") != -1 || string.indexOf("BIGINT") != -1 || string.indexOf("SERIAL") != -1) {
            return "INTEGER";
        }
        if (string.indexOf("REAL") != -1 || string.indexOf("DOUBLE") != -1 && string.indexOf("BINARY") == -1 || string.indexOf("FLOAT") != -1 && string.indexOf("BINARY") == -1) {
            return "REAL";
        }
        if (string.equals("DATE") || string.equals("YEAR")) {
            return "DATE";
        }
        if (string.equals("TIME")) {
            return "TIME";
        }
        if (string.indexOf("DATETIME") != -1 || string.indexOf("TIMESTAMP") != -1) {
            return "TIMESTAMP";
        }
        return string;
    }

    private void createH2_DDL() {
        if (this.columnType.indexOf("CHAR") != -1) {
            if (this.columnType.equals("LONGVARCHAR")) {
                this.tableDefinition.append(this.columnType);
            } else if (this.columnSize <= 0) {
                this.tableDefinition.append(this.columnType + "(" + Integer.MAX_VALUE + ")");
            } else {
                this.tableDefinition.append(this.columnType + "(" + this.columnSize + ")");
            }
        } else if (this.columnType.equals("INTEGER") || this.columnType.equals("BIGINT")) {
            if (this.columnIsAutoIncrement && this.autoIncrementCount <= 0) {
                this.tableDefinition.append(this.columnType + " IDENTITY");
                ++this.autoIncrementCount;
            } else {
                this.tableDefinition.append(this.columnType);
            }
        } else if (this.columnType.equals("DOUBLE")) {
            this.tableDefinition.append(this.columnType);
        } else if (this.columnType.equals("DECIMAL") || this.columnType.equals("NUMERIC")) {
            if (this.columnClass.toLowerCase(Locale.ENGLISH).indexOf("double") != -1) {
                this.tableDefinition.append("DOUBLE");
            } else if (this.columnPrecision <= 0) {
                if (this.columnScale == 0) {
                    this.tableDefinition.append(this.columnType);
                } else {
                    this.tableDefinition.append(this.columnType + "(" + Math.abs(this.columnScale) + ")");
                }
            } else {
                this.tableDefinition.append(this.columnType + "(" + this.columnPrecision + "," + this.columnScale + ")");
            }
        } else if (this.columnType.equals("BLOB") || this.columnType.equals("BINARY")) {
            if (this.columnSize <= 0) {
                this.tableDefinition.append(this.columnType);
            } else if (this.dataSourceType.equals("derby") && this.columnType.equals("BINARY")) {
                this.tableDefinition.append(this.columnType + "(" + this.columnPrecision + ")");
            } else {
                this.tableDefinition.append(this.columnType + "(" + this.columnSize + ")");
            }
        } else if (this.columnType.equals("CLOB")) {
            this.tableDefinition.append(this.columnType + "(" + this.columnSize + ")");
        } else {
            this.tableDefinition.append(this.columnType);
        }
    }

    private void createDerby_DDL(boolean bl) {
        if (this.columnType.indexOf("CHAR") != -1) {
            if (this.columnType.equals("CHAR")) {
                this.tableDefinition.append("CHAR(" + this.columnSize + ")");
            } else if (this.columnType.equals("VARCHAR")) {
                if (this.columnSize >= 32700 || this.columnSize <= 0) {
                    this.tableDefinition.append("LONG VARCHAR");
                } else {
                    this.tableDefinition.append("VARCHAR(" + this.columnSize + ")");
                }
            } else if (this.columnType.indexOf("FOR BIT DATA") != -1) {
                if (this.columnType.indexOf("VARCHAR") != -1) {
                    if (this.columnType.indexOf("LONG") != -1) {
                        this.tableDefinition.append("LONG VARCHAR FOR BIT DATA");
                    } else {
                        this.tableDefinition.append("VARCHAR(" + this.columnPrecision + ") FOR BIT DATA");
                    }
                } else {
                    this.tableDefinition.append("CHAR(" + this.columnPrecision + ") FOR BIT DATA");
                }
            } else if (this.columnType.equals("LONG VARCHAR") && bl) {
                this.tableDefinition.append("VARCHAR(1024)");
            } else {
                this.tableDefinition.append(this.columnType);
            }
        } else if (this.columnType.equals("INTEGER") || this.columnType.equals("BIGINT")) {
            if (this.columnIsAutoIncrement && this.autoIncrementCount <= 0) {
                this.tableDefinition.append(this.columnType + " GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1)");
                ++this.autoIncrementCount;
            } else {
                this.tableDefinition.append(this.columnType);
            }
        } else if (this.columnType.equals("BLOB")) {
            if (this.columnSize <= 0) {
                this.tableDefinition.append(this.columnType);
            } else {
                this.tableDefinition.append(this.columnType + "(" + this.columnSize + ")");
            }
        } else if (this.columnType.equals("CLOB")) {
            this.tableDefinition.append(this.columnType + "(" + this.columnSize + ")");
        } else if (this.columnType.equals("DECIMAL")) {
            if (this.columnClass.toLowerCase(Locale.ENGLISH).indexOf("double") != -1) {
                this.tableDefinition.append("DOUBLE");
            } else if (this.columnPrecision > 31) {
                this.columnPrecision = 31;
                if (this.columnScale > this.columnPrecision) {
                    this.tableDefinition.append(this.columnType + "(" + this.columnPrecision + ",16)");
                } else {
                    this.tableDefinition.append(this.columnType + "(" + this.columnPrecision + "," + this.columnScale + ")");
                }
            } else if (this.columnPrecision <= 0) {
                if (this.columnScale == 0) {
                    this.tableDefinition.append(this.columnType);
                } else {
                    if (Math.abs(this.columnScale) > 31) {
                        this.columnScale = 31;
                    }
                    this.tableDefinition.append(this.columnType + "(" + Math.abs(this.columnScale) + ")");
                }
            } else {
                this.tableDefinition.append(this.columnType + "(" + this.columnPrecision + "," + this.columnScale + ")");
            }
        } else {
            this.tableDefinition.append(this.columnType);
        }
    }

    private void createHSQL_DDL() {
        if (this.columnType.indexOf("CHAR") != -1) {
            if (this.columnType.equals("CHAR") || this.columnType.equals("CHARACTER")) {
                this.tableDefinition.append("CHAR(" + this.columnSize + ")");
            } else if (this.dataSinkType.equals("hsql")) {
                if (this.columnType.equals("VARCHAR") || this.columnType.equals("VARCHAR_IGNORECASE")) {
                    this.tableDefinition.append("VARCHAR(" + this.columnSize + ")");
                } else {
                    this.tableDefinition.append(this.columnType);
                }
            } else if (this.columnSize >= 0x1000000 || this.columnPrecision >= 0x1000000 || this.columnClass.indexOf("Array") != -1 || this.columnSize <= 0) {
                this.tableDefinition.append("LONGVARCHAR");
            } else {
                this.tableDefinition.append("VARCHAR(" + this.columnSize + ")");
            }
        } else if (this.columnType.indexOf("BINARY") != -1 && this.dataSinkType.equals(DEFAULT_DATASINK_TYPE)) {
            if (this.columnType.equals("BINARY")) {
                if (this.columnSize == 0) {
                    this.tableDefinition.append("BINARY(1)");
                } else if (this.dataSourceType.equals("derby")) {
                    this.tableDefinition.append("BINARY(" + this.columnPrecision + ")");
                } else {
                    this.tableDefinition.append("BINARY(" + this.columnSize + ")");
                }
            } else if (this.columnSize >= 0x1000000) {
                this.tableDefinition.append("LONGVARBINARY");
            } else if (this.dataSourceType.equals("derby")) {
                this.tableDefinition.append("VARBINARY(" + this.columnPrecision + ")");
            } else {
                this.tableDefinition.append("VARBINARY(" + this.columnSize + ")");
            }
        } else if (this.columnType.equals("BLOB")) {
            if (this.columnSize <= 0) {
                this.tableDefinition.append(this.columnType);
            } else {
                this.tableDefinition.append(this.columnType + "(" + this.columnSize + ")");
            }
        } else if (this.columnType.equals("INTEGER") || this.columnType.equals("BIGINT")) {
            if (this.columnIsAutoIncrement && this.autoIncrementCount <= 0) {
                this.tableDefinition.append(this.columnType + " IDENTITY");
                ++this.autoIncrementCount;
            } else {
                this.tableDefinition.append(this.columnType);
            }
        } else if (this.columnType.equals("DOUBLE")) {
            this.tableDefinition.append(this.columnType);
        } else if (this.columnType.equals("DECIMAL") || this.columnType.equals("NUMERIC")) {
            if (this.columnClass.toLowerCase(Locale.ENGLISH).indexOf("double") != -1) {
                this.tableDefinition.append("DOUBLE");
            } else if (this.dataSinkType.equals("hsql") && this.columnType.equals("NUMERIC")) {
                this.tableDefinition.append(this.columnType);
            } else if (this.columnPrecision <= 0) {
                if (this.columnScale == 0) {
                    this.tableDefinition.append(this.columnType);
                } else {
                    this.tableDefinition.append(this.columnType + "(" + Math.abs(this.columnScale) + ")");
                }
            } else {
                this.tableDefinition.append(this.columnType + "(" + this.columnPrecision + "," + this.columnScale + ")");
            }
        } else if (this.columnType.equals("TIME WITH TIME ZONE")) {
            this.tableDefinition.append(this.columnType);
        } else if (this.columnType.indexOf("TIMESTAMP") != -1) {
            if (this.dataSinkType.equals("hsql")) {
                if (this.columnSize == 29) {
                    this.tableDefinition.append(this.columnType + "(0)");
                } else {
                    this.tableDefinition.append(this.columnType);
                }
            } else {
                this.tableDefinition.append(this.columnType);
            }
        } else if (this.columnType.indexOf("INTERVAL") != -1) {
            if (this.columnType.equals("INTERVAL YEAR")) {
                this.tableDefinition.append(this.columnType + "(" + this.columnPrecision + ")");
            } else {
                this.tableDefinition.append(this.columnType);
            }
        } else if ((this.columnType.equals("BIT") || this.columnType.equals("BIT VARYING")) && this.columnSize != 0) {
            this.tableDefinition.append(this.columnType + "(" + this.columnSize + ")");
        } else {
            this.tableDefinition.append(this.columnType);
        }
    }

    public boolean isUseSQLiteCast() {
        return this.useSQLiteCast;
    }

    public void setUseSQLiteCast(boolean bl) {
        this.useSQLiteCast = bl;
    }
}

