/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.utilities.db;

import com.dandymadeproductions.ajqvue.datasource.ConnectionInstance;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import com.dandymadeproductions.ajqvue.utilities.db.DDLGenerator;
import com.dandymadeproductions.ajqvue.utilities.db.SQLInsertPrepareThread;
import com.dandymadeproductions.ajqvue.utilities.db.SQLLoadThread;
import com.dandymadeproductions.ajqvue.utilities.db.SQLQuery;
import com.dandymadeproductions.ajqvue.utilities.db.TableRowElements;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DB_To_DBThread
implements Runnable {
    private Logger threadLogger;
    private ConnectionInstance connectionInstanceSink;
    private Connection dbConnectionSink;
    private SQLQuery sqlQuerySink;
    private String dbSinkTypeString;
    private String sinkDBTableNameString;
    private ConnectionInstance connectionInstanceSource;
    private String sqlQueryString;
    private SQLQuery sqlQuerySource;
    private boolean dbTypeMemory;
    private boolean useSQLiteCast;
    private boolean createSinkTable;
    private int queryRowCount;
    public static final String SINK_DB_TABLE_NAME = "aqjvueSinkDBTable";
    public static final int VARCHAR_LIMIT = 65535;

    public DB_To_DBThread(ConnectionInstance connectionInstance, String string) {
        this(connectionInstance, null, string, SINK_DB_TABLE_NAME, true, false);
    }

    public DB_To_DBThread(ConnectionInstance connectionInstance, String string, String string2) {
        this(connectionInstance, null, string, string2, true, false);
    }

    protected DB_To_DBThread(ConnectionInstance connectionInstance, ConnectionInstance connectionInstance2, String string, String string2, boolean bl, boolean bl2) {
        this.connectionInstanceSource = connectionInstance;
        this.connectionInstanceSink = connectionInstance2;
        this.sqlQueryString = string;
        this.sinkDBTableNameString = string2;
        if (connectionInstance2 == null) {
            this.connectionInstanceSink = new ConnectionInstance("hsql2", true, false);
            this.dbTypeMemory = true;
            this.dbSinkTypeString = this.connectionInstanceSink.getDataSourceType();
            this.createSinkTable = true;
            this.useSQLiteCast = false;
        } else {
            String string3 = connectionInstance2.getConnectionProperties().getProperty("DB");
            this.dbTypeMemory = string3.indexOf("mem:") != -1 || string3.indexOf("memory:") != -1;
            this.dbSinkTypeString = connectionInstance2.getDataSourceType();
            this.createSinkTable = bl;
            this.useSQLiteCast = connectionInstance2.getDataSourceType().indexOf("sqlite") != -1 ? bl2 : false;
        }
    }

    @Override
    public void run() {
        boolean bl = false;
        if (this.connectionInstanceSource == null) {
            this.log(Level.FINE, "DB_To_DBThread", "ConnectionInstance Source Null:", "");
            return;
        }
        this.log(Level.FINE, "DB_To_DBThread", "ConnectionInstance Source URL: ", this.connectionInstanceSource.getConnectionProperties().getConnectionURLString());
        if (this.dbConnectionSink == null) {
            this.openConnectionSink();
        }
        if (this.dbConnectionSink == null) {
            return;
        }
        if (this.createSinkTable) {
            this.log(Level.INFO, "\nDB_To_DBThread", "run()", "Entering executeSinkDBCreation()");
            bl = this.executeSinkDBCreation(this.dbConnectionSink);
            this.log(Level.INFO, "DB_To_DBThread", "run()", "Done executeSinkDBCreation(), Error:" + bl + "\n");
        }
        if (!bl) {
            this.log(Level.INFO, "DB_To_DBThread", "run()", "Entering executeDB_To_DB_Transfer()");
            this.executeDB_To_DB_Transfer(this.connectionInstanceSink, this.dbConnectionSink);
            this.log(Level.INFO, "DB_To_DBThread", "run()", "Done executeDB_To_DB_Transfer()\n");
        }
        if (!bl) {
            this.log(Level.INFO, "DB_To_DBThread", "run()", "Entering executeDB_CheckTransfer()");
            int n = this.executeDB_CheckTransfer(this.connectionInstanceSink, this.dbConnectionSink, 10);
            this.log(Level.INFO, "DB_To_DBThread", "run()", "Done executeDB_CheckTransfer() Error: " + (n == -1) + "\n");
        }
    }

    public void openConnectionSink() {
        this.log(Level.FINE, "DB_To_DBThread", "openConnectionSink()", this.connectionInstanceSink.getConnectionProperties().getConnectionURLString());
        this.dbConnectionSink = this.connectionInstanceSink.getConnection("DB_To_DBThread openConnectionSink()");
    }

    public void closeConnectionSink() {
        this.log(Level.FINE, "DB_To_DBThread", "closeConnectionSink()", this.dbSinkTypeString);
        if (this.dbConnectionSink != null) {
            this.log(Level.FINE, "DB_To_DBThread", "closeConnectionSink()", this.connectionInstanceSink.getConnectionProperties().getConnectionURLString());
            if (this.dbTypeMemory) {
                this.connectionInstanceSink.shutdown("DB_To_DBThread closeConnectionSink()");
                this.dbConnectionSink = null;
            } else {
                this.connectionInstanceSink.closeConnection(this.dbConnectionSink, "DB_To_DBThread closeConnectionSink()");
            }
        } else {
            this.dbConnectionSink = null;
        }
    }

    private boolean executeSinkDBCreation(Connection connection) {
        boolean bl = false;
        this.log(Level.FINE, "DB_To_DBThread", "executeSinkDBCreation()", " dbTypeMemory: " + this.dbTypeMemory);
        try {
            this.log(Level.INFO, "DB_To_DBThread", "executeSinkDBCreation()", "Setting Up SQLQuery");
            this.sqlQuerySource = new SQLQuery(this.sqlQueryString);
            boolean bl2 = bl = this.sqlQuerySource.executeSQL(this.connectionInstanceSource) == -1;
            if (bl) {
                return bl;
            }
            this.queryRowCount = this.sqlQuerySource.getRowCount(this.connectionInstanceSource);
            this.log(Level.FINE, "DB_To_DBThread", "executeSinkDBCreation()", "Query Row Count: " + this.queryRowCount);
            this.log(Level.INFO, "DB_To_DBThread", "executeSinkDBCreation()", "Setting Up DDL");
            DDLGenerator dDLGenerator = new DDLGenerator(this.sqlQuerySource, this.connectionInstanceSource.getDataSourceType(), this.dbSinkTypeString, 1);
            dDLGenerator.setUseSQLiteCast(this.useSQLiteCast);
            this.log(Level.INFO, "DB_To_DBThread", "executeSinkDBCreation()", "Getting DDL");
            Connection connection2 = this.connectionInstanceSource.getConnection("DB_To_DBThread executeSinkDBCreation()");
            String string = dDLGenerator.getDDL(connection2, this.sinkDBTableNameString, this.connectionInstanceSink.getCatalogSeparator(), this.connectionInstanceSink.getIdentifierQuoteString());
            this.connectionInstanceSource.closeConnection(connection2, "DB_To_DBThread executeSinkDBCreation()");
            this.log(Level.INFO, "DB_To_DBThread", "executeSinkDBCreation()", "Creating Sink DB");
            Statement statement = connection.createStatement();
            String[] stringArray = string.split(";\n");
            for (int i = 0; i < stringArray.length; ++i) {
                statement.execute(stringArray[i].trim());
            }
            this.log(Level.INFO, "DB_To_DBThread", "executeSinkDBCreation()", "Checking New Database");
            string = "SELECT * FROM " + Utils.getSchemaTableName(this.sinkDBTableNameString, this.connectionInstanceSink.getCatalogSeparator(), this.connectionInstanceSink.getIdentifierQuoteString());
            this.log(Level.FINE, "DB_To_DBThread", "executeSinkDBCreation()", string);
            this.sqlQuerySink = new SQLQuery(string, 1);
            bl = this.sqlQuerySink.executeSQL(connection) != 1;
        }
        catch (SQLException sQLException) {
            ConnectionInstance.displaySQLErrors(sQLException, "DB_ToFileMemoryDBPanel executeSinkDBCreation()", true);
            bl = true;
        }
        return bl;
    }

    private void executeDB_To_DB_Transfer(ConnectionInstance connectionInstance, Connection connection) {
        this.log(Level.INFO, "DB_To_DBThread", "executeDB_To_DB_Transfer()", "Setting up Threads");
        ArrayBlockingQueue<TableRowElements> arrayBlockingQueue = new ArrayBlockingQueue<TableRowElements>(50, true);
        SQLLoadThread sQLLoadThread = new SQLLoadThread(this.connectionInstanceSource, this.sqlQuerySource, arrayBlockingQueue, false, 1000, true, true);
        if (this.threadLogger != null) {
            sQLLoadThread.setLogger(this.threadLogger);
        }
        Thread thread = new Thread((Runnable)sQLLoadThread, "sqlLoadThread");
        thread.setPriority(thread.getPriority() + 1);
        this.log(Level.FINE, "DB_To_DBThread", "executeDB_To_DB_Transfer()", "loadThread : " + thread);
        SQLInsertPrepareThread sQLInsertPrepareThread = new SQLInsertPrepareThread(sQLLoadThread, connectionInstance, connection, this.sqlQuerySink, arrayBlockingQueue, SINK_DB_TABLE_NAME, false, 50);
        if (this.threadLogger != null) {
            sQLInsertPrepareThread.setLogger(this.threadLogger);
        }
        Thread thread2 = new Thread((Runnable)sQLInsertPrepareThread, "insertThread");
        this.log(Level.FINE, "DB_To_DBThread", "executeDB_To_DB_Transfer()", "insertThread : " + thread2);
        this.log(Level.INFO, "DB_To_DBThread", "executeDB_To_DB_Transfer()", "Starting Transfer\n");
        thread.start();
        thread2.start();
        try {
            thread.join();
            thread2.join();
        }
        catch (InterruptedException interruptedException) {
            this.log(Level.WARNING, "DB_To_DBThread", "executeDB_To_DB_Transfer()", interruptedException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int executeDB_CheckTransfer(ConnectionInstance connectionInstance, Connection connection, int n) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        if (n > 10) {
            n = 10;
        }
        ResultSet resultSet = null;
        Statement statement = null;
        this.log(Level.INFO, "DB_To_DBThread", "executeDB_CheckTransfer()", "Checking Data");
        try {
            boolean bl;
            stringBuilder.append("SELECT * FROM " + Utils.getSchemaTableName(this.sinkDBTableNameString, connectionInstance.getCatalogSeparator(), connectionInstance.getIdentifierQuoteString()));
            SQLQuery sQLQuery = new SQLQuery(stringBuilder.toString());
            boolean bl2 = bl = sQLQuery.executeSQL(connectionInstance) == -1;
            if (bl) {
                int n3 = -1;
                return n3;
            }
            n2 = sQLQuery.getRowCount(connectionInstance);
            this.log(Level.FINE, "DB_To_DBThread", "executeDB_CheckTransfer()", "Inserted Row Count: " + n2);
            if (n <= 0) return n2;
            stringBuilder.delete(0, stringBuilder.length());
            stringBuilder.append("SELECT * FROM " + Utils.getSchemaTableName(this.sinkDBTableNameString, connectionInstance.getCatalogSeparator(), connectionInstance.getIdentifierQuoteString()));
            if (connectionInstance.getDataSourceType().equals("h2")) {
                stringBuilder.append(" LIMIT " + n);
            } else if (connectionInstance.getDataSourceType().equals("derby")) {
                stringBuilder.append("OFFSET 0 ROWS FETCH NEXT " + n + " ROWS ONLY");
            } else {
                stringBuilder.append(" LIMIT " + n + " OFFSET 0");
            }
            statement = connection.createStatement();
            this.log(Level.FINE, "DB_To_DBThread", "executeDB_CheckTransfer()", "sqlStatementString:\n" + stringBuilder);
            resultSet = statement.executeQuery(stringBuilder.toString());
            int n4 = resultSet.getMetaData().getColumnCount();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            StringBuilder stringBuilder2 = new StringBuilder("\n");
            while (true) {
                int n5;
                if (resultSet.next()) {
                } else {
                    this.log(Level.FINE, "", "", stringBuilder2.toString());
                    if (this.queryRowCount == n2) return n2;
                    n5 = -1;
                    return n5;
                }
                for (n5 = 1; n5 <= n4; ++n5) {
                    String string = DB_To_DBThread.isBlob(resultSetMetaData.getColumnClassName(n5), resultSetMetaData.getColumnTypeName(n5)) ? "BLOB" : (DB_To_DBThread.isText(resultSetMetaData.getColumnClassName(n5), resultSetMetaData.getColumnTypeName(n5), resultSetMetaData.getColumnDisplaySize(n5), 65535) ? "TEXT" : resultSet.getString(n5));
                    if (string == null) {
                        stringBuilder2.append("Null, ");
                        continue;
                    }
                    stringBuilder2.append(string + ", ");
                }
                if (stringBuilder2.length() != 0) {
                    stringBuilder2.delete(stringBuilder2.length() - 2, stringBuilder2.length());
                }
                stringBuilder2.append("\n");
            }
        }
        catch (SQLException sQLException) {
            ConnectionInstance.displaySQLErrors(sQLException, "DB_To_DBThread executeDB_CheckTransfer()", true);
            n2 = -1;
            return n2;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                ConnectionInstance.displaySQLErrors(sQLException, "DB_To_DBThread executeDB_CheckTransfer()", true);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    ConnectionInstance.displaySQLErrors(sQLException, "DB_To_DBThread executeDB_CheckTransfer()", true);
                }
            }
        }
    }

    private void log(Level level, String string, String string2, String string3) {
        if (this.threadLogger != null) {
            this.threadLogger.logp(level, string, string2, string3);
        }
    }

    public static boolean isBlob(String string, String string2) {
        string = string.toLowerCase(Locale.ENGLISH);
        string2 = string2.toUpperCase(Locale.ENGLISH);
        return string.indexOf("string") == -1 && string2.indexOf("BLOB") != -1 || string2.indexOf("BYTEA") != -1 || string2.indexOf("BINARY") != -1 || string.indexOf("byte") != -1 && string2.indexOf("BIT DATA") != -1 || string2.indexOf("RAW") != -1 || string2.indexOf("IMAGE") != -1;
    }

    public static boolean isText(String string, String string2, int n, int n2) {
        int n3 = n2 == 0 ? 65535 : n2;
        string = string.toLowerCase(Locale.ENGLISH);
        string2 = string2.toUpperCase(Locale.ENGLISH);
        return string.indexOf("string") != -1 && !string2.equals("CHAR") && !string2.equals("NCHAR") && !string2.equals("BPCHAR") && n > n3 || string.indexOf("string") != -1 && string2.equals("LONG") || string2.equals("TEXT") || string2.indexOf("CLOB") != -1 || string2.equals("XML");
    }

    public void setLogger(Logger logger) {
        this.threadLogger = logger;
    }
}

