/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.utilities;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.io.PDFDataTableDumpThread;
import com.dandymadeproductions.ajqvue.io.WriteDataFile;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.InputDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.DefaultEditorKit;

public class Utils
extends Ajqvue {
    public static final String MMddyyyy_DASH = "MM-dd-yyyy";
    public static final String MMddyyyy_SLASH = "MM/dd/yyyy";
    public static final String MMMddyyyy_DASH = "MMM-dd-yyyy";
    public static final String ddMMyyyy_DASH = "dd-MM-yyyy";
    public static final String ddMMyyyy_SLASH = "dd/MM/yyyy";
    public static final String ddMMMyyyy_DASH = "dd-MMM-yyyy";
    public static final String yyyyMMdd_DASH = "yyyy-MM-dd";
    public static final String yyyyMMdd_SLASH = "yyyy/MM/dd";
    public static final String yyyyMMMdd_DASH = "yyyy-MMM-dd";
    public static final String MMM = "MMM";
    private static final Object[] dateFormatOptions = new Object[]{"MM-dd-yyyy", "MM/dd/yyyy", "MMM-dd-yyyy", "dd-MM-yyyy", "dd/MM/yyyy", "dd-MMM-yyyy", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy-MMM-dd"};

    public static void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    public static void clearCache() {
        File file = new File(Utils.getCacheDirectory());
        boolean bl = false;
        if (file.exists() && file.isDirectory()) {
            block6: {
                try {
                    File[] fileArray = file.listFiles();
                    if (fileArray != null) {
                        for (int i = 0; i < fileArray.length; ++i) {
                            boolean bl2;
                            if (!fileArray[i].isFile() || (bl2 = fileArray[i].delete())) continue;
                            bl = true;
                        }
                    }
                }
                catch (SecurityException securityException) {
                    if (!Ajqvue.getDebug()) break block6;
                    System.out.println("Utils clearCache() Failed to Clear Cache: " + securityException.toString());
                }
            }
            if (bl && Ajqvue.getDebug()) {
                System.out.println("Utils clearCache() Failed to Clear a Cache File.");
            }
        }
    }

    public static String convertCharMonthToDecimal(String string) {
        if (string.toLowerCase(Locale.ENGLISH).indexOf("jan") != -1) {
            return "01";
        }
        if (string.toLowerCase(Locale.ENGLISH).indexOf("feb") != -1) {
            return "02";
        }
        if (string.toLowerCase(Locale.ENGLISH).indexOf("mar") != -1) {
            return "03";
        }
        if (string.toLowerCase(Locale.ENGLISH).indexOf("apr") != -1) {
            return "04";
        }
        if (string.toLowerCase(Locale.ENGLISH).indexOf("may") != -1) {
            return "05";
        }
        if (string.toLowerCase(Locale.ENGLISH).indexOf("jun") != -1) {
            return "06";
        }
        if (string.toLowerCase(Locale.ENGLISH).indexOf("jul") != -1) {
            return "07";
        }
        if (string.toLowerCase(Locale.ENGLISH).indexOf("aug") != -1) {
            return "08";
        }
        if (string.toLowerCase(Locale.ENGLISH).indexOf("sep") != -1) {
            return "09";
        }
        if (string.toLowerCase(Locale.ENGLISH).indexOf("oct") != -1) {
            return "10";
        }
        if (string.toLowerCase(Locale.ENGLISH).indexOf("nov") != -1) {
            return "11";
        }
        if (string.toLowerCase(Locale.ENGLISH).indexOf("dec") != -1) {
            return "12";
        }
        return "0";
    }

    public static String convertDecimalToCharMonth(int n) {
        if (n == 1) {
            return "Jan";
        }
        if (n == 2) {
            return "Feb";
        }
        if (n == 3) {
            return "Mar";
        }
        if (n == 4) {
            return "Apr";
        }
        if (n == 5) {
            return "May";
        }
        if (n == 6) {
            return "Jun";
        }
        if (n == 7) {
            return "Jul";
        }
        if (n == 8) {
            return "Aug";
        }
        if (n == 9) {
            return "Sep";
        }
        if (n == 10) {
            return "Oct";
        }
        if (n == 11) {
            return "Nov";
        }
        if (n == 12) {
            return "Dec";
        }
        return n + "";
    }

    public static String convertDBDateString_To_ViewDateString(String string, String string2) {
        if (string != null && !string.equals("")) {
            string = string.trim();
            int n = string.indexOf("-");
            int n2 = string.lastIndexOf("-");
            if (n == -1 || n2 == -1) {
                return "";
            }
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1, n2);
            String string5 = string.substring(string.lastIndexOf("-") + 1);
            String string6 = string2.equals(yyyyMMdd_DASH) || string2.equals(yyyyMMdd_SLASH) || string2.equals(yyyyMMMdd_DASH) ? (string2.indexOf(MMM) != -1 ? string3 + "-" + Utils.convertDecimalToCharMonth(Integer.parseInt(string4)) + "-" + string5 : string3 + "-" + string4 + "-" + string5) : (string2.equals(ddMMyyyy_DASH) || string2.equals(ddMMyyyy_SLASH) || string2.equals(ddMMMyyyy_DASH) ? (string2.indexOf(MMM) != -1 ? string5 + "-" + Utils.convertDecimalToCharMonth(Integer.parseInt(string4)) + "-" + string3 : string5 + "-" + string4 + "-" + string3) : (string2.indexOf(MMM) != -1 ? Utils.convertDecimalToCharMonth(Integer.parseInt(string4)) + "-" + string5 + "-" + string3 : string4 + "-" + string5 + "-" + string3));
            if (string2.indexOf("/") != -1) {
                string6 = string6.replaceAll("-", "/");
            }
            return string6;
        }
        return string;
    }

    public static String convertViewDateString_To_DBDateString(String string, String string2) {
        String string3;
        String string4;
        String string5;
        if (string.indexOf("/") != -1) {
            string = string.replaceAll("/", "-");
        }
        int n = string.indexOf("-");
        int n2 = string.lastIndexOf("-");
        if (n == -1 || n2 == -1) {
            return "";
        }
        if (string2.equals(yyyyMMdd_DASH) || string2.equals(yyyyMMdd_SLASH) || string2.equals(yyyyMMMdd_DASH)) {
            string5 = string.substring(0, n);
            string4 = string.substring(n + 1, n2);
            if (string4.length() > 2) {
                string4 = Utils.convertCharMonthToDecimal(string4);
            }
            string3 = string.substring(n2 + 1);
        } else if (string2.equals(ddMMyyyy_DASH) || string2.equals(ddMMyyyy_SLASH) || string2.equals(ddMMMyyyy_DASH)) {
            string5 = string.substring(n2 + 1);
            string4 = string.substring(n + 1, n2);
            if (string4.length() > 2) {
                string4 = Utils.convertCharMonthToDecimal(string4);
            }
            string3 = string.substring(0, n);
        } else {
            string5 = string.substring(n2 + 1);
            string4 = string.substring(0, n);
            if (string4.length() > 2) {
                string4 = Utils.convertCharMonthToDecimal(string4);
            }
            string3 = string.substring(n + 1, n2);
        }
        return string5 + "-" + string4 + "-" + string3;
    }

    protected static String convertPasswordToString(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            stringBuffer.append(cArray[i]);
        }
        if (stringBuffer.length() == 0) {
            return "";
        }
        return stringBuffer.toString();
    }

    public static byte[] convertBitsToHSQL_Bits(String string) {
        if (string.isEmpty()) {
            return new byte[0];
        }
        try {
            Integer.parseInt(string, 2);
        }
        catch (NumberFormatException numberFormatException) {
            return new byte[0];
        }
        byte[] byArray = new byte[string.length() / 8 + 1];
        for (int i = 0; i < byArray.length; ++i) {
            StringBuilder stringBuilder = string.length() / ((i + 1) * 8) > 0 ? new StringBuilder(string.substring(i * 8, i * 8 + 8)) : new StringBuilder(string.substring(i * 8, string.length()));
            if (stringBuilder.length() < 8) {
                do {
                    stringBuilder.append("0");
                } while (stringBuilder.length() < 8);
            }
            if (stringBuilder.charAt(0) == '0') {
                byArray[i] = Byte.valueOf(stringBuilder.toString(), 2);
                continue;
            }
            int n = 0;
            do {
                if (stringBuilder.charAt(n) == '0') {
                    stringBuilder.setCharAt(n, '1');
                    continue;
                }
                stringBuilder.setCharAt(n, '0');
            } while (++n < 8);
            int n2 = (Integer.parseInt(stringBuilder.toString(), 2) + 1) * -1;
            byArray[i] = Byte.parseByte(String.valueOf(n2), 10);
        }
        return byArray;
    }

    public static JColorChooser createColorChooser(Component component) {
        JColorChooser jColorChooser = new JColorChooser();
        jColorChooser.setBorder(BorderFactory.createTitledBorder("Color"));
        jColorChooser.setColor(component.getBackground());
        jColorChooser.setPreviewPanel(new JPanel());
        return jColorChooser;
    }

    public static InputDialog createTextDialog(boolean bl, JEditorPane jEditorPane) {
        if (!bl) {
            jEditorPane.setEditable(false);
        }
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        jScrollPane.setPreferredSize(new Dimension(500, 350));
        jScrollPane.setMinimumSize(new Dimension(400, 200));
        Object[] objectArray = new Object[]{jScrollPane};
        AResourceBundle aResourceBundle = Ajqvue.getResourceBundle();
        String string = aResourceBundle.getResourceString("Utils.dialogtitle.TextData", "Text Data");
        String string2 = aResourceBundle.getResourceString("Utils.dialogbutton.Save", "Save");
        String string3 = bl ? aResourceBundle.getResourceString("Utils.dialogbutton.Open", "Open") : aResourceBundle.getResourceString("Utils.dialogbutton.Close", "Close");
        InputDialog inputDialog = new InputDialog(null, string, string2, string3, objectArray, null);
        return inputDialog;
    }

    public static JMenuBar createEditMenu(boolean bl) {
        JMenuItem jMenuItem;
        JMenuBar jMenuBar = new JMenuBar();
        AResourceBundle aResourceBundle = Ajqvue.getResourceBundle();
        String string = aResourceBundle.getResourceString("Utils.menu.Edit", "Edit");
        JMenu jMenu = new JMenu(string);
        jMenu.setFont(jMenu.getFont().deriveFont(1));
        if (bl) {
            jMenuItem = new JMenuItem(new DefaultEditorKit.CutAction());
            string = aResourceBundle.getResourceString("Utils.menu.Cut", "Cut");
            jMenuItem.setText(string + "          Ctrl-x");
            jMenuItem.setMnemonic(88);
            jMenu.add(jMenuItem);
        }
        jMenuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        string = aResourceBundle.getResourceString("Utils.menu.Copy", "Copy");
        jMenuItem.setText(string + "       Ctrl-c");
        jMenuItem.setMnemonic(67);
        jMenu.add(jMenuItem);
        if (bl) {
            jMenuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
            string = aResourceBundle.getResourceString("Utils.menu.Paste", "Paste");
            jMenuItem.setText(string + "       Ctrl-v");
            jMenuItem.setMnemonic(86);
            jMenu.add(jMenuItem);
        }
        if ((jMenuItem = Utils.createSelectAllMenuItem(aResourceBundle)) != null) {
            jMenu.addSeparator();
            jMenu.add(jMenuItem);
        }
        jMenuBar.add(jMenu);
        return jMenuBar;
    }

    public static JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        AResourceBundle aResourceBundle = Ajqvue.getResourceBundle();
        JMenuItem jMenuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        String string = aResourceBundle.getResourceString("Utils.menu.Cut", "Cut");
        jMenuItem.setText(string);
        jMenuItem.setMnemonic(88);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        string = aResourceBundle.getResourceString("Utils.menu.Copy", "Copy");
        jMenuItem.setText(string);
        jMenuItem.setMnemonic(67);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        string = aResourceBundle.getResourceString("Utils.menu.Paste", "Paste");
        jMenuItem.setText(string);
        jMenuItem.setMnemonic(86);
        jPopupMenu.add(jMenuItem);
        jMenuItem = Utils.createSelectAllMenuItem(aResourceBundle);
        if (jMenuItem != null) {
            jPopupMenu.addSeparator();
            jPopupMenu.add(jMenuItem);
        }
        return jPopupMenu;
    }

    private static JMenuItem createSelectAllMenuItem(AResourceBundle aResourceBundle) {
        JTextPane jTextPane = new JTextPane();
        JMenuItem jMenuItem = null;
        Action[] actionArray = jTextPane.getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            Action action = actionArray[i];
            if (!action.getValue("Name").equals("select-all")) continue;
            jMenuItem = new JMenuItem(action);
            String string = aResourceBundle.getResourceString("Utils.menu.SelectAll", "Select All");
            jMenuItem.setText(string);
        }
        return jMenuItem;
    }

    public static Clip getAudioClip(String string) {
        File file = new File(string);
        try {
            AudioInputStream audioInputStream;
            try {
                audioInputStream = AudioSystem.getAudioInputStream(file);
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                return null;
            }
            AudioFormat audioFormat = audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, audioFormat);
            if (!AudioSystem.isLineSupported(info)) {
                audioInputStream.close();
                return null;
            }
            try {
                Clip clip = (Clip)AudioSystem.getLine(info);
                clip.open(audioInputStream);
                audioInputStream.close();
                return clip;
            }
            catch (LineUnavailableException lineUnavailableException) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getCacheDirectory() {
        String string;
        block4: {
            string = Utils.getAjqvueConfDirectory() + Utils.getFileSeparator() + "cache" + Utils.getFileSeparator();
            File file = new File(string);
            if (!file.isDirectory()) {
                try {
                    if (!file.mkdirs()) {
                        throw new SecurityException();
                    }
                }
                catch (SecurityException securityException) {
                    if (!Ajqvue.getDebug()) break block4;
                    System.out.println("Utils getCacheDirectory() Failed to Make Cache Directory.\n" + securityException.toString());
                }
            }
        }
        return string;
    }

    public static int[] getChartList(int n, int n2) {
        int n3;
        Random random = new Random();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int[] nArray = new int[n];
        for (n3 = 0; n3 < n - 1; ++n3) {
            int n4 = random.nextInt(n2);
            while (hashMap.containsValue(n4)) {
                n4 = random.nextInt(n2);
            }
            hashMap.put(n3, n4);
            nArray[n3] = n4;
        }
        hashMap.put(n3, n);
        nArray[n3] = n2;
        return nArray;
    }

    public static String getConditionString(String string) {
        String string2 = "";
        String string3 = ConnectionManager.getDataSourceType();
        if (string.toUpperCase(Locale.ENGLISH).indexOf("WHERE") == -1) {
            return string2;
        }
        string = string.replaceAll("(?i)where", "WHERE");
        if (string3.equals("oracle") || string3.equals("sqlserver")) {
            if (string.toUpperCase(Locale.ENGLISH).indexOf("BETWEEN") != -1) {
                string = Utils.getUnlimitedSQLStatementString(string);
            }
            string2 = string.toUpperCase(Locale.ENGLISH).indexOf(" GROUP BY ") != -1 ? string.substring(string.indexOf("WHERE"), string.toUpperCase(Locale.ENGLISH).indexOf(" GROUP BY ")) : (string.toUpperCase(Locale.ENGLISH).indexOf(" ORDER BY ") != -1 ? string.substring(string.indexOf("WHERE"), string.toUpperCase(Locale.ENGLISH).indexOf(" ORDER BY ")) : string.substring(string.indexOf("WHERE")));
        } else {
            string2 = string.toUpperCase(Locale.ENGLISH).indexOf(" GROUP BY ") != -1 ? string.substring(string.indexOf("WHERE"), string.toUpperCase(Locale.ENGLISH).indexOf(" GROUP BY ")) : (string.toUpperCase(Locale.ENGLISH).indexOf(" ORDER BY ") != -1 ? string.substring(string.indexOf("WHERE"), string.toUpperCase(Locale.ENGLISH).indexOf(" ORDER BY ")) : (string.toUpperCase(Locale.ENGLISH).indexOf("LIMIT") != -1 ? string.substring(string.indexOf("WHERE"), string.toUpperCase(Locale.ENGLISH).indexOf(" LIMIT")) : string.substring(string.indexOf("WHERE"))));
        }
        return string2;
    }

    public static Object[] getDateFormatOption() {
        Object[] objectArray = new Object[dateFormatOptions.length];
        for (int i = 0; i < dateFormatOptions.length; ++i) {
            objectArray[i] = dateFormatOptions[i];
        }
        return objectArray;
    }

    public static Image getFrameIcon() {
        return Ajqvue.getResourceBundle().getResourceImage(Utils.getIconsDirectory() + Utils.getFileSeparator() + "searchIcon.png").getImage();
    }

    public static String getFileSeparator() {
        String string = System.getProperty("file.separator");
        if (string == null || string.equals("")) {
            string = "/";
        }
        return string;
    }

    public static String getIconsDirectory() {
        return "images" + Utils.getFileSeparator() + "icons";
    }

    public static String getAjqvueConfDirectory() {
        return System.getProperty("user.home") + Utils.getFileSeparator() + ".ajqvue";
    }

    public static String getAjqvueDirectory() {
        return System.getProperty("user.dir");
    }

    public static String getSchemaTableName(String string) {
        return Utils.getSchemaTableName(string, ConnectionManager.getCatalogSeparator(), ConnectionManager.getIdentifierQuoteString());
    }

    public static String getSchemaTableName(String string, String string2, String string3) {
        String string4 = string.indexOf(string2) != -1 ? string3 + string.substring(0, string.indexOf(string2)) + string3 + string2 + string3 + string.substring(string.indexOf(string2) + 1) + string3 : string3 + string + string3;
        return string4;
    }

    public static char[] getStandardCharacters() {
        return "k8^ef1209rEW-+$xB1aH".toCharArray();
    }

    public static String getUnlimitedSQLStatementString(String string) {
        String string2 = ConnectionManager.getDataSourceType();
        StringBuffer stringBuffer = new StringBuffer();
        if (!string2.equals("oracle") && !string2.equals("sqlserver") && !string2.equals("derby") && string.indexOf("LIMIT") == -1 || (string2.equals("oracle") || string2.equals("sqlserver")) && string.indexOf("BETWEEN") == -1 || string2.equals("derby") && string.indexOf("OFFSET") == -1) {
            return string;
        }
        if (string2.equals("oracle") || string2.equals("sqlserver")) {
            int n = string.indexOf("(");
            int n2 = string.lastIndexOf("FROM");
            int n3 = string.lastIndexOf(")");
            int n4 = string.indexOf("ORDER");
            int n5 = string.toUpperCase(Locale.ENGLISH).indexOf("AS DMPROWNUMBER");
            if (n != -1 && n2 != -1 && n3 != -1 && n4 != -1 && n5 != -1) {
                stringBuffer.append(string.substring(0, n - 1) + string.substring(n2 + 4, n3) + " " + string.substring(n4, n5 - 2));
            }
        } else if (string2.equals("hsql") || string2.equals("hsql2")) {
            if (string.indexOf("LIMIT") != -1) {
                int n;
                int n6 = string.indexOf("LIMIT");
                if (n6 < (n = string.indexOf(ConnectionManager.getIdentifierQuoteString()))) {
                    stringBuffer.append(string.substring(0, n6) + string.substring(n));
                } else {
                    stringBuffer.append(string.substring(0, n6));
                }
            }
        } else if (string2.equals("derby")) {
            if (string.indexOf("OFFSET") != -1) {
                stringBuffer.append(string.substring(0, string.lastIndexOf("OFFSET")));
            }
        } else if (string.indexOf("LIMIT") != -1) {
            stringBuffer.append(string.substring(0, string.lastIndexOf("LIMIT")));
        }
        String string3 = stringBuffer.toString().trim();
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append(string3);
        return new String(stringBuffer);
    }

    public static boolean isBlob(String string, String string2) {
        string = string.toLowerCase(Locale.ENGLISH);
        string2 = string2.toUpperCase(Locale.ENGLISH);
        return string.indexOf("String") == -1 && string2.indexOf("BLOB") != -1 || string2.indexOf("BYTEA") != -1 || string2.indexOf("BINARY") != -1 || string.indexOf("byte") != -1 && string2.indexOf("BIT DATA") != -1 || string2.indexOf("RAW") != -1 || string2.indexOf("IMAGE") != -1;
    }

    public static boolean isNotQuoted(String string, int n, String string2) {
        return Utils.isNumeric(string, string2) || n == -5 || n == 3 || n == 8 || n == 6 || n == 4 || n == 2 || n == 7 || n == 5 || n == -6;
    }

    public static boolean isNumeric(String string, String string2) {
        return (string2.equals("INT") || string2.equals("INT2") || string2.equals("INT4") || string2.equals("INT8") || string.indexOf("Boolean") == -1 && string2.indexOf("TINYINT") != -1 || string2.indexOf("SMALLINT") != -1 || string2.indexOf("INTEGER") != -1 || string2.indexOf("MEDIUMINT") != -1 || string2.indexOf("BIGINT") != -1 || string2.indexOf("SERIAL") != -1 || string2.equals("DOUBLE") || string2.equals("FLOAT") || string2.equals("FLOAT4") || string2.equals("FLOAT8") || string.indexOf("String") == -1 && string2.equals("LONG") || string2.equals("REAL") || string2.indexOf("DECIMAL") != -1 || string2.indexOf("NUMBER") != -1 || string2.indexOf("MONEY") != -1 || string2.equals("NUMERIC") || string2.indexOf("COUNTER") != -1 || string.indexOf("byte") != -1 && string2.equals("BYTE") || string2.equals("CURRENCY")) && string.indexOf("Array") == -1;
    }

    public static boolean isText(String string, String string2, boolean bl, int n) {
        int n2 = bl ? 255 : 32700;
        string = string.toLowerCase(Locale.ENGLISH);
        string2 = string2.toUpperCase(Locale.ENGLISH);
        return string.indexOf("string") != -1 && !string2.equals("CHAR") && !string2.equals("NCHAR") && !string2.equalsIgnoreCase("BPCHAR") && n > n2 || string.indexOf("string") != -1 && string2.equals("LONG") || string2.equals("TEXT") || string2.indexOf("CLOB") != -1 || string2.equals("XML");
    }

    public static String processDateFormatSearch(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("/") != -1) {
            string = string.replaceAll("/", "-");
        }
        if (string.indexOf("-") == -1) {
            if (string.length() == 3) {
                string = Utils.convertCharMonthToDecimal(string);
            }
            return string;
        }
        if (string.length() >= 10 && string.length() < 12) {
            return Utils.convertViewDateString_To_DBDateString(string, DBTablesPanel.getGeneralDBProperties().getViewDateFormat());
        }
        String[] stringArray = string.split("-");
        if (stringArray.length == 1) {
            if (stringArray[0].length() == 3) {
                stringArray[0] = Utils.convertCharMonthToDecimal(stringArray[0]);
                string = string.indexOf("-") == 0 ? "-" + stringArray[0] : stringArray[0] + "-";
            }
            return string;
        }
        String string2 = DBTablesPanel.getGeneralDBProperties().getViewDateFormat();
        if (string2.equals(yyyyMMdd_DASH) || string2.equals(yyyyMMdd_SLASH) || string2.equals(yyyyMMMdd_DASH)) {
            if (stringArray.length == 3) {
                return stringArray[0] + "-" + stringArray[1] + "-" + stringArray[2];
            }
            if (stringArray[0].length() == 4) {
                String string3 = stringArray[0];
                String string4 = stringArray[1];
                if (string4.length() > 2) {
                    string4 = Utils.convertCharMonthToDecimal(string4);
                }
                return string3 + "-" + string4;
            }
            String string5 = stringArray[0];
            String string6 = stringArray[1];
            if (string5.length() > 2) {
                string5 = Utils.convertCharMonthToDecimal(string5);
            }
            return string5 + "-" + string6;
        }
        if (string2.equals(ddMMyyyy_DASH) || string2.equals(ddMMyyyy_SLASH) || string2.equals(ddMMMyyyy_DASH)) {
            if (stringArray.length == 3) {
                return stringArray[2] + "-" + stringArray[1] + "-" + stringArray[0];
            }
            if (stringArray[1].length() == 4) {
                String string7 = stringArray[1];
                String string8 = stringArray[0];
                if (string8.length() > 2) {
                    string8 = Utils.convertCharMonthToDecimal(string8);
                }
                return string7 + "-" + string8;
            }
            String string9 = stringArray[1];
            String string10 = stringArray[0];
            if (string9.length() > 2) {
                string9 = Utils.convertCharMonthToDecimal(string9);
            }
            return string9 + "-" + string10;
        }
        if (stringArray.length == 3) {
            return stringArray[2] + "-" + stringArray[0] + "-" + stringArray[1];
        }
        if (stringArray[1].length() == 4) {
            String string11 = stringArray[1];
            String string12 = stringArray[0];
            return string11 + "-%-" + string12;
        }
        String string13 = stringArray[0];
        String string14 = stringArray[1];
        if (string13.length() > 2) {
            string13 = Utils.convertCharMonthToDecimal(string13);
        }
        return string13 + "-" + string14;
    }

    public static int processFileChooserSelection(JFrame jFrame, JFileChooser jFileChooser) {
        String string = Utils.getFileSeparator();
        boolean bl = false;
        int n = 1;
        while (!bl) {
            n = jFileChooser.showSaveDialog(jFrame);
            if (n == 0) {
                String string2 = jFileChooser.getSelectedFile().getName();
                string2 = jFileChooser.getCurrentDirectory() + string + string2;
                if (!string2.equals("")) {
                    File file = new File(string2);
                    if (file.exists()) {
                        if (Utils.processFileOverwriteDialog()) {
                            bl = true;
                            n = 0;
                            continue;
                        }
                        bl = false;
                        n = 1;
                        continue;
                    }
                    bl = true;
                    n = 0;
                    continue;
                }
                bl = true;
                n = 0;
                continue;
            }
            bl = true;
            n = 1;
        }
        return n;
    }

    public static boolean processFileOverwriteDialog() {
        AResourceBundle aResourceBundle = Ajqvue.getResourceBundle();
        boolean bl = false;
        String string = Utils.getFileSeparator();
        if (string == null || string.equals("")) {
            string = "/";
        }
        String string2 = "images" + string + "icons" + string;
        ImageIcon imageIcon = aResourceBundle.getResourceImage(string2 + "deleteFileIcon.gif");
        String string3 = aResourceBundle.getResourceString("Utils.message.FileExistsOverWrite", "File Exists, Over Write?");
        JLabel jLabel = new JLabel(string3, 0);
        Object[] objectArray = new Object[]{jLabel};
        string3 = aResourceBundle.getResourceString("Utils.dialogtitle.SaveWarning", "Save Warning");
        String string4 = aResourceBundle.getResourceString("Utils.dialogbutton.Yes", "Yes");
        String string5 = aResourceBundle.getResourceString("Utils.dialogbutton.No", "No");
        InputDialog inputDialog = new InputDialog(null, string3, string4, string5, objectArray, imageIcon);
        inputDialog.pack();
        inputDialog.center();
        inputDialog.setResizable(false);
        inputDialog.setVisible(true);
        bl = inputDialog.isActionResult();
        inputDialog.dispose();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String processLocaleLanguage() {
        String string = "";
        String string2 = "ajqvue_locale.txt";
        String string3 = "locale";
        boolean bl = false;
        String string4 = Utils.getAjqvueConfDirectory() + Utils.getFileSeparator() + string2;
        File file = new File(string3);
        File file2 = new File(string4);
        File file3 = new File(Utils.getAjqvueConfDirectory());
        if (!file3.isDirectory()) {
            try {
                bl = !file3.mkdir();
            }
            catch (SecurityException securityException) {
                String string5 = "File Error: Failed to create .ajqvue directory.\n" + securityException;
                JOptionPane.showMessageDialog(null, string5, "Alert", 0);
                return "";
            }
        }
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            if (!bl && (file2.createNewFile() || file2.length() == 0L)) {
                String[] stringArray = file.list();
                if (stringArray == null) {
                    String string6 = "";
                    return string6;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    int n = stringArray[i].lastIndexOf(".");
                    if (n <= 0 || !stringArray[i].substring(n + 1).equals("properties")) continue;
                    arrayList.add(stringArray[i].substring(n - 5, n));
                }
                if (arrayList.size() == 0) {
                    String string7 = "";
                    return string7;
                }
                JComboBox<Object> jComboBox = new JComboBox<Object>(arrayList.toArray());
                jComboBox.setBorder(BorderFactory.createLoweredBevelBorder());
                Object[] objectArray = new Object[]{jComboBox};
                ImageIcon imageIcon = new ImageIcon(Utils.getIconsDirectory() + Utils.getFileSeparator() + "localeIcon.gif");
                InputDialog inputDialog = new InputDialog(null, "Language Selection", "ok", "cancel", objectArray, imageIcon);
                inputDialog.pack();
                inputDialog.center();
                inputDialog.setResizable(false);
                inputDialog.setVisible(true);
                string = inputDialog.isActionResult() ? (String)jComboBox.getSelectedItem() : "en_US";
                WriteDataFile.mainWriteDataString(string4, string.getBytes(), false);
                inputDialog.dispose();
                return string;
            }
            fileReader = new FileReader(string4);
            bufferedReader = new BufferedReader(fileReader);
            string = bufferedReader.readLine();
            if (string != null && string.length() == 5) {
                if (string.indexOf("_") != -1) return string;
            }
            string = "";
            return string;
        }
        catch (IOException iOException) {
            String string8 = "Failed to open/create ajqvue_locale.txt File.\n";
            JOptionPane.showMessageDialog(null, string8, "Alert", 0);
            string = "";
            return string;
        }
        catch (SecurityException securityException) {
            String string9 = "Failed to load language options form locale directory.\n";
            JOptionPane.showMessageDialog(null, string9, "Alert", 0);
            string = "";
            return string;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                if (Ajqvue.getDebug()) {
                    System.out.println("Utils processLocaleLanguage() Failed to Close BufferedReader. " + iOException);
                }
            }
            finally {
                block82: {
                    try {
                        if (fileReader != null) {
                            fileReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!Ajqvue.getDebug()) break block82;
                        System.out.println("Utils processLocaleLanguage() Failed to Close FileReader. " + iOException);
                    }
                }
            }
        }
    }

    public static void processTableData_To_PDFOutput(JTable jTable, HashMap<String, String> hashMap, String string, String string2) {
        if (jTable != null) {
            Thread thread = new Thread(new PDFDataTableDumpThread(jTable, hashMap, string, string2));
            thread.start();
        }
    }

    public static void setLocalTimeZone(Statement statement) {
        Calendar calendar = Calendar.getInstance();
        String string = calendar.get(15) / 3600000 + ":00";
        try {
            statement.executeUpdate("ALTER SESSION SET TIME_ZONE = '" + string + "'");
        }
        catch (SQLException sQLException) {
            ConnectionManager.displaySQLErrors(sQLException, "Utils setLocalTimeZone()");
            return;
        }
    }

    public static void setUIManagerFont(int n) {
        Object object = UIManager.get("Label.font");
        if (object == null || !(object instanceof Font)) {
            return;
        }
        Font font = (Font)object;
        if (font.getSize() == n) {
            return;
        }
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        Set set = uIDefaults.keySet();
        for (Object k : set) {
            if (k.toString().indexOf("font") == -1) continue;
            if (n > 16) {
                UIManager.put(k, new FontUIResource(font.getName(), 0, n));
                continue;
            }
            UIManager.put(k, new FontUIResource(font.getName(), font.getStyle(), n));
        }
    }

    public static String stateConvert(byte[] byArray, boolean bl) {
        if (byArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
            if (bl) {
                stringBuffer.append("");
            } else {
                stringBuffer.append("0x");
            }
            try {
                int n;
                int n2 = 1;
                while ((n = bufferedInputStream.read()) != -1) {
                    if (bl) {
                        if (n2++ <= 2) continue;
                        try {
                            String string = (char)n + "";
                            String string2 = (char)bufferedInputStream.read() + "";
                            int n3 = Integer.valueOf(string, 16) * 16;
                            int n4 = Integer.valueOf(string2, 16);
                            stringBuffer.append((char)(n3 + n4));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            String string = "Unable to Decode Input State File Format.";
                            JOptionPane.showMessageDialog(null, string, "Alert", 0);
                            bufferedInputStream.close();
                            return "";
                        }
                    }
                    String string = Integer.toString(n, 16);
                    if (string.length() < 2) {
                        string = "0" + string;
                    }
                    if (string.length() > 2) {
                        string = string.substring(string.length() - 2);
                    }
                    stringBuffer.append(string);
                }
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                String string = "I/O BufferedInputStream Failure.";
                JOptionPane.showMessageDialog(null, string, "Alert", 0);
                return "";
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public static double nDigitChop(double d, int n) {
        int n2 = n;
        String string = Double.toString(d);
        int n3 = string.indexOf(".");
        d = n3 != -1 && string.length() >= n3 + n2 + 1 ? Double.valueOf(string.substring(0, n3 + n2 + 1)).doubleValue() : Double.valueOf(string).doubleValue();
        return d;
    }

    public static void windowToFront(String string) {
        for (Window window : Arrays.asList(Window.getWindows())) {
            if (!window.getClass().getSimpleName().equals(string)) continue;
            window.toFront();
        }
    }
}

