/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.utilities;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressBar
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -3850262903856481389L;
    private AResourceBundle resourceBundle = Ajqvue.getResourceBundle();
    private JProgressBar progressBar;
    private JButton cancelButton;
    private int taskLength;
    private boolean taskCanceled;

    public ProgressBar(String string) {
        super(string);
        String string2 = Utils.getIconsDirectory() + Utils.getFileSeparator();
        ImageIcon imageIcon = this.resourceBundle.getResourceImage(string2 + "progressBarIcon.gif");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        String string3 = this.resourceBundle.getResourceString("ProgressBar.button.Cancel", "Cancel");
        this.cancelButton = new JButton(string3);
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.setFocusable(false);
        this.cancelButton.addActionListener(this);
        jPanel.add(this.cancelButton);
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        jPanel.add(this.progressBar);
        this.getContentPane().add((Component)jPanel, "Center");
        JLabel jLabel = new JLabel(imageIcon);
        this.getContentPane().add((Component)jLabel, "South");
        this.taskCanceled = false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.taskCanceled = true;
    }

    public void setCanceled(boolean bl) {
        this.taskCanceled = bl;
    }

    public void setCurrentValue(int n) {
        this.progressBar.setValue(n);
    }

    public void setTaskLength(int n) {
        this.progressBar.setIndeterminate(false);
        this.taskLength = n;
        this.progressBar.setMaximum(this.taskLength);
    }

    public boolean isCanceled() {
        return this.taskCanceled;
    }

    public void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setLocation(n, n2);
    }
}

