/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.utilities;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class InputDialog
extends JDialog
implements PropertyChangeListener {
    private static final long serialVersionUID = 4525672919728444486L;
    private JOptionPane dialogOptionPane;
    private Object[] content;
    private String confirmationString;
    private String nonConfirmationString;
    private String actionResult = "";
    private transient WindowListener inputDialogFrameListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            InputDialog.this.actionResult = "close";
            InputDialog.this.closeDialog();
        }
    };

    public InputDialog(JFrame jFrame, String string, String string2, String string3, Object[] objectArray, ImageIcon imageIcon) {
        super((Frame)jFrame, true);
        this.setTitle(string);
        this.confirmationString = !string2.equals("") ? string2 : "ok";
        this.nonConfirmationString = !string3.equals("") ? string3 : "cancel";
        this.content = (Object[])objectArray.clone();
        Object[] objectArray2 = new Object[]{this.confirmationString, this.nonConfirmationString};
        this.dialogOptionPane = new JOptionPane(objectArray, -1, 2, imageIcon, objectArray2);
        this.setContentPane(this.dialogOptionPane);
        this.setOkDefaultButton(this.dialogOptionPane);
        this.dialogOptionPane.addPropertyChangeListener(this);
        this.addWindowListener(this.inputDialogFrameListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (this.isVisible() && propertyChangeEvent.getSource() == this.dialogOptionPane && "value".equals(string)) {
            Object object = this.dialogOptionPane.getValue();
            if (object.equals(this.confirmationString)) {
                this.actionResult = "ok";
                this.closeDialog();
            }
            if (object.equals(this.nonConfirmationString)) {
                if (this.content != null) {
                    for (int i = 0; i < this.content.length; ++i) {
                        if (!(this.content[i] instanceof JTextField)) continue;
                        ((JTextField)this.content[i]).setText("");
                    }
                }
                this.actionResult = "";
                this.closeDialog();
            }
        }
        this.dialogOptionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
    }

    private void setOkDefaultButton(JComponent jComponent) {
        Component[] componentArray = jComponent.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof JButton) {
                JButton jButton = (JButton)componentArray[i];
                if (!jButton.getText().equals(this.confirmationString)) continue;
                this.getRootPane().setDefaultButton(jButton);
                continue;
            }
            if (!(componentArray[i] instanceof JComponent)) continue;
            this.setOkDefaultButton((JComponent)componentArray[i]);
        }
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    public boolean isActionResult() {
        return this.actionResult.equals("ok");
    }

    public String getActionResult() {
        return this.actionResult;
    }

    public void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setLocation(n, n2);
    }
}

