/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.utilities;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ImageUtil {
    private String lastSaveDirectory = "";
    private AResourceBundle resourceBundle;

    public ImageUtil(Component component, String string, String string2) {
        if (component == null || component.getWidth() == 0 || component.getHeight() == 0) {
            return;
        }
        this.lastSaveDirectory = string == null ? "" : string;
        this.resourceBundle = Ajqvue.getResourceBundle();
        this.saveImage(component, string2);
    }

    private void saveImage(Component component, String string) {
        Graphics2D graphics2D;
        if (component == null) {
            return;
        }
        JFileChooser jFileChooser = this.lastSaveDirectory.equals("") ? new JFileChooser() : new JFileChooser(new File(this.lastSaveDirectory));
        String string2 = this.resourceBundle.getResourceString("ImageUtil.dialogtitle.PNGImageSaveFile", "Save PNG Image File");
        jFileChooser.setDialogTitle(string2);
        jFileChooser.setFileFilter(new PNG_FileFilter());
        int n = jFileChooser.showSaveDialog(null);
        if (n == 0) {
            String string3;
            int n2;
            this.lastSaveDirectory = jFileChooser.getCurrentDirectory().toString();
            File file = jFileChooser.getSelectedFile();
            if (!file.getName().toLowerCase(Locale.ENGLISH).endsWith(".png")) {
                try {
                    File file2;
                    file = file2 = new File(file.getAbsolutePath() + ".png");
                }
                catch (SecurityException securityException) {
                    String string4 = this.resourceBundle.getResourceString("ImageUtil.dialogmessage.ImageSaveError", "Image Save Error");
                    JOptionPane.showMessageDialog(null, securityException.getMessage(), string4, 0);
                    return;
                }
            }
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(null, string3 = this.resourceBundle.getResourceString("ImageUtil.dialogmessage.OverwriteExistingFile", "Overwrite existing file?"), string2 = this.resourceBundle.getResourceString("ImageUtil.dialogtitle.ConfirmOverwrite", "Confirm Overwite"), 2, 3)) == 2) {
                return;
            }
            int n3 = component.getWidth();
            int n4 = component.getHeight();
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n3, n4, 2);
            graphics2D = bufferedImage.createGraphics();
            component.paint(graphics2D);
            try {
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
            }
            catch (Exception exception) {
                string3 = this.resourceBundle.getResourceString("ImageUtil.dialogmessage.ImageSaveError", "Image Save Error");
                JOptionPane.showMessageDialog(null, exception.getMessage(), string3, 0);
            }
        } else {
            return;
        }
        graphics2D.dispose();
    }

    public String getLastSaveDiretory() {
        return this.lastSaveDirectory;
    }

    public void setLastSaveDirectory(String string) {
        if (string != null) {
            this.lastSaveDirectory = string;
        }
    }

    public static class PNG_FileFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            return file.getName().toLowerCase(Locale.ENGLISH).endsWith(".png") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "PNG image  (*.png) ";
        }
    }
}

