/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.utilities;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.gui.forms.TableEntryForm;
import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.Date;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DateFieldCalendar
extends JFrame
implements ActionListener,
KeyListener,
MouseListener {
    private static final long serialVersionUID = -4172877510265932315L;
    private TableEntryForm callingForm;
    private Object columnName;
    private String columnType;
    private AResourceBundle resourceBundle;
    private JButton previousYearButton;
    private JButton nextYearButton;
    private JButton previousMonthButton;
    private JButton nextMonthButton;
    private JComboBox<String> monthComboBox;
    private JTextField yearTextField;
    private JLabel dateSelectionLabel;
    private JPanel centerPanel;
    private JPanel daysPanel;
    private JLabel[][] dayLabel = new JLabel[7][6];
    private Calendar calendar;
    private String timeString;
    private Object dateSelection;
    private int month;
    private int day;
    private int year;
    private int daysInMonth;
    private int firstDayOfMonth;
    private String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private JButton okButton;
    private JButton cancelButton;
    private transient WindowListener calendarFrameListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            DateFieldCalendar.this.dispose();
        }
    };

    public DateFieldCalendar(TableEntryForm tableEntryForm, Object object, String string) {
        Font font;
        this.callingForm = tableEntryForm;
        this.columnName = object;
        this.columnType = string;
        JLabel[] jLabelArray = new JLabel[7];
        String[] stringArray = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        String string2 = Utils.getIconsDirectory() + Utils.getFileSeparator();
        this.resourceBundle = Ajqvue.getResourceBundle();
        String string3 = this.resourceBundle.getResourceString("DateFieldCalendar.title.DateSelection", "Date Selection");
        this.setTitle(string3);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        if (this.getFont() != null) {
            String string4 = this.getFont().getFontName();
            int n = this.getFont().getSize();
            font = new Font(string4, 1, n);
        } else {
            font = new Font("Serif", 1, 12);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.previousYearButton = new JButton(this.resourceBundle.getResourceImage(string2 + "previousYearIcon.png"));
        this.previousYearButton.setMargin(new Insets(0, 0, 0, 0));
        this.previousYearButton.setBorder(BorderFactory.createLoweredBevelBorder());
        this.previousYearButton.setToolTipText("Previous Year");
        this.previousYearButton.addActionListener(this);
        jPanel2.add(this.previousYearButton);
        this.previousMonthButton = new JButton(this.resourceBundle.getResourceImage(string2 + "previousMonthIcon.png"));
        this.previousMonthButton.setMargin(new Insets(0, 0, 0, 0));
        this.previousMonthButton.setBorder(BorderFactory.createLoweredBevelBorder());
        this.previousMonthButton.setToolTipText("Previous Month");
        this.previousMonthButton.addActionListener(this);
        jPanel2.add(this.previousMonthButton);
        this.monthComboBox = new JComboBox<String>(this.months);
        jPanel2.add(this.monthComboBox);
        this.monthComboBox.addActionListener(this);
        this.yearTextField = new JTextField(4);
        Dimension dimension = this.monthComboBox.getPreferredSize();
        dimension.width = this.monthComboBox.getPreferredSize().width - 40;
        this.yearTextField.setPreferredSize(dimension);
        this.yearTextField.addKeyListener(this);
        jPanel2.add(this.yearTextField);
        this.nextMonthButton = new JButton(this.resourceBundle.getResourceImage(string2 + "nextMonthIcon.png"));
        this.nextMonthButton.setMargin(new Insets(0, 0, 0, 0));
        this.nextMonthButton.setBorder(BorderFactory.createRaisedBevelBorder());
        this.nextMonthButton.setToolTipText("Next Month");
        this.nextMonthButton.addActionListener(this);
        jPanel2.add(this.nextMonthButton);
        this.nextYearButton = new JButton(this.resourceBundle.getResourceImage(string2 + "nextYearIcon.png"));
        this.nextYearButton.setMargin(new Insets(0, 0, 0, 0));
        this.nextYearButton.setBorder(BorderFactory.createRaisedBevelBorder());
        this.nextYearButton.setToolTipText("Next Year");
        this.nextYearButton.addActionListener(this);
        jPanel2.add(this.nextYearButton);
        jPanel.add((Component)jPanel2, "North");
        this.centerPanel = new JPanel(new BorderLayout());
        this.createInitialCalendarDate();
        JPanel jPanel3 = new JPanel(new GridLayout(1, 7, 0, 0));
        jPanel3.setBorder(BorderFactory.createLoweredBevelBorder());
        for (int i = 0; i < stringArray.length; ++i) {
            jLabelArray[i] = new JLabel(stringArray[i], 0);
            jLabelArray[i].setFont(font);
            jLabelArray[i].setBorder(null);
            jPanel3.add(jLabelArray[i]);
        }
        this.centerPanel.add((Component)jPanel3, "North");
        this.daysPanel = new JPanel(new GridLayout(6, 7, 0, 0));
        this.daysPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.createCalendar(true);
        this.centerPanel.add((Component)this.daysPanel, "Center");
        jPanel.add((Component)this.centerPanel, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createEtchedBorder());
        string3 = this.resourceBundle.getResourceString("DateFieldCalendar.button.OK", "OK");
        this.okButton = new JButton(string3);
        this.okButton.setFocusPainted(false);
        this.okButton.setMargin(new Insets(0, 0, 0, 0));
        this.okButton.addActionListener(this);
        jPanel4.add(this.okButton);
        this.dateSelectionLabel = new JLabel(this.dateSelection + "", 0);
        this.dateSelectionLabel.setFont(font);
        this.dateSelectionLabel.setPreferredSize(this.monthComboBox.getPreferredSize());
        this.dateSelectionLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel4.add(this.dateSelectionLabel);
        string3 = this.resourceBundle.getResourceString("DateFieldCalendar.button.Cancel", "Cancel");
        this.cancelButton = new JButton(string3);
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.setMargin(new Insets(0, 0, 0, 0));
        this.cancelButton.addActionListener(this);
        jPanel4.add(this.cancelButton);
        jPanel.add((Component)jPanel4, "South");
        this.getContentPane().add(jPanel);
        this.addWindowListener(this.calendarFrameListener);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Date date;
        String string;
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            if (object == this.previousYearButton || object == this.nextYearButton) {
                try {
                    int n2 = Integer.parseInt(this.yearTextField.getText());
                    n2 = object == this.previousYearButton ? --n2 : ++n2;
                    this.yearTextField.setText(n2 + "");
                    string = this.createDateString(this.month + 1, this.day, n2);
                    this.dateSelectionLabel.setText(string);
                    date = Date.valueOf(this.formatJavaDateString(string));
                    this.calendar.setTime(date);
                    this.updateCalendarData();
                    this.createCalendar(false);
                }
                catch (NumberFormatException numberFormatException) {
                    this.showAlertDialog();
                }
            }
            if (object == this.previousMonthButton || object == this.nextMonthButton) {
                this.monthComboBox.removeActionListener(this);
                n = this.monthComboBox.getSelectedIndex();
                if (object == this.previousMonthButton) {
                    if (n == 0) {
                        this.monthComboBox.setSelectedIndex(this.months.length - 1);
                    } else {
                        this.monthComboBox.setSelectedIndex(n - 1);
                    }
                } else if (n == this.months.length - 1) {
                    this.monthComboBox.setSelectedIndex(0);
                } else {
                    this.monthComboBox.setSelectedIndex(n + 1);
                }
                n = this.monthComboBox.getSelectedIndex();
                string = this.createDateString(n + 1, this.day, this.year);
                this.dateSelectionLabel.setText(string);
                date = Date.valueOf(this.formatJavaDateString(string));
                this.calendar.setTime(date);
                this.updateCalendarData();
                this.createCalendar(false);
                this.monthComboBox.addActionListener(this);
            }
            if (object == this.okButton) {
                this.dateSelection = this.dateSelectionLabel.getText() + this.timeString;
                String string2 = Utils.convertViewDateString_To_DBDateString(this.dateSelectionLabel.getText(), "MM-dd-yyyy");
                string2 = Utils.convertDBDateString_To_ViewDateString(string2 + "", DBTablesPanel.getGeneralDBProperties().getViewDateFormat());
                string2 = string2 + this.timeString;
                this.callingForm.setFormField(this.columnName, (Object)string2);
                this.dispose();
            } else if (object == this.cancelButton) {
                this.dispose();
            }
        }
        if (object instanceof JComboBox && object == this.monthComboBox && this.dateSelectionLabel != null) {
            n = this.monthComboBox.getSelectedIndex();
            string = this.createDateString(n + 1, this.day, this.year);
            this.dateSelectionLabel.setText(string);
            date = Date.valueOf(this.formatJavaDateString(string));
            this.calendar.setTime(date);
            this.updateCalendarData();
            this.createCalendar(false);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\n') {
            try {
                int n = Integer.parseInt(this.yearTextField.getText());
                String string = this.createDateString(this.month + 1, this.day, n);
                this.dateSelectionLabel.setText(string);
                try {
                    Date date = Date.valueOf(this.formatJavaDateString(string));
                    this.calendar.setTime(date);
                    this.updateCalendarData();
                    this.createCalendar(false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Integer.parseInt("error");
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.showAlertDialog();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof JLabel && !((JLabel)object).getText().equals(" ")) {
            this.day = Integer.parseInt(((JLabel)object).getText());
            String string = this.createDateString(this.month + 1, this.day, this.year);
            this.dateSelectionLabel.setText(string);
            Date date = Date.valueOf(this.formatJavaDateString(string));
            this.calendar.setTime(date);
            for (int i = 0; i < this.dayLabel.length; ++i) {
                for (int j = 0; j < this.dayLabel[0].length; ++j) {
                    this.dayLabel[i][j].setBorder(null);
                }
            }
            ((JLabel)object).setBorder(BorderFactory.createEtchedBorder());
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void createInitialCalendarDate() {
        this.calendar = Calendar.getInstance();
        String string = this.callingForm.getFormField((String)this.columnName);
        String string2 = "";
        this.timeString = "";
        try {
            if (this.columnType.equals("DATE")) {
                if (string.length() < 10 || string.length() >= 12) {
                    Date.valueOf("error");
                } else {
                    string2 = Utils.convertViewDateString_To_DBDateString(string, DBTablesPanel.getGeneralDBProperties().getViewDateFormat());
                    Date date = Date.valueOf(string2);
                    string2 = Utils.convertDBDateString_To_ViewDateString(string2, "MM-dd-yyyy");
                    this.timeString = "";
                    this.calendar.setTime(date);
                }
            } else if (string.indexOf(" ") == -1 || string.length() < 10) {
                Date.valueOf("error");
            } else {
                string2 = string.substring(0, string.indexOf(" "));
                string2 = Utils.convertViewDateString_To_DBDateString(string2, DBTablesPanel.getGeneralDBProperties().getViewDateFormat());
                this.timeString = string.substring(string.indexOf(" "));
                this.timeString = this.timeString.trim();
                if (this.timeString.length() > 8) {
                    this.timeString = this.timeString.substring(0, 8);
                }
                this.timeString = " " + this.timeString;
                Date date = Date.valueOf(string2);
                string2 = Utils.convertDBDateString_To_ViewDateString(string2, "MM-dd-yyyy");
                this.calendar.setTime(date);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string2 = this.createDateString(this.calendar.get(2) + 1, this.calendar.get(5), this.calendar.get(1));
            if (this.columnType.equals("DATE")) {
                this.timeString = "";
            }
            this.timeString = this.calendar.get(10) < 10 ? "0" + this.calendar.get(10) + ":" : this.calendar.get(10) + ":";
            this.timeString = this.calendar.get(12) < 10 ? this.timeString + "0" + this.calendar.get(12) + ":" : this.timeString + this.calendar.get(12) + ":";
            this.timeString = this.calendar.get(13) < 10 ? this.timeString + "0" + this.calendar.get(13) : " " + this.timeString + this.calendar.get(13);
        }
        this.dateSelection = string2;
        this.updateCalendarData();
    }

    private String formatJavaDateString(String string) {
        String string2 = string.trim();
        int n = string2.indexOf("-");
        int n2 = string2.lastIndexOf("-");
        if (n2 != -1 && n >= 1 && n <= 2 && n2 - n >= 1 && n2 - n <= 3) {
            String string3 = string2.substring(string2.lastIndexOf("-") + 1);
            String string4 = string2.substring(0, string2.lastIndexOf("-"));
            return string3 + "-" + string4;
        }
        return "";
    }

    private String createDateString(int n, int n2, int n3) {
        String string = "";
        string = n < 10 ? "0" + n + "-" : n + "-";
        string = n2 < 10 ? string + "0" + n2 + "-" : string + n2 + "-";
        string = string + n3;
        return string;
    }

    private void createCalendar(boolean bl) {
        int n = 1;
        for (int i = 0; i < this.dayLabel.length; ++i) {
            for (int j = 0; j < this.dayLabel[0].length; ++j) {
                int n2 = n - this.firstDayOfMonth + 1;
                if (bl) {
                    this.dayLabel[i][j] = new JLabel();
                }
                if (n < this.firstDayOfMonth || n2 > this.daysInMonth) {
                    this.dayLabel[i][j].setText(" ");
                    this.dayLabel[i][j].removeMouseListener(this);
                } else {
                    this.dayLabel[i][j].setText(n2 + "");
                    this.dayLabel[i][j].addMouseListener(this);
                }
                if (n2 == this.day) {
                    this.dayLabel[i][j].setBorder(BorderFactory.createEtchedBorder());
                } else {
                    this.dayLabel[i][j].setBorder(null);
                }
                if (bl) {
                    this.dayLabel[i][j].setHorizontalAlignment(0);
                    this.dayLabel[i][j].setBackground(new Color(0, 255, 0));
                    this.daysPanel.add(this.dayLabel[i][j]);
                }
                ++n;
            }
        }
    }

    private void updateCalendarData() {
        this.year = this.calendar.get(1);
        this.month = this.calendar.get(2);
        this.day = this.calendar.get(5);
        this.daysInMonth = this.calendar.getActualMaximum(5);
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.year, this.month, 1);
        this.firstDayOfMonth = calendar.get(7);
        this.monthComboBox.setSelectedIndex(this.month);
        this.yearTextField.setText(this.year + "");
    }

    private void showAlertDialog() {
        String string = this.resourceBundle.getResourceString("DateFieldCalendar.dialogtitle.Alert", "Alert");
        String string2 = this.resourceBundle.getResourceString("DateFieldCalendar.dialogmessage.InvalidYear", "Invalid Input for Year");
        JOptionPane.showMessageDialog(null, string2 + " ", string, 0);
    }

    public void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.setLocation(n, n2);
    }
}

