/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.utilities;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javafx.scene.image.Image;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class AResourceBundle
implements Serializable {
    private static final long serialVersionUID = -4607428315735688372L;
    private String className = this.getClass().getSimpleName();
    private URL resourceURL;
    private String resourceType;
    private String cacheDirectory = Utils.getCacheDirectory();
    private String cachedJAR_FileName;
    private HashMap<String, String> localeListData;
    private HashMap<String, ImageIcon> imagesData;
    boolean debugMode;
    boolean cacheJar;
    private static final String FILE_RESOURCE = "file";
    private static final String HTTP_RESOURCE = "http";
    private static final String JAR_RESOUCE = "jar";

    public AResourceBundle(String string) {
        this(string, false, true);
    }

    public AResourceBundle(String string, boolean bl) {
        this(string, bl, true);
    }

    public AResourceBundle(String string, boolean bl, boolean bl2) {
        this.debugMode = bl;
        this.cacheJar = false;
        if (string == null || string.equals("")) {
            return;
        }
        try {
            if (string.endsWith(".jar") && string.indexOf(":") != -1) {
                this.resourceURL = new URL("jar:" + string + "!/");
                if (this.cacheJar && this.resourceURL.toExternalForm().indexOf("jar:file:") == -1) {
                    this.cachedJAR_FileName = this.cacheDirectory + Long.toString(System.currentTimeMillis()).substring(0, 10);
                    try {
                        this.cacheJar = this.cacheJAR(string);
                    }
                    catch (IOException iOException) {
                        if (bl) {
                            System.out.println(this.className + " Constructor()\nFailed to Close Cache Stream.\n" + iOException.toString());
                        }
                    }
                }
            } else {
                this.resourceURL = new URL(string);
                this.cacheJar = false;
            }
            this.resourceType = this.resourceURL.getProtocol();
        }
        catch (MalformedURLException malformedURLException) {
            this.displayErrors(this.className + " Constructor() \nFailed to create locale resouce URL from, " + string + "\n" + malformedURLException.toString());
            return;
        }
        this.localeListData = new HashMap();
    }

    public String getResourceString(String string, String string2) {
        if (this.localeListData != null && string != null) {
            if (this.localeListData.containsKey(string)) {
                return this.localeListData.get(string);
            }
            if (!this.localeListData.isEmpty() && this.debugMode) {
                System.out.println(this.className + " getResourceString()\nInvalid Resource Key: " + string);
            }
            return this.getDefaultResourceString(string2);
        }
        if (this.debugMode) {
            System.out.println(this.className + " getResourceString()\nEither Undefined Locale or Resource Key.");
        }
        return this.getDefaultResourceString(string2);
    }

    private String getDefaultResourceString(String string) {
        if (string != null) {
            return string;
        }
        if (this.debugMode) {
            System.out.println(this.className + " getDefaultResourceString()\nUndefined Resource Default Value.");
        }
        return "";
    }

    public ImageIcon getResourceImage(String string) {
        URL uRL = null;
        if (this.resourceURL != null && string != null) {
            try {
                if (this.resourceType.equals(FILE_RESOURCE) || this.resourceType.equals(HTTP_RESOURCE)) {
                    uRL = new URL(this.resourceURL.toExternalForm() + string);
                    ImageIcon imageIcon = new ImageIcon(uRL);
                    if (this.debugMode && (imageIcon.getIconWidth() == -1 || imageIcon.getIconHeight() == -1)) {
                        System.out.println(this.className + " getResourceImage()\nFailed to find image file: " + uRL.getFile() + "\n");
                    }
                    return imageIcon;
                }
                if (this.resourceType.equals(JAR_RESOUCE)) {
                    if (this.cacheJar && this.resourceURL.toExternalForm().indexOf("jar:file:") == -1) {
                        return new ImageIcon(this.getJAR_Resource(string, new URL("jar:file:" + this.cachedJAR_FileName + "!/")));
                    }
                    return new ImageIcon(this.getJAR_Resource(string, this.resourceURL));
                }
                this.displayErrors(this.className + " getResourceImage() \nFailed to identity URL protocol in order to process, , " + this.resourceURL.getProtocol());
                return new ImageIcon(new byte[0]);
            }
            catch (MalformedURLException malformedURLException) {
                if (this.debugMode) {
                    System.out.println(this.className + " getResourceImage()\nFailed to Create Image URL.\n" + malformedURLException.toString());
                }
                return new ImageIcon(new byte[0]);
            }
            catch (IOException iOException) {
                if (this.debugMode) {
                    System.out.println(this.className + " getResourceImage()\nFailed to close resources or create cache URL.\n" + iOException.toString());
                }
                return new ImageIcon(new byte[0]);
            }
        }
        if (this.debugMode) {
            System.out.println(this.className + " getResourceImage()\nEither Undefined resourceURL or image file.");
        }
        return new ImageIcon(new byte[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getResourceFXImage(String string) {
        URL uRL = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.resourceURL != null && string != null) {
            try {
                if (this.resourceType.equals(FILE_RESOURCE) || this.resourceType.equals(HTTP_RESOURCE)) {
                    uRL = new URL(this.resourceURL.toExternalForm() + string);
                    Image image = new Image(this.resourceURL.toExternalForm() + string);
                    if (this.debugMode && (image.getWidth() == -1.0 || image.getHeight() == -1.0)) {
                        System.out.println(this.className + " getResourceFXImage()\nFailed to find image file: " + uRL.getFile() + "\n");
                    }
                    Image image2 = image;
                    return image2;
                }
                if (this.resourceType.equals(JAR_RESOUCE)) {
                    if (this.cacheJar && this.resourceURL.toExternalForm().indexOf("jar:file:") == -1) {
                        byteArrayInputStream = new ByteArrayInputStream(this.getJAR_Resource(string, new URL("jar:file:" + this.cachedJAR_FileName + "!/")));
                        Image image = new Image((InputStream)byteArrayInputStream);
                        return image;
                    }
                    byteArrayInputStream = new ByteArrayInputStream(this.getJAR_Resource(string, this.resourceURL));
                    Image image = new Image((InputStream)byteArrayInputStream);
                    return image;
                }
                this.displayErrors(this.className + " getResourceFXImage() \nFailed to identity URL protocol in order to process, , " + this.resourceURL.getProtocol());
                Image image = null;
                return image;
            }
            catch (MalformedURLException malformedURLException) {
                if (this.debugMode) {
                    System.out.println(this.className + " getResourceFXImage()\nFailed to Create Image URL.\n" + malformedURLException.toString());
                }
                Image image = null;
                return image;
            }
            catch (IOException iOException) {
                if (this.debugMode) {
                    System.out.println(this.className + " getResourceImage()\nFailed to close resources or create cache URL.\n" + iOException.toString());
                }
                Image image = null;
                return image;
            }
            finally {
                block33: {
                    try {
                        if (byteArrayInputStream != null) {
                            byteArrayInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!this.debugMode) break block33;
                        System.out.println(this.className + " getResourceImage()\nFailed to close resource.\n" + iOException.toString());
                    }
                }
            }
        }
        if (this.debugMode) {
            System.out.println(this.className + " getResourceFXImage()\nEither Undefined resourceURL or image file.");
        }
        return null;
    }

    public File getResourceFile(String string) {
        URL uRL = null;
        if (this.resourceURL != null && string != null) {
            if (this.resourceType.equals(FILE_RESOURCE)) {
                File file;
                try {
                    uRL = new URL(this.resourceURL.toExternalForm() + string);
                    file = new File(uRL.getFile());
                }
                catch (MalformedURLException malformedURLException) {
                    this.displayErrors(this.className + " getResourceFile() \nFailed to identity URL protocol in order to process, , " + this.resourceURL.toExternalForm() + string);
                    return null;
                }
                return file;
            }
            if (this.resourceType.equals(HTTP_RESOURCE) || this.resourceType.equals(JAR_RESOUCE)) {
                JOptionPane.showMessageDialog(null, this.className + " getResourceFile() Only Supports\nLocal File Resources!", "Alert", 0);
                return null;
            }
            this.displayErrors(this.className + " getResourceFile() \nFailed to identity URL protocol in order to process, , " + this.resourceURL.getProtocol());
            return null;
        }
        if (this.debugMode) {
            System.out.println(this.className + " getResourceImage()\nEither Undefined resourceURL or image file.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getResourceBytes(String string) {
        URL uRL = null;
        if (this.resourceURL != null && string != null) {
            try {
                if (this.resourceType.equals(FILE_RESOURCE) || this.resourceType.equals(HTTP_RESOURCE)) {
                    uRL = new URL(this.resourceURL.toExternalForm() + string);
                    InputStream inputStream = null;
                    BufferedInputStream bufferedInputStream = null;
                    try {
                        if (this.resourceType.equals(FILE_RESOURCE)) {
                            inputStream = new FileInputStream(new File(this.resourceURL.toExternalForm() + string));
                        } else {
                            URLConnection uRLConnection = uRL.openConnection();
                            inputStream = uRLConnection.getInputStream();
                        }
                        bufferedInputStream = new BufferedInputStream(inputStream);
                        int n = bufferedInputStream.available();
                        byte[] byArray = new byte[n];
                        int n2 = 0;
                        while (n2 < n) {
                            byArray[n2++] = (byte)bufferedInputStream.read();
                        }
                        byte[] byArray2 = byArray;
                        return byArray2;
                    }
                    catch (IOException iOException) {
                        if (Ajqvue.getDebug()) {
                            System.out.println(this.className + " getResourceBytes() \nError Reading Resource. " + iOException.toString());
                        }
                        byte[] byArray = new byte[]{};
                        return byArray;
                    }
                    finally {
                        try {
                            if (bufferedInputStream != null) {
                                bufferedInputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            if (Ajqvue.getDebug()) {
                                System.out.println(this.className + " getResourceBytes() \nFailed to Close BufferedInputStream. " + iOException.toString());
                            }
                        }
                        finally {
                            block50: {
                                try {
                                    if (inputStream != null) {
                                        inputStream.close();
                                    }
                                }
                                catch (IOException iOException) {
                                    if (!Ajqvue.getDebug()) break block50;
                                    System.out.println("WriteDataFile writeDataFileText() \nFailed to Close FileOutputStream. " + iOException.toString());
                                }
                            }
                        }
                    }
                }
                if (this.resourceType.equals(JAR_RESOUCE)) {
                    if (!this.cacheJar) return this.getJAR_Resource(string, this.resourceURL);
                    if (this.resourceURL.toExternalForm().indexOf("jar:file:") != -1) return this.getJAR_Resource(string, this.resourceURL);
                    return this.getJAR_Resource(string, new URL("jar:file:" + this.cachedJAR_FileName + "!/"));
                }
                this.displayErrors(this.className + " getResourceBytes() \nFailed to identity URL protocol in order to process, , " + this.resourceURL.getProtocol());
                return new byte[0];
            }
            catch (MalformedURLException malformedURLException) {
                if (!this.debugMode) return new byte[0];
                System.out.println(this.className + " getResourceBytes()\nFailed to Create Resource URL.\n" + malformedURLException.toString());
                return new byte[0];
            }
            catch (IOException iOException) {
                if (!this.debugMode) return new byte[0];
                System.out.println(this.className + " getResourceBytes()\nFailed to close resources or create cache URL.\n" + iOException.toString());
                return new byte[0];
            }
        }
        if (!this.debugMode) return new byte[0];
        System.out.println(this.className + " getResourceBytes()\nEither Undefined resourceURL or resource name.");
        return new byte[0];
    }

    public ImageIcon getImage(String string) {
        if (this.imagesData != null && this.imagesData.containsKey(string)) {
            return this.imagesData.get(string);
        }
        if (this.debugMode) {
            System.out.println(this.className + " getImage()\nFailed to find image key: " + string);
        }
        return null;
    }

    public void setLocaleResource(String string, String string2, String string3) {
        if (this.resourceURL == null || string2 == null || string3 == null) {
            return;
        }
        String string4 = string + string2 + "_" + string3 + ".properties";
        try {
            if (this.resourceType.equals(FILE_RESOURCE)) {
                this.createFile_LocaleResource(this.resourceURL.toExternalForm().substring(this.resourceURL.toExternalForm().indexOf("file:") + 5) + string4);
            } else if (this.resourceType.equals(HTTP_RESOURCE)) {
                this.createHttp_LocaleResource(new URL(this.resourceURL.toExternalForm() + string4));
            } else if (this.resourceType.equals(JAR_RESOUCE)) {
                this.createJAR_LocaleResource(string4);
            } else {
                this.displayErrors(this.className + " setLocaleResource() \nFailed to identity URL protocol in order to process, , " + this.resourceURL.getProtocol());
            }
        }
        catch (IOException iOException) {
            this.displayErrors(this.className + " setLocaleResource() \nFailed to close " + this.resourceType + " in process.\n" + iOException.toString());
        }
    }

    public void setImage(String string, String string2) {
        if (this.imagesData == null) {
            this.imagesData = new HashMap();
        }
        this.imagesData.put(string, this.getResourceImage(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile_LocaleResource(String string) throws IOException {
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(string);
            this.readLocaleResource(fileInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHttp_LocaleResource(URL uRL) throws IOException {
        try (InputStream inputStream = null;){
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.connect();
            inputStream = httpURLConnection.getInputStream();
            this.readLocaleResource(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJAR_LocaleResource(String string) throws IOException {
        ZipFile zipFile = null;
        InputStream inputStream = null;
        try {
            JarURLConnection jarURLConnection;
            Object object;
            if (this.cacheJar && this.resourceURL.toExternalForm().indexOf("jar:file:") == -1) {
                object = new URL("jar:file:" + this.cachedJAR_FileName + "!/");
                jarURLConnection = (JarURLConnection)((URL)object).openConnection();
            } else {
                jarURLConnection = (JarURLConnection)this.resourceURL.openConnection();
            }
            zipFile = jarURLConnection.getJarFile();
            ZipEntry zipEntry = ((JarFile)zipFile).getEntry(string);
            if (zipEntry == null) {
                object = ((JarFile)zipFile).entries();
                while (object.hasMoreElements() && !(zipEntry = (ZipEntry)object.nextElement()).getName().endsWith(string)) {
                    zipEntry = null;
                }
            }
            if (zipEntry != null) {
                inputStream = ((JarFile)zipFile).getInputStream(zipEntry);
                this.readLocaleResource(inputStream);
            } else {
                this.displayErrors(this.className + " createJAR_LocaleResource() \nFailed to find the given locale file in JAR.\n" + string);
            }
        }
        catch (IOException iOException) {
            this.displayErrors(this.className + " createJAR_LocaleResource() \nFailed to process the given locale file, " + string + "\n" + iOException.toString());
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLocaleResource(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            inputStreamReader = new InputStreamReader(inputStream, "UTF-16");
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).indexOf("=") == -1) continue;
                String string2 = string.substring(0, string.indexOf("=")).trim();
                String string3 = string.substring(string.indexOf("=") + 1).trim();
                this.localeListData.put(string2, string3);
            }
            bufferedReader.close();
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            this.displayErrors(this.className + " readLocaleResource() \nFailed to process the given locale file, " + this.resourceURL.toExternalForm() + "\n" + iOException.toString());
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getJAR_Resource(String string, URL uRL) throws IOException {
        int n;
        int n2;
        int n3;
        JarFile jarFile = null;
        InputStream inputStream = null;
        byte[] byArray = null;
        try {
            Object object;
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            jarFile = jarURLConnection.getJarFile();
            ZipEntry zipEntry = jarFile.getEntry(string);
            if (zipEntry == null) {
                object = jarFile.entries();
                while (object.hasMoreElements() && !(zipEntry = (ZipEntry)object.nextElement()).getName().equals(string)) {
                    zipEntry = null;
                }
            }
            if (zipEntry != null) {
                inputStream = jarFile.getInputStream(zipEntry);
                n3 = (int)zipEntry.getSize();
                if (n3 == -1) {
                    if (this.debugMode) {
                        System.out.println(this.className + " getJAR_Resource()\nFailed to Determine Resource Size: " + string);
                    }
                    object = new byte[0];
                    return object;
                }
            } else {
                if (this.debugMode) {
                    System.out.println(this.className + " getJAR_Resource()\nResource Entry Not Found: " + string);
                }
                object = new byte[0];
                return object;
            }
            byArray = new byte[n3];
            n2 = 0;
            n = 0;
        }
        catch (IOException iOException) {
            if (this.debugMode) {
                System.out.println(this.className + " getJAR_Resource()\nFailed Processing of Resource from Jar: " + string);
            }
            byte[] byArray2 = new byte[]{};
            return byArray2;
        }
        finally {
            String string2 = "";
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                string2 = iOException.toString();
            }
            finally {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            if (!string2.isEmpty()) {
                throw new IOException(string2);
            }
        }
        while (n3 - n2 > 0) {
            n = inputStream.read(byArray, n2, n3 - n2);
            if (n == -1) break;
            n2 += n;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean cacheJAR(String string) throws IOException {
        boolean bl = false;
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        FileOutputStream fileOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            int n;
            inputStream = new URL(string).openStream();
            bufferedInputStream = new BufferedInputStream(inputStream);
            File file = new File(this.cacheDirectory);
            if (!file.isDirectory() && !file.mkdir() && this.debugMode) {
                System.out.println(this.className + " cacheJAR()\nFailed to create Cache Directory");
                boolean bl2 = bl;
                return bl2;
            }
            fileOutputStream = new FileOutputStream(this.cachedJAR_FileName);
            filterOutputStream = new BufferedOutputStream(fileOutputStream);
            while ((n = bufferedInputStream.read()) != -1) {
                ((BufferedOutputStream)filterOutputStream).write(n);
            }
            ((BufferedOutputStream)filterOutputStream).flush();
            bl = true;
            return bl;
        }
        catch (IOException iOException) {
            if (!this.debugMode) return bl;
            System.out.println(this.className + " cacheJAR()\nFailed to Cache JAR.\n" + iOException.toString());
            return bl;
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {
                if (this.debugMode) {
                    System.out.println(this.className + " cacheJAR() Failed to Close fileOutputBuffer.\n" + iOException.toString());
                }
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    if (this.debugMode) {
                        System.out.println(this.className + " cacheJAR() Failed to Close fileOutputStream.\n" + iOException.toString());
                    }
                }
                finally {
                    try {
                        if (bufferedInputStream != null) {
                            bufferedInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (this.debugMode) {
                            System.out.println(this.className + " cacheJAR() Failed to Close inputBuffer.\n" + iOException.toString());
                        }
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
            }
        }
    }

    private void displayErrors(String string) {
        JOptionPane.showMessageDialog(null, string, "Alert", 0);
    }
}

