/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.structures;

import java.util.prefs.Preferences;

public class DataImportProperties {
    private boolean identityInsert = false;
    private String dataDelimiter = ",";
    private String dateFormat = "MM-dd-yyyy";
    private Preferences dataImportPreferences;
    private static final String IDENTITYINSERT = "ImportIdentityInsert";
    private static final String DATADELIMITER = "ImportDataDelimiter";
    private static final String DATEFORMAT = "ImportDateFormat";

    public DataImportProperties() {
        try {
            this.dataImportPreferences = Preferences.userNodeForPackage(DataImportProperties.class);
        }
        catch (SecurityException securityException) {
            return;
        }
        try {
            this.identityInsert = this.dataImportPreferences.getBoolean(IDENTITYINSERT, this.identityInsert);
            this.dataDelimiter = this.dataImportPreferences.get(DATADELIMITER, this.dataDelimiter);
            this.dateFormat = this.dataImportPreferences.get(DATEFORMAT, this.dateFormat);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public boolean getIdentityInsert() {
        return this.identityInsert;
    }

    public String getDataDelimiter() {
        return this.dataDelimiter;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setIdentityInsert(boolean bl) {
        this.identityInsert = bl;
        this.savePreference(IDENTITYINSERT, bl);
    }

    public void setDataDelimiter(String string) {
        this.dataDelimiter = string;
        this.savePreference(DATADELIMITER, string);
    }

    public void setDateFormat(String string) {
        this.dateFormat = string;
        this.savePreference(DATEFORMAT, string);
    }

    private void savePreference(String string, boolean bl) {
        try {
            if (this.dataImportPreferences != null) {
                this.dataImportPreferences.putBoolean(string, bl);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void savePreference(String string, String string2) {
        try {
            if (this.dataImportPreferences != null) {
                this.dataImportPreferences.put(string, string2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[DataImportProperties: ");
        stringBuffer.append("[identityInsert = " + this.identityInsert + "]");
        stringBuffer.append("[dataDelimiter = " + this.dataDelimiter + "]");
        stringBuffer.append("[dataFormat = " + this.dateFormat + "]");
        return stringBuffer.toString();
    }
}

