/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.plugin;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.InputDialog;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class RepositoryAccess {
    private InputDialog accessDialog;
    private JTextField userTextField;
    private JPasswordField passwordField;
    private String user;
    private char[] password;
    private int loginAttempts;
    private String resourceTitle;
    private String resourceOK;
    private String resourceCancel;
    private String resourceUser;
    private String resourcePassword;
    private AResourceBundle resourceBundle = Ajqvue.getResourceBundle();
    private static final int LOGIN_RETRYS = 3;

    protected RepositoryAccess(boolean bl) {
        this.resourceTitle = this.resourceBundle.getResourceString("RepositoryAccess.dialogtitle.Login", "Login");
        this.resourceUser = this.resourceBundle.getResourceString("RepositoryAccess.label.User", "User");
        this.resourcePassword = this.resourceBundle.getResourceString("RepositoryAccess.label.Password", "Password");
        this.resourceOK = this.resourceBundle.getResourceString("RepositoryAccess.dialogbutton.OK", "OK");
        this.resourceCancel = this.resourceBundle.getResourceString("RepositoryAccess.dialogbutton.Cancel", "Cancel");
        this.loginAttempts = bl ? 0 : 2;
    }

    protected boolean promptUserPassword() {
        boolean bl = false;
        if (this.loginAttempts >= 3) {
            return bl;
        }
        if (this.accessDialog == null) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(4, 1, 100, 0));
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(4, 4, 12, 4)));
            JLabel jLabel = new JLabel(this.resourceUser, 2);
            jPanel.add(jLabel);
            this.userTextField = new JTextField(20);
            this.userTextField.setBorder(BorderFactory.createLoweredBevelBorder());
            jPanel.add(this.userTextField);
            JLabel jLabel2 = new JLabel(this.resourcePassword, 2);
            jPanel.add(jLabel2);
            this.passwordField = new JPasswordField(20);
            this.passwordField.setBorder(BorderFactory.createLoweredBevelBorder());
            jPanel.add(this.passwordField);
            Object[] objectArray = new Object[]{jPanel};
            this.accessDialog = new InputDialog(null, this.resourceTitle, this.resourceOK, this.resourceCancel, objectArray, null);
        }
        this.accessDialog.pack();
        this.accessDialog.center();
        this.accessDialog.setVisible(true);
        if (this.accessDialog.isActionResult()) {
            this.user = this.userTextField.getText();
            this.password = this.passwordField.getPassword();
            bl = !this.user.isEmpty() && this.password.length != 0;
            ++this.loginAttempts;
        }
        if (this.loginAttempts >= 3) {
            this.accessDialog.dispose();
        }
        return bl;
    }

    protected boolean loginAttemptsExceeded() {
        return this.loginAttempts >= 3;
    }

    protected String getUser() {
        return this.user;
    }

    protected String getPassword() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.password.length; ++i) {
            stringBuffer.append(this.password[i]);
            this.password[i] = 48;
        }
        return stringBuffer.toString();
    }
}

