/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.io;

import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.io.SQLDump;
import com.dandymadeproductions.ajqvue.io.WriteDataFile;
import com.dandymadeproductions.ajqvue.utilities.ProgressBar;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import com.dandymadeproductions.ajqvue.utilities.db.TableDefinitionGenerator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;

public class SQLDatabaseSchemeDumpThread
extends SQLDump
implements Runnable {
    private ProgressBar databaseDumpProgressBar;

    public SQLDatabaseSchemeDumpThread(String string) {
        this.fileName = string;
    }

    @Override
    public void run() {
        Connection connection = ConnectionManager.getConnection("DatabaseSchemeDumpThread run()");
        if (connection == null) {
            return;
        }
        this.databaseDumpProgressBar = new ProgressBar("SQL Database Scheme Dump");
        String string = this.generateHeaders();
        this.databaseDumpProgressBar.setTaskLength(ConnectionManager.getTableNames().size());
        this.databaseDumpProgressBar.pack();
        this.databaseDumpProgressBar.center();
        this.databaseDumpProgressBar.setVisible(true);
        int n = 0;
        Iterator<String> iterator = ConnectionManager.getTableNames().iterator();
        while (iterator.hasNext() && !this.databaseDumpProgressBar.isCanceled()) {
            this.databaseDumpProgressBar.setCurrentValue(n + 1);
            String string2 = Utils.getSchemaTableName(iterator.next());
            string = string + this.genCommentSep("Table structure for table " + string2);
            string = string + new TableDefinitionGenerator(connection, string2).getTableDefinition();
            ++n;
        }
        if (!this.databaseDumpProgressBar.isCanceled()) {
            WriteDataFile.mainWriteDataString(this.fileName, string.getBytes(), false);
        }
        this.databaseDumpProgressBar.dispose();
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            ConnectionManager.closeConnection(connection, "DatabaseSchemeDumpThread run()");
        }
        ConnectionManager.closeConnection(connection, "DatabaseSchemeDumpThread run()");
    }
}

