/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.io;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.gui.Main_Frame;
import com.dandymadeproductions.ajqvue.gui.Main_JMenuBar;
import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.TableTabPanel;
import com.dandymadeproductions.ajqvue.utilities.ProgressBar;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class SQLDataDumpImportThread
implements Runnable {
    private String fileName;
    private String dataSourceType;
    private boolean validImport;
    private boolean reloadDatabase;

    public SQLDataDumpImportThread(String string, boolean bl) {
        this.fileName = string;
        this.reloadDatabase = bl;
        this.dataSourceType = ConnectionManager.getDataSourceType();
    }

    @Override
    public void run() {
        File file = new File(this.fileName);
        if (file.exists()) {
            this.importSQLFile();
            if (this.validImport) {
                if (this.reloadDatabase) {
                    ConnectionManager.setSchemaPattern(ConnectionManager.getAllSchemasPattern());
                    Main_Frame.reloadDBTables();
                    Main_JMenuBar.reloadSchemasMenu();
                    Main_Frame.reloadDBTables();
                } else {
                    this.refreshTableTabPanel();
                }
            }
        } else {
            String string = "The file '" + this.fileName + "' does not exists.";
            JOptionPane.showMessageDialog(null, string, this.fileName, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importSQLFile() {
        Connection connection = ConnectionManager.getConnection("SQLDataDumpImportThread importSQLFile()");
        if (connection == null) {
            this.validImport = false;
            return;
        }
        ProgressBar progressBar = new ProgressBar("SQL Import");
        String string = "";
        int n = 0;
        int n2 = 0;
        int n3 = DBTablesPanel.getGeneralDBProperties().getBatchSize();
        boolean bl = DBTablesPanel.getGeneralDBProperties().getBatchSizeEnabled();
        boolean bl2 = this.dataSourceType.equals("sqlserver") && DBTablesPanel.getSelectedTableTabPanel() != null ? DBTablesPanel.getDataImportProperties().getIdentityInsert() : false;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        Statement statement = null;
        try {
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            if (bl2) {
                statement.executeUpdate("SET IDENTITY_INSERT " + DBTablesPanel.getSelectedTableTabPanel().getTableName() + " ON");
            }
            if (this.dataSourceType.equals("mysql") || this.dataSourceType.equals("mariadb") || this.dataSourceType.equals("postgresql")) {
                statement.executeUpdate("BEGIN");
            }
            try {
                String string2;
                inputStreamReader = new FileReader(this.fileName);
                bufferedReader = new BufferedReader(inputStreamReader);
                while ((string2 = bufferedReader.readLine()) != null) {
                    ++n;
                }
                progressBar.setTaskLength(n);
                progressBar.pack();
                progressBar.center();
                progressBar.setVisible(true);
                this.validImport = true;
                bufferedReader.close();
                inputStreamReader = new FileReader(this.fileName);
                bufferedReader = new BufferedReader(inputStreamReader);
                n2 = 1;
                int n4 = 0;
                StringBuffer stringBuffer = new StringBuffer();
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (progressBar.isCanceled()) {
                        this.validImport = false;
                        break;
                    }
                    if (!string2.isEmpty()) {
                        if (string2.length() >= 2 && (string2.startsWith("--") || string2.startsWith("/*") || string2.startsWith("*") || string2.startsWith("*/"))) {
                            progressBar.setCurrentValue(n2++);
                            continue;
                        }
                        if (string2.endsWith(";")) {
                            stringBuffer.append(string2.substring(0, string2.length() - 1));
                            string = stringBuffer.length() > 50 ? stringBuffer.substring(0, 50) : stringBuffer.toString();
                            statement.addBatch(stringBuffer.toString());
                            stringBuffer.delete(0, stringBuffer.length());
                            if (bl) {
                                if (n4 > n3) {
                                    statement.executeBatch();
                                    connection.commit();
                                    n4 = 0;
                                } else {
                                    ++n4;
                                }
                            }
                        } else {
                            stringBuffer.append(string2);
                        }
                    }
                    progressBar.setCurrentValue(n2++);
                }
                progressBar.dispose();
                if (this.validImport) {
                    statement.executeBatch();
                    connection.commit();
                } else {
                    connection.rollback();
                }
                if (bl2) {
                    statement.executeUpdate("SET IDENTITY_INSERT " + DBTablesPanel.getSelectedTableTabPanel().getTableName() + " OFF");
                }
                connection.setAutoCommit(true);
            }
            catch (IOException iOException) {
                progressBar.dispose();
                JOptionPane.showMessageDialog(null, "Unable to Read Input File!", "Alert", 0);
                try {
                    connection.rollback();
                    connection.setAutoCommit(true);
                    if (bl2) {
                        statement.executeUpdate("SET IDENTITY_INSERT " + DBTablesPanel.getSelectedTableTabPanel().getTableName() + " OFF");
                    }
                    ConnectionManager.closeConnection(connection, "SQLDataDumpImportThread importSQLFile() rollback");
                }
                catch (SQLException sQLException) {
                    ConnectionManager.displaySQLErrors(sQLException, "SQLDataDumpImportThread importSQLFile() rollback failed");
                }
            }
        }
        catch (SQLException sQLException) {
            progressBar.dispose();
            ConnectionManager.displaySQLErrors(sQLException, "line# " + n2 + " " + string + " SQLDataDumpImportThread importSQLFile()");
            try {
                connection.rollback();
                connection.setAutoCommit(true);
                ConnectionManager.closeConnection(connection, "SQLDataDumpImportThread importSQLFile() rollback");
            }
            catch (SQLException sQLException2) {
                ConnectionManager.displaySQLErrors(sQLException, "SQLDataDumpImportThread importSQLFile() rollback failed");
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                ConnectionManager.displaySQLErrors(sQLException, "SQLDataImportThread importSQLFile() failed close");
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    if (Ajqvue.getDebug()) {
                        System.out.println("SQLDataImporthread importSQL() Failed to Close BufferedReader. " + iOException);
                    }
                }
                finally {
                    block139: {
                        try {
                            if (inputStreamReader != null) {
                                inputStreamReader.close();
                            }
                        }
                        catch (IOException iOException) {
                            if (!Ajqvue.getDebug()) break block139;
                            System.out.println("SQLDataImporthread importSQL() Failed to Close FileReader. " + iOException);
                        }
                    }
                }
            }
            ConnectionManager.closeConnection(connection, "SQLDataDumpImportThread importSQLFile()");
        }
    }

    private void refreshTableTabPanel() {
        TableTabPanel tableTabPanel = DBTablesPanel.getSelectedTableTabPanel();
        if (tableTabPanel != null) {
            ArrayList<String> arrayList = tableTabPanel.getCurrentTableHeadings();
            tableTabPanel.setTableHeadings(arrayList);
        }
    }
}

