/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.io;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.datasource.ConnectionManager;
import com.dandymadeproductions.ajqvue.gui.panels.DBTablesPanel;
import com.dandymadeproductions.ajqvue.gui.panels.TableTabPanel;
import com.dandymadeproductions.ajqvue.utilities.ProgressBar;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import com.dandymadeproductions.ajqvue.utilities.db.SQLQuery;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class CSVDataImportThread
implements Runnable {
    private Connection dbConnection;
    private String dataSourceType;
    private String importTable;
    private String fileName;
    private String csvOption;
    private boolean argConnection;
    private boolean validImport;
    private boolean useStatusDialog;
    private boolean temporaryDataFile;

    public CSVDataImportThread(String string, String string2, boolean bl) {
        this(null, ConnectionManager.getDataSourceType(), "", string, string2, true, bl);
    }

    public CSVDataImportThread(Connection connection, String string, String string2, boolean bl, String string3) {
        this(connection, string, string2, string3, "Insert", bl, false);
    }

    private CSVDataImportThread(Connection connection, String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        this.dbConnection = connection;
        this.dataSourceType = string;
        this.importTable = string2;
        this.fileName = string3;
        this.csvOption = string4;
        this.useStatusDialog = bl;
        this.temporaryDataFile = bl2;
        this.argConnection = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        File file = new File(this.fileName);
        if (file.exists()) {
            this.importCSVFile();
            if (!this.validImport || this.argConnection) return;
            this.refreshTableTabPanel();
            if (!this.temporaryDataFile) return;
            try {
                if (file.delete()) return;
                throw new SecurityException();
            }
            catch (SecurityException securityException) {
                if (!Ajqvue.getDebug()) return;
                System.out.println("Failed to Delete: '" + file + "'. " + securityException.toString());
            }
            return;
        }
        String string = "The file '" + this.fileName + "' does not exists.";
        JOptionPane.showMessageDialog(null, string, this.fileName, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importCSVFile() {
        block250: {
            block245: {
                var10_1 = new ArrayList<String>();
                var11_2 = new ArrayList<String>();
                var30_3 = DBTablesPanel.getDataImportProperties().getDateFormat();
                var26_4 = DBTablesPanel.getGeneralDBProperties().getBatchSize();
                var27_5 = DBTablesPanel.getGeneralDBProperties().getBatchSizeEnabled();
                var28_6 = this.dataSourceType.equals("sqlserver") != false && DBTablesPanel.getSelectedTableTabPanel() != null ? DBTablesPanel.getDataImportProperties().getIdentityInsert() : false;
                var6_7 = null;
                var7_8 = null;
                var1_9 = null;
                var29_10 = new ProgressBar("CSV Import To: " + this.importTable);
                var21_11 = 0;
                var23_12 = 0;
                try {
                    if (this.dbConnection == null) {
                        this.dbConnection = ConnectionManager.getConnection("CSVDataImportThread importCSVFile()");
                        if (this.dbConnection == null || DBTablesPanel.getSelectedTableTabPanel() == null) {
                            this.validImport = false;
                            return;
                        }
                        this.importTable = DBTablesPanel.getSelectedTableTabPanel().getTableName();
                        var16_59 = ConnectionManager.getIdentifierQuoteString();
                        var8_60 = Utils.getSchemaTableName(this.importTable);
                        var9_61 = DBTablesPanel.getSelectedTableTabPanel().getPrimaryKeys();
                        var12_62 = DBTablesPanel.getSelectedTableTabPanel().getColumnClassHashMap();
                        var13_63 = DBTablesPanel.getSelectedTableTabPanel().getColumnSQLTypeHashMap();
                        var14_64 = DBTablesPanel.getSelectedTableTabPanel().getColumnTypeNameHashMap();
                        this.argConnection = false;
                    } else {
                        var15_65 = this.dbConnection.getMetaData().getCatalogSeparator();
                        if (var15_65 == null || var15_65.isEmpty()) {
                            var15_65 = ".";
                        }
                        if ((var16_59 = this.dbConnection.getMetaData().getIdentifierQuoteString()) == null || var16_59.equals(" ")) {
                            var16_59 = "";
                        }
                        var8_60 = Utils.getSchemaTableName(this.importTable, var15_65, var16_59);
                        var31_20 = new SQLQuery("SELECT * FROM " + var8_60);
                        if (var31_20.executeSQL(this.dbConnection) != 1) {
                            this.validImport = false;
                            return;
                        }
                        var9_61 = new ArrayList<E>();
                        var12_62 = var31_20.getColumnClassHashMap();
                        var13_63 = var31_20.getColumnSQLTypeHashMap();
                        var14_64 = var31_20.getColumnTypeNameHashMap();
                    }
                    this.dbConnection.setAutoCommit(false);
                    var1_9 = this.dbConnection.createStatement();
                    if (var28_6) {
                        var1_9.executeUpdate("SET IDENTITY_INSERT " + DBTablesPanel.getSelectedTableTabPanel().getTableName() + " ON");
                    }
                    if (this.dataSourceType.equals("mysql") || this.dataSourceType.equals("mariadb") || this.dataSourceType.equals("postgresql")) {
                        var1_9.executeUpdate("BEGIN");
                    }
                    try {
                        var6_7 = new FileReader(this.fileName);
                        var7_8 = new BufferedReader(var6_7);
                        while ((var17_76 = var7_8.readLine()) != null) {
                            ++var21_11;
                        }
                        var29_10.setTaskLength(var21_11);
                        var29_10.pack();
                        var29_10.center();
                        var29_10.setVisible(this.useStatusDialog);
                        this.validImport = true;
                        var7_8.close();
                        var6_7 = new FileReader(this.fileName);
                        var7_8 = new BufferedReader(var6_7);
                        var2_77 = new StringBuffer();
                        var3_78 = new StringBuffer();
                        var5_79 = new StringBuffer();
                        var25_80 = 0;
                        var22_81 = 0;
                        var23_12 = 1;
lbl70:
                        // 2 sources

                        while (true) {
                            var17_76 = var7_8.readLine();
                            if (var17_76 != null) {
                                if (var29_10.isCanceled()) {
                                    this.validImport = false;
                                } else {
                                    if (var23_12 == 1) {
                                        if (this.csvOption.equals("Insert")) {
                                            var2_77.append("INSERT INTO " + var8_60 + " (");
                                        } else {
                                            var2_77.append("UPDATE " + var8_60 + " SET ");
                                        }
                                        var24_86 = this.separateTokens(var17_76, 0);
                                        var22_81 = var24_86.length;
                                        break;
                                    }
                                    var3_78.delete(0, var3_78.length());
                                    var5_79.delete(0, var5_79.length());
                                    var4_82 = "";
                                    var24_86 = this.separateTokens(var17_76, var22_81);
                                    break block245;
                                }
                            }
                            if (this.validImport) {
                                var1_9.executeBatch();
                                this.dbConnection.commit();
                            } else {
                                this.dbConnection.rollback();
                            }
                            if (var28_6) {
                                var1_9.executeUpdate("SET IDENTITY_INSERT " + DBTablesPanel.getSelectedTableTabPanel().getTableName() + " OFF");
                            }
                            var6_7.close();
                            var7_8.close();
                            var1_9.close();
                            this.dbConnection.setAutoCommit(true);
                            return;
                        }
                    }
                    catch (IOException var31_22) {
                        var29_10.setVisible(false);
                        JOptionPane.showMessageDialog(null, "Unable to Read Input File!", "Alert", 0);
                        try {
                            var1_9.close();
                            this.dbConnection.rollback();
                            this.dbConnection.setAutoCommit(true);
                            if (var28_6) {
                                var1_9.executeUpdate("SET IDENTITY_INSERT " + DBTablesPanel.getSelectedTableTabPanel().getTableName() + " OFF");
                            }
                            if (this.argConnection != false) return;
                            ConnectionManager.closeConnection(this.dbConnection, "CSVDataImportThread importCSVFile() rollback");
                            return;
                        }
                        catch (SQLException var32_47) {
                            ConnectionManager.displaySQLErrors(var32_47, "SQLDataImportThread importCSVFile() rollback failed");
                            return;
                        }
                    }
                }
                catch (SQLException var31_30) {
                    var29_10.setVisible(false);
                    ConnectionManager.displaySQLErrors(var31_30, "line# " + var23_12 + " CSVDataImportThread importCSVLFile()");
                    try {
                        this.dbConnection.rollback();
                        this.dbConnection.setAutoCommit(true);
                        if (this.argConnection != false) return;
                        ConnectionManager.closeConnection(this.dbConnection, "CSVDataImportThread importCSVFile() rollback");
                        return;
                    }
                    catch (SQLException var32_48) {
                        ConnectionManager.displaySQLErrors(var31_30, "CSVDataImportThread importCSVFile() rollback failed");
                        return;
                    }
                }
                finally {
                    var29_10.dispose();
                    try {
                        if (var1_9 != null) {
                            var1_9.close();
                        }
                    }
                    catch (SQLException var31_34) {
                        ConnectionManager.displaySQLErrors(var31_34, "CSVDataImportThread importCSVFile() failed close");
                    }
                    finally {
                        try {
                            if (var7_8 != null) {
                                var7_8.close();
                            }
                        }
                        catch (IOException var31_36) {
                            if (Ajqvue.getDebug()) {
                                System.out.println("CSVDataImporthread importCSV() Failed to Close BufferedReader. " + var31_36);
                            }
                        }
                        finally {
                            block248: {
                                try {
                                    if (var6_7 != null) {
                                        var6_7.close();
                                    }
                                }
                                catch (IOException var31_37) {
                                    if (!Ajqvue.getDebug()) break block248;
                                    System.out.println("CSVDataImporthread importCSV() Failed to Close FileReader. " + var31_37);
                                }
                            }
                        }
                    }
                    if (!this.argConnection) {
                        ConnectionManager.closeConnection(this.dbConnection, "CSVDataImportThread importCSVFile()");
                    }
                }
                for (var31_21 = 0; var31_21 < var22_81; ++var31_21) {
                    if (this.csvOption.equals("Insert")) {
                        var2_77.append(var16_59 + var24_86[var31_21] + var16_59 + ", ");
                    }
                    if (this.argConnection) {
                        var10_1.add(var24_86[var31_21]);
                    } else {
                        var10_1.add(this.parseColumnNameField(var24_86[var31_21]));
                    }
                    var11_2.add(var24_86[var31_21]);
                }
                if (this.csvOption.equals("Insert")) {
                    var2_77.delete(var2_77.length() - 2, var2_77.length());
                    var2_77.append(") VALUES (");
                }
                break block250;
            }
            for (var31_21 = 0; var31_21 < var24_86.length; ++var31_21) {
                if (!var12_62.containsKey(var10_1.get(var31_21))) {
                    this.validImport = false;
                    break;
                }
                var18_83 = var12_62.get(var10_1.get(var31_21));
                var19_84 = var13_63.get(var10_1.get(var31_21));
                var20_85 = var14_64.get(var10_1.get(var31_21));
                if (!var24_86[var31_21].toLowerCase(Locale.ENGLISH).equals("null") && !var24_86[var31_21].toLowerCase(Locale.ENGLISH).equals("default")) {
                    if (var24_86[var31_21].equals("")) {
                        var24_86[var31_21] = "default";
                    } else if (Utils.isBlob(var18_83, var20_85)) {
                        var24_86[var31_21] = "null";
                    } else if ((this.dataSourceType.equals("mysql") || this.dataSourceType.equals("mariadb")) && var20_85 != null && var20_85.indexOf("BIT") != -1) {
                        var24_86[var31_21] = "B'" + var24_86[var31_21] + "'";
                    } else if (this.dataSourceType.equals("postgresql") && var18_83 != null && var18_83.indexOf("geometric") != -1) {
                        var24_86[var31_21] = "'" + var24_86[var31_21] + "'::" + var20_85;
                    } else if (var20_85 != null && (var20_85.equals("DATE") || var20_85.equals("DATETIME") || var20_85.indexOf("TIMESTAMP") != -1 && var18_83 != null && var18_83.indexOf("Array") == -1)) {
                        if (var20_85.equals("DATE")) {
                            var24_86[var31_21] = this.dataSourceType.equals("oracle") ? "TO_DATE('" + Utils.convertViewDateString_To_DBDateString(var24_86[var31_21], var30_3) + "', 'YYYY-MM-DD')" : (this.dataSourceType.equals("odbc") ? "#" + Utils.convertViewDateString_To_DBDateString(var24_86[var31_21], var30_3) + "#" : "'" + Utils.convertViewDateString_To_DBDateString(var24_86[var31_21], var30_3) + "'");
                        } else {
                            if (var24_86[var31_21].indexOf(" ") != -1) {
                                var32_46 = var24_86[var31_21].indexOf(" ");
                                var33_50 = var24_86[var31_21].substring(var32_46);
                                var24_86[var31_21] = var24_86[var31_21].substring(0, var32_46);
                            } else {
                                var33_50 = "";
                            }
                            var24_86[var31_21] = this.dataSourceType.equals("oracle") ? (var20_85.equals("TIMESTAMP") ? "TO_TIMESTAMP('" + Utils.convertViewDateString_To_DBDateString(var24_86[var31_21], var30_3) + var33_50 + "', 'YYYY-MM-DD HH24:MI:SS:FF')" : (var20_85.equals("TIMESTAMPTZ") || var20_85.equals("TIMESTAMP WITH TIME ZONE") ? "TO_TIMESTAMP_TZ('" + Utils.convertViewDateString_To_DBDateString(var24_86[var31_21], var30_3) + var33_50 + "', 'YYYY-MM-DD HH24:MI:SS TZHTZM')" : "TO_TIMESTAMP_TZ('" + Utils.convertViewDateString_To_DBDateString(var24_86[var31_21], var30_3) + var33_50 + "', 'YYYY-MM-DD HH24:MI:SS TZH:TZM')")) : (this.dataSourceType.equals("odbc") ? "#" + Utils.convertViewDateString_To_DBDateString(var24_86[var31_21], var30_3) + var33_50 + "#" : "'" + Utils.convertViewDateString_To_DBDateString(var24_86[var31_21], var30_3) + var33_50 + "'");
                        }
                    } else if (!Utils.isNotQuoted(var18_83, var19_84, var20_85)) {
                        var24_86[var31_21] = "'" + var24_86[var31_21] + "'";
                    }
                }
                if (this.csvOption.equals("Insert")) {
                    var3_78.append(var24_86[var31_21] + ", ");
                    continue;
                }
                if (var9_61.contains(var11_2.get(var31_21))) {
                    if (var4_82.equals("")) {
                        var4_82 = "WHERE " + var16_59 + (String)var11_2.get(var31_21) + var16_59 + "=" + var24_86[var31_21] + " AND ";
                        continue;
                    }
                    var4_82 = var4_82 + var16_59 + (String)var11_2.get(var31_21) + var16_59 + "=" + var24_86[var31_21] + " AND ";
                    continue;
                }
                var3_78.append(var16_59 + (String)var11_2.get(var31_21) + var16_59 + "=" + var24_86[var31_21] + ", ");
            }
            if (this.csvOption.equals("Insert")) {
                var3_78.delete(var3_78.length() - 2, var3_78.length());
                var3_78.append(")");
            } else {
                if (var3_78.length() >= 2) {
                    var3_78.delete(var3_78.length() - 2, var3_78.length());
                }
                if (var4_82.length() > 5) {
                    var3_78.append(" " + var4_82.substring(0, var4_82.length() - 5));
                } else {
                    var3_78.append(" " + var4_82);
                }
            }
            var5_79.append(var2_77.toString() + var3_78.toString());
            var1_9.addBatch(var5_79.toString());
            if (var27_5) {
                if (var25_80 > var26_4) {
                    var1_9.executeBatch();
                    this.dbConnection.commit();
                    var25_80 = 0;
                } else {
                    ++var25_80;
                }
            }
        }
        var29_10.setCurrentValue(var23_12++);
        ** while (true)
    }

    private String parseColumnNameField(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.indexOf(95) != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            while (stringTokenizer.hasMoreTokens()) {
                if (stringTokenizer.countTokens() > 1) {
                    stringBuffer.append(this.firstLetterToUpperCase(stringTokenizer.nextToken()));
                    stringBuffer.append(" ");
                    continue;
                }
                stringBuffer.append(this.firstLetterToUpperCase(stringTokenizer.nextToken()));
            }
            string = stringBuffer.toString();
        } else {
            string = this.firstLetterToUpperCase(string);
        }
        return string;
    }

    private String firstLetterToUpperCase(String string) {
        if (string.length() >= 1) {
            String string2 = string.substring(0, 1);
            string2 = string2.toUpperCase(Ajqvue.getLocale());
            return string2 + string.substring(1);
        }
        return string;
    }

    private String[] separateTokens(String string, int n) {
        String string2 = DBTablesPanel.getDataImportProperties().getDataDelimiter();
        if (string2.indexOf("'") == -1) {
            string = string.replaceAll("'", "''");
        }
        if (string2.indexOf("`") == -1) {
            string = string.replaceAll("`", "''");
        }
        String[] stringArray = string.split(string2, n);
        return stringArray;
    }

    private void refreshTableTabPanel() {
        TableTabPanel tableTabPanel = DBTablesPanel.getSelectedTableTabPanel();
        if (tableTabPanel != null) {
            ArrayList<String> arrayList = tableTabPanel.getCurrentTableHeadings();
            tableTabPanel.setTableHeadings(arrayList);
        }
    }
}

