/*
 * Decompiled with CFR 0.152.
 */
package com.dandymadeproductions.ajqvue.gui.panels;

import com.dandymadeproductions.ajqvue.Ajqvue;
import com.dandymadeproductions.ajqvue.utilities.AResourceBundle;
import com.dandymadeproductions.ajqvue.utilities.Utils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class TopTabPanel
extends JPanel
implements MouseListener,
Runnable {
    private static final long serialVersionUID = -6010256554607153451L;
    private static final int imageIconSize = 50;
    private static final int moveIncrement = 10;
    private transient Image backgroundImage;
    private int backgroundImageWidth;
    private int backgroundImageHeight;
    private ImageIcon[][] imageIcons;
    private ImageIcon[][] currentImageIcons;
    private transient Image offScreenGraphicsImage;
    private Point blankPosition;
    private Point movingPosition;
    private Point currentMovingPosition;
    private Point destinationPosition;
    private boolean movingPositionInitialized;
    private String moveDirection;
    private boolean noBackgroundImageLoaded;
    private boolean delayAnimation;
    private int currentTime;
    private volatile boolean runThread;
    private volatile boolean suspendThread;
    private static final int FRAME_DELAY = 200;
    private static final int ANIMATION_DELAY = 1000;

    public TopTabPanel(boolean bl) {
        AResourceBundle aResourceBundle = Ajqvue.getResourceBundle();
        String string = Utils.getFileSeparator();
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(11);
        String string2 = n >= 20 || n <= 4 ? "mainTab_night.jpg" : (n <= 9 ? "mainTab_morning.jpg" : (n <= 16 ? "mainTab_day.jpg" : "mainTab_evening.jpg"));
        this.backgroundImage = aResourceBundle.getResourceImage("images" + string + string2).getImage();
        this.backgroundImageWidth = this.backgroundImage.getWidth(null);
        this.backgroundImageHeight = this.backgroundImage.getHeight(null);
        if (this.backgroundImageWidth != -1 && this.backgroundImageHeight != -1) {
            this.noBackgroundImageLoaded = false;
            BufferedImage bufferedImage = new BufferedImage(this.backgroundImageWidth, this.backgroundImageHeight, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(this.backgroundImage, null, null);
            this.imageIcons = new ImageIcon[this.backgroundImageWidth / 50][this.backgroundImageHeight / 50];
            for (int i = 0; i < this.imageIcons.length; ++i) {
                for (int j = 0; j < this.imageIcons[0].length; ++j) {
                    this.imageIcons[i][j] = new ImageIcon(bufferedImage.getSubimage(50 * i, 50 * j, 50, 50));
                }
            }
            this.currentImageIcons = new ImageIcon[this.backgroundImageWidth / 50][this.backgroundImageHeight / 50];
            graphics2D.dispose();
            this.initializeAnimation();
            this.selectMovingSubImage();
            this.currentMovingPosition = new Point();
            this.destinationPosition = new Point();
            this.movingPositionInitialized = false;
        } else {
            this.noBackgroundImageLoaded = true;
        }
        this.currentTime = 0;
        this.runThread = true;
        this.suspendThread = bl;
        this.delayAnimation = true;
        this.addMouseListener(this);
    }

    private void initializeAnimation() {
        Random random = new Random(System.currentTimeMillis());
        this.blankPosition = new Point(Math.abs(random.nextInt() % this.imageIcons.length), Math.abs(random.nextInt() % this.imageIcons[0].length));
        for (int i = 0; i < this.imageIcons.length; ++i) {
            for (int j = 0; j < this.imageIcons[0].length; ++j) {
                this.currentImageIcons[i][j] = this.imageIcons[i][j];
            }
        }
    }

    private void selectMovingSubImage() {
        this.movingPosition = new Point();
        Random random = new Random(System.currentTimeMillis());
        if (random.nextInt() % 2 == 0) {
            if (random.nextInt() % 2 == 0) {
                this.movingPosition.x = this.blankPosition.x - 1;
                this.moveDirection = "Right";
            } else {
                this.movingPosition.x = this.blankPosition.x + 1;
                this.moveDirection = "Left";
            }
            if (this.movingPosition.x < 0) {
                this.movingPosition.x += 2;
                this.moveDirection = "Left";
            }
            if (this.movingPosition.x > this.imageIcons.length - 1) {
                this.movingPosition.x -= 2;
                this.moveDirection = "Right";
            }
            this.movingPosition.y = this.blankPosition.y;
        } else {
            if (random.nextInt() % 2 == 0) {
                this.movingPosition.y = this.blankPosition.y - 1;
                this.moveDirection = "Down";
            } else {
                this.movingPosition.y = this.blankPosition.y + 1;
                this.moveDirection = "Up";
            }
            if (this.movingPosition.y < 0) {
                this.movingPosition.y += 2;
                this.moveDirection = "Up";
            }
            if (this.movingPosition.y > this.imageIcons[0].length - 1) {
                this.movingPosition.y -= 2;
                this.moveDirection = "Down";
            }
            this.movingPosition.x = this.blankPosition.x;
        }
    }

    @Override
    public void run() {
        while (this.runThread) {
            this.timeStep();
            this.render();
        }
    }

    private void render() {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D != null) {
            Dimension dimension = this.getSize();
            if (this.checkImage(dimension)) {
                Graphics2D graphics2D2 = (Graphics2D)this.offScreenGraphicsImage.getGraphics();
                this.drawPanel(this.offScreenGraphicsImage.getGraphics());
                graphics2D.drawImage(this.offScreenGraphicsImage, 0, 0, null);
                graphics2D2.dispose();
            }
            graphics2D.dispose();
        }
    }

    private boolean checkImage(Dimension dimension) {
        if (dimension.width <= 0 || dimension.height <= 0) {
            return false;
        }
        if (this.offScreenGraphicsImage == null || this.offScreenGraphicsImage.getWidth(null) != dimension.width || this.offScreenGraphicsImage.getHeight(null) != dimension.height) {
            this.offScreenGraphicsImage = this.createImage(dimension.width, dimension.height);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeStep() {
        try {
            Thread.sleep(200L);
            if (this.currentTime < 1000) {
                this.currentTime += 200;
            } else {
                this.delayAnimation = false;
            }
            TopTabPanel topTabPanel = this;
            synchronized (topTabPanel) {
                while (this.suspendThread) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            System.out.println("TopTabPanel:Process Interrupted. " + interruptedException.toString());
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.resetPanel();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.drawPanel(graphics);
    }

    private void drawPanel(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setColor(Color.BLACK);
        graphics2D.fillRect(0, 0, n, n2);
        if (this.noBackgroundImageLoaded) {
            Font font = new Font("Serif", 1, 48);
            Random random = new Random(System.currentTimeMillis());
            Color color = new Color(Math.abs(random.nextInt() % 254), Math.abs(random.nextInt() % 254), Math.abs(random.nextInt() % 254));
            Color color2 = new Color(Math.abs(random.nextInt() % 254), Math.abs(random.nextInt() % 254), Math.abs(random.nextInt() % 254));
            GradientPaint gradientPaint = new GradientPaint(new Point2D.Double(0.0, 0.0), color, new Point2D.Double(n, (double)n2 / 10.0), color2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.setFont(font);
            int n3 = (int)font.getStringBounds("Dandy Made Productions", graphics2D.getFontRenderContext()).getWidth();
            graphics2D.drawString("Dandy Made Productions", (n - n3) / 2, n2 / 2);
        } else {
            AffineTransform affineTransform = AffineTransform.getScaleInstance((double)n / (double)this.backgroundImageWidth + 0.1, (double)n2 / (double)this.backgroundImageHeight + 0.1);
            graphics2D.setTransform(affineTransform);
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < this.imageIcons.length; ++i) {
                for (int j = 0; j < this.imageIcons[0].length; ++j) {
                    if (i != this.blankPosition.x || j != this.blankPosition.y || this.delayAnimation) {
                        if (i == this.movingPosition.x && j == this.movingPosition.y) {
                            if (!this.movingPositionInitialized) {
                                this.currentMovingPosition.x = n4;
                                this.currentMovingPosition.y = n5;
                                if (this.moveDirection.equals("Right")) {
                                    this.destinationPosition.x = this.currentMovingPosition.x + 50;
                                    this.destinationPosition.y = this.currentMovingPosition.y;
                                } else if (this.moveDirection.equals("Left")) {
                                    this.destinationPosition.x = this.currentMovingPosition.x - 50;
                                    this.destinationPosition.y = this.currentMovingPosition.y;
                                } else if (this.moveDirection.equals("Down")) {
                                    this.destinationPosition.x = this.currentMovingPosition.x;
                                    this.destinationPosition.y = this.currentMovingPosition.y + 50;
                                } else {
                                    this.destinationPosition.x = this.currentMovingPosition.x;
                                    this.destinationPosition.y = this.currentMovingPosition.y - 50;
                                }
                                this.movingPositionInitialized = true;
                            }
                            graphics2D.drawImage(this.currentImageIcons[i][j].getImage(), this.currentMovingPosition.x, this.currentMovingPosition.y, this);
                            if (this.moveDirection.equals("Right")) {
                                this.currentMovingPosition.x += 10;
                                if (this.currentMovingPosition.x > this.destinationPosition.x) {
                                    this.movingPositionInitialized = false;
                                }
                            } else if (this.moveDirection.equals("Left")) {
                                this.currentMovingPosition.x -= 10;
                                if (this.currentMovingPosition.x < this.destinationPosition.x) {
                                    this.movingPositionInitialized = false;
                                }
                            } else if (this.moveDirection.equals("Down")) {
                                this.currentMovingPosition.y += 10;
                                if (this.currentMovingPosition.y > this.destinationPosition.y) {
                                    this.movingPositionInitialized = false;
                                }
                            } else {
                                this.currentMovingPosition.y -= 10;
                                if (this.currentMovingPosition.y < this.destinationPosition.y) {
                                    this.movingPositionInitialized = false;
                                }
                            }
                            if (!this.movingPositionInitialized) {
                                this.currentImageIcons[this.blankPosition.x][this.blankPosition.y] = this.currentImageIcons[this.movingPosition.x][this.movingPosition.y];
                                this.blankPosition.x = this.movingPosition.x;
                                this.blankPosition.y = this.movingPosition.y;
                                this.selectMovingSubImage();
                            }
                        } else {
                            graphics2D.drawImage(this.currentImageIcons[i][j].getImage(), n4, n5, this);
                        }
                    }
                    n5 += 50;
                }
                n4 += 50;
                n5 = 0;
            }
        }
    }

    public void resetPanel() {
        this.currentTime = 0;
        this.delayAnimation = true;
        if (!this.noBackgroundImageLoaded) {
            this.initializeAnimation();
            this.selectMovingSubImage();
            this.movingPositionInitialized = false;
        }
    }

    public synchronized void setThreadAction(boolean bl) {
        this.suspendThread = bl;
        if (!this.suspendThread) {
            this.notifyAll();
        }
    }

    public void suspendPanel(boolean bl) {
        this.runThread = !bl;
    }
}

